/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.CGPathElement;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAffineTransformStruct;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGradient;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public final class GC
extends Resource {
    public NSGraphicsContext handle;
    Drawable drawable;
    GCData data;
    CGPathElement element;
    int count;
    int typeCount;
    byte[] types;
    double[] points;
    double[] point;
    static final int TAB_COUNT = 32;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_FILL = 256;
    static final int DRAW_OFFSET = 512;
    static final int CLIPPING = 1024;
    static final int TRANSFORM = 2048;
    static final int VISIBLE_REGION = 4096;
    static final int DRAW = 3833;
    static final int FILL = 3074;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GC(Drawable drawable, int n2) {
        if (drawable == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            GCData gCData = new GCData();
            gCData.style = GC.checkStyle(n2);
            long l2 = drawable.internal_new_GC(gCData);
            Device device = gCData.device;
            if (device == null) {
                device = Device.getDevice();
            }
            if (device == null) {
                SWT.error(4);
            }
            this.device = gCData.device = device;
            this.init(drawable, gCData, l2);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x2000000) != 0) {
            n2 &= 0xFBFFFFFF;
        }
        return n2 & 0x6000000;
    }

    public static GC cocoa_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        long l2 = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, l2);
        return gC;
    }

    long applierFunc(long l2, long l3) {
        OS.memmove(this.element, l3, (long)CGPathElement.sizeof);
        int n2 = 0;
        int n3 = 1;
        switch (this.element.type) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                n3 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                n3 = 3;
                break;
            }
            case 4: {
                n2 = 5;
                n3 = 0;
            }
        }
        if (this.types != null) {
            this.types[this.typeCount] = (byte)n2;
            if (n3 > 0) {
                OS.memmove(this.point, this.element.points, (long)(n3 * CGPoint.sizeof));
                System.arraycopy(this.point, 0, this.points, this.count, n3 * 2);
            }
        }
        ++this.typeCount;
        this.count += n3 * 2;
        return 0L;
    }

    NSAutoreleasePool checkGC(int n2) {
        Object object;
        Object object2;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        if (this.data.flippedContext != null && !this.handle.isEqual(NSGraphicsContext.currentContext())) {
            this.data.restoreContext = true;
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(this.handle);
        }
        if ((n2 & 0xC00) != 0) {
            NSView nSView = this.data.view;
            if ((this.data.state & 0x400) == 0 || (this.data.state & 0x800) == 0 || (this.data.state & 0x1000) == 0) {
                boolean bl2 = this.handle.shouldAntialias();
                this.handle.restoreGraphicsState();
                this.handle.saveGraphicsState();
                this.handle.setShouldAntialias(bl2);
                if (!(nSView == null || this.data.paintRect != null && nSView.isFlipped())) {
                    object2 = NSAffineTransform.transform();
                    object = nSView.convertRect_toView_(nSView.bounds(), null);
                    if (this.data.paintRect == null) {
                        ((NSAffineTransform)object2).translateXBy(((NSRect)object).x, ((NSRect)object).y + ((NSRect)object).height);
                        double d2 = nSView.window().userSpaceScaleFactor();
                        ((NSAffineTransform)object2).scaleXBy(d2, d2);
                    } else {
                        ((NSAffineTransform)object2).translateXBy(0.0, ((NSRect)object).height);
                    }
                    ((NSAffineTransform)object2).scaleXBy(1.0, -1.0);
                    ((NSAffineTransform)object2).concat();
                    if (this.data.visibleRgn != 0L) {
                        if (this.data.visiblePath == null || (this.data.state & 0x1000) == 0) {
                            if (this.data.visiblePath != null) {
                                this.data.visiblePath.release();
                            }
                            this.data.visiblePath = Region.cocoa_new(this.device, this.data.visibleRgn).getPath();
                        }
                        this.data.visiblePath.addClip();
                        this.data.state |= 0x1000;
                    }
                }
                if (this.data.clipPath != null) {
                    this.data.clipPath.addClip();
                }
                if (this.data.transform != null) {
                    this.data.transform.concat();
                }
                n2 &= 0xFFFFF3FF;
                this.data.state |= 0xC00;
                this.data.state &= 0xFFFFFFFC;
            }
        }
        OS.CGContextSetBlendMode(this.handle.graphicsPort(), this.data.xorMode ? 10 : 0);
        int n3 = this.data.state;
        if ((n3 & n2) == n2) {
            return nSAutoreleasePool;
        }
        n3 = (n3 ^ n2) & n2;
        this.data.state |= n2;
        if ((n3 & 1) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setStroke();
                }
            } else {
                object2 = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                this.data.fg = NSColor.colorWithDeviceRed((double)object2[0], (double)object2[1], (double)object2[2], (float)this.data.alpha / 255.0f);
                object = this.data.fg;
                ((NSObject)object).retain();
                ((NSColor)object).setStroke();
            }
        }
        if ((n3 & 0x100) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                object2 = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                this.data.fg = NSColor.colorWithDeviceRed((double)object2[0], (double)object2[1], (double)object2[2], (float)this.data.alpha / 255.0f);
                object = this.data.fg;
                ((NSObject)object).retain();
                ((NSColor)object).setFill();
            }
            this.data.state &= 0xFFFFFFFD;
        }
        if ((n3 & 2) != 0) {
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                object2 = this.data.background;
                if (this.data.bg != null) {
                    this.data.bg.release();
                }
                this.data.bg = NSColor.colorWithDeviceRed((double)object2[0], (double)object2[1], (double)object2[2], (float)this.data.alpha / 255.0f);
                object = this.data.bg;
                ((NSObject)object).retain();
                ((NSColor)object).setFill();
            }
            this.data.state &= 0xFFFFFEFF;
        }
        NSBezierPath nSBezierPath = this.data.path;
        if ((n3 & 0x40) != 0) {
            nSBezierPath.setLineWidth(this.data.lineWidth == 0.0f ? 1.0 : (double)this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n3 |= 8;
                }
            }
        }
        if ((n3 & 8) != 0) {
            object2 = null;
            float f2 = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    object2 = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    object2 = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    object2 = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    object2 = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    object2 = this.data.lineDashes;
                }
            }
            if (object2 != null) {
                double[] dArray = new double[((Object)object2).length];
                for (int i2 = 0; i2 < dArray.length; ++i2) {
                    dArray[i2] = f2 == 0.0f || this.data.lineStyle == 6 ? (double)object2[i2] : (double)(object2[i2] * f2);
                }
                nSBezierPath.setLineDash(dArray, dArray.length, this.data.lineDashesOffset);
            } else {
                nSBezierPath.setLineDash(null, 0L, 0.0);
            }
        }
        if ((n3 & 0x80) != 0) {
            nSBezierPath.setMiterLimit(this.data.lineMiterLimit);
        }
        if ((n3 & 0x20) != 0) {
            int n4 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    n4 = 1;
                    break;
                }
                case 3: {
                    n4 = 2;
                }
            }
            nSBezierPath.setLineJoinStyle(n4);
        }
        if ((n3 & 0x10) != 0) {
            int n5 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n5 = 1;
                    break;
                }
                case 1: {
                    n5 = 0;
                    break;
                }
                case 3: {
                    n5 = 2;
                }
            }
            nSBezierPath.setLineCapStyle(n5);
        }
        if ((n3 & 0x200) != 0) {
            double d3;
            double d4;
            this.data.drawYOffset = 0.0;
            this.data.drawXOffset = 0.0;
            NSSize nSSize = new NSSize();
            nSSize.height = 1.0;
            nSSize.width = 1.0;
            if (this.data.transform != null) {
                nSSize = this.data.transform.transformSize(nSSize);
            }
            if ((d4 = nSSize.width) < 0.0) {
                d4 = -d4;
            }
            if ((d3 = (double)this.data.lineWidth * d4) == 0.0 || (int)d3 % 2 == 1) {
                this.data.drawXOffset = 0.5 / d4;
            }
            if ((d4 = nSSize.height) < 0.0) {
                d4 = -d4;
            }
            if ((d3 = (double)this.data.lineWidth * d4) == 0.0 || (int)d3 % 2 == 1) {
                this.data.drawYOffset = 0.5 / d4;
            }
        }
        return nSAutoreleasePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyArea(Image image, int n2, int n3) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        try {
            if (this.data.image != null) {
                int n4 = n2;
                int n5 = n3;
                boolean bl2 = false;
                int n6 = 0;
                NSSize nSSize = this.data.image.handle.size();
                int n7 = (int)nSSize.height;
                int n8 = (int)nSSize.width - n2;
                int n9 = (int)nSSize.height - n3;
                int n10 = n8;
                int n11 = n9;
                NSGraphicsContext nSGraphicsContext = NSGraphicsContext.graphicsContextWithBitmapImageRep(image.getRepresentation());
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(nSGraphicsContext);
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                NSSize nSSize2 = image.handle.size();
                nSAffineTransform.translateXBy(0.0, nSSize2.height - (double)(n9 + 2 * n6));
                nSAffineTransform.concat();
                NSRect nSRect = new NSRect();
                nSRect.x = n4;
                nSRect.y = n7 - (n5 + n11);
                nSRect.width = n10;
                nSRect.height = n11;
                NSRect nSRect2 = new NSRect();
                nSRect2.x = (double)bl2;
                nSRect2.y = n6;
                nSRect2.width = n8;
                nSRect2.height = n9;
                this.data.image.handle.drawInRect(nSRect2, nSRect, 1L, 1.0);
                NSGraphicsContext.static_restoreGraphicsState();
                return;
            }
            if (this.data.view != null) {
                NSPoint nSPoint = new NSPoint();
                nSPoint.x = n2;
                nSPoint.y = n3;
                NSWindow nSWindow = this.data.view.window();
                nSPoint = this.data.view.convertPoint_toView_(nSPoint, nSWindow.contentView().superview());
                NSRect nSRect = nSWindow.frame();
                nSPoint.y = nSRect.height - nSPoint.y;
                NSSize nSSize = image.handle.size();
                CGRect cGRect = new CGRect();
                cGRect.size.width = nSSize.width;
                cGRect.size.height = nSSize.height;
                CGRect cGRect2 = new CGRect();
                cGRect2.origin.x = nSPoint.x;
                cGRect2.origin.y = nSPoint.y;
                cGRect2.size.width = nSSize.width;
                cGRect2.size.height = nSSize.height;
                NSBitmapImageRep nSBitmapImageRep = image.getRepresentation();
                NSGraphicsContext nSGraphicsContext = NSGraphicsContext.graphicsContextWithBitmapImageRep(nSBitmapImageRep);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(nSGraphicsContext);
                long l2 = OS.objc_msgSend(NSApplication.sharedApplication().id, OS.sel_contextID);
                OS.CGContextCopyWindowContentsToRect(nSGraphicsContext.graphicsPort(), cGRect, l2, nSWindow.windowNumber(), cGRect2);
                NSGraphicsContext.static_restoreGraphicsState();
                return;
            }
            if (this.handle.isDrawingToScreen()) {
                long l3;
                NSImage nSImage = image.handle;
                NSSize nSSize = nSImage.size();
                NSArray nSArray = null;
                NSString nSString = null;
                if (OS.VERSION >= 4208) {
                    nSArray = NSScreen.screens();
                    nSString = NSString.stringWith("NSScreenNumber");
                }
                CGRect cGRect = new CGRect();
                cGRect.origin.x = n2;
                cGRect.origin.y = n3;
                cGRect.size.width = nSSize.width;
                cGRect.size.height = nSSize.height;
                int n12 = 16;
                long l4 = OS.malloc(4 * n12);
                if (OS.CGGetDisplaysWithRect(cGRect, n12, l4, l3 = OS.malloc(4L)) != 0) {
                    return;
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, l3, (long)OS.PTR_SIZEOF);
                for (int i2 = 0; i2 < nArray[0]; ++i2) {
                    long l5;
                    OS.memmove(nArray2, l4 + (long)(i2 * 4), 4L);
                    OS.CGDisplayBounds(nArray2[0], cGRect);
                    double d2 = 1.0;
                    if (OS.VERSION >= 4208) {
                        int n13 = 0;
                        while ((long)n13 < nSArray.count()) {
                            NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(n13));
                            if (nArray2[0] == new NSNumber(nSScreen.deviceDescription().objectForKey(nSString)).intValue()) {
                                d2 = nSScreen.backingScaleFactor();
                                break;
                            }
                            ++n13;
                        }
                    }
                    long l6 = 0L;
                    long l7 = l5 = OS.VERSION >= 4208 ? 0L : OS.CGDisplayBaseAddress(nArray2[0]);
                    if (l5 != 0L) {
                        long l8;
                        long l9;
                        long l10 = OS.CGDisplayPixelsWide(nArray2[0]);
                        long l11 = OS.CGDisplayPixelsHigh(nArray2[0]);
                        long l12 = OS.CGDisplayBytesPerRow(nArray2[0]);
                        long l13 = OS.CGDisplayBitsPerPixel(nArray2[0]);
                        long l14 = OS.CGDisplayBitsPerSample(nArray2[0]);
                        int n14 = 6;
                        switch ((int)l13) {
                            case 16: {
                                n14 |= OS.kCGBitmapByteOrder16Host;
                                break;
                            }
                            case 32: {
                                n14 |= OS.kCGBitmapByteOrder32Host;
                            }
                        }
                        if (OS.__BIG_ENDIAN__() && OS.VERSION >= 4160) {
                            l9 = OS.CGColorSpaceCreateDeviceRGB();
                            l8 = OS.CGBitmapContextCreate(l5, l10, l11, l14, l12, l9, n14);
                            OS.CGColorSpaceRelease(l9);
                            l6 = OS.CGBitmapContextCreateImage(l8);
                            OS.CGContextRelease(l8);
                        } else {
                            l9 = OS.CGDataProviderCreateWithData(0L, l5, l12 * l11, 0L);
                            l8 = OS.CGColorSpaceCreateDeviceRGB();
                            l6 = OS.CGImageCreate(l10, l11, l14, l13, l12, l8, n14, l9, 0L, true, 0);
                            OS.CGColorSpaceRelease(l8);
                            OS.CGDataProviderRelease(l9);
                        }
                    } else if (OS.VERSION >= 4192) {
                        l6 = OS.CGDisplayCreateImage(nArray2[0]);
                    }
                    if (l6 == 0L) continue;
                    this.copyArea(image, (int)((double)n2 * d2 - cGRect.origin.x), (int)((double)n3 * d2 - cGRect.origin.y), l6, d2);
                    OS.CGImageRelease(l6);
                }
                OS.free(l4);
                OS.free(l3);
            }
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    void copyArea(Image image, int n2, int n3, long l2, double d2) {
        if (l2 == 0L) {
            return;
        }
        NSBitmapImageRep nSBitmapImageRep = image.getRepresentation();
        long l3 = nSBitmapImageRep.bitsPerSample();
        long l4 = nSBitmapImageRep.pixelsWide();
        long l5 = nSBitmapImageRep.pixelsHigh();
        long l6 = nSBitmapImageRep.bytesPerRow();
        long l7 = nSBitmapImageRep.bitmapData();
        long l8 = nSBitmapImageRep.bitmapFormat();
        int n4 = nSBitmapImageRep.hasAlpha() ? ((l8 & 1L) != 0L ? 4 : 3) : ((l8 & 1L) != 0L ? 6 : 5);
        long l9 = OS.CGColorSpaceCreateDeviceRGB();
        long l10 = OS.CGBitmapContextCreate(l7, l4, l5, l3, l6, l9, n4);
        OS.CGColorSpaceRelease(l9);
        if (l10 != 0L) {
            CGRect cGRect = new CGRect();
            cGRect.origin.x = (double)(-n2) / d2;
            cGRect.origin.y = (double)n3 / d2;
            cGRect.size.width = (double)OS.CGImageGetWidth(l2) / d2;
            cGRect.size.height = (double)OS.CGImageGetHeight(l2) / d2;
            OS.CGContextTranslateCTM(l10, 0.0, -(cGRect.size.height - (double)l5));
            OS.CGContextDrawImage(l10, cGRect, l2);
            OS.CGContextRelease(l10);
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.copyArea(n2, n3, n4, n5, n6, n7, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        if (n8 == 0 && n9 == 0) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        try {
            Image image = this.data.image;
            if (image != null) {
                NSImage nSImage = image.handle;
                NSSize nSSize = nSImage.size();
                int n10 = (int)nSSize.height;
                this.handle.saveGraphicsState();
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.scaleXBy(1.0, -1.0);
                nSAffineTransform.translateXBy(0.0, -(n5 + 2 * n7));
                nSAffineTransform.concat();
                NSRect nSRect = new NSRect();
                nSRect.x = n2;
                nSRect.y = n10 - (n3 + n5);
                nSRect.width = n4;
                nSRect.height = n5;
                NSRect nSRect2 = new NSRect();
                nSRect2.x = n6;
                nSRect2.y = n7;
                nSRect2.width = n4;
                nSRect2.height = n5;
                nSImage.drawInRect(nSRect2, nSRect, 1L, 1.0);
                this.handle.restoreGraphicsState();
                return;
            }
            if (this.data.view != null) {
                NSView nSView = this.data.view;
                NSRect nSRect = nSView.visibleRect();
                if (nSRect.width <= 0.0 || nSRect.height <= 0.0) {
                    return;
                }
                NSRect nSRect3 = new NSRect();
                nSRect3.x = n2;
                nSRect3.y = n3;
                nSRect3.width = n4;
                nSRect3.height = n5;
                NSPoint nSPoint = new NSPoint();
                nSPoint.x = n6;
                nSPoint.y = n7;
                nSView.lockFocus();
                OS.NSCopyBits(0L, nSRect3, nSPoint);
                nSView.unlockFocus();
                if (bl2) {
                    boolean bl3;
                    boolean bl4 = bl3 = n6 + n4 < n2 || n2 + n4 < n6 || n7 + n5 < n3 || n3 + n5 < n7;
                    if (bl3) {
                        nSView.setNeedsDisplayInRect(nSRect3);
                    } else {
                        int n11;
                        if (n8 != 0) {
                            n11 = n6 - n8;
                            if (n8 < 0) {
                                n11 = n6 + n4;
                            }
                            nSRect3.x = n11;
                            nSRect3.width = Math.abs(n8);
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                        if (n9 != 0) {
                            n11 = n7 - n9;
                            if (n9 < 0) {
                                n11 = n7 + n5;
                            }
                            nSRect3.x = n2;
                            nSRect3.y = n11;
                            nSRect3.width = n4;
                            nSRect3.height = Math.abs(n9);
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                    }
                    NSRect nSRect4 = new NSRect();
                    nSRect4.x = n2;
                    nSRect4.y = n3;
                    nSRect4.width = n4;
                    nSRect4.height = n5;
                    OS.NSIntersectionRect(nSRect, nSRect, nSRect4);
                    if (!OS.NSEqualRects(nSRect, nSRect4)) {
                        if (nSRect4.x != nSRect.x) {
                            nSRect3.x = nSRect4.x + (double)n8;
                            nSRect3.y = nSRect4.y + (double)n9;
                            nSRect3.width = nSRect.x - nSRect4.x;
                            nSRect3.height = nSRect4.height;
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                        if (nSRect.x + nSRect.width != nSRect4.x + nSRect4.width) {
                            nSRect3.x = nSRect4.x + nSRect.width + (double)n8;
                            nSRect3.y = nSRect4.y + (double)n9;
                            nSRect3.width = nSRect4.width - nSRect.width;
                            nSRect3.height = nSRect4.height;
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                        if (nSRect.y != nSRect4.y) {
                            nSRect3.x = nSRect.x + (double)n8;
                            nSRect3.y = nSRect4.y + (double)n9;
                            nSRect3.width = nSRect.width;
                            nSRect3.height = nSRect.y - nSRect4.y;
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                        if (nSRect.y + nSRect.height != nSRect4.y + nSRect4.height) {
                            nSRect3.x = nSRect.x + (double)n8;
                            nSRect3.y = nSRect.y + nSRect.height + (double)n9;
                            nSRect3.width = nSRect.width;
                            nSRect3.height = nSRect4.y + nSRect4.height - (nSRect.y + nSRect.height);
                            nSView.setNeedsDisplayInRect(nSRect3);
                        }
                    }
                }
                return;
            }
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    static long createCGPathRef(NSBezierPath nSBezierPath) {
        long l2 = nSBezierPath.elementCount();
        if (l2 > 0L) {
            long l3;
            long l4 = OS.CGPathCreateMutable();
            if (l4 == 0L) {
                SWT.error(2);
            }
            if ((l3 = OS.malloc(NSPoint.sizeof * 3)) == 0L) {
                SWT.error(2);
            }
            double[] dArray = new double[6];
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = (int)nSBezierPath.elementAtIndex(n2, l3);
                switch (n3) {
                    case 0: {
                        OS.memmove(dArray, l3, (long)NSPoint.sizeof);
                        OS.CGPathMoveToPoint(l4, 0L, dArray[0], dArray[1]);
                        break;
                    }
                    case 1: {
                        OS.memmove(dArray, l3, (long)NSPoint.sizeof);
                        OS.CGPathAddLineToPoint(l4, 0L, dArray[0], dArray[1]);
                        break;
                    }
                    case 2: {
                        OS.memmove(dArray, l3, (long)(NSPoint.sizeof * 3));
                        OS.CGPathAddCurveToPoint(l4, 0L, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        break;
                    }
                    case 3: {
                        OS.CGPathCloseSubpath(l4);
                    }
                }
                ++n2;
            }
            OS.free(l3);
            return l4;
        }
        return 0L;
    }

    void createLayout() {
        NSSize nSSize = new NSSize();
        nSSize.width = 5000000.0;
        nSSize.height = 5000000.0;
        NSTextStorage nSTextStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        NSLayoutManager nSLayoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        nSLayoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
        NSTextContainer nSTextContainer = (NSTextContainer)new NSTextContainer().alloc();
        nSTextContainer = nSTextContainer.initWithContainerSize(nSSize);
        nSTextContainer.setLineFragmentPadding(0.0);
        nSTextStorage.addLayoutManager(nSLayoutManager);
        nSLayoutManager.addTextContainer(nSTextContainer);
        nSLayoutManager.release();
        nSTextContainer.release();
        this.data.textContainer = nSTextContainer;
        this.data.layoutManager = nSLayoutManager;
        this.data.textStorage = nSTextStorage;
    }

    NSAttributedString createString(String string, int n2, boolean bl2) {
        Object object;
        Object object2;
        NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
        Font font = this.data.font;
        nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
        font.addTraits(nSMutableDictionary);
        if (bl2) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    nSMutableDictionary.setObject(pattern.color, OS.NSForegroundColorAttributeName);
                }
            } else {
                object2 = this.data.fg;
                if (object2 == null) {
                    object = this.data.foreground;
                    this.data.fg = NSColor.colorWithDeviceRed(object[0], object[1], object[2], (float)this.data.alpha / 255.0f);
                    object2 = this.data.fg;
                    ((NSObject)object2).retain();
                }
                nSMutableDictionary.setObject((id)object2, OS.NSForegroundColorAttributeName);
            }
        }
        if ((n2 & 4) == 0) {
            nSMutableDictionary.setObject(this.device.paragraphStyle, OS.NSParagraphStyleAttributeName);
        }
        int n3 = string.length();
        object2 = new char[n3];
        string.getChars(0, n3, (char[])object2, 0);
        if ((n2 & 8) != 0 || (n2 & 2) == 0) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < ((Object)object2).length) {
                int n6 = n5++;
                Object object3 = object2[n4++];
                object2[n6] = object3;
                Object object4 = object3;
                switch (object4) {
                    case 38: {
                        if ((n2 & 8) == 0 || n4 == ((Object)object2).length) break;
                        if (object2[n4] == 38) {
                            ++n4;
                            break;
                        }
                        --n5;
                        break;
                    }
                    case 10: 
                    case 13: {
                        if ((n2 & 2) != 0) break;
                        if (object4 == 13 && n4 != ((Object)object2).length && object2[n4] == 10) {
                            ++n4;
                        }
                        --n5;
                    }
                }
            }
            n3 = n5;
        }
        object = ((NSString)new NSString().alloc()).initWithCharacters((char[])object2, n3);
        NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString((NSString)object, nSMutableDictionary);
        nSMutableDictionary.release();
        ((NSObject)object).release();
        return nSAttributedString;
    }

    NSBezierPath createNSBezierPath(long l2) {
        Callback callback = new Callback(this, "applierFunc", 2);
        long l3 = callback.getAddress();
        if (l3 == 0L) {
            SWT.error(3);
        }
        this.typeCount = 0;
        this.count = 0;
        this.element = new CGPathElement();
        OS.CGPathApply(l2, 0L, l3);
        this.types = new byte[this.typeCount];
        this.points = new double[this.count];
        this.point = new double[6];
        this.typeCount = 0;
        this.count = 0;
        OS.CGPathApply(l2, 0L, l3);
        callback.dispose();
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        NSPoint nSPoint = new NSPoint();
        NSPoint nSPoint2 = new NSPoint();
        NSPoint nSPoint3 = new NSPoint();
        int n2 = 0;
        block7: for (int i2 = 0; i2 < this.types.length; ++i2) {
            switch (this.types[i2]) {
                case 1: {
                    nSPoint.x = this.points[n2++];
                    nSPoint.y = this.points[n2++];
                    nSBezierPath.moveToPoint(nSPoint);
                    continue block7;
                }
                case 2: {
                    nSPoint.x = this.points[n2++];
                    nSPoint.y = this.points[n2++];
                    nSBezierPath.lineToPoint(nSPoint);
                    continue block7;
                }
                case 4: {
                    nSPoint2.x = this.points[n2++];
                    nSPoint2.y = this.points[n2++];
                    nSPoint3.x = this.points[n2++];
                    nSPoint3.y = this.points[n2++];
                    nSPoint.x = this.points[n2++];
                    nSPoint.y = this.points[n2++];
                    nSBezierPath.curveToPoint(nSPoint, nSPoint2, nSPoint3);
                    continue block7;
                }
                case 3: {
                    double d2 = nSPoint.x;
                    double d3 = nSPoint.y;
                    nSPoint2.x = this.points[n2++];
                    nSPoint2.y = this.points[n2++];
                    nSPoint.x = this.points[n2++];
                    nSPoint.y = this.points[n2++];
                    double d4 = d2;
                    double d5 = d3;
                    double d6 = d4 + 2.0 * (nSPoint2.x - d4) / 3.0;
                    double d7 = d5 + 2.0 * (nSPoint2.y - d5) / 3.0;
                    double d8 = d6 + (nSPoint.x - d4) / 3.0;
                    double d9 = d7 + (nSPoint.y - d5) / 3.0;
                    nSPoint2.x = d6;
                    nSPoint2.y = d7;
                    nSPoint3.x = d8;
                    nSPoint3.y = d9;
                    nSBezierPath.curveToPoint(nSPoint, nSPoint2, nSPoint3);
                    continue block7;
                }
                case 5: {
                    nSBezierPath.closePath();
                    continue block7;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
        }
        this.element = null;
        this.types = null;
        this.points = null;
        nSPoint = null;
        return nSBezierPath;
    }

    void destroy() {
        Image image = this.data.image;
        if (image != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if (this.data.textStorage != null) {
            this.data.textStorage.release();
        }
        this.data.textStorage = null;
        this.data.layoutManager = null;
        this.data.textContainer = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        if (this.data.path != null) {
            this.data.path.release();
        }
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
        }
        if (this.data.visiblePath != null) {
            this.data.visiblePath.release();
        }
        if (this.data.transform != null) {
            this.data.transform.release();
        }
        if (this.data.inverseTransform != null) {
            this.data.inverseTransform.release();
        }
        this.data.visiblePath = null;
        this.data.clipPath = null;
        this.data.path = null;
        this.data.inverseTransform = null;
        this.data.transform = null;
        this.data.bg = null;
        this.data.fg = null;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle.id, this.data);
        }
        this.handle.restoreGraphicsState();
        this.handle.release();
        this.drawable = null;
        this.data.image = null;
        this.data = null;
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            double d2 = this.data.drawXOffset;
            double d3 = this.data.drawYOffset;
            nSAffineTransform.translateXBy((double)n2 + d2 + (double)((float)n4 / 2.0f), (double)n3 + d3 + (double)((float)n5 / 2.0f));
            nSAffineTransform.scaleXBy((float)n4 / 2.0f, (float)n5 / 2.0f);
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            float f2 = -n6;
            float f3 = -(n6 + n7);
            nSBezierPath.appendBezierPathWithArcWithCenter(nSPoint, 1.0, f2, f3, n7 > 0);
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawFocus(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        try {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            CGRect cGRect = new CGRect();
            cGRect.origin.x = n2 + nArray[0];
            cGRect.origin.y = n3 + nArray[0];
            cGRect.size.width = n4 - nArray[0] * 2;
            cGRect.size.height = n5 - nArray[0] * 2;
            OS.HIThemeDrawFocusRect(cGRect, true, this.handle.graphicsPort(), 0);
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public void drawImage(Image image, int n2, int n3) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n2, n3, -1, -1, true);
    }

    public void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0 || n8 == 0 || n9 == 0) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n8 < 0 || n9 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        NSImage nSImage = image.handle;
        NSSize nSSize = nSImage.size();
        int n10 = (int)nSSize.width;
        int n11 = (int)nSSize.height;
        if (bl2) {
            n4 = n8 = n10;
            n5 = n9 = n11;
        } else {
            boolean bl3 = bl2 = n2 == 0 && n3 == 0 && n4 == n8 && n8 == n10 && n5 == n9 && n9 == n11;
            if (n2 + n4 > n10 || n3 + n5 > n11) {
                SWT.error(5);
            }
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        try {
            if (image.memGC != null) {
                image.createAlpha();
            }
            this.handle.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.scaleXBy(1.0, -1.0);
            nSAffineTransform.translateXBy(0.0, -(n9 + 2 * n7));
            nSAffineTransform.concat();
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n11 - (n3 + n5);
            nSRect.width = n4;
            nSRect.height = n5;
            NSRect nSRect2 = new NSRect();
            nSRect2.x = n6;
            nSRect2.y = n7;
            nSRect2.width = n8;
            nSRect2.height = n9;
            nSImage.drawInRect(nSRect2, nSRect, 2L, (float)this.data.alpha / 255.0f);
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n2 == n4 && n3 == n5 && this.data.lineWidth <= 1.0f) {
            this.drawPoint(n2, n3);
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = (double)n2 + this.data.drawXOffset;
            nSPoint.y = (double)n3 + this.data.drawYOffset;
            nSBezierPath.moveToPoint(nSPoint);
            nSPoint.x = (double)n4 + this.data.drawXOffset;
            nSPoint.y = (double)n5 + this.data.drawYOffset;
            nSBezierPath.lineToPoint(nSPoint);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            NSBezierPath nSBezierPath = this.data.path;
            NSRect nSRect = new NSRect();
            nSRect.x = (double)n2 + this.data.drawXOffset;
            nSRect.y = (double)n3 + this.data.drawXOffset;
            nSRect.width = n4;
            nSRect.height = n5;
            nSBezierPath.appendBezierPathWithOvalInRect(nSRect);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(this.data.drawXOffset, this.data.drawYOffset);
            nSAffineTransform.concat();
            NSBezierPath nSBezierPath = this.data.path;
            nSBezierPath.appendBezierPath(path.handle);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPoint(int n2, int n3) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3328);
        try {
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = 1.0;
            nSRect.height = 1.0;
            NSBezierPath nSBezierPath = this.data.path;
            nSBezierPath.appendBezierPathWithRect(nSRect);
            nSBezierPath.fill();
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 4) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            double d2 = this.data.drawXOffset;
            double d3 = this.data.drawYOffset;
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = (double)nArray[0] + d2;
            nSPoint.y = (double)nArray[1] + d3;
            nSBezierPath.moveToPoint(nSPoint);
            int n2 = nArray.length / 2 * 2;
            for (int i2 = 2; i2 < n2; i2 += 2) {
                nSPoint.x = (double)nArray[i2] + d2;
                nSPoint.y = (double)nArray[i2 + 1] + d3;
                nSBezierPath.lineToPoint(nSPoint);
            }
            nSBezierPath.closePath();
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 4) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            double d2 = this.data.drawXOffset;
            double d3 = this.data.drawYOffset;
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = (double)nArray[0] + d2;
            nSPoint.y = (double)nArray[1] + d3;
            nSBezierPath.moveToPoint(nSPoint);
            int n2 = nArray.length / 2 * 2;
            for (int i2 = 2; i2 < n2; i2 += 2) {
                nSPoint.x = (double)nArray[i2] + d2;
                nSPoint.y = (double)nArray[i2 + 1] + d3;
                nSBezierPath.lineToPoint(nSPoint);
            }
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRectangle(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            NSRect nSRect = new NSRect();
            nSRect.x = (double)n2 + this.data.drawXOffset;
            nSRect.y = (double)n3 + this.data.drawYOffset;
            nSRect.width = n4;
            nSRect.height = n5;
            NSBezierPath nSBezierPath = this.data.path;
            nSBezierPath.appendBezierPathWithRect(nSRect);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public void drawRectangle(Rectangle rectangle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n6 == 0 || n7 == 0) {
            this.drawRectangle(n2, n3, n4, n5);
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3833);
        try {
            NSBezierPath nSBezierPath = this.data.path;
            NSRect nSRect = new NSRect();
            nSRect.x = (double)n2 + this.data.drawXOffset;
            nSRect.y = (double)n3 + this.data.drawYOffset;
            nSRect.width = n4;
            nSRect.height = n5;
            nSBezierPath.appendBezierPathWithRoundedRect(nSRect, (float)n6 / 2.0f, (float)n7 / 2.0f);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.stroke();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, n2, n3, false);
    }

    public void drawString(String string, int n2, int n3, boolean bl2) {
        this.drawText(string, n2, n3, bl2 ? 1 : 0);
    }

    public void drawText(String string, int n2, int n3) {
        this.drawText(string, n2, n3, 6);
    }

    public void drawText(String string, int n2, int n3, boolean bl2) {
        int n4 = 6;
        if (bl2) {
            n4 |= 1;
        }
        this.drawText(string, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String string, int n2, int n3, int n4) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3332);
        try {
            int n5 = string.length();
            if (n5 == 0) {
                return;
            }
            boolean bl2 = true;
            switch (this.data.textAntialias) {
                case -1: {
                    if (this.handle.isDrawingToScreen()) break;
                    bl2 = false;
                    break;
                }
                case 0: {
                    bl2 = false;
                    break;
                }
                case 1: {
                    bl2 = true;
                }
            }
            this.handle.saveGraphicsState();
            this.handle.setShouldAntialias(bl2);
            if (this.data.textStorage == null) {
                this.createLayout();
            }
            NSAttributedString nSAttributedString = this.createString(string, n4, true);
            this.data.textStorage.setAttributedString(nSAttributedString);
            nSAttributedString.release();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n2;
            nSPoint.y = n3;
            NSRange nSRange = this.data.layoutManager.glyphRangeForTextContainer(this.data.textContainer);
            if ((n4 & 1) == 0) {
                NSRect nSRect = this.data.layoutManager.usedRectForTextContainer(this.data.textContainer);
                nSRect.x = n2;
                nSRect.y = n3;
                Pattern pattern = this.data.backgroundPattern;
                if (pattern != null) {
                    this.setPatternPhase(pattern);
                }
                if (pattern != null && pattern.gradient != null) {
                    NSBezierPath nSBezierPath = NSBezierPath.bezierPathWithRect(nSRect);
                    this.fillPattern(nSBezierPath, pattern);
                } else {
                    NSColor nSColor = this.data.bg;
                    if (nSColor == null) {
                        double[] dArray = this.data.background;
                        nSColor = this.data.bg = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], (float)this.data.alpha / 255.0f);
                        nSColor.retain();
                    }
                    nSColor.setFill();
                    NSBezierPath.fillRect(nSRect);
                }
            }
            this.data.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            double d2 = this.data.drawXOffset;
            double d3 = this.data.drawYOffset;
            nSAffineTransform.translateXBy((double)n2 + d2 + (double)((float)n4 / 2.0f), (double)n3 + d3 + (double)((float)n5 / 2.0f));
            nSAffineTransform.scaleXBy((float)n4 / 2.0f, (float)n5 / 2.0f);
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            nSBezierPath.moveToPoint(nSPoint);
            float f2 = -n6;
            float f3 = -(n6 + n7);
            nSBezierPath.appendBezierPathWithArcWithCenter(nSPoint, 1.0, f2, f3, n7 > 0);
            nSBezierPath.closePath();
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillGradientRectangle(int n2, int n3, int n4, int n5, boolean bl2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        try {
            RGB rGB;
            RGB rGB2 = this.getBackground().getRGB();
            RGB rGB3 = rGB = this.getForeground().getRGB();
            RGB rGB4 = rGB2;
            boolean bl3 = false;
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
                if (!bl2) {
                    bl3 = true;
                }
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
                if (bl2) {
                    bl3 = true;
                }
            }
            if (bl3) {
                rGB3 = rGB2;
                rGB4 = rGB;
            }
            if (rGB3.equals(rGB4)) {
                this.fillRectangle(n2, n3, n4, n5);
            } else {
                NSColor nSColor = NSColor.colorWithDeviceRed((float)rGB3.red / 255.0f, (float)rGB3.green / 255.0f, (float)rGB3.blue / 255.0f, (float)this.data.alpha / 255.0f);
                NSColor nSColor2 = NSColor.colorWithDeviceRed((float)rGB4.red / 255.0f, (float)rGB4.green / 255.0f, (float)rGB4.blue / 255.0f, (float)this.data.alpha / 255.0f);
                NSGradient nSGradient = ((NSGradient)new NSGradient().alloc()).initWithStartingColor(nSColor, nSColor2);
                NSRect nSRect = new NSRect();
                nSRect.x = n2;
                nSRect.y = n3;
                nSRect.width = n4;
                nSRect.height = n5;
                nSGradient.drawInRect(nSRect, bl2 ? 90.0 : 0.0);
                nSGradient.release();
            }
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOval(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            NSBezierPath nSBezierPath = this.data.path;
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            nSBezierPath.appendBezierPathWithOvalInRect(nSRect);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    void fillPattern(NSBezierPath nSBezierPath, Pattern pattern) {
        double d2;
        double d3;
        double d4;
        double d5;
        this.handle.saveGraphicsState();
        nSBezierPath.addClip();
        NSRect nSRect = nSBezierPath.bounds();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = pattern.pt1.x;
        nSPoint.y = pattern.pt1.y;
        NSPoint nSPoint2 = new NSPoint();
        nSPoint2.x = pattern.pt2.x;
        nSPoint2.y = pattern.pt2.y;
        double d6 = nSPoint2.x - nSPoint.x;
        double d7 = nSPoint2.y - nSPoint.y;
        if (d6 == 0.0 && d7 == 0.0) {
            double[] dArray = pattern.color1;
            NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], (float)this.data.alpha / 255.0f).setFill();
            nSBezierPath.fill();
            this.handle.restoreGraphicsState();
            return;
        }
        if (d6 == 0.0 || d7 == 0.0) {
            d5 = nSRect.x;
            d4 = nSRect.y;
            d3 = nSRect.x + nSRect.width;
            d2 = nSRect.y + nSRect.height;
            if (d6 < 0.0 || d7 < 0.0) {
                d5 = d3;
                d4 = d2;
                d3 = nSRect.x;
                d2 = nSRect.y;
            }
        } else {
            double d8 = (nSPoint2.y - nSPoint.y) / (nSPoint2.x - nSPoint.x);
            double d9 = nSPoint2.y - d8 * nSPoint2.x;
            double d10 = -1.0 / d8;
            double d11 = nSRect.y - d10 * nSRect.x;
            d5 = d3 = (d9 - d11) / (d10 - d8);
            d11 = nSRect.y + nSRect.height - d10 * nSRect.x;
            double d12 = (d9 - d11) / (d10 - d8);
            d5 = d6 > 0.0 ? Math.min(d5, d12) : Math.max(d5, d12);
            d3 = d6 < 0.0 ? Math.min(d3, d12) : Math.max(d3, d12);
            d11 = nSRect.y - d10 * (nSRect.x + nSRect.width);
            d12 = (d9 - d11) / (d10 - d8);
            d5 = d6 > 0.0 ? Math.min(d5, d12) : Math.max(d5, d12);
            d3 = d6 < 0.0 ? Math.min(d3, d12) : Math.max(d3, d12);
            d11 = nSRect.y + nSRect.height - d10 * (nSRect.x + nSRect.width);
            d12 = (d9 - d11) / (d10 - d8);
            d5 = d6 > 0.0 ? Math.min(d5, d12) : Math.max(d5, d12);
            d3 = d6 < 0.0 ? Math.min(d3, d12) : Math.max(d3, d12);
            d4 = d8 * d5 + d9;
            d2 = d8 * d3 + d9;
        }
        if (d6 != 0.0) {
            while (d6 > 0.0 && nSPoint.x >= d5 || d6 < 0.0 && nSPoint.x <= d5) {
                nSPoint.x -= d6;
                nSPoint.y -= d7;
            }
        } else {
            while (d7 > 0.0 && nSPoint.y >= d4 || d7 < 0.0 && nSPoint.y <= d4) {
                nSPoint.x -= d6;
                nSPoint.y -= d7;
            }
        }
        nSPoint2.x = nSPoint.x;
        nSPoint2.y = nSPoint.y;
        do {
            nSPoint2.x += d6;
            nSPoint2.y += d7;
            pattern.gradient.drawFromPoint(nSPoint, nSPoint2, 0L);
            nSPoint.x = nSPoint2.x;
            nSPoint.y = nSPoint2.y;
        } while (d6 > 0.0 && nSPoint2.x <= d3 || d6 < 0.0 && nSPoint2.x >= d3 || d6 == 0.0 && (d7 > 0.0 && nSPoint2.y <= d2 || d7 < 0.0 && nSPoint2.y >= d2));
        this.handle.restoreGraphicsState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            NSBezierPath nSBezierPath = this.data.path;
            nSBezierPath.appendBezierPath(path.handle);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 4) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            NSBezierPath nSBezierPath = this.data.path;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = nArray[0];
            nSPoint.y = nArray[1];
            nSBezierPath.moveToPoint(nSPoint);
            int n2 = nArray.length / 2 * 2;
            for (int i2 = 2; i2 < n2; i2 += 2) {
                nSPoint.x = nArray[i2];
                nSPoint.y = nArray[i2 + 1];
                nSBezierPath.lineToPoint(nSPoint);
            }
            nSBezierPath.closePath();
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRectangle(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            NSBezierPath nSBezierPath = this.data.path;
            nSBezierPath.appendBezierPathWithRect(nSRect);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n6 == 0 || n7 == 0) {
            this.fillRectangle(n2, n3, n4, n5);
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3074);
        try {
            NSBezierPath nSBezierPath = this.data.path;
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            nSBezierPath.appendBezierPathWithRoundedRect(nSRect, (float)n6 / 2.0f, (float)n7 / 2.0f);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(nSBezierPath, pattern);
            } else {
                nSBezierPath.fill();
            }
            nSBezierPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    void strokePattern(NSBezierPath nSBezierPath, Pattern pattern) {
        this.handle.saveGraphicsState();
        long l2 = GC.createCGPathRef(nSBezierPath);
        long l3 = this.handle.graphicsPort();
        OS.CGContextSaveGState(l3);
        this.initCGContext(l3);
        OS.CGContextAddPath(l3, l2);
        OS.CGContextReplacePathWithStrokedPath(l3);
        OS.CGPathRelease(l2);
        l2 = 0L;
        l2 = OS.CGContextCopyPath(l3);
        if (l2 == 0L) {
            SWT.error(2);
        }
        OS.CGContextRestoreGState(l3);
        NSBezierPath nSBezierPath2 = this.createNSBezierPath(l2);
        OS.CGPathRelease(l2);
        this.fillPattern(nSBezierPath2, pattern);
        this.handle.restoreGraphicsState();
    }

    void flush() {
        this.handle.flushGraphics();
    }

    public int getAdvanceWidth(char c2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c2})).x;
    }

    public Color getBackground() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return Color.cocoa_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return this.data.backgroundPattern;
    }

    public boolean getAdvanced() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public int getCharWidth(char c2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c2})).x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getClipping() {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            Object object;
            NSRect nSRect = null;
            if (this.data.view != null) {
                nSRect = this.data.view.visibleRect();
            } else {
                nSRect = new NSRect();
                if (this.data.image != null) {
                    object = this.data.image.handle.size();
                    nSRect.width = ((NSSize)object).width;
                    nSRect.height = ((NSSize)object).height;
                } else if (this.data.size != null) {
                    nSRect.width = this.data.size.width;
                    nSRect.height = this.data.size.height;
                }
            }
            if (this.data.paintRect != null || this.data.clipPath != null || this.data.inverseTransform != null) {
                if (this.data.paintRect != null) {
                    OS.NSIntersectionRect(nSRect, nSRect, this.data.paintRect);
                }
                if (this.data.clipPath != null) {
                    object = this.data.clipPath.bounds();
                    ((NSRect)object).x = (int)((NSRect)object).x;
                    ((NSRect)object).y = (int)((NSRect)object).y;
                    OS.NSIntersectionRect(nSRect, nSRect, (NSRect)object);
                }
                if (this.data.inverseTransform != null && nSRect.width > 0.0 && nSRect.height > 0.0) {
                    object = new NSPoint();
                    ((NSPoint)object).x = nSRect.x;
                    ((NSPoint)object).y = nSRect.y;
                    NSSize nSSize = new NSSize();
                    nSSize.width = nSRect.width;
                    nSSize.height = nSRect.height;
                    object = this.data.inverseTransform.transformPoint((NSPoint)object);
                    nSSize = this.data.inverseTransform.transformSize(nSSize);
                    nSRect.x = ((NSPoint)object).x;
                    nSRect.y = ((NSPoint)object).y;
                    nSRect.width = nSSize.width;
                    nSRect.height = nSSize.height;
                }
            }
            object = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
            return object;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClipping(Region region) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            Object object;
            region.subtract(region);
            NSRect nSRect = null;
            if (this.data.view != null) {
                nSRect = this.data.view.visibleRect();
            } else {
                nSRect = new NSRect();
                if (this.data.image != null) {
                    object = this.data.image.handle.size();
                    nSRect.width = ((NSSize)object).width;
                    nSRect.height = ((NSSize)object).height;
                } else if (this.data.size != null) {
                    nSRect.width = this.data.size.width;
                    nSRect.height = this.data.size.height;
                }
            }
            region.add((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
            object = this.data.paintRect;
            if (object != null) {
                region.intersect((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
            }
            if (this.data.clipPath != null) {
                NSBezierPath nSBezierPath = this.data.clipPath.bezierPathByFlatteningPath();
                int n2 = (int)nSBezierPath.elementCount();
                int n3 = 0;
                Region region2 = new Region(this.device);
                int[] nArray = new int[n2 * 2];
                long l2 = OS.malloc(NSPoint.sizeof);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                NSPoint nSPoint = new NSPoint();
                block8: for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = (int)nSBezierPath.elementAtIndex(i2, l2);
                    switch (n4) {
                        case 0: {
                            if (n3 != 0) {
                                region2.add(nArray, n3);
                            }
                            n3 = 0;
                            OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                            nArray[n3++] = (int)nSPoint.x;
                            nArray[n3++] = (int)nSPoint.y;
                            continue block8;
                        }
                        case 1: {
                            OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                            nArray[n3++] = (int)nSPoint.x;
                            nArray[n3++] = (int)nSPoint.y;
                            continue block8;
                        }
                        case 3: {
                            if (n3 != 0) {
                                region2.add(nArray, n3);
                            }
                            n3 = 0;
                        }
                    }
                }
                if (n3 != 0) {
                    region2.add(nArray, n3);
                }
                OS.free(l2);
                region.intersect(region2);
                region2.dispose();
            }
            if (this.data.inverseTransform != null) {
                region.convertRgn(this.data.inverseTransform);
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public int getFillRule() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics() {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(4);
        try {
            Object object;
            if (this.data.textStorage == null) {
                this.createLayout();
            }
            if (this.data.font.metrics == null) {
                object = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(3L);
                nSMutableDictionary.setObject(this.data.font.handle, OS.NSFontAttributeName);
                this.data.font.addTraits(nSMutableDictionary);
                NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(NSString.stringWith((String)object), nSMutableDictionary);
                this.data.textStorage.setAttributedString(nSAttributedString);
                nSAttributedString.release();
                nSMutableDictionary.release();
                NSLayoutManager nSLayoutManager = this.data.layoutManager;
                nSLayoutManager.glyphRangeForTextContainer(this.data.textContainer);
                NSRect nSRect = nSLayoutManager.usedRectForTextContainer(this.data.textContainer);
                int n2 = (int)Math.ceil(nSRect.width) / ((String)object).length();
                int n3 = (int)nSLayoutManager.defaultBaselineOffsetForFont(this.data.font.handle);
                int n4 = (int)nSLayoutManager.defaultLineHeightForFont(this.data.font.handle);
                this.data.font.metrics = FontMetrics.cocoa_new(n3, n4 - n3, n2, 0, n4);
            }
            object = this.data.font.metrics;
            return object;
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public Color getForeground() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return Color.cocoa_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == null) {
            SWT.error(24);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(3072);
        this.uncheckGC(nSAutoreleasePool);
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == null) {
            SWT.error(44);
        }
        int n2 = (int)this.handle.imageInterpolation();
        switch (n2) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == null) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)this.data.lineDashes[i2];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    public void getTransform(Transform transform) {
        NSAffineTransform nSAffineTransform;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((nSAffineTransform = this.data.transform) != null) {
            NSAffineTransformStruct nSAffineTransformStruct = nSAffineTransform.transformStruct();
            transform.handle.setTransformStruct(nSAffineTransformStruct);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(Drawable drawable, GCData gCData, long l2) {
        if (gCData.foreground != null) {
            gCData.state &= 0xFFFFFEFE;
        }
        if (gCData.background != null) {
            gCData.state &= 0xFFFFFFFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        gCData.state &= 0xFFFFFDFF;
        Image image = gCData.image;
        if (image != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = new NSGraphicsContext(l2);
        this.handle.retain();
        this.handle.saveGraphicsState();
        gCData.path = NSBezierPath.bezierPath();
        gCData.path.setWindingRule(gCData.fillRule == 2 ? 0L : 1L);
        gCData.path.retain();
    }

    void initCGContext(long l2) {
        int n2 = this.data.state;
        if ((n2 & 0x40) != 0) {
            OS.CGContextSetLineWidth(l2, this.data.lineWidth == 0.0f ? 1.0 : (double)this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 |= 8;
                }
            }
        }
        if ((n2 & 8) != 0) {
            float[] fArray = null;
            float f2 = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    fArray = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    fArray = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    fArray = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    fArray = this.data.lineDashes;
                }
            }
            if (fArray != null) {
                float[] fArray2 = new float[fArray.length];
                for (int i2 = 0; i2 < fArray2.length; ++i2) {
                    fArray2[i2] = f2 == 0.0f || this.data.lineStyle == 6 ? fArray[i2] : fArray[i2] * f2;
                }
                OS.CGContextSetLineDash(l2, this.data.lineDashesOffset, fArray2, fArray2.length);
            } else {
                OS.CGContextSetLineDash(l2, 0.0, null, 0L);
            }
        }
        if ((n2 & 0x80) != 0) {
            OS.CGContextSetMiterLimit(l2, this.data.lineMiterLimit);
        }
        if ((n2 & 0x20) != 0) {
            int n3 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    break;
                }
                case 3: {
                    n3 = 2;
                }
            }
            OS.CGContextSetLineJoin(l2, n3);
        }
        if ((n2 & 0x10) != 0) {
            int n4 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    n4 = 0;
                    break;
                }
                case 3: {
                    n4 = 2;
                }
            }
            OS.CGContextSetLineCap(l2, n4);
        }
    }

    public boolean isClipped() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.clipPath != null;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    boolean isIdentity(float[] fArray) {
        return fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 0.0f;
    }

    public void setAdvanced(boolean bl2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (!bl2) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping((Rectangle)null);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.alpha = n2 & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        boolean bl2 = true;
        switch (n2) {
            case -1: {
                if (this.handle.isDrawingToScreen()) break;
                bl2 = false;
                break;
            }
            case 0: {
                bl2 = false;
                break;
            }
            case 1: {
                bl2 = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = n2;
        this.handle.setShouldAntialias(bl2);
    }

    public void setBackground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        this.data.bg = null;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClipping(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            NSBezierPath nSBezierPath = NSBezierPath.bezierPathWithRect(nSRect);
            nSBezierPath.retain();
            this.setClipping(nSBezierPath);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void setClipping(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.setClipping(new NSBezierPath(path.handle.copy().id));
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping((NSBezierPath)null);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.setClipping(region != null ? region.getPath() : null);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void setClipping(NSBezierPath nSBezierPath) {
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
            this.data.clipPath = null;
        }
        if (nSBezierPath != null) {
            this.data.clipPath = nSBezierPath;
            if (this.data.transform != null) {
                this.data.clipPath.transformUsingAffineTransform(this.data.transform);
            }
        }
        this.data.state &= 0xFFFFFBFF;
    }

    public void setFillRule(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (n2) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = n2;
        this.data.path.setWindingRule(n2 == 2 ? 0L : 1L);
    }

    public void setFont(Font font) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        this.data.fg = null;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setInterpolation(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        int n3 = 0;
        switch (n2) {
            case -1: {
                n3 = 0;
                break;
            }
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle.setImageInterpolation(n3);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        float f2;
        int n2;
        int n3;
        int n4;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        int n5 = 0;
        float f3 = lineAttributes.width;
        if (f3 != this.data.lineWidth) {
            n5 |= 0x240;
        }
        if ((n4 = lineAttributes.style) != this.data.lineStyle) {
            n5 |= 8;
            switch (n4) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n4 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n3 = lineAttributes.join) != this.data.lineJoin) {
            n5 |= 0x20;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.cap) != this.data.lineCap) {
            n5 |= 0x10;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl2 = fArray2 == null || fArray2.length != fArray.length;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                float f4 = fArray[i2];
                if (f4 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl2 || fArray2[i2] == f4) continue;
                bl2 = true;
            }
            if (bl2) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n5 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n5 |= 8;
        } else {
            fArray = fArray2;
        }
        float f5 = lineAttributes.dashOffset;
        if (f5 != this.data.lineDashesOffset) {
            n5 |= 8;
        }
        if ((f2 = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n5 |= 0x80;
        }
        if (n5 == 0) {
            return;
        }
        this.data.lineWidth = f3;
        this.data.lineStyle = n4;
        this.data.lineCap = n2;
        this.data.lineJoin = n3;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f5;
        this.data.lineMiterLimit = f2;
        this.data.state &= ~n5;
    }

    public void setLineCap(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineCap == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n2;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n2;
            boolean bl2 = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n3 = nArray[n2];
                if (n3 <= 0) {
                    SWT.error(5);
                }
                if (bl2 || fArray[n2] == (float)n3) continue;
                bl2 = true;
            }
            if (!bl2) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.data.lineDashes[n2] = nArray[n2];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n2;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n2;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n2) {
            return;
        }
        this.data.lineWidth = n2;
        this.data.state &= 0xFFFFFDBF;
    }

    void setPatternPhase(Pattern pattern) {
        if (pattern.image == null) {
            return;
        }
        NSPoint nSPoint = new NSPoint();
        if (this.data.image != null) {
            nSPoint.y += this.data.image.handle.size().height - pattern.image.handle.size().height;
        } else if (this.data.view != null) {
            NSView nSView = this.data.view;
            if (!nSView.isFlipped()) {
                nSPoint.y = nSView.bounds().height;
            }
            NSView nSView2 = nSView.window().contentView();
            nSPoint = nSView.convertPoint_toView_(nSPoint, nSView2);
            nSPoint.y = nSView2.bounds().height - nSPoint.y;
        } else if (this.data.size != null) {
            nSPoint.y += this.data.size.height - pattern.image.handle.size().height;
        }
        this.handle.setPatternPhase(nSPoint);
    }

    public void setXORMode(boolean bl2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.xorMode = bl2;
    }

    public void setTextAntialias(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (n2) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = n2;
    }

    public void setTransform(Transform transform) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (transform != null) {
            if (this.data.transform != null) {
                this.data.transform.release();
            }
            if (this.data.inverseTransform != null) {
                this.data.inverseTransform.release();
            }
            this.data.transform = ((NSAffineTransform)new NSAffineTransform().alloc()).initWithTransform(transform.handle);
            this.data.inverseTransform = ((NSAffineTransform)new NSAffineTransform().alloc()).initWithTransform(transform.handle);
            NSAffineTransformStruct nSAffineTransformStruct = this.data.inverseTransform.transformStruct();
            if (nSAffineTransformStruct.m11 * nSAffineTransformStruct.m22 - nSAffineTransformStruct.m12 * nSAffineTransformStruct.m21 != 0.0) {
                this.data.inverseTransform.invert();
            }
        } else {
            this.data.inverseTransform = null;
            this.data.transform = null;
        }
        this.data.state &= 0xFFFFF5FF;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point textExtent(String string, int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = this.checkGC(4);
        try {
            int n3 = string.length();
            if (this.data.textStorage == null) {
                this.createLayout();
            }
            NSAttributedString nSAttributedString = this.createString(n3 == 0 ? " " : string, n2, false);
            this.data.textStorage.setAttributedString(nSAttributedString);
            nSAttributedString.release();
            this.data.layoutManager.glyphRangeForTextContainer(this.data.textContainer);
            NSRect nSRect = this.data.layoutManager.usedRectForTextContainer(this.data.textContainer);
            Point point = new Point(n3 == 0 ? 0 : (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
            return point;
        }
        finally {
            this.uncheckGC(nSAutoreleasePool);
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    void uncheckGC(NSAutoreleasePool nSAutoreleasePool) {
        NSView nSView;
        if (this.data.flippedContext != null && this.data.restoreContext) {
            NSGraphicsContext.static_restoreGraphicsState();
            this.data.restoreContext = false;
        }
        if ((nSView = this.data.view) != null && this.data.paintRect == null && this.data.thread != Thread.currentThread()) {
            this.flush();
        }
        if (nSAutoreleasePool != null) {
            nSAutoreleasePool.release();
        }
    }
}

