/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String name;
    public float height;
    public int style;
    public String nsName;
    String lang;
    String country;
    String variant;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n2 = 0;
        int n3 = string.indexOf(124);
        if (n3 == -1) {
            SWT.error(5);
        }
        String string2 = string.substring(n2, n3);
        try {
            if (Integer.parseInt(string2) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n2 = n3 + 1;
        n3 = string.indexOf(124, n2);
        if (n3 == -1) {
            SWT.error(5);
        }
        String string3 = string.substring(n2, n3);
        n2 = n3 + 1;
        if ((n3 = string.indexOf(124, n2)) == -1) {
            SWT.error(5);
        }
        float f2 = 0.0f;
        try {
            f2 = Float.parseFloat(string.substring(n2, n3));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n2 = n3 + 1;
        n3 = string.indexOf(124, n2);
        if (n3 == -1) {
            SWT.error(5);
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string.substring(n2, n3));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n2 = n3 + 1;
        n3 = string.indexOf(124, n2);
        this.setName(string3);
        this.setHeight(f2);
        this.setStyle(n4);
        if (n3 == -1) {
            return;
        }
        String string4 = string.substring(n2, n3);
        n2 = n3 + 1;
        if ((n3 = string.indexOf(124, n2)) == -1) {
            return;
        }
        String string5 = string.substring(n2, n3);
        if (string4.equals("COCOA") && string5.equals("1") && (n2 = n3 + 1) < (n3 = string.length())) {
            this.nsName = string.substring(n2, n3);
        }
    }

    public FontData(String string, int n2, int n3) {
        this.setName(string);
        this.setHeight(n2);
        this.setStyle(n3);
    }

    FontData(String string, float f2, int n2) {
        this.setName(string);
        this.setHeight(f2);
        this.setStyle(n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fontData = (FontData)object;
        return this.name.equals(fontData.name) && this.height == fontData.height && this.style == fontData.style;
    }

    public int getHeight() {
        return (int)this.height;
    }

    float getHeightF() {
        return this.height;
    }

    public String getLocale() {
        String string;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = '_';
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            stringBuffer.append(c2);
        }
        if (this.country != null) {
            stringBuffer.append(this.country);
            stringBuffer.append(c2);
        }
        if (this.variant != null) {
            stringBuffer.append(this.variant);
        }
        if ((n2 = (string = stringBuffer.toString()).length()) > 0 && string.charAt(n2 - 1) == c2) {
            string = string.substring(0, n2 - 1);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getHeight() << 8 ^ this.style;
    }

    public void setHeight(int n2) {
        if (n2 < 0) {
            SWT.error(5);
        }
        this.height = n2;
    }

    void setHeight(float f2) {
        if (f2 < 0.0f) {
            SWT.error(5);
        }
        this.height = f2;
    }

    public void setLocale(String string) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (string != null) {
            int n2;
            int n3 = 95;
            int n4 = string.length();
            int n5 = string.indexOf(n3);
            if (n5 == -1) {
                n5 = n2 = n4;
            } else {
                n2 = string.indexOf(n3, n5 + 1);
                if (n2 == -1) {
                    n2 = n4;
                }
            }
            if (n5 > 0) {
                this.lang = string.substring(0, n5);
            }
            if (n2 > n5 + 1) {
                this.country = string.substring(n5 + 1, n2);
            }
            if (n4 > n2 + 1) {
                this.variant = string.substring(n2 + 1);
            }
        }
    }

    public void setName(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.name = string;
        this.nsName = null;
    }

    public void setStyle(int n2) {
        this.style = n2;
        this.nsName = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("1|");
        stringBuffer.append(this.getName());
        stringBuffer.append("|");
        stringBuffer.append(this.getHeightF());
        stringBuffer.append("|");
        stringBuffer.append(this.getStyle());
        stringBuffer.append("|");
        stringBuffer.append("COCOA|1|");
        if (this.nsName != null) {
            stringBuffer.append(this.nsName);
        }
        return stringBuffer.toString();
    }
}

