/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    boolean warnings;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_TRANSPARENT;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    NSMutableParagraphStyle paragraphStyle;
    Point dpi;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            if (NSThread.isMainThread()) {
                NSString nSString;
                NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                NSThread nSThread = NSThread.currentThread();
                NSMutableDictionary nSMutableDictionary = nSThread.threadDictionary();
                id id2 = nSMutableDictionary.objectForKey(nSString = NSString.stringWith("SWT_NSAutoreleasePool"));
                if (id2 == null) {
                    NSNumber nSNumber = NSNumber.numberWithInteger(nSAutoreleasePool.id);
                    nSMutableDictionary.setObject(nSNumber, nSString);
                } else {
                    nSAutoreleasePool.release();
                }
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i2 = 0; i2 < this.objects.length; ++i2) {
                if (this.objects[i2] != object) continue;
                this.objects[i2] = null;
                this.errors[i2] = null;
                return;
            }
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSScreen nSScreen = this.getPrimaryScreen();
        NSRect nSRect = nSScreen.frame();
        double d2 = nSScreen.userSpaceScaleFactor();
        nSRect.x /= d2;
        nSRect.y /= d2;
        nSRect.width /= d2;
        nSRect.height /= d2;
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n2;
                int n3 = 0;
                int n4 = this.objects.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.objects[n2] == null) continue;
                    ++n3;
                }
                n2 = 0;
                deviceData.objects = new Object[n3];
                deviceData.errors = new Error[n3];
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (this.objects[i2] == null) continue;
                    deviceData.objects[n2] = this.objects[i2];
                    deviceData.errors[n2] = this.errors[i2];
                    ++n2;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return (int)OS.NSBitsPerPixelFromDepth(this.getPrimaryScreen().depth());
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    NSScreen getPrimaryScreen() {
        NSArray nSArray = NSScreen.screens();
        return new NSScreen(nSArray.objectAtIndex(0L));
    }

    public FontData[] getFontList(String string, boolean bl2) {
        this.checkDevice();
        if (!bl2) {
            return new FontData[0];
        }
        String string2 = this.systemFont.getFontData()[0].getName();
        boolean bl3 = false;
        int n2 = 0;
        NSArray nSArray = NSFontManager.sharedFontManager().availableFontFamilies();
        FontData[] fontDataArray = new FontData[100];
        if (nSArray != null) {
            long l2 = nSArray.count();
            int n3 = 0;
            while ((long)n3 < l2) {
                NSString nSString = new NSString(nSArray.objectAtIndex(n3));
                String string3 = nSString.getString();
                NSArray nSArray2 = NSFontManager.sharedFontManager().availableMembersOfFontFamily(nSString);
                if (nSArray2 != null) {
                    int n4 = (int)nSArray2.count();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        NSArray nSArray3 = new NSArray(nSArray2.objectAtIndex(i2));
                        String string4 = new NSString(nSArray3.objectAtIndex(0L)).getString();
                        long l3 = new NSNumber(nSArray3.objectAtIndex(2L)).integerValue();
                        long l4 = new NSNumber(nSArray3.objectAtIndex(3L)).integerValue();
                        int n5 = 0;
                        if ((l4 & 1L) != 0L) {
                            n5 |= 2;
                        }
                        if (l3 == 9L) {
                            n5 |= 1;
                        }
                        if (string != null && !Compatibility.equalsIgnoreCase(string, string3)) continue;
                        FontData fontData = new FontData(string3, 0, n5);
                        fontData.nsName = string4;
                        if (Compatibility.equalsIgnoreCase(string2, string3)) {
                            bl3 = true;
                        }
                        if (n2 == fontDataArray.length) {
                            FontData[] fontDataArray2 = new FontData[fontDataArray.length + 100];
                            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, fontDataArray.length);
                            fontDataArray = fontDataArray2;
                        }
                        fontDataArray[n2++] = fontData;
                    }
                }
                ++n3;
            }
        }
        if (!bl3 && (string == null || Compatibility.equalsIgnoreCase(string, string2))) {
            if (n2 == fontDataArray.length) {
                FontData[] fontDataArray3 = new FontData[fontDataArray.length + 1];
                System.arraycopy(fontDataArray, 0, fontDataArray3, 0, fontDataArray.length);
                fontDataArray = fontDataArray3;
            }
            fontDataArray[n2++] = this.systemFont.getFontData()[0];
        }
        if (n2 == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray4 = new FontData[n2];
        System.arraycopy(fontDataArray, 0, fontDataArray4, 0, n2);
        return fontDataArray4;
    }

    Point getScreenDPI() {
        NSScreen nSScreen = this.getPrimaryScreen();
        NSDictionary nSDictionary = nSScreen.deviceDescription();
        NSValue nSValue = new NSValue(nSDictionary.objectForKey((id)new id((long)OS.NSDeviceResolution())).id);
        NSSize nSSize = nSValue.sizeValue();
        double d2 = 1.0;
        if (OS.VERSION >= 4208) {
            d2 = nSScreen.backingScaleFactor();
        }
        return new Point((int)(nSSize.width / d2), (int)(nSSize.height / d2));
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        switch (n2) {
            case 37: {
                return this.COLOR_TRANSPARENT;
            }
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.COLOR_TRANSPARENT = new Color(this, 255, 255, 255, 0);
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        this.paragraphStyle.setAlignment(0L);
        this.paragraphStyle.setLineBreakMode(2L);
        NSArray nSArray = new NSArray(new NSArray().alloc().init());
        this.paragraphStyle.setTabStops(nSArray);
        nSArray.release();
        boolean bl2 = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        double d2 = bl2 ? NSFont.smallSystemFontSize() : NSFont.systemFontSize();
        Point point = this.dpi = this.getDPI();
        Point point2 = this.getScreenDPI();
        NSFont nSFont = NSFont.systemFontOfSize(d2 * (double)point.y / (double)point2.y);
        nSFont.retain();
        this.systemFont = Font.cocoa_new(this, nSFont);
    }

    public abstract long internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        boolean[] blArray;
        byte[] byArray;
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        boolean bl2 = false;
        NSString nSString = NSString.stringWith(string);
        long l2 = nSString.fileSystemRepresentation();
        if (l2 != 0L && OS.FSPathMakeRef(l2, byArray = new byte[80], blArray = new boolean[1]) == 0) {
            bl2 = OS.ATSFontActivateFromFileReference(byArray, 2, 0, 0L, 0, null) == 0;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i2 = 0; i2 < this.objects.length; ++i2) {
                if (this.objects[i2] != null) continue;
                this.objects[i2] = object;
                this.errors[i2] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                for (int i2 = 0; i2 < this.objects.length; ++i2) {
                    Object object2 = this.objects[i2];
                    if (object2 == null) continue;
                    ++n2;
                    if (object2 instanceof Color) {
                        ++n3;
                    }
                    if (object2 instanceof Cursor) {
                        ++n4;
                    }
                    if (object2 instanceof Font) {
                        ++n5;
                    }
                    if (object2 instanceof GC) {
                        ++n6;
                    }
                    if (object2 instanceof Image) {
                        ++n7;
                    }
                    if (object2 instanceof Path) {
                        ++n8;
                    }
                    if (object2 instanceof Pattern) {
                        ++n9;
                    }
                    if (object2 instanceof Region) {
                        ++n10;
                    }
                    if (object2 instanceof TextLayout) {
                        ++n11;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++n12;
                }
                if (n2 != 0) {
                    String string = "Summary: ";
                    if (n3 != 0) {
                        string = string + n3 + " Color(s), ";
                    }
                    if (n4 != 0) {
                        string = string + n4 + " Cursor(s), ";
                    }
                    if (n5 != 0) {
                        string = string + n5 + " Font(s), ";
                    }
                    if (n6 != 0) {
                        string = string + n6 + " GC(s), ";
                    }
                    if (n7 != 0) {
                        string = string + n7 + " Image(s), ";
                    }
                    if (n8 != 0) {
                        string = string + n8 + " Path(s), ";
                    }
                    if (n9 != 0) {
                        string = string + n9 + " Pattern(s), ";
                    }
                    if (n10 != 0) {
                        string = string + n10 + " Region(s), ";
                    }
                    if (n11 != 0) {
                        string = string + n11 + " TextLayout(s), ";
                    }
                    if (n12 != 0) {
                        string = string + n12 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.out.println(string);
                    }
                    for (int i3 = 0; i3 < this.errors.length; ++i3) {
                        if (this.errors[i3] == null) continue;
                        this.errors[i3].printStackTrace(System.out);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.release();
        }
        this.paragraphStyle = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    public void setWarnings(boolean bl2) {
        this.checkDevice();
        this.warnings = bl2;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

