/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Cursor
extends Resource {
    static final byte[] WAIT_SOURCE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] SHADOWED_IBEAM_SOURCE = new byte[]{85, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public NSCursor handle;

    Cursor(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, int n2) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        boolean bl2 = false;
        try {
            switch (n2) {
                case 21: {
                    this.handle = NSCursor.pointingHandCursor();
                    break;
                }
                case 0: {
                    this.handle = NSCursor.arrowCursor();
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 3: {
                    this.handle = NSCursor.arrowCursor();
                    break;
                }
                case 4: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 5: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 6: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 7: {
                    this.handle = NSCursor.resizeUpDownCursor();
                    break;
                }
                case 8: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 9: {
                    this.handle = NSCursor.resizeLeftRightCursor();
                    break;
                }
                case 10: {
                    this.handle = NSCursor.resizeUpCursor();
                    break;
                }
                case 11: {
                    this.handle = NSCursor.resizeDownCursor();
                    break;
                }
                case 12: {
                    this.handle = NSCursor.resizeRightCursor();
                    break;
                }
                case 13: {
                    this.handle = NSCursor.resizeLeftCursor();
                    break;
                }
                case 14: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 15: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 16: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 17: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 18: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 19: {
                    bl2 = true;
                    break;
                }
                case 20: {
                    this.handle = NSCursor.operationNotAllowedCursor();
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            if (this.handle == null && bl2) {
                NSImage nSImage = (NSImage)new NSImage().alloc();
                NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
                this.handle = (NSCursor)new NSCursor().alloc();
                int n3 = 16;
                int n4 = 16;
                NSSize nSSize = new NSSize();
                nSSize.width = n3;
                nSSize.height = n4;
                nSImage = nSImage.initWithSize(nSSize);
                nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, n3, n4, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, n3 * 4, 32L);
                NSPoint nSPoint = new NSPoint();
                if (n2 == 1) {
                    OS.memmove(nSBitmapImageRep.bitmapData(), WAIT_SOURCE, (long)WAIT_SOURCE.length);
                } else {
                    OS.memmove(nSBitmapImageRep.bitmapData(), SHADOWED_IBEAM_SOURCE, (long)SHADOWED_IBEAM_SOURCE.length);
                    nSPoint.x = 4.0;
                    nSPoint.y = 8.0;
                }
                nSImage.addRepresentation(nSBitmapImageRep);
                this.handle = this.handle.initWithImage(nSImage, nSPoint);
                nSBitmapImageRep.release();
                nSImage.release();
            } else {
                this.handle.retain();
            }
            this.handle.setOnMouseEntered(true);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n2, int n3) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        byte[] byArray = new byte[imageData.width * imageData.height * 4];
        for (int i2 = 0; i2 < imageData.height; ++i2) {
            int n4 = i2 * imageData.width * 4;
            for (int i3 = 0; i3 < imageData.width; ++i3) {
                int n5 = imageData.getPixel(i3, i2);
                int n6 = imageData2.getPixel(i3, i2);
                if (n5 == 0 && n6 == 0) {
                    byArray[n4] = -1;
                } else if (n5 == 0 && n6 == 1) {
                    byArray[n4 + 3] = -1;
                    byArray[n4 + 2] = -1;
                    byArray[n4 + 1] = -1;
                    byArray[n4] = -1;
                } else if (n5 != 1 || n6 == 0) {
                    // empty if block
                }
                n4 += 4;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.createNSCursor(n2, n3, byArray, imageData.width, imageData.height);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void createNSCursor(int n2, int n3, byte[] byArray, int n4, int n5) {
        NSImage nSImage = (NSImage)new NSImage().alloc();
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        this.handle = (NSCursor)new NSCursor().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = n4;
        nSSize.height = n5;
        nSImage = nSImage.initWithSize(nSSize);
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, n4, n5, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, n4 * 4, 32L);
        OS.memmove(nSBitmapImageRep.bitmapData(), byArray, (long)byArray.length);
        nSImage.addRepresentation(nSBitmapImageRep);
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n2;
        nSPoint.y = n3;
        this.handle = this.handle.initWithImage(nSImage, nSPoint);
        nSBitmapImageRep.release();
        nSImage.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, ImageData imageData, int n2, int n3) {
        super(device);
        int n4;
        int n5;
        Object object;
        if (imageData == null) {
            SWT.error(4);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        byte[] byArray = new byte[imageData.width * imageData.height * 4];
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, imageData.width * 4, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        } else {
            object = paletteData.getRGBs();
            n5 = ((RGB[])object).length;
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = new byte[n5];
            byte[] byArray4 = new byte[n5];
            for (n4 = 0; n4 < ((RGB[])object).length; ++n4) {
                RGB rGB = object[n4];
                if (rGB == null) continue;
                byArray2[n4] = (byte)rGB.red;
                byArray3[n4] = (byte)rGB.green;
                byArray4[n4] = (byte)rGB.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 32, imageData.width * 4, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        }
        if (imageData.maskData != null || imageData.transparentPixel != -1) {
            object = imageData.getTransparencyMask();
            byte[] byArray5 = object.data;
            int n6 = object.bytesPerLine;
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < imageData.height; ++n4) {
                for (int i2 = 0; i2 < imageData.width; ++i2) {
                    byArray[n7] = (byArray5[n8 + (i2 >> 3)] & 1 << 7 - (i2 & 7)) != 0 ? -1 : 0;
                    n7 += 4;
                }
                n8 += n6;
            }
        } else if (imageData.alpha != -1) {
            byte by = (byte)imageData.alpha;
            for (n5 = 0; n5 < byArray.length; n5 += 4) {
                byArray[n5] = by;
            }
        } else if (imageData.alphaData != null) {
            object = imageData.alphaData;
            for (n5 = 0; n5 < byArray.length; n5 += 4) {
                byArray[n5] = (byte)object[n5 / 4];
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.createNSCursor(n2, n3, byArray, imageData.width, imageData.height);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor cocoa_new(Device device, NSCursor nSCursor) {
        Cursor cursor = new Cursor(device);
        cursor.handle = nSCursor;
        return cursor;
    }
}

