/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String ID_NAME = OS.NSFilenamesPboardType.getString();
    static final int ID = FileTransfer.registerType(ID_NAME);
    static final String ID1_NAME = OS.kUTTypeFileURL.getString();
    static final int ID1 = FileTransfer.registerType(ID1_NAME);

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        int n2 = stringArray.length;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            NSString nSString = NSString.stringWith(string);
            nSMutableArray.addObject(nSString);
        }
        transferData.data = nSMutableArray;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSArray nSArray = (NSArray)transferData.data;
        if (nSArray.count() == 0L) {
            return null;
        }
        int n2 = (int)nSArray.count();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            NSString nSString = new NSString(nSArray.objectAtIndex(i2));
            stringArray[i2] = nSString.getString();
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        if (OS.VERSION >= 4192) {
            return new int[]{ID, ID1};
        }
        return new int[]{ID};
    }

    protected String[] getTypeNames() {
        if (OS.VERSION >= 4192) {
            return new String[]{ID_NAME, ID1_NAME};
        }
        return new String[]{ID_NAME};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null && stringArray[i2].length() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

