/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    static Callback dropTarget2Args;
    static Callback dropTarget3Args;
    static Callback dropTarget6Args;
    static long proc2Args;
    static long proc3Args;
    static long proc6Args;
    static final String LOCK_CURSOR = "org.eclipse.swt.internal.lockCursor";
    static boolean dropNotAllowed;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int feedback = 0;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";

    void addDragHandlers() {
        long l2;
        long l3 = OS.object_getClass(this.control.view.id);
        if (l3 == 0L) {
            DND.error(2001);
        }
        if ((l2 = OS.class_getMethodImplementation(l3, OS.sel_draggingEntered_)) == proc3Args) {
            return;
        }
        this.addDragHandlers(l3);
        long l4 = 0L;
        l4 = OS.objc_msgSend(this.control.view.id, OS.sel_getImageView);
        if (l4 != 0L) {
            l3 = OS.object_getClass(l4);
            this.addDragHandlers(l3);
        }
    }

    void addDragHandlers(long l2) {
        OS.class_addMethod(l2, OS.sel_draggingEntered_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_draggingUpdated_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_draggingExited_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_performDragOperation_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_wantsPeriodicDraggingUpdates, proc2Args, "@:");
        if (OS.class_getSuperclass(l2) == OS.class_NSOutlineView) {
            OS.class_addMethod(l2, OS.sel_outlineView_acceptDrop_item_childIndex_, proc6Args, "@:@@@i");
            OS.class_addMethod(l2, OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_, proc6Args, "@:@@@i");
        } else if (OS.class_getSuperclass(l2) == OS.class_NSTableView) {
            OS.class_addMethod(l2, OS.sel_tableView_acceptDrop_row_dropOperation_, proc6Args, "@:@@@i");
            OS.class_addMethod(l2, OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_, proc6Args, "@:@@@i");
        }
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    long dndCallSuper(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4);
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DropTarget.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    int draggingEntered(long l2, long l3, NSObject nSObject) {
        if (nSObject == null) {
            return 0;
        }
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int n2 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2002, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n3 = dNDEvent.detail = (n2 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
                if (transferDataArray[i2].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i2];
                break;
            }
        }
        if (this.selectedDataType != null && (n2 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            this.setDropNotAllowed();
        } else if (!((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(l2).isKindOfClass(OS.class_NSTableView)) {
            return (int)this.dndCallSuper(l2, l3, nSObject.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    void draggingExited(long l2, long l3, NSObject nSObject) {
        this.clearDropNotAllowed();
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        if (new NSObject(l2).isKindOfClass(OS.class_NSTableView)) {
            this.dndCallSuper(l2, l3, nSObject.id);
        }
    }

    int draggingUpdated(long l2, long l3, NSObject nSObject) {
        if (nSObject == null) {
            return 0;
        }
        int n2 = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int n3 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n2) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n4 = dNDEvent.detail = (n3 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
                if (transferDataArray[i2].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i2];
                break;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n3) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            this.setDropNotAllowed();
        } else if (!((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(l2).isKindOfClass(OS.class_NSTableView)) {
            return (int)this.dndCallSuper(l2, l3, nSObject.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public DropTarget(Control control, int n2) {
        super(control, DropTarget.checkStyle(n2));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.addDragHandlers();
    }

    static long dropTargetProc(long l2, long l3) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l2);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        if (l3 == OS.sel_wantsPeriodicDraggingUpdates) {
            return dropTarget.wantsPeriodicDraggingUpdates(l2, l3) ? 1L : 0L;
        }
        return 0L;
    }

    static long dropTargetProc(long l2, long l3, long l4) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l2);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        NSObject nSObject = new NSObject(l4);
        if (l3 == OS.sel_draggingEntered_) {
            return dropTarget.draggingEntered(l2, l3, nSObject);
        }
        if (l3 == OS.sel_draggingUpdated_) {
            return dropTarget.draggingUpdated(l2, l3, nSObject);
        }
        if (l3 == OS.sel_draggingExited_) {
            dropTarget.draggingExited(l2, l3, nSObject);
        } else if (l3 == OS.sel_performDragOperation_) {
            return dropTarget.performDragOperation(l2, l3, nSObject) ? 1L : 0L;
        }
        return 0L;
    }

    static long dropTargetProc(long l2, long l3, long l4, long l5, long l6, long l7) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l2);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        if (l3 == OS.sel_outlineView_acceptDrop_item_childIndex_) {
            return dropTarget.outlineView_acceptDrop_item_childIndex(l2, l3, l4, l5, l6, l7) ? 1L : 0L;
        }
        if (l3 == OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_) {
            return dropTarget.outlineView_validateDrop_proposedItem_proposedChildIndex(l2, l3, l4, l5, l6, l7);
        }
        if (l3 == OS.sel_tableView_acceptDrop_row_dropOperation_) {
            return dropTarget.tableView_acceptDrop_row_dropOperation(l2, l3, l4, l5, l6, l7) ? 1L : 0L;
        }
        if (l3 == OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_) {
            return dropTarget.tableView_validateDrop_proposedRow_proposedDropOperation(l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n2 = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Listener listener = listenerArray[i2];
            if (!(listener instanceof DNDListener)) continue;
            dropTargetListenerArray[n3] = (DropTargetListener)((DNDListener)listener).getEventListener();
            ++n3;
        }
        if (n3 == n2) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n3];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n3);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean bl2;
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        long l2 = nSEvent.modifierFlags();
        boolean bl3 = (l2 & 0x80000L) == 524288L;
        boolean bl4 = bl2 = (l2 & 0x40000L) == 262144L;
        if (bl2 && bl3) {
            return 16;
        }
        if (bl2) {
            return 4;
        }
        if (bl3) {
            return 1;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control.view.unregisterDraggedTypes();
        this.control = null;
    }

    int opToOsOp(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 2;
        }
        if ((n2 & 2) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 8) != 0) {
            n3 |= 0x20;
        }
        return n3;
    }

    int osOpToOp(long l2) {
        int n2 = 0;
        if ((l2 & 1L) != 0L) {
            n2 |= 1;
        }
        if ((l2 & 2L) != 0L) {
            n2 |= 4;
        }
        if ((l2 & 0x20L) != 0L) {
            n2 |= 8;
        }
        if ((l2 & 0x10L) != 0L) {
            n2 |= 2;
        }
        if (l2 == -1L) {
            n2 = 7;
        }
        return n2;
    }

    boolean drop(NSObject nSObject) {
        Object object;
        Object object2;
        TransferData[] transferDataArray;
        this.clearDropNotAllowed();
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        if (this.dropEffect != null) {
            NSPoint nSPoint = nSObject.draggingLocation();
            transferDataArray = nSObject.draggingDestinationWindow().convertBaseToScreen(nSPoint);
            dNDEvent.item = this.dropEffect.getItem((int)transferDataArray.x, (int)transferDataArray.y);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent) || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            return false;
        }
        this.keyOperation = -1;
        int n2 = dNDEvent.operations;
        transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, dNDEvent.dataTypes.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.selectedDataType = null;
        if (dNDEvent.dataType != null) {
            for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
                if (transferDataArray[i2].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i2];
                break;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        NSPasteboard nSPasteboard = nSObject.draggingPasteboard();
        NSObject nSObject2 = null;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10L);
        block1: for (int i3 = 0; i3 < this.transferAgents.length; ++i3) {
            object2 = this.transferAgents[i3];
            object = ((Transfer)object2).getTypeNames();
            int[] nArray = ((Transfer)object2).getTypeIds();
            for (int i4 = 0; i4 < ((String[])object).length; ++i4) {
                if (this.selectedDataType.type != nArray[i4]) continue;
                nSMutableArray.addObject(NSString.stringWith(object[i4]));
                continue block1;
            }
        }
        NSString nSString = nSPasteboard.availableTypeFromArray(nSMutableArray);
        object2 = new TransferData();
        if (nSString != null) {
            ((TransferData)object2).type = Transfer.registerType(nSString.getString());
            ((TransferData)object2).data = nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSHTMLPboardType) || nSString.isEqual(OS.NSRTFPboardType) ? nSPasteboard.stringForType(nSString) : (nSString.isEqual(OS.NSURLPboardType) || nSString.isEqual(OS.kUTTypeURL) ? NSURL.URLFromPasteboard(nSPasteboard) : (nSString.isEqual(OS.NSFilenamesPboardType) || nSString.isEqual(OS.kUTTypeFileURL) ? new NSArray(nSPasteboard.propertyListForType((NSString)OS.NSFilenamesPboardType).id) : nSPasteboard.dataForType(nSString)));
        }
        if (((TransferData)object2).data != null) {
            nSObject2 = ((TransferData)object2).data;
        }
        object = null;
        for (int i5 = 0; i5 < this.transferAgents.length; ++i5) {
            Transfer transfer = this.transferAgents[i5];
            if (transfer == null || !transfer.isSupportedType(this.selectedDataType)) continue;
            this.selectedDataType.data = nSObject2;
            object = transfer.nativeToJava(this.selectedDataType);
            break;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.data = object;
        this.notifyListeners(2006, dNDEvent);
        this.selectedOperation = 0;
        if ((n2 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        return this.selectedOperation != 0;
    }

    boolean performDragOperation(long l2, long l3, NSObject nSObject) {
        if (new NSObject(l2).isKindOfClass(OS.class_NSTableView)) {
            return this.dndCallSuper(l2, l3, nSObject.id) != 0L;
        }
        return this.drop(nSObject);
    }

    boolean outlineView_acceptDrop_item_childIndex(long l2, long l3, long l4, long l5, long l6, long l7) {
        return this.drop(new NSObject(l5));
    }

    long outlineView_validateDrop_proposedItem_proposedChildIndex(long l2, long l3, long l4, long l5, long l6, long l7) {
        NSOutlineView nSOutlineView = new NSOutlineView(l4);
        NSObject nSObject = new NSObject(l5);
        NSPoint nSPoint = nSObject.draggingLocation();
        nSPoint = nSOutlineView.convertPoint_fromView_(nSPoint, null);
        Tree tree = (Tree)this.getControl();
        TreeItem treeItem = tree.getItem(new Point((int)nSPoint.x, (int)nSPoint.y));
        if (this.feedback == 0 || treeItem == null) {
            nSOutlineView.setDropItem(null, -1L);
        } else if ((this.feedback & 1) != 0) {
            nSOutlineView.setDropItem(treeItem.handle, -1L);
        } else {
            int n2;
            TreeItem treeItem2 = treeItem.getParentItem();
            SWTTreeItem sWTTreeItem = null;
            if (treeItem2 != null) {
                sWTTreeItem = treeItem2.handle;
                n2 = treeItem2.indexOf(treeItem);
            } else {
                n2 = ((Tree)this.getControl()).indexOf(treeItem);
            }
            if ((this.feedback & 4) != 0) {
                nSOutlineView.setDropItem(sWTTreeItem, n2 + 1);
            }
            if ((this.feedback & 2) != 0) {
                nSOutlineView.setDropItem(sWTTreeItem, n2);
            }
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(NSObject nSObject, DNDEvent dNDEvent) {
        Object object;
        NSObject nSObject2;
        Object object2;
        NSPasteboard nSPasteboard;
        NSArray nSArray;
        int n2;
        if (nSObject == null) {
            return false;
        }
        int n3 = this.getStyle();
        long l2 = nSObject.draggingSourceOperationMask();
        int n4 = this.osOpToOp(l2) & n3;
        if (n4 == 0) {
            return false;
        }
        this.keyOperation = n2 = this.getOperationFromKeyState();
        if (n2 == 16) {
            if ((n3 & 0x10) == 0) {
                n2 = (n4 & 2) != 0 ? 2 : 0;
            }
        } else if ((n2 & n4) == 0) {
            n2 = 0;
        }
        if ((nSArray = (nSPasteboard = nSObject.draggingPasteboard()).types()) == null) {
            return false;
        }
        long l3 = nSArray.count();
        TransferData[] transferDataArray = new TransferData[(int)l3];
        int n5 = -1;
        int n6 = 0;
        while ((long)n6 < l3) {
            object2 = nSArray.objectAtIndex(n6);
            nSObject2 = new NSString((id)object2);
            object = new TransferData();
            ((TransferData)object).type = Transfer.registerType(((NSString)nSObject2).getString());
            for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
                Transfer transfer = this.transferAgents[i2];
                if (transfer == null || !transfer.isSupportedType((TransferData)object)) continue;
                transferDataArray[++n5] = object;
                break;
            }
            ++n6;
        }
        if (n5 == -1) {
            return false;
        }
        if (n5 < transferDataArray.length - 1) {
            TransferData[] transferDataArray2 = new TransferData[n5 + 1];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, n5 + 1);
            transferDataArray = transferDataArray2;
        }
        NSPoint nSPoint = nSObject.draggingLocation();
        object2 = nSObject.draggingDestinationWindow().convertBaseToScreen(nSPoint);
        nSObject2 = NSScreen.screens();
        object = new NSScreen(((NSArray)nSObject2).objectAtIndex(0L)).frame();
        ((NSPoint)object2).y = ((NSRect)object).height - ((NSPoint)object2).y;
        dNDEvent.widget = this;
        dNDEvent.x = (int)((NSPoint)object2).x;
        dNDEvent.y = (int)((NSPoint)object2).y;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n4;
        dNDEvent.detail = n2;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(dNDEvent.x, dNDEvent.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        int n2;
        Object object;
        int n3;
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n3 = 0; n3 < this.transferAgents.length; ++n3) {
            object = transferArray[n3].getTypeNames();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                arrayList.add(object[n2]);
            }
        }
        n3 = arrayList.size();
        object = NSMutableArray.arrayWithCapacity(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            ((NSMutableArray)object).addObject(NSString.stringWith((String)arrayList.get(n2)));
        }
        this.control.view.registerForDraggedTypes((NSArray)object);
    }

    void setDropNotAllowed() {
        if (!dropNotAllowed) {
            NSCursor.currentCursor().push();
            Display display = this.getDisplay();
            display.setData(LOCK_CURSOR, Boolean.FALSE);
            NSCursor.operationNotAllowedCursor().push();
            display.setData(LOCK_CURSOR, Boolean.TRUE);
            dropNotAllowed = true;
        }
    }

    void clearDropNotAllowed() {
        if (dropNotAllowed) {
            Display display = this.getDisplay();
            display.setData(LOCK_CURSOR, Boolean.FALSE);
            NSCursor.pop();
            display.setData(LOCK_CURSOR, Boolean.TRUE);
            NSCursor.pop();
            dropNotAllowed = false;
        }
    }

    boolean tableView_acceptDrop_row_dropOperation(long l2, long l3, long l4, long l5, long l6, long l7) {
        return this.drop(new NSObject(l5));
    }

    int tableView_validateDrop_proposedRow_proposedDropOperation(long l2, long l3, long l4, long l5, long l6, long l7) {
        NSTableView nSTableView = new NSTableView(l4);
        NSObject nSObject = new NSObject(l5);
        NSPoint nSPoint = nSObject.draggingLocation();
        long l8 = nSTableView.rowAtPoint(nSPoint = nSTableView.convertPoint_fromView_(nSPoint, null));
        if (0L <= l8 && l8 < nSTableView.numberOfRows()) {
            if (this.feedback == 0) {
                nSTableView.setDropRow(-1L, 0L);
            } else if ((this.feedback & 1) != 0) {
                nSTableView.setDropRow(l8, 0L);
            } else {
                if ((this.feedback & 4) != 0) {
                    nSTableView.setDropRow(l8 + 1L, 1L);
                }
                if ((this.feedback & 2) != 0) {
                    nSTableView.setDropRow(l8, 1L);
                }
            }
        }
        return this.opToOsOp(this.selectedOperation);
    }

    boolean wantsPeriodicDraggingUpdates(long l2, long l3) {
        return true;
    }

    static {
        Class<DropTarget> clazz = DropTarget.class;
        dropTarget2Args = new Callback(clazz, "dropTargetProc", 2);
        proc2Args = dropTarget2Args.getAddress();
        if (proc2Args == 0L) {
            SWT.error(3);
        }
        if ((proc3Args = (dropTarget3Args = new Callback(clazz, "dropTargetProc", 3)).getAddress()) == 0L) {
            SWT.error(3);
        }
        if ((proc6Args = (dropTarget6Args = new Callback(clazz, "dropTargetProc", 6)).getAddress()) == 0L) {
            SWT.error(3);
        }
        dropNotAllowed = false;
    }
}

