/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = Clipboard.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n2) {
        this.checkWidget();
        if ((n2 & 1) == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard != null) {
            nSPasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0L), null);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n2) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((n2 & 1) == 0) {
            return null;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return null;
        }
        String[] stringArray = transfer.getTypeNames();
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nSMutableArray.addObject(NSString.stringWith(stringArray[i2]));
        }
        NSString nSString = nSPasteboard.availableTypeFromArray(nSMutableArray);
        if (nSString != null) {
            TransferData transferData = new TransferData();
            transferData.type = Transfer.registerType(nSString.getString());
            transferData.data = nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSRTFPboardType) || nSString.isEqual(OS.NSHTMLPboardType) ? nSPasteboard.stringForType(nSString) : (nSString.isEqual(OS.NSFilenamesPboardType) || nSString.isEqual(OS.kUTTypeFileURL) ? new NSArray(nSPasteboard.propertyListForType((NSString)OS.NSFilenamesPboardType).id) : (nSString.isEqual(OS.NSURLPboardType) || nSString.isEqual(OS.kUTTypeURL) ? NSURL.URLFromPasteboard(nSPasteboard) : nSPasteboard.dataForType(nSString)));
            if (transferData.data != null) {
                return transfer.nativeToJava(transferData);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n2) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null && transferArray[i2] != null && transferArray[i2].validate(objectArray[i2])) continue;
            DND.error(5);
        }
        if ((n2 & 1) == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            DND.error(2002);
        }
        nSPasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0L), null);
        for (int i3 = 0; i3 < transferArray.length; ++i3) {
            String[] stringArray = transferArray[i3].getTypeNames();
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                TransferData transferData = new TransferData();
                transferData.type = Transfer.registerType(stringArray[i4]);
                transferArray[i3].javaToNative(objectArray[i3], transferData);
                NSObject nSObject = transferData.data;
                NSString nSString = NSString.stringWith(stringArray[i4]);
                nSPasteboard.addTypes(NSArray.arrayWithObject(nSString), null);
                if (nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSRTFPboardType) || nSString.isEqual(OS.NSHTMLPboardType)) {
                    nSPasteboard.setString((NSString)nSObject, nSString);
                    continue;
                }
                if (nSString.isEqual(OS.NSURLPboardType) || nSString.isEqual(OS.kUTTypeURL)) {
                    NSURL nSURL = (NSURL)nSObject;
                    nSURL.writeToPasteboard(nSPasteboard);
                    continue;
                }
                if (nSString.isEqual(OS.NSFilenamesPboardType) || nSString.isEqual(OS.kUTTypeFileURL)) {
                    nSPasteboard.setPropertyList((NSArray)nSObject, OS.NSFilenamesPboardType);
                    continue;
                }
                nSPasteboard.setData((NSData)nSObject, nSString);
            }
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n2) {
        this.checkWidget();
        if ((n2 & 1) == 0) {
            return new TransferData[0];
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return new TransferData[0];
        }
        NSArray nSArray = nSPasteboard.types();
        if (nSArray == null) {
            return new TransferData[0];
        }
        int n3 = (int)nSArray.count();
        TransferData[] transferDataArray = new TransferData[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            transferDataArray[i2] = new TransferData();
            transferDataArray[i2].type = Transfer.registerType(new NSString(nSArray.objectAtIndex(i2)).getString());
        }
        return transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return new String[0];
        }
        NSArray nSArray = nSPasteboard.types();
        if (nSArray == null) {
            return new String[0];
        }
        int n2 = (int)nSArray.count();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = new NSString(nSArray.objectAtIndex(i2)).getString();
        }
        return stringArray;
    }
}

