/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeCursor
extends Canvas {
    Tree tree;
    TreeItem row;
    TreeColumn column;
    Listener listener;
    Listener treeListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    Color background = null;
    Color foreground = null;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TreeCursor(Tree tree, int n2) {
        super(tree, n2);
        ScrollBar scrollBar;
        this.tree = tree;
        this.setBackground(null);
        this.setForeground(null);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (TreeCursor.this.row != null) {
                    if (TreeCursor.this.row.isDisposed()) {
                        TreeCursor.this.unhookRowColumnListeners();
                        TreeCursor.this._resize();
                        TreeCursor.this.tree.setFocus();
                        return;
                    }
                    TreeItem treeItem = TreeCursor.this.row;
                    TreeItem treeItem2 = TreeCursor.this.row.getParentItem();
                    while (treeItem2 != null && !treeItem2.getExpanded()) {
                        treeItem = treeItem2;
                        treeItem2 = treeItem.getParentItem();
                    }
                    if (treeItem != TreeCursor.this.row) {
                        TreeCursor.this.setRowColumn(treeItem, TreeCursor.this.column, false);
                    }
                }
                switch (event.type) {
                    case 12: {
                        TreeCursor.this.onDispose(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TreeCursor.this.redraw();
                        break;
                    }
                    case 1: {
                        TreeCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TreeCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        event.doit = true;
                        switch (event.detail) {
                            case 4: 
                            case 32: 
                            case 64: {
                                event.doit = false;
                            }
                        }
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 15, 16, 1, 9, 31};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], this.listener);
        }
        this.treeListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 18: {
                        TreeCursor.this.treeCollapse(event);
                        break;
                    }
                    case 17: {
                        TreeCursor.this.treeExpand(event);
                        break;
                    }
                    case 15: {
                        TreeCursor.this.treeFocusIn(event);
                        break;
                    }
                    case 3: {
                        TreeCursor.this.treeMouseDown(event);
                    }
                }
            }
        };
        this.tree.addListener(18, this.treeListener);
        this.tree.addListener(17, this.treeListener);
        this.tree.addListener(15, this.treeListener);
        this.tree.addListener(3, this.treeListener);
        this.disposeItemListener = new Listener(){

            public void handleEvent(Event event) {
                for (TreeItem treeItem = TreeCursor.this.row; treeItem != null; treeItem = treeItem.getParentItem()) {
                    treeItem.removeListener(12, TreeCursor.this.disposeItemListener);
                }
                TreeItem treeItem = (TreeItem)event.widget;
                TreeItem treeItem2 = treeItem.getParentItem();
                if (treeItem2 != null) {
                    TreeCursor.this.setRowColumn(treeItem2, TreeCursor.this.column, true);
                } else if (TreeCursor.this.tree.getItemCount() == 1) {
                    TreeCursor.this.unhookRowColumnListeners();
                } else {
                    TreeItem treeItem3;
                    TreeItem treeItem4 = null;
                    int n2 = TreeCursor.this.tree.indexOf(treeItem);
                    if (n2 != 0 && !(treeItem3 = TreeCursor.this.tree.getItem(n2 - 1)).isDisposed()) {
                        treeItem4 = treeItem3;
                    }
                    if (treeItem4 == null && n2 + 1 < TreeCursor.this.tree.getItemCount() && !(treeItem3 = TreeCursor.this.tree.getItem(n2 + 1)).isDisposed()) {
                        treeItem4 = treeItem3;
                    }
                    if (treeItem4 != null) {
                        TreeCursor.this.setRowColumn(treeItem4, TreeCursor.this.column, true);
                    } else {
                        TreeCursor.this.unhookRowColumnListeners();
                    }
                }
                TreeCursor.this._resize();
            }
        };
        this.disposeColumnListener = new Listener(){

            public void handleEvent(Event event) {
                if (TreeCursor.this.column != null) {
                    if (TreeCursor.this.tree.getColumnCount() == 1) {
                        TreeCursor.this.column = null;
                    } else {
                        int n2;
                        int n3 = n2 = TreeCursor.this.tree.indexOf(TreeCursor.this.column);
                        int[] nArray = TreeCursor.this.tree.getColumnOrder();
                        for (int i2 = 0; i2 < nArray.length; ++i2) {
                            if (nArray[i2] != n2) continue;
                            n3 = i2;
                            break;
                        }
                        if (n3 == nArray.length - 1) {
                            TreeCursor.this.setRowColumn(TreeCursor.this.row, TreeCursor.this.tree.getColumn(nArray[n3 - 1]), true);
                        } else {
                            TreeCursor.this.setRowColumn(TreeCursor.this.row, TreeCursor.this.tree.getColumn(nArray[n3 + 1]), true);
                        }
                    }
                }
                TreeCursor.this._resize();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TreeCursor.this._resize();
            }
        };
        ScrollBar scrollBar2 = this.tree.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, this.resizeListener);
        }
        if ((scrollBar = this.tree.getVerticalBar()) != null) {
            scrollBar.addListener(13, this.resizeListener);
        }
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 29;
            }
        });
        this.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (TreeCursor.this.row == null) {
                    return;
                }
                int n2 = TreeCursor.this.column == null ? 0 : TreeCursor.this.tree.indexOf(TreeCursor.this.column);
                accessibleEvent.result = TreeCursor.this.row.getText(n2);
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int countSubTreePages(TreeItem treeItem) {
        int n2 = 1;
        if (treeItem == null) {
            return 0;
        }
        if (treeItem.getItemCount() == 0) {
            return 1;
        }
        if (!treeItem.getExpanded()) {
            return 1;
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
            n2 += this.countSubTreePages(treeItemArray[i2]);
        }
        return n2;
    }

    int findIndex(TreeItem[] treeItemArray, TreeItem treeItem) {
        if (treeItemArray == null || treeItem == null) {
            return -1;
        }
        Rectangle rectangle = treeItem.getBounds();
        int n2 = 0;
        for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
            TreeItem treeItem2 = null;
            TreeItem treeItem3 = treeItemArray[i2];
            if (i2 > 0) {
                treeItem2 = treeItemArray[i2 - 1];
            }
            Rectangle rectangle2 = treeItem3.getBounds();
            if (rectangle.y == rectangle2.y) {
                return n2;
            }
            if (rectangle.y < rectangle2.y) {
                return n2 - 1 + this.findIndex(treeItem2.getItems(), treeItem);
            }
            if (rectangle.y > rectangle2.y && i2 == treeItemArray.length - 1) {
                return n2 + this.findIndex(treeItem3.getItems(), treeItem);
            }
            if (rectangle.y >= rectangle2.y + (1 + treeItem3.getItemCount()) * this.tree.getItemHeight() && treeItem3.getExpanded()) {
                n2 += this.countSubTreePages(treeItem3);
                continue;
            }
            ++n2;
        }
        return -1;
    }

    TreeItem findItem(TreeItem[] treeItemArray, Point point) {
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = treeItemArray.length - 1;
        int n4 = n3 / 2;
        while (n3 - n2 > 1) {
            object2 = treeItemArray[n4];
            object = ((TreeItem)object2).getBounds();
            if (point.y < ((Rectangle)object).y) {
                n3 = n4;
                n4 = (n3 - n2) / 2;
                continue;
            }
            n2 = n4;
            n4 = n2 + (n3 - n2) / 2;
        }
        object2 = treeItemArray[n3].getBounds();
        if (((Rectangle)object2).y < point.y) {
            if (((Rectangle)object2).y + ((Rectangle)object2).height < point.y) {
                if (!treeItemArray[n3].getExpanded()) {
                    return null;
                }
                return this.findItem(treeItemArray[n3].getItems(), point);
            }
            object = this.tree.getColumnOrder();
            Rectangle rectangle = null;
            if (((Object)object).length > 0) {
                Rectangle rectangle2 = treeItemArray[n3].getBounds((int)object[0]);
                Rectangle rectangle3 = treeItemArray[n3].getBounds((int)object[((Object)object).length - 1]);
                rectangle = rectangle2.union(rectangle3);
                rectangle.height = rectangle.height + (this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0);
            } else {
                rectangle = treeItemArray[n3].getBounds();
            }
            return rectangle.contains(point) ? treeItemArray[n3] : null;
        }
        object = treeItemArray[n2].getBounds();
        if (((Rectangle)object).y + ((Rectangle)object).height < point.y) {
            return this.findItem(treeItemArray[n2].getItems(), point);
        }
        int[] nArray = this.tree.getColumnOrder();
        Rectangle rectangle = null;
        if (nArray.length > 0) {
            Rectangle rectangle4 = treeItemArray[n2].getBounds(nArray[0]);
            Rectangle rectangle5 = treeItemArray[n2].getBounds(nArray[nArray.length - 1]);
            rectangle = rectangle4.union(rectangle5);
            rectangle.height = rectangle.height + (this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0);
        } else {
            rectangle = treeItemArray[n2].getBounds();
        }
        return rectangle.contains(point) ? treeItemArray[n2] : null;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.background;
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.tree.indexOf(this.column);
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.foreground;
    }

    TreeItem getLastVisibleItem(TreeItem[] treeItemArray) {
        if (treeItemArray == null) {
            return null;
        }
        TreeItem treeItem = treeItemArray[treeItemArray.length - 1];
        if (treeItem.getExpanded() && treeItem.getItemCount() > 0) {
            return this.getLastVisibleItem(treeItem.getItems());
        }
        return treeItem;
    }

    TreeItem getNextItem(TreeItem treeItem) {
        int n2;
        if (treeItem == null) {
            return null;
        }
        if (treeItem.getExpanded() && treeItem.getItemCount() > 0) {
            return treeItem.getItem(0);
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        while (treeItem2 != null) {
            n2 = treeItem2.indexOf(treeItem);
            if (n2 == -1) {
                return null;
            }
            if (n2 < treeItem2.getItemCount() - 1) {
                return treeItem2.getItem(n2 + 1);
            }
            treeItem = treeItem2;
            treeItem2 = treeItem.getParentItem();
        }
        n2 = this.tree.indexOf(treeItem);
        if (n2 == -1) {
            return null;
        }
        if (n2 == this.tree.getItemCount() - 1) {
            return null;
        }
        return this.tree.getItem(n2 + 1);
    }

    TreeItem getPreviousItem(TreeItem treeItem) {
        if (treeItem == null) {
            return null;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == null) {
            int n2 = this.tree.indexOf(treeItem);
            if (n2 == -1 || n2 == 0) {
                return null;
            }
            treeItem = this.tree.getItem(n2 - 1);
            if (treeItem.getExpanded() && treeItem.getItemCount() > 0) {
                return this.getLastVisibleItem(treeItem.getItems());
            }
            return treeItem;
        }
        int n3 = treeItem2.indexOf(treeItem);
        if (n3 == -1) {
            return null;
        }
        if (n3 == 0) {
            return treeItem2;
        }
        treeItem = treeItem2.getItem(n3 - 1);
        if (treeItem.getExpanded() && treeItem.getItemCount() > 0) {
            return this.getLastVisibleItem(treeItem.getItems());
        }
        return treeItem;
    }

    public TreeItem getRow() {
        this.checkWidget();
        return this.row;
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                TreeItem treeItem = this.getPreviousItem(this.row);
                if (treeItem == null) break;
                this.setRowColumn(treeItem, this.column, true);
                break;
            }
            case 0x1000002: {
                TreeItem treeItem = this.getNextItem(this.row);
                if (treeItem == null) break;
                this.setRowColumn(treeItem, this.column, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int n2;
                if ((event.stateMask & SWT.MOD1) != 0) {
                    this.row.setExpanded(event.keyCode == 0x1000004);
                    break;
                }
                int n3 = this.tree.getColumnCount();
                if (n3 == 0) break;
                int n4 = this.column == null ? 0 : this.tree.indexOf(this.column);
                int[] nArray = this.tree.getColumnOrder();
                for (n2 = 0; n2 < nArray.length && nArray[n2] != n4; ++n2) {
                }
                if (n2 == nArray.length) {
                    n2 = 0;
                }
                int n5 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                TreeItem treeItem = this.row.getParentItem();
                int n6 = this.tree.indexOf(this.row);
                if (event.keyCode == n5) {
                    if (treeItem != null) {
                        this.setRowColumn(this.row, this.tree.getColumn(nArray[Math.max(0, n2 - 1)]), true);
                        break;
                    }
                    this.setRowColumn(n6, nArray[Math.max(0, n2 - 1)], true);
                    break;
                }
                if (treeItem != null) {
                    this.setRowColumn(this.row, this.tree.getColumn(nArray[Math.min(n3 - 1, n2 + 1)]), true);
                    break;
                }
                this.setRowColumn(n6, nArray[Math.min(n3 - 1, n2 + 1)], true);
                break;
            }
            case 0x1000007: {
                int n7 = this.column == null ? 0 : this.tree.indexOf(this.column);
                this.setRowColumn(0, n7, true);
                break;
            }
            case 0x1000008: {
                TreeItem[] treeItemArray = this.tree.getItems();
                this.setRowColumn(this.getLastVisibleItem(treeItemArray), this.column, true);
                break;
            }
            case 0x1000005: {
                Rectangle rectangle = this.tree.getClientArea();
                Rectangle rectangle2 = this.tree.getTopItem().getBounds();
                TreeItem treeItem = this.row;
                int n8 = this.findIndex(this.tree.getItems(), treeItem);
                int n9 = this.tree.getItemHeight();
                rectangle.height -= rectangle2.y;
                int n10 = Math.max(1, rectangle.height / n9);
                if (n8 - n10 <= 0) {
                    TreeItem treeItem2 = this.tree.getItem(0);
                    this.setRowColumn(treeItem2, this.column, true);
                    break;
                }
                for (int i2 = 0; i2 < n10; ++i2) {
                    treeItem = this.getPreviousItem(treeItem);
                }
                this.setRowColumn(treeItem, this.column, true);
                break;
            }
            case 0x1000006: {
                Rectangle rectangle = this.tree.getClientArea();
                Rectangle rectangle3 = this.tree.getTopItem().getBounds();
                TreeItem treeItem = this.row;
                int n11 = this.findIndex(this.tree.getItems(), treeItem);
                int n12 = this.tree.getItemHeight();
                rectangle.height -= rectangle3.y;
                TreeItem treeItem3 = this.getLastVisibleItem(this.tree.getItems());
                int n13 = Math.max(1, rectangle.height / n12);
                int n14 = this.findIndex(this.tree.getItems(), treeItem3);
                if (n14 <= n11 + n13) {
                    this.setRowColumn(treeItem3, this.column, true);
                    break;
                }
                for (int i3 = 0; i3 < n13; ++i3) {
                    treeItem = this.getNextItem(treeItem);
                }
                this.setRowColumn(treeItem, this.column, true);
                break;
            }
        }
    }

    void onDispose(Event event) {
        ScrollBar scrollBar;
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.tree.removeListener(18, this.treeListener);
        this.tree.removeListener(17, this.treeListener);
        this.tree.removeListener(15, this.treeListener);
        this.tree.removeListener(3, this.treeListener);
        this.unhookRowColumnListeners();
        ScrollBar scrollBar2 = this.tree.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.removeListener(13, this.resizeListener);
        }
        if ((scrollBar = this.tree.getVerticalBar()) != null) {
            scrollBar.removeListener(13, this.resizeListener);
        }
    }

    void paint(Event event) {
        Object object;
        int n2;
        if (this.row == null) {
            return;
        }
        int n3 = n2 = this.column == null ? 0 : this.tree.indexOf(this.column);
        int[] nArray = this.tree.getColumnOrder();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            n3 = i2;
            break;
        }
        GC gC = event.gc;
        gC.setBackground(this.getBackground());
        gC.setForeground(this.getForeground());
        gC.fillRectangle(event.x, event.y, event.width, event.height);
        Image image = this.row.getImage(n2);
        int n4 = 0;
        String string = SWT.getPlatform();
        if (image != null) {
            if ("win32".equals(string)) {
                if (n3 > 0) {
                    n4 += 2;
                }
            } else {
                n4 += 2;
            }
        }
        Point point = this.getSize();
        if (image != null) {
            object = image.getBounds();
            int n5 = (point.y - ((Rectangle)object).height) / 2;
            gC.drawImage(image, n4, n5);
            n4 += ((Rectangle)object).width;
        }
        if (((String)(object = this.row.getText(n2))).length() > 0) {
            int n6;
            Rectangle rectangle = this.row.getBounds(n2);
            Point point2 = gC.stringExtent((String)object);
            if ("win32".equals(string)) {
                if (this.tree.getColumnCount() == 0 || n3 == 0) {
                    n4 += image == null ? 2 : 5;
                } else {
                    n6 = this.column.getAlignment();
                    switch (n6) {
                        case 16384: {
                            n4 += image == null ? 5 : 3;
                            break;
                        }
                        case 131072: {
                            n4 = rectangle.width - point2.x - 2;
                            break;
                        }
                        case 0x1000000: {
                            n4 = (int)((double)n4 + Math.ceil((double)(rectangle.width - n4 - point2.x) / 2.0));
                        }
                    }
                }
            } else if (this.tree.getColumnCount() == 0) {
                n4 += image == null ? 4 : 3;
            } else {
                n6 = this.column.getAlignment();
                switch (n6) {
                    case 16384: {
                        n4 += image == null ? 5 : 3;
                        break;
                    }
                    case 131072: {
                        n4 = rectangle.width - point2.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        n4 += (rectangle.width - n4 - point2.x) / 2 + 2;
                    }
                }
            }
            n6 = (point.y - point2.y) / 2;
            gC.drawString((String)object, n4, n6);
        }
        if (this.isFocusControl()) {
            Display display = this.getDisplay();
            gC.setBackground(display.getSystemColor(2));
            gC.setForeground(display.getSystemColor(1));
            gC.drawFocus(0, 0, point.x, point.y);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    void _resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int n2 = this.column == null ? 0 : this.tree.indexOf(this.column);
            this.setBounds(this.row.getBounds(n2));
        }
    }

    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(this.getBackground());
        this.redraw();
    }

    public void setForeground(Color color) {
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.redraw();
    }

    void setRowColumn(int n2, int n3, boolean bl2) {
        TreeItem treeItem = n2 == -1 ? null : this.tree.getItem(n2);
        TreeColumn treeColumn = n3 == -1 || this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(n3);
        this.setRowColumn(treeItem, treeColumn, bl2);
    }

    void setRowColumn(TreeItem treeItem, TreeColumn treeColumn, boolean bl2) {
        TreeItem treeItem2;
        if (this.row != null && this.row != treeItem) {
            for (treeItem2 = this.row; treeItem2 != null; treeItem2 = treeItem2.getParentItem()) {
                treeItem2.removeListener(12, this.disposeItemListener);
            }
            this.row = null;
        }
        if (this.column != null && this.column != treeColumn) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (treeItem != null) {
            if (this.row != treeItem) {
                this.row = treeItem;
                for (treeItem2 = treeItem; treeItem2 != null; treeItem2 = treeItem2.getParentItem()) {
                    treeItem2.addListener(12, this.disposeItemListener);
                }
                this.tree.showItem(treeItem);
            }
            if (this.column != treeColumn && treeColumn != null) {
                this.column = treeColumn;
                treeColumn.addListener(12, this.disposeColumnListener);
                treeColumn.addListener(10, this.resizeListener);
                treeColumn.addListener(11, this.resizeListener);
                this.tree.showColumn(treeColumn);
            }
            int n2 = treeColumn == null ? 0 : this.tree.indexOf(treeColumn);
            this.setBounds(treeItem.getBounds(n2));
            this.redraw();
            if (bl2) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setSelection(int n2, int n3) {
        int n4;
        this.checkWidget();
        int n5 = this.tree.getColumnCount();
        int n6 = n4 = n5 == 0 ? 0 : n5 - 1;
        if (n2 < 0 || n2 >= this.tree.getItemCount() || n3 < 0 || n3 > n4) {
            SWT.error(5);
        }
        this.setRowColumn(n2, n3, false);
    }

    public void setSelection(TreeItem treeItem, int n2) {
        int n3;
        this.checkWidget();
        int n4 = this.tree.getColumnCount();
        int n5 = n3 = n4 == 0 ? 0 : n4 - 1;
        if (treeItem == null || treeItem.isDisposed() || n2 < 0 || n2 > n3) {
            SWT.error(5);
        }
        TreeColumn treeColumn = this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(n2);
        this.setRowColumn(treeItem, treeColumn, false);
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        if (bl2) {
            this._resize();
        }
        super.setVisible(bl2);
    }

    void treeCollapse(Event event) {
        if (this.row == null) {
            return;
        }
        TreeItem treeItem = (TreeItem)event.item;
        for (TreeItem treeItem2 = this.row.getParentItem(); treeItem2 != null; treeItem2 = treeItem2.getParentItem()) {
            if (treeItem2 != treeItem) continue;
            this.setRowColumn(treeItem, this.column, true);
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TreeCursor.this.isDisposed()) {
                    return;
                }
                TreeCursor.this.setRowColumn(TreeCursor.this.row, TreeCursor.this.column, true);
            }
        });
    }

    void treeExpand(Event event) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TreeCursor.this.isDisposed()) {
                    return;
                }
                TreeCursor.this.setRowColumn(TreeCursor.this.row, TreeCursor.this.column, true);
            }
        });
    }

    void treeFocusIn(Event event) {
        if (this.isVisible()) {
            if (this.row == null && this.column == null) {
                return;
            }
            this.setFocus();
        }
    }

    void treeMouseDown(Event event) {
        int n2;
        int n3;
        Item item;
        if (this.tree.getItemCount() == 0) {
            return;
        }
        Point point = new Point(event.x, event.y);
        TreeItem treeItem = this.tree.getItem(point);
        if (treeItem == null && (this.tree.getStyle() & 0x10000) == 0) {
            item = this.tree.getTopItem();
            TreeItem treeItem2 = item.getParentItem();
            while (treeItem2 != null) {
                item = treeItem2;
                treeItem2 = item.getParentItem();
            }
            n3 = this.tree.indexOf((TreeItem)item);
            n2 = this.tree.getClientArea().height / this.tree.getItemHeight();
            int n4 = Math.min(n3 + n2, this.tree.getItemCount() - 1);
            TreeItem[] treeItemArray = this.tree.getItems();
            TreeItem[] treeItemArray2 = new TreeItem[n4 - n3 + 1];
            System.arraycopy(treeItemArray, n3, treeItemArray2, 0, n4 - n3 + 1);
            treeItem = this.findItem(treeItemArray2, point);
        }
        if (treeItem == null) {
            return;
        }
        item = null;
        int n5 = this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0;
        n3 = this.tree.getColumnCount();
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                Rectangle rectangle = treeItem.getBounds(n2);
                rectangle.width += n5;
                rectangle.height += n5;
                if (!rectangle.contains(point)) continue;
                item = this.tree.getColumn(n2);
                break;
            }
            if (item == null) {
                item = this.tree.getColumn(0);
            }
        }
        this.setRowColumn(treeItem, (TreeColumn)item, true);
        this.setFocus();
    }

    void unhookRowColumnListeners() {
        if (this.column != null && !this.column.isDisposed()) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
        }
        this.column = null;
        if (this.row != null && !this.row.isDisposed()) {
            for (TreeItem treeItem = this.row; treeItem != null; treeItem = treeItem.getParentItem()) {
                treeItem.removeListener(12, this.disposeItemListener);
            }
        }
        this.row = null;
    }
}

