/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

@Deprecated
public class TableTreeItem
extends Item {
    TableItem tableItem;
    TableTree parent;
    TableTreeItem parentItem;
    TableTreeItem[] items = TableTree.EMPTY_ITEMS;
    String[] texts = TableTree.EMPTY_TEXTS;
    Image[] images = TableTree.EMPTY_IMAGES;
    Color background;
    Color foreground;
    Font font;
    boolean expanded;
    boolean checked;
    boolean grayed;

    public TableTreeItem(TableTree tableTree, int n2) {
        this(tableTree, n2, tableTree.getItemCount());
    }

    public TableTreeItem(TableTree tableTree, int n2, int n3) {
        this(tableTree, null, n2, n3);
    }

    public TableTreeItem(TableTreeItem tableTreeItem, int n2) {
        this(tableTreeItem, n2, tableTreeItem.getItemCount());
    }

    public TableTreeItem(TableTreeItem tableTreeItem, int n2, int n3) {
        this(tableTreeItem.getParent(), tableTreeItem, n2, n3);
    }

    TableTreeItem(TableTree tableTree, TableTreeItem tableTreeItem, int n2, int n3) {
        super(tableTree, n2);
        this.parent = tableTree;
        this.parentItem = tableTreeItem;
        if (tableTreeItem == null) {
            int n4 = tableTree.addItem(this, n3);
            this.tableItem = new TableItem(tableTree.getTable(), n2, n4);
            this.tableItem.setData("TableTreeItemID", this);
            this.addCheck();
            if (tableTree.sizeImage == null) {
                int n5 = tableTree.getItemHeight();
                tableTree.sizeImage = new Image((Device)tableTree.getDisplay(), n5, n5);
                GC gC = new GC(tableTree.sizeImage);
                gC.setBackground(tableTree.getBackground());
                gC.fillRectangle(0, 0, n5, n5);
                gC.dispose();
                this.tableItem.setImage(0, tableTree.sizeImage);
            }
        } else {
            tableTreeItem.addItem(this, n3);
        }
    }

    void addCheck() {
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        this.tableItem.setChecked(this.checked);
        this.tableItem.setGrayed(this.grayed);
    }

    void addItem(TableTreeItem tableTreeItem, int n2) {
        Object object;
        if (tableTreeItem == null) {
            SWT.error(4);
        }
        if (n2 < 0 || n2 > this.items.length) {
            SWT.error(5);
        }
        if (this.items.length == 0 && n2 == 0 && this.tableItem != null) {
            object = this.expanded ? this.parent.getMinusImage() : this.parent.getPlusImage();
            this.tableItem.setImage(0, (Image)object);
        }
        object = new TableTreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, object, 0, n2);
        object[n2] = tableTreeItem;
        System.arraycopy(this.items, n2, object, n2 + 1, this.items.length - n2);
        this.items = object;
        if (this.expanded) {
            tableTreeItem.setVisible(true);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background == null ? this.parent.getBackground() : this.background;
    }

    public Rectangle getBounds(int n2) {
        this.checkWidget();
        if (this.tableItem != null) {
            return this.tableItem.getBounds(n2);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (this.tableItem == null) {
            return this.checked;
        }
        return this.tableItem.getChecked();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (this.tableItem == null) {
            return this.grayed;
        }
        return this.tableItem.getGrayed();
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == null ? this.parent.getFont() : this.font;
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground == null ? this.parent.getForeground() : this.foreground;
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int n2) {
        if (0 < n2 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    int getIndent() {
        if (this.parentItem == null) {
            return 0;
        }
        return this.parentItem.getIndent() + 1;
    }

    public TableTreeItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.items.length;
        if (0 > n2 || n2 >= n3) {
            SWT.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        return this.items.length;
    }

    public TableTreeItem[] getItems() {
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, this.items.length);
        return tableTreeItemArray;
    }

    TableTreeItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        if (this.tableItem == tableItem) {
            return this;
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            TableTreeItem tableTreeItem = this.items[i2].getItem(tableItem);
            if (tableTreeItem == null) continue;
            return tableTreeItem;
        }
        return null;
    }

    public TableTree getParent() {
        return this.parent;
    }

    public TableTreeItem getParentItem() {
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int n2) {
        if (0 <= n2 && n2 < this.texts.length) {
            return this.texts[n2];
        }
        return null;
    }

    boolean getVisible() {
        return this.tableItem != null;
    }

    public int indexOf(TableTreeItem tableTreeItem) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] != tableTreeItem) continue;
            return i2;
        }
        return -1;
    }

    void expandAll(boolean bl2) {
        if (this.items.length == 0) {
            return;
        }
        if (!this.expanded) {
            this.setExpanded(true);
            if (bl2) {
                Event event = new Event();
                event.item = this;
                this.parent.notifyListeners(17, event);
            }
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            this.items[i2].expandAll(bl2);
        }
    }

    int expandedIndexOf(TableTreeItem tableTreeItem) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] == tableTreeItem) {
                return n2;
            }
            if (this.items[i2].expanded) {
                n2 += this.items[i2].visibleChildrenCount();
            }
            ++n2;
        }
        return -1;
    }

    int visibleChildrenCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (!this.items[i2].getVisible()) continue;
            n2 += 1 + this.items[i2].visibleChildrenCount();
        }
        return n2;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        for (int i2 = this.items.length - 1; i2 >= 0; --i2) {
            this.items[i2].dispose();
        }
        super.dispose();
        if (!this.parent.inDispose) {
            if (this.parentItem != null) {
                this.parentItem.removeItem(this);
            } else {
                this.parent.removeItem(this);
            }
            if (this.tableItem != null) {
                this.tableItem.dispose();
            }
        }
        this.items = null;
        this.parentItem = null;
        this.parent = null;
        this.images = null;
        this.texts = null;
        this.tableItem = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
    }

    void removeItem(TableTreeItem tableTreeItem) {
        int n2;
        for (n2 = 0; n2 < this.items.length && this.items[n2] != tableTreeItem; ++n2) {
        }
        if (n2 == this.items.length) {
            return;
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n2);
        System.arraycopy(this.items, n2 + 1, tableTreeItemArray, n2, this.items.length - n2 - 1);
        this.items = tableTreeItemArray;
        if (this.items.length == 0 && this.tableItem != null) {
            this.tableItem.setImage(0, null);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setBackground(color);
        }
        this.background = color;
    }

    public void setChecked(boolean bl2) {
        this.checkWidget();
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.tableItem != null) {
            this.tableItem.setChecked(bl2);
        }
        this.checked = bl2;
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.tableItem != null) {
            this.tableItem.setGrayed(bl2);
        }
        this.grayed = bl2;
    }

    public void setExpanded(boolean bl2) {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        if (this.expanded == bl2) {
            return;
        }
        this.expanded = bl2;
        if (this.tableItem == null) {
            return;
        }
        this.parent.setRedraw(false);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            this.items[i2].setVisible(bl2);
        }
        Image image = bl2 ? this.parent.getMinusImage() : this.parent.getPlusImage();
        this.tableItem.setImage(0, image);
        this.parent.setRedraw(true);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setFont(font);
        }
        this.font = font;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setForeground(color);
        }
        this.foreground = color;
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        int n3 = Math.max(this.parent.getTable().getColumnCount(), 1);
        if (n2 <= 0 || n2 >= n3) {
            return;
        }
        if (this.images.length < n3) {
            Image[] imageArray = new Image[n3];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        if (this.tableItem != null) {
            this.tableItem.setImage(n2, image);
        }
    }

    public void setImage(Image image) {
        this.setImage(0, image);
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n3 = Math.max(this.parent.getTable().getColumnCount(), 1);
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        if (this.texts.length < n3) {
            String[] stringArray = new String[n3];
            System.arraycopy(this.texts, 0, stringArray, 0, this.texts.length);
            this.texts = stringArray;
        }
        this.texts[n2] = string;
        if (this.tableItem != null) {
            this.tableItem.setText(n2, string);
        }
    }

    public void setText(String string) {
        this.setText(0, string);
    }

    void setVisible(boolean bl2) {
        if (this.parentItem == null) {
            return;
        }
        if (this.getVisible() == bl2) {
            return;
        }
        if (bl2) {
            int n2;
            if (!this.parentItem.getVisible()) {
                return;
            }
            Table table = this.parent.getTable();
            int n3 = table.indexOf(this.parentItem.tableItem);
            int n4 = this.parentItem.expandedIndexOf(this) + n3 + 1;
            if (n4 < 0) {
                return;
            }
            this.tableItem = new TableItem(table, this.getStyle(), n4);
            this.tableItem.setData("TableTreeItemID", this);
            this.tableItem.setImageIndent(this.getIndent());
            if (this.background != null) {
                this.tableItem.setBackground(this.background);
            }
            if (this.foreground != null) {
                this.tableItem.setForeground(this.foreground);
            }
            if (this.font != null) {
                this.tableItem.setFont(this.font);
            }
            this.addCheck();
            int n5 = Math.max(table.getColumnCount(), 1);
            for (n2 = 0; n2 < n5; ++n2) {
                if (n2 < this.texts.length && this.texts[n2] != null) {
                    this.setText(n2, this.texts[n2]);
                }
                if (n2 >= this.images.length || this.images[n2] == null) continue;
                this.setImage(n2, this.images[n2]);
            }
            if (this.items.length != 0) {
                if (this.expanded) {
                    this.tableItem.setImage(0, this.parent.getMinusImage());
                    int n6 = this.items.length;
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.items[n2].setVisible(true);
                    }
                } else {
                    this.tableItem.setImage(0, this.parent.getPlusImage());
                }
            }
        } else {
            int n7 = this.items.length;
            for (int i2 = 0; i2 < n7; ++i2) {
                this.items[i2].setVisible(false);
            }
            this.tableItem.dispose();
            this.tableItem = null;
        }
    }
}

