/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public Control topControl;

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        int n4;
        Control[] controlArray = composite.getChildren();
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < controlArray.length; ++n4) {
            Point point = controlArray[n4].computeSize(n2, n3, bl2);
            n5 = Math.max(point.x, n5);
            n6 = Math.max(point.y, n6);
        }
        n4 = n5 + 2 * this.marginWidth;
        int n7 = n6 + 2 * this.marginHeight;
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        return new Point(n4, n7);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean bl2) {
        Control[] controlArray = composite.getChildren();
        Rectangle rectangle = composite.getClientArea();
        rectangle.x += this.marginWidth;
        rectangle.y += this.marginHeight;
        rectangle.width -= 2 * this.marginWidth;
        rectangle.height -= 2 * this.marginHeight;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].setBounds(rectangle);
            controlArray[i2].setVisible(controlArray[i2] == this.topControl);
        }
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    public String toString() {
        String string = this.getName() + " {";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.topControl != null) {
            string = string + "topControl=" + this.topControl + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

