/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class CTabFolderRenderer {
    protected CTabFolder parent;
    int[] curve;
    int[] topCurveHighlightStart;
    int[] topCurveHighlightEnd;
    int curveWidth = 0;
    int curveIndent = 0;
    int lastTabHeight = -1;
    Color fillColor;
    Color selectionHighlightGradientBegin = null;
    Color[] selectionHighlightGradientColorsCache = null;
    Color selectedOuterColor = null;
    Color selectedInnerColor = null;
    Color tabAreaColor = null;
    Color lastBorderColor = null;
    static final int[] TOP_LEFT_CORNER_HILITE = new int[]{5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6};
    static final int[] TOP_LEFT_CORNER = new int[]{0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0};
    static final int[] TOP_RIGHT_CORNER = new int[]{-6, 0, -5, 1, -4, 1, -1, 4, -1, 5, 0, 6};
    static final int[] BOTTOM_LEFT_CORNER = new int[]{0, -6, 1, -5, 1, -4, 4, -1, 5, -1, 6, 0};
    static final int[] BOTTOM_RIGHT_CORNER = new int[]{-6, 0, -5, -1, -4, -1, -1, -4, -1, -5, 0, -6};
    static final int[] SIMPLE_TOP_LEFT_CORNER = new int[]{0, 2, 1, 1, 2, 0};
    static final int[] SIMPLE_TOP_RIGHT_CORNER = new int[]{-2, 0, -1, 1, 0, 2};
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER = new int[]{0, -2, 1, -1, 2, 0};
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER = new int[]{-2, 0, -1, -1, 0, -2};
    static final int[] SIMPLE_UNSELECTED_INNER_CORNER = new int[]{0, 0};
    static final int[] TOP_LEFT_CORNER_BORDERLESS = new int[]{0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0};
    static final int[] TOP_RIGHT_CORNER_BORDERLESS = new int[]{-7, 0, -6, 1, -5, 1, -2, 4, -2, 5, -1, 6};
    static final int[] BOTTOM_LEFT_CORNER_BORDERLESS = new int[]{0, -6, 1, -6, 1, -5, 2, -4, 4, -2, 5, -1, 6, -1, 6, 0};
    static final int[] BOTTOM_RIGHT_CORNER_BORDERLESS = new int[]{-7, 0, -7, -1, -6, -1, -5, -2, -3, -4, -2, -5, -2, -6, -1, -6};
    static final int[] SIMPLE_TOP_LEFT_CORNER_BORDERLESS = new int[]{0, 2, 1, 1, 2, 0};
    static final int[] SIMPLE_TOP_RIGHT_CORNER_BORDERLESS = new int[]{-3, 0, -2, 1, -1, 2};
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS = new int[]{0, -3, 1, -2, 2, -1, 3, 0};
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS = new int[]{-4, 0, -3, -1, -2, -2, -1, -3};
    static final RGB CLOSE_FILL = new RGB(252, 160, 160);
    static final int BUTTON_SIZE = 16;
    static final int BUTTON_TRIM = 1;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int BORDER1_COLOR = 18;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 2;
    static final int ITEM_LEFT_MARGIN = 4;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";
    public static final int PART_BODY = -1;
    public static final int PART_HEADER = -2;
    public static final int PART_BORDER = -3;
    public static final int PART_BACKGROUND = -4;
    public static final int PART_MAX_BUTTON = -5;
    public static final int PART_MIN_BUTTON = -6;
    public static final int PART_CHEVRON_BUTTON = -7;
    public static final int PART_CLOSE_BUTTON = -8;
    public static final int MINIMUM_SIZE = 0x1000000;

    protected CTabFolderRenderer(CTabFolder cTabFolder) {
        if (cTabFolder == null) {
            return;
        }
        if (cTabFolder.isDisposed()) {
            SWT.error(5);
        }
        this.parent = cTabFolder;
    }

    void antialias(int[] nArray, Color color, Color color2, GC gC) {
        int n2;
        int n3;
        int n4;
        if (this.parent.simple) {
            return;
        }
        String string = SWT.getPlatform();
        if ("cocoa".equals(string)) {
            return;
        }
        if (this.parent.getDisplay().getDepth() < 15) {
            return;
        }
        if (color2 != null) {
            int n5 = 0;
            n4 = 1;
            n3 = this.parent.onBottom ? 0 : this.parent.getSize().y;
            int[] nArray2 = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length / 2; ++n2) {
                if (n4 != 0 && n5 + 3 < nArray.length) {
                    n4 = this.parent.onBottom ? (n3 <= nArray[n5 + 3] ? 1 : 0) : (n3 >= nArray[n5 + 3] ? 1 : 0);
                    n3 = nArray[n5 + 1];
                }
                nArray2[n5] = nArray[n5++] + (n4 != 0 ? -1 : 1);
                nArray2[n5] = nArray[n5++];
            }
            gC.setForeground(color2);
            gC.drawPolyline(nArray2);
        }
        if (color != null) {
            int[] nArray3 = new int[nArray.length];
            n4 = 0;
            n3 = 1;
            int n6 = this.parent.onBottom ? 0 : this.parent.getSize().y;
            for (n2 = 0; n2 < nArray.length / 2; ++n2) {
                if (n3 != 0 && n4 + 3 < nArray.length) {
                    n3 = this.parent.onBottom ? (n6 <= nArray[n4 + 3] ? 1 : 0) : (n6 >= nArray[n4 + 3] ? 1 : 0);
                    n6 = nArray[n4 + 1];
                }
                nArray3[n4] = nArray[n4++] + (n3 != 0 ? 1 : -1);
                nArray3[n4] = nArray[n4++];
            }
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
        }
    }

    protected Point computeSize(int n2, int n3, GC gC, int n4, int n5) {
        Object object;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case -2: {
                if (this.parent.fixedTabHeight != -1) {
                    n7 = this.parent.fixedTabHeight == 0 ? 0 : this.parent.fixedTabHeight + 1;
                    break;
                }
                object = this.parent.items;
                if (((CTabItem[])object).length == 0) {
                    n7 = gC.textExtent((String)"Default", (int)9).y + 2 + 2;
                } else {
                    for (int i2 = 0; i2 < ((CTabItem[])object).length; ++i2) {
                        n7 = Math.max(n7, this.computeSize((int)i2, (int)0, (GC)gC, (int)n4, (int)n5).y);
                    }
                }
                gC.dispose();
                break;
            }
            case -8: 
            case -6: 
            case -5: {
                n7 = 16;
                n6 = 16;
                break;
            }
            case -7: {
                n6 = 24;
                n7 = 16;
                break;
            }
            default: {
                Object object2;
                if (0 > n2 || n2 >= this.parent.getItemCount()) break;
                this.updateCurves();
                object = this.parent.items[n2];
                if (((Widget)object).isDisposed()) {
                    return new Point(0, 0);
                }
                Image image = ((Item)object).getImage();
                if (image != null && !image.isDisposed()) {
                    object2 = image.getBounds();
                    if ((n3 & 2) != 0 || this.parent.showUnselectedImage) {
                        n6 += ((Rectangle)object2).width;
                    }
                    n7 = ((Rectangle)object2).height;
                }
                object2 = null;
                if ((n3 & 0x1000000) != 0) {
                    int n8 = this.parent.minChars;
                    Object object3 = object2 = n8 == 0 ? null : ((Item)object).getText();
                    if (object2 != null && ((String)object2).length() > n8) {
                        int n9;
                        if (this.useEllipses()) {
                            n9 = n8 < ELLIPSIS.length() + 1 ? n8 : n8 - ELLIPSIS.length();
                            object2 = ((String)object2).substring(0, n9);
                            if (n8 > ELLIPSIS.length() + 1) {
                                object2 = (String)object2 + ELLIPSIS;
                            }
                        } else {
                            n9 = n8;
                            object2 = ((String)object2).substring(0, n9);
                        }
                    }
                } else {
                    object2 = ((Item)object).getText();
                }
                if (object2 != null) {
                    if (n6 > 0) {
                        n6 += 4;
                    }
                    if (((CTabItem)object).font == null) {
                        Point point = gC.textExtent((String)object2, 9);
                        n6 += point.x;
                        n7 = Math.max(n7, point.y);
                    } else {
                        Font font = gC.getFont();
                        gC.setFont(((CTabItem)object).font);
                        Point point = gC.textExtent((String)object2, 9);
                        n6 += point.x;
                        n7 = Math.max(n7, point.y);
                        gC.setFont(font);
                    }
                }
                if (!this.parent.showClose && !((CTabItem)object).showClose || (n3 & 2) == 0 && !this.parent.showUnselectedClose) break;
                if (n6 > 0) {
                    n6 += 4;
                }
                n6 += this.computeSize((int)-8, (int)0, (GC)gC, (int)-1, (int)-1).x;
            }
        }
        object = this.computeTrim(n2, n3, 0, 0, n6, n7);
        n6 = ((Rectangle)object).width;
        n7 = ((Rectangle)object).height;
        return new Point(n6, n7);
    }

    protected Rectangle computeTrim(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = n8 = this.parent.borderVisible ? 1 : 0;
        int n10 = this.parent.onBottom ? n8 : 0;
        int n11 = this.parent.onBottom ? 0 : n8;
        int n12 = this.parent.tabHeight;
        switch (n2) {
            case -1: {
                int n13;
                int n14 = this.parent.getStyle();
                int n15 = (n14 & 0x800000) != 0 ? 1 : 3;
                int n16 = n13 = (n14 & 0x800000) != 0 ? 0 : 2;
                if (this.parent.fixedTabHeight == 0 && (n14 & 0x800000) != 0 && (n14 & 0x800) == 0) {
                    n15 = 0;
                }
                int n17 = this.parent.marginWidth;
                int n18 = this.parent.marginHeight;
                n4 = n4 - n17 - n13 - n8;
                n6 = n6 + n8 + n9 + 2 * n17 + 2 * n13;
                if (this.parent.minimized) {
                    n5 = this.parent.onBottom ? n5 - n10 : n5 - n15 - n12 - n10;
                    n7 = n10 + n11 + n12 + n15;
                    break;
                }
                n5 = this.parent.onBottom ? n5 - n18 - n13 - n10 : n5 - n18 - n15 - n12 - n10;
                n7 = n7 + n10 + n11 + 2 * n18 + n12 + n15 + n13;
                break;
            }
            case -2: {
                break;
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: {
                --n4;
                --n5;
                n6 += 2;
                n7 += 2;
                break;
            }
            case -3: {
                n4 -= n8;
                n6 = n6 + n8 + n9;
                if (!this.parent.simple) {
                    n6 += 2;
                }
                n5 -= n10;
                n7 = n7 + n10 + n11;
                break;
            }
            default: {
                if (0 > n2 || n2 >= this.parent.getItemCount()) break;
                this.updateCurves();
                n4 -= 4;
                n6 = n6 + 4 + 4;
                if (!this.parent.simple && !this.parent.single && (n3 & 2) != 0) {
                    n6 += this.curveWidth - this.curveIndent;
                }
                n5 -= 2;
                n7 = n7 + 2 + 2;
            }
        }
        return new Rectangle(n4, n5, n6, n7);
    }

    void createAntialiasColors() {
        int n2;
        int n3;
        int n4;
        RGB rGB;
        RGB rGB2;
        this.disposeAntialiasColors();
        this.lastBorderColor = this.parent.getDisplay().getSystemColor(18);
        RGB rGB3 = this.lastBorderColor.getRGB();
        RGB rGB4 = this.parent.selectionBackground.getRGB();
        if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
            rGB4 = null;
        }
        RGB rGB5 = this.parent.getBackground().getRGB();
        if (this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
            rGB5 = null;
        }
        if (rGB5 != null) {
            rGB2 = rGB3;
            rGB = rGB5;
            n4 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n3 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n2 = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.selectedOuterColor = new Color(this.parent.getDisplay(), n4, n3, n2);
        }
        if (rGB4 != null) {
            rGB2 = rGB3;
            rGB = rGB4;
            n4 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n3 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n2 = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.selectedInnerColor = new Color(this.parent.getDisplay(), n4, n3, n2);
        }
        if ((rGB5 = this.parent.getParent().getBackground().getRGB()) != null) {
            rGB2 = rGB3;
            rGB = rGB5;
            n4 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n3 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n2 = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.tabAreaColor = new Color(this.parent.getDisplay(), n4, n3, n2);
        }
    }

    void createSelectionHighlightGradientColors(Color color) {
        this.disposeSelectionHighlightGradientColors();
        if (color == null) {
            return;
        }
        int n2 = this.parent.tabHeight;
        RGB rGB = color.getRGB();
        RGB rGB2 = this.parent.selectionBackground.getRGB();
        this.selectionHighlightGradientColorsCache = new Color[n2];
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = n3 - i2;
            int n5 = i2;
            int n6 = (rGB2.red * n5 + rGB.red * n4) / n3;
            int n7 = (rGB2.green * n5 + rGB.green * n4) / n3;
            int n8 = (rGB2.blue * n5 + rGB.blue * n4) / n3;
            this.selectionHighlightGradientColorsCache[i2] = new Color(this.parent.getDisplay(), n6, n7, n8);
        }
    }

    protected void dispose() {
        this.disposeAntialiasColors();
        this.disposeSelectionHighlightGradientColors();
        if (this.fillColor != null) {
            this.fillColor.dispose();
            this.fillColor = null;
        }
    }

    void disposeAntialiasColors() {
        if (this.tabAreaColor != null) {
            this.tabAreaColor.dispose();
        }
        if (this.selectedInnerColor != null) {
            this.selectedInnerColor.dispose();
        }
        if (this.selectedOuterColor != null) {
            this.selectedOuterColor.dispose();
        }
        this.selectedOuterColor = null;
        this.selectedInnerColor = null;
        this.tabAreaColor = null;
    }

    void disposeSelectionHighlightGradientColors() {
        if (this.selectionHighlightGradientColorsCache == null) {
            return;
        }
        for (Color color : this.selectionHighlightGradientColorsCache) {
            color.dispose();
        }
        this.selectionHighlightGradientColorsCache = null;
    }

    protected void draw(int n2, int n3, Rectangle rectangle, GC gC) {
        switch (n2) {
            case -4: {
                this.drawBackground(gC, rectangle, n3);
                break;
            }
            case -1: {
                this.drawBody(gC, rectangle, n3);
                break;
            }
            case -2: {
                this.drawTabArea(gC, rectangle, n3);
                break;
            }
            case -5: {
                this.drawMaximize(gC, rectangle, n3);
                break;
            }
            case -6: {
                this.drawMinimize(gC, rectangle, n3);
                break;
            }
            case -7: {
                this.drawChevron(gC, rectangle, n3);
                break;
            }
            default: {
                if (0 > n2 || n2 >= this.parent.getItemCount()) break;
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                if ((n3 & 2) != 0) {
                    this.drawSelected(n2, gC, rectangle, n3);
                    break;
                }
                this.drawUnselected(n2, gC, rectangle, n3);
            }
        }
    }

    void drawBackground(GC gC, Rectangle rectangle, int n2) {
        boolean bl2 = (n2 & 2) != 0;
        Color color = bl2 ? this.parent.selectionBackground : this.parent.getBackground();
        Image image = bl2 ? this.parent.selectionBgImage : null;
        Color[] colorArray = bl2 ? this.parent.selectionGradientColors : this.parent.gradientColors;
        int[] nArray = bl2 ? this.parent.selectionGradientPercents : this.parent.gradientPercents;
        boolean bl3 = bl2 ? this.parent.selectionGradientVertical : this.parent.gradientVertical;
        this.drawBackground(gC, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, image, colorArray, nArray, bl3);
    }

    void drawBackground(GC gC, int[] nArray, boolean bl2) {
        int n2;
        Color color = bl2 ? this.parent.selectionBackground : this.parent.getBackground();
        Image image = bl2 ? this.parent.selectionBgImage : null;
        Color[] colorArray = bl2 ? this.parent.selectionGradientColors : this.parent.gradientColors;
        int[] nArray2 = bl2 ? this.parent.selectionGradientPercents : this.parent.gradientPercents;
        boolean bl3 = bl2 ? this.parent.selectionGradientVertical : this.parent.gradientVertical;
        Point point = this.parent.getSize();
        int n3 = point.x;
        int n4 = this.parent.tabHeight + ((this.parent.getStyle() & 0x800000) != 0 ? 1 : 3);
        int n5 = 0;
        int n6 = this.parent.borderVisible ? 1 : 0;
        int n7 = this.parent.onBottom ? n6 : 0;
        int n8 = n2 = this.parent.onBottom ? 0 : n6;
        if (n6 > 0) {
            ++n5;
            n3 -= 2;
        }
        int n9 = this.parent.onBottom ? point.y - n2 - n4 : n7;
        this.drawBackground(gC, nArray, n5, n9, n3, n4, color, image, colorArray, nArray2, bl3);
    }

    void drawBackground(GC gC, int[] nArray, int n2, int n3, int n4, int n5, Color color, Image image, Color[] colorArray, int[] nArray2, boolean bl2) {
        Region region = null;
        Region region2 = null;
        if (nArray != null) {
            region = new Region();
            gC.getClipping(region);
            region2 = new Region();
            region2.add(nArray);
            region2.intersect(region);
            gC.setClipping(region2);
        }
        if (image != null) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
            Rectangle rectangle = image.getBounds();
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n3, n4, n5);
        } else if (colorArray != null) {
            if (colorArray.length == 1) {
                Color color2 = colorArray[0] != null ? colorArray[0] : color;
                gC.setBackground(color2);
                gC.fillRectangle(n2, n3, n4, n5);
            } else if (bl2) {
                if (this.parent.onBottom) {
                    Color color3;
                    int n6 = 0;
                    if (nArray2[nArray2.length - 1] < 100) {
                        n6 = (100 - nArray2[nArray2.length - 1]) * n5 / 100;
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n3, n4, n6);
                    }
                    if ((color3 = colorArray[colorArray.length - 1]) == null) {
                        color3 = color;
                    }
                    for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
                        gC.setForeground(color3);
                        color3 = colorArray[i2];
                        if (color3 == null) {
                            color3 = color;
                        }
                        gC.setBackground(color3);
                        int n7 = i2 > 0 ? nArray2[i2] - nArray2[i2 - 1] : nArray2[i2];
                        int n8 = n7 * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n6, n4, n8, true);
                        n6 += n8;
                    }
                } else {
                    Color color4 = colorArray[0];
                    if (color4 == null) {
                        color4 = color;
                    }
                    int n9 = 0;
                    for (int i3 = 0; i3 < nArray2.length; ++i3) {
                        gC.setForeground(color4);
                        color4 = colorArray[i3 + 1];
                        if (color4 == null) {
                            color4 = color;
                        }
                        gC.setBackground(color4);
                        int n10 = i3 > 0 ? nArray2[i3] - nArray2[i3 - 1] : nArray2[i3];
                        int n11 = n10 * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n9, n4, n11, true);
                        n9 += n11;
                    }
                    if (n9 < n5) {
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n9, n4, n5 - n9 + 1);
                    }
                }
            } else {
                n3 = 0;
                n5 = this.parent.getSize().y;
                Color color5 = colorArray[0];
                if (color5 == null) {
                    color5 = color;
                }
                int n12 = 0;
                for (int i4 = 0; i4 < nArray2.length; ++i4) {
                    gC.setForeground(color5);
                    color5 = colorArray[i4 + 1];
                    if (color5 == null) {
                        color5 = color;
                    }
                    gC.setBackground(color5);
                    int n13 = nArray2[i4] * n4 / 100 - n12;
                    gC.fillGradientRectangle(n2 + n12, n3, n13, n5, false);
                    n12 += n13;
                }
                if (n12 < n4) {
                    gC.setBackground(color);
                    gC.fillRectangle(n2 + n12, n3, n4 - n12, n5);
                }
            }
        } else if ((this.parent.getStyle() & 0x40000) != 0 || !color.equals(this.parent.getBackground())) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
        }
        if (nArray != null) {
            gC.setClipping(region);
            region.dispose();
            region2.dispose();
        }
    }

    void drawBorder(GC gC, int[] nArray) {
        gC.setForeground(this.parent.getDisplay().getSystemColor(18));
        gC.drawPolyline(nArray);
    }

    void drawBody(GC gC, Rectangle rectangle, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Point point = new Point(rectangle.width, rectangle.height);
        int n8 = this.parent.selectedIndex;
        int n9 = this.parent.tabHeight;
        int n10 = n7 = this.parent.borderVisible ? 1 : 0;
        int n11 = this.parent.onBottom ? n7 : 0;
        int n12 = this.parent.onBottom ? 0 : n7;
        int n13 = this.parent.getStyle();
        int n14 = (n13 & 0x800000) != 0 ? 1 : 3;
        int n15 = n6 = (n13 & 0x800000) != 0 ? 0 : 2;
        if (!this.parent.minimized) {
            int n16;
            int n17;
            n5 = point.x - n7 - n10 - 2 * n6;
            n4 = point.y - n11 - n12 - n9 - n14 - n6;
            if (n6 > 0) {
                int[] nArray = null;
                if (this.parent.onBottom) {
                    n3 = n7;
                    n17 = n11;
                    n16 = point.x - n10;
                    int n18 = point.y - n12 - n9 - n14;
                    nArray = new int[]{n3, n17, n16, n17, n16, n18, n16 - n6, n18, n16 - n6, n17 + n6, n3 + n6, n17 + n6, n3 + n6, n18, n3, n18};
                } else {
                    n3 = n7;
                    n17 = n11 + n9 + n14;
                    n16 = point.x - n10;
                    int n19 = point.y - n12;
                    nArray = new int[]{n3, n17, n3 + n6, n17, n3 + n6, n19 - n6, n16 - n6, n19 - n6, n16 - n6, n17, n16, n17, n16, n19, n3, n19};
                }
                if (n8 != -1 && this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1 && !this.parent.selectionGradientVertical) {
                    this.drawBackground(gC, nArray, true);
                } else if (n8 == -1 && this.parent.gradientColors != null && this.parent.gradientColors.length > 1 && !this.parent.gradientVertical) {
                    this.drawBackground(gC, nArray, false);
                } else {
                    gC.setBackground(n8 == -1 ? this.parent.getBackground() : this.parent.selectionBackground);
                    gC.fillPolygon(nArray);
                }
            }
            if ((this.parent.getStyle() & 0x40000) != 0) {
                gC.setBackground(this.parent.getBackground());
                int n20 = this.parent.marginWidth;
                n3 = this.parent.marginHeight;
                n17 = n7 + n20 + n6;
                n16 = this.parent.onBottom ? n11 + n6 + n3 : n11 + n9 + n14 + n3;
                gC.fillRectangle(n17 - n20, n16 - n3, n5, n4);
            }
        } else if ((this.parent.getStyle() & 0x40000) != 0 && point.y > (n5 = n11 + n9 + n14 + n12)) {
            gC.setBackground(this.parent.getParent().getBackground());
            gC.fillRectangle(0, n5, point.x, point.y - n5);
        }
        if (n7 > 0) {
            gC.setForeground(this.parent.getDisplay().getSystemColor(18));
            n5 = n7 - 1;
            n4 = point.x - n10;
            int n21 = this.parent.onBottom ? n11 - 1 : n11 + n9;
            n3 = this.parent.onBottom ? point.y - n9 - n12 - 1 : point.y - n12;
            gC.drawLine(n5, n21, n5, n3);
            gC.drawLine(n4, n21, n4, n3);
            if (this.parent.onBottom) {
                gC.drawLine(n5, n21, n4, n21);
            } else {
                gC.drawLine(n5, n3, n4, n3);
            }
        }
    }

    void drawClose(GC gC, Rectangle rectangle, int n2) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n3 = rectangle.x + Math.max(1, (rectangle.width - 9) / 2);
        int n4 = rectangle.y + Math.max(1, (rectangle.height - 9) / 2);
        n4 += this.parent.onBottom ? -1 : 1;
        Color color = display.getSystemColor(17);
        switch (n2 & 0x2A) {
            case 0: {
                int[] nArray = new int[]{n3, n4, n3 + 2, n4, n3 + 4, n4 + 2, n3 + 5, n4 + 2, n3 + 7, n4, n3 + 9, n4, n3 + 9, n4 + 2, n3 + 7, n4 + 4, n3 + 7, n4 + 5, n3 + 9, n4 + 7, n3 + 9, n4 + 9, n3 + 7, n4 + 9, n3 + 5, n4 + 7, n3 + 4, n4 + 7, n3 + 2, n4 + 9, n3, n4 + 9, n3, n4 + 7, n3 + 2, n4 + 5, n3 + 2, n4 + 4, n3, n4 + 2};
                gC.setBackground(display.getSystemColor(25));
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 32: {
                int[] nArray = new int[]{n3, n4, n3 + 2, n4, n3 + 4, n4 + 2, n3 + 5, n4 + 2, n3 + 7, n4, n3 + 9, n4, n3 + 9, n4 + 2, n3 + 7, n4 + 4, n3 + 7, n4 + 5, n3 + 9, n4 + 7, n3 + 9, n4 + 9, n3 + 7, n4 + 9, n3 + 5, n4 + 7, n3 + 4, n4 + 7, n3 + 2, n4 + 9, n3, n4 + 9, n3, n4 + 7, n3 + 2, n4 + 5, n3 + 2, n4 + 4, n3, n4 + 2};
                gC.setBackground(this.getFillColor());
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n3 + 1, n4 + 1, n3 + 3, n4 + 1, n3 + 5, n4 + 3, n3 + 6, n4 + 3, n3 + 8, n4 + 1, n3 + 10, n4 + 1, n3 + 10, n4 + 3, n3 + 8, n4 + 5, n3 + 8, n4 + 6, n3 + 10, n4 + 8, n3 + 10, n4 + 10, n3 + 8, n4 + 10, n3 + 6, n4 + 8, n3 + 5, n4 + 8, n3 + 3, n4 + 10, n3 + 1, n4 + 10, n3 + 1, n4 + 8, n3 + 3, n4 + 6, n3 + 3, n4 + 5, n3 + 1, n4 + 3};
                gC.setBackground(this.getFillColor());
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 8: {
                int[] nArray = new int[]{n3, n4, n3 + 10, n4, n3 + 10, n4 + 10, n3, n4 + 10};
                this.drawBackground(gC, nArray, false);
                break;
            }
        }
    }

    void drawChevron(GC gC, Rectangle rectangle, int n2) {
        int n3;
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n4 = this.parent.selectedIndex;
        Display display = this.parent.getDisplay();
        Point point = display.getDPI();
        int n5 = 720 / point.y;
        FontData fontData = this.parent.getFont().getFontData()[0];
        fontData.setHeight(n5);
        Font font = new Font((Device)display, fontData);
        int n6 = font.getFontData()[0].getHeight() * point.y / 72;
        int n7 = Math.max(2, (rectangle.height - n6 - 4) / 2);
        int n8 = rectangle.x + 2;
        int n9 = rectangle.y + n7;
        int n10 = this.parent.getItemCount();
        if (this.parent.single) {
            n3 = n4 == -1 ? n10 : n10 - 1;
        } else {
            int n11;
            for (n11 = 0; n11 < this.parent.priority.length && this.parent.items[this.parent.priority[n11]].showing; ++n11) {
            }
            n3 = n10 - n11;
        }
        String string = n3 > 99 ? "99+" : String.valueOf(n3);
        switch (n2 & 0x22) {
            case 0: {
                Color color = this.parent.single ? this.parent.getSelectionForeground() : this.parent.getForeground();
                gC.setForeground(color);
                gC.setFont(font);
                gC.drawLine(n8, n9, n8 + 2, n9 + 2);
                gC.drawLine(n8 + 2, n9 + 2, n8, n9 + 4);
                gC.drawLine(n8 + 1, n9, n8 + 3, n9 + 2);
                gC.drawLine(n8 + 3, n9 + 2, n8 + 1, n9 + 4);
                gC.drawLine(n8 + 4, n9, n8 + 6, n9 + 2);
                gC.drawLine(n8 + 6, n9 + 2, n8 + 5, n9 + 4);
                gC.drawLine(n8 + 5, n9, n8 + 7, n9 + 2);
                gC.drawLine(n8 + 7, n9 + 2, n8 + 4, n9 + 4);
                gC.drawString(string, n8 + 7, n9 + 3, true);
                break;
            }
            case 32: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                gC.drawLine(n8, n9, n8 + 2, n9 + 2);
                gC.drawLine(n8 + 2, n9 + 2, n8, n9 + 4);
                gC.drawLine(n8 + 1, n9, n8 + 3, n9 + 2);
                gC.drawLine(n8 + 3, n9 + 2, n8 + 1, n9 + 4);
                gC.drawLine(n8 + 4, n9, n8 + 6, n9 + 2);
                gC.drawLine(n8 + 6, n9 + 2, n8 + 5, n9 + 4);
                gC.drawLine(n8 + 5, n9, n8 + 7, n9 + 2);
                gC.drawLine(n8 + 7, n9 + 2, n8 + 4, n9 + 4);
                gC.drawString(string, n8 + 7, n9 + 3, true);
                break;
            }
            case 2: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                gC.drawLine(n8 + 1, n9 + 1, n8 + 3, n9 + 3);
                gC.drawLine(n8 + 3, n9 + 3, n8 + 1, n9 + 5);
                gC.drawLine(n8 + 2, n9 + 1, n8 + 4, n9 + 3);
                gC.drawLine(n8 + 4, n9 + 3, n8 + 2, n9 + 5);
                gC.drawLine(n8 + 5, n9 + 1, n8 + 7, n9 + 3);
                gC.drawLine(n8 + 7, n9 + 3, n8 + 6, n9 + 5);
                gC.drawLine(n8 + 6, n9 + 1, n8 + 8, n9 + 3);
                gC.drawLine(n8 + 8, n9 + 3, n8 + 5, n9 + 5);
                gC.drawString(string, n8 + 8, n9 + 4, true);
            }
        }
        font.dispose();
    }

    void drawHighlight(GC gC, Rectangle rectangle, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.parent.simple || this.parent.onBottom) {
            return;
        }
        if (this.selectionHighlightGradientBegin == null) {
            return;
        }
        Color[] colorArray = this.selectionHighlightGradientColorsCache;
        if (colorArray == null) {
            return;
        }
        int n8 = colorArray.length;
        if (n8 == 0) {
            return;
        }
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        gC.setForeground(colorArray[0]);
        gC.drawLine(TOP_LEFT_CORNER_HILITE[0] + n9 + 1, 1 + n10, n3 - this.curveIndent, 1 + n10);
        int[] nArray = TOP_LEFT_CORNER_HILITE;
        int n11 = this.parent.tabHeight - this.topCurveHighlightEnd.length / 2;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        for (n7 = 0; n7 < nArray.length / 2; ++n7) {
            n6 = nArray[n7 * 2];
            n5 = nArray[n7 * 2 + 1];
            n12 = n6 + n9;
            n13 = n5 + n10;
            n14 = n5 - 1;
            gC.setForeground(colorArray[n14]);
            gC.drawPoint(n12, n13);
        }
        for (n7 = n14; n7 < n8; ++n7) {
            gC.setForeground(colorArray[n7]);
            gC.drawPoint(n12, 1 + n13++);
        }
        n7 = n3 - this.curveIndent;
        for (n6 = 0; n6 < this.topCurveHighlightStart.length / 2; ++n6) {
            n5 = this.topCurveHighlightStart[n6 * 2];
            n4 = this.topCurveHighlightStart[n6 * 2 + 1];
            n12 = n5 + n7;
            n13 = n4 + n10;
            n14 = n4 - 1;
            if (n14 >= n8) break;
            gC.setForeground(colorArray[n14]);
            gC.drawPoint(n12, n13);
        }
        for (n6 = n14; n6 < n14 + n11 && n6 < n8; ++n6) {
            gC.setForeground(colorArray[n6]);
            gC.drawPoint(1 + n12++, 1 + n13++);
        }
        for (n6 = 0; n6 < this.topCurveHighlightEnd.length / 2; ++n6) {
            n5 = this.topCurveHighlightEnd[n6 * 2];
            n4 = this.topCurveHighlightEnd[n6 * 2 + 1];
            n12 = n5 + n7;
            n13 = n4 + n10;
            n14 = n4 - 1;
            if (n14 >= n8) break;
            gC.setForeground(colorArray[n14]);
            gC.drawPoint(n12, n13);
        }
    }

    void drawLeftUnselectedBorder(GC gC, Rectangle rectangle, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.height;
        int[] nArray = null;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : BOTTOM_LEFT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n6 = 0;
            nArray[n6++] = n3;
            nArray[n6++] = n4 - 1;
            for (int i2 = 0; i2 < nArray2.length / 2; ++i2) {
                nArray[n6++] = n3 + nArray2[2 * i2];
                nArray[n6++] = n4 + n5 + nArray2[2 * i2 + 1] - 1;
            }
        } else {
            int[] nArray3 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : TOP_LEFT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n7 = 0;
            nArray[n7++] = n3;
            nArray[n7++] = n4 + n5;
            for (int i3 = 0; i3 < nArray3.length / 2; ++i3) {
                nArray[n7++] = n3 + nArray3[2 * i3];
                nArray[n7++] = n4 + nArray3[2 * i3 + 1];
            }
        }
        this.drawBorder(gC, nArray);
    }

    void drawMaximize(GC gC, Rectangle rectangle, int n2) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n3 = rectangle.x + (rectangle.width - 10) / 2;
        int n4 = rectangle.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (n2 & 0x22) {
            case 0: {
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n3, n4, 9, 9);
                    gC.drawRectangle(n3, n4, 9, 9);
                    gC.drawLine(n3 + 1, n4 + 2, n3 + 8, n4 + 2);
                    break;
                }
                gC.fillRectangle(n3, n4 + 3, 5, 4);
                gC.fillRectangle(n3 + 2, n4, 5, 4);
                gC.drawRectangle(n3, n4 + 3, 5, 4);
                gC.drawRectangle(n3 + 2, n4, 5, 4);
                gC.drawLine(n3 + 3, n4 + 1, n3 + 6, n4 + 1);
                gC.drawLine(n3 + 1, n4 + 4, n3 + 4, n4 + 4);
                break;
            }
            case 32: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n3, n4, 9, 9);
                    gC.drawRectangle(n3, n4, 9, 9);
                    gC.drawLine(n3 + 1, n4 + 2, n3 + 8, n4 + 2);
                    break;
                }
                gC.fillRectangle(n3, n4 + 3, 5, 4);
                gC.fillRectangle(n3 + 2, n4, 5, 4);
                gC.drawRectangle(n3, n4 + 3, 5, 4);
                gC.drawRectangle(n3 + 2, n4, 5, 4);
                gC.drawLine(n3 + 3, n4 + 1, n3 + 6, n4 + 1);
                gC.drawLine(n3 + 1, n4 + 4, n3 + 4, n4 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n3 + 1, n4 + 1, 9, 9);
                    gC.drawRectangle(n3 + 1, n4 + 1, 9, 9);
                    gC.drawLine(n3 + 2, n4 + 3, n3 + 9, n4 + 3);
                    break;
                }
                gC.fillRectangle(n3 + 1, n4 + 4, 5, 4);
                gC.fillRectangle(n3 + 3, n4 + 1, 5, 4);
                gC.drawRectangle(n3 + 1, n4 + 4, 5, 4);
                gC.drawRectangle(n3 + 3, n4 + 1, 5, 4);
                gC.drawLine(n3 + 4, n4 + 2, n3 + 7, n4 + 2);
                gC.drawLine(n3 + 2, n4 + 5, n3 + 5, n4 + 5);
            }
        }
    }

    void drawMinimize(GC gC, Rectangle rectangle, int n2) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n3 = rectangle.x + (rectangle.width - 10) / 2;
        int n4 = rectangle.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (n2 & 0x22) {
            case 0: {
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n3, n4, 9, 3);
                    gC.drawRectangle(n3, n4, 9, 3);
                    break;
                }
                gC.fillRectangle(n3, n4 + 3, 5, 4);
                gC.fillRectangle(n3 + 2, n4, 5, 4);
                gC.drawRectangle(n3, n4 + 3, 5, 4);
                gC.drawRectangle(n3 + 2, n4, 5, 4);
                gC.drawLine(n3 + 3, n4 + 1, n3 + 6, n4 + 1);
                gC.drawLine(n3 + 1, n4 + 4, n3 + 4, n4 + 4);
                break;
            }
            case 32: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n3, n4, 9, 3);
                    gC.drawRectangle(n3, n4, 9, 3);
                    break;
                }
                gC.fillRectangle(n3, n4 + 3, 5, 4);
                gC.fillRectangle(n3 + 2, n4, 5, 4);
                gC.drawRectangle(n3, n4 + 3, 5, 4);
                gC.drawRectangle(n3 + 2, n4, 5, 4);
                gC.drawLine(n3 + 3, n4 + 1, n3 + 6, n4 + 1);
                gC.drawLine(n3 + 1, n4 + 4, n3 + 4, n4 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n3 + 1, n4 + 1, 9, 3);
                    gC.drawRectangle(n3 + 1, n4 + 1, 9, 3);
                    break;
                }
                gC.fillRectangle(n3 + 1, n4 + 4, 5, 4);
                gC.fillRectangle(n3 + 3, n4 + 1, 5, 4);
                gC.drawRectangle(n3 + 1, n4 + 4, 5, 4);
                gC.drawRectangle(n3 + 3, n4 + 1, 5, 4);
                gC.drawLine(n3 + 4, n4 + 2, n3 + 7, n4 + 2);
                gC.drawLine(n3 + 2, n4 + 5, n3 + 5, n4 + 5);
            }
        }
    }

    void drawRightUnselectedBorder(GC gC, Rectangle rectangle, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int[] nArray = null;
        int n7 = n3 + n5 - 1;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : BOTTOM_RIGHT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n8 = 0;
            for (int i2 = 0; i2 < nArray2.length / 2; ++i2) {
                nArray[n8++] = n7 + nArray2[2 * i2];
                nArray[n8++] = n4 + n6 + nArray2[2 * i2 + 1] - 1;
            }
            nArray[n8++] = n7;
            nArray[n8++] = n4 - 1;
        } else {
            int[] nArray3 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : TOP_RIGHT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n9 = 0;
            for (int i3 = 0; i3 < nArray3.length / 2; ++i3) {
                nArray[n9++] = n7 + nArray3[2 * i3];
                nArray[n9++] = n4 + nArray3[2 * i3 + 1];
            }
            nArray[n9++] = n7;
            nArray[n9++] = n4 + n6;
        }
        this.drawBorder(gC, nArray);
    }

    void drawSelected(int n2, GC gC, Rectangle rectangle, int n3) {
        Object object;
        int n4;
        int n5;
        int n6;
        CTabItem cTabItem = this.parent.items[n2];
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        int n9 = rectangle.height;
        int n10 = rectangle.width;
        if (!this.parent.simple && !this.parent.single) {
            n10 -= this.curveWidth - this.curveIndent;
        }
        int n11 = n6 = this.parent.borderVisible ? 1 : 0;
        int n12 = this.parent.onBottom ? n6 : 0;
        int n13 = this.parent.onBottom ? 0 : n6;
        Point point = this.parent.getSize();
        int n14 = Math.min(n7 + n10, this.parent.getRightItemEdge(gC));
        if ((n3 & 8) != 0) {
            int n15 = (this.parent.getStyle() & 0x800000) != 0 ? 1 : 3;
            n5 = n6;
            int n16 = this.parent.onBottom ? point.y - n13 - this.parent.tabHeight - n15 : n12 + this.parent.tabHeight + 1;
            int n17 = point.x - n6 - n11;
            n4 = n15 - 1;
            int[] nArray = new int[]{n5, n16, n5 + n17, n16, n5 + n17, n16 + n4, n5, n16 + n4};
            if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                this.drawBackground(gC, nArray, true);
            } else {
                gC.setBackground(this.parent.selectionBackground);
                gC.fillRectangle(n5, n16, n17, n4);
            }
            if (this.parent.single) {
                if (!cTabItem.showing) {
                    return;
                }
            } else {
                int n18;
                int n19;
                Object object2;
                if (!cTabItem.showing) {
                    int n20 = Math.max(0, n6 - 1);
                    int n21 = this.parent.onBottom ? n8 - 1 : n8 + n9;
                    int n22 = point.x - n11;
                    gC.setForeground(this.parent.getDisplay().getSystemColor(18));
                    gC.drawLine(n20, n21, n22, n21);
                    return;
                }
                nArray = null;
                if (this.parent.onBottom) {
                    object2 = this.parent.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                    object = this.parent.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : this.curve;
                    if (n6 == 0 && n2 == this.parent.firstIndex) {
                        object2 = new int[]{n7, n8 + n9};
                    }
                    nArray = new int[((int[])object2).length + ((Object)object).length + 8];
                    n19 = 0;
                    nArray[n19++] = n7;
                    nArray[n19++] = n8 - 1;
                    nArray[n19++] = n7;
                    nArray[n19++] = n8 - 1;
                    for (n18 = 0; n18 < ((int[])object2).length / 2; ++n18) {
                        nArray[n19++] = n7 + object2[2 * n18];
                        nArray[n19++] = n8 + n9 + object2[2 * n18 + 1] - 1;
                    }
                    for (n18 = 0; n18 < ((Object)object).length / 2; ++n18) {
                        nArray[n19++] = this.parent.simple ? n14 - 1 + object[2 * n18] : n14 - this.curveIndent + object[2 * n18];
                        nArray[n19++] = this.parent.simple ? n8 + n9 + object[2 * n18 + 1] - 1 : n8 + object[2 * n18 + 1] - 2;
                    }
                    nArray[n19++] = this.parent.simple ? n14 - 1 : n14 + this.curveWidth - this.curveIndent;
                    nArray[n19++] = n8 - 1;
                    nArray[n19++] = this.parent.simple ? n14 - 1 : n14 + this.curveWidth - this.curveIndent;
                    nArray[n19++] = n8 - 1;
                } else {
                    object2 = this.parent.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                    object = this.parent.simple ? SIMPLE_TOP_RIGHT_CORNER : this.curve;
                    if (n6 == 0 && n2 == this.parent.firstIndex) {
                        object2 = new int[]{n7, n8};
                    }
                    nArray = new int[((int[])object2).length + ((Object)object).length + 8];
                    n19 = 0;
                    nArray[n19++] = n7;
                    nArray[n19++] = n8 + n9 + 1;
                    nArray[n19++] = n7;
                    nArray[n19++] = n8 + n9 + 1;
                    for (n18 = 0; n18 < ((int[])object2).length / 2; ++n18) {
                        nArray[n19++] = n7 + object2[2 * n18];
                        nArray[n19++] = n8 + object2[2 * n18 + 1];
                    }
                    for (n18 = 0; n18 < ((Object)object).length / 2; ++n18) {
                        nArray[n19++] = this.parent.simple ? n14 - 1 + object[2 * n18] : n14 - this.curveIndent + object[2 * n18];
                        nArray[n19++] = n8 + object[2 * n18 + 1];
                    }
                    nArray[n19++] = this.parent.simple ? n14 - 1 : n14 + this.curveWidth - this.curveIndent;
                    nArray[n19++] = n8 + n9 + 1;
                    nArray[n19++] = this.parent.simple ? n14 - 1 : n14 + this.curveWidth - this.curveIndent;
                    nArray[n19++] = n8 + n9 + 1;
                }
                object2 = gC.getClipping();
                object = cTabItem.getBounds();
                ++((Rectangle)object).height;
                if (this.parent.onBottom) {
                    --((Rectangle)object).y;
                }
                if ((n19 = (int)(((Rectangle)object2).intersects((Rectangle)object) ? 1 : 0)) != 0) {
                    if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                        this.drawBackground(gC, nArray, true);
                    } else {
                        Color color = this.parent.selectionBackground;
                        Image image = this.parent.selectionBgImage;
                        Color[] colorArray = this.parent.selectionGradientColors;
                        int[] nArray2 = this.parent.selectionGradientPercents;
                        boolean bl2 = this.parent.selectionGradientVertical;
                        n5 = n7;
                        n16 = this.parent.onBottom ? n8 - 1 : n8 + 1;
                        n17 = n10;
                        n4 = n9;
                        if (!this.parent.single && !this.parent.simple) {
                            n17 += this.curveWidth - this.curveIndent;
                        }
                        this.drawBackground(gC, nArray, n5, n16, n17, n4, color, image, colorArray, nArray2, bl2);
                    }
                }
                this.drawHighlight(gC, rectangle, n3, n14);
                nArray[0] = Math.max(0, n6 - 1);
                if (n6 == 0 && n2 == this.parent.firstIndex) {
                    nArray[1] = this.parent.onBottom ? n8 + n9 - 1 : n8;
                    nArray[5] = nArray[3] = nArray[1];
                }
                nArray[nArray.length - 2] = point.x - n11 + 1;
                for (int i2 = 0; i2 < nArray.length / 2; ++i2) {
                    if (nArray[2 * i2 + 1] != n8 + n9 + 1) continue;
                    int n23 = 2 * i2 + 1;
                    nArray[n23] = nArray[n23] - 1;
                }
                Color color = this.parent.getDisplay().getSystemColor(18);
                if (!color.equals(this.lastBorderColor)) {
                    this.createAntialiasColors();
                }
                this.antialias(nArray, this.selectedInnerColor, this.selectedOuterColor, gC);
                gC.setForeground(color);
                gC.drawPolyline(nArray);
                if (n19 == 0) {
                    return;
                }
            }
        }
        if ((n3 & 0x10) != 0) {
            Image image;
            Rectangle rectangle2 = this.computeTrim(n2, 0, 0, 0, 0, 0);
            n5 = n7 - rectangle2.x;
            if (this.parent.single && (this.parent.showClose || cTabItem.showClose)) {
                n5 += cTabItem.closeRect.width;
            }
            if ((image = cTabItem.getImage()) != null && !image.isDisposed()) {
                Rectangle rectangle3 = image.getBounds();
                n4 = n14 - n5 - (rectangle2.width + rectangle2.x);
                if (!this.parent.single && cTabItem.closeRect.width > 0) {
                    n4 -= cTabItem.closeRect.width + 4;
                }
                if (rectangle3.width < n4) {
                    int n24 = n5;
                    int n25 = n8 + (n9 - rectangle3.height) / 2;
                    gC.drawImage(image, n24, n25 += this.parent.onBottom ? -1 : 1);
                    n5 += rectangle3.width + 4;
                }
            }
            int n26 = n14 - n5 - (rectangle2.width + rectangle2.x);
            if (!this.parent.single && cTabItem.closeRect.width > 0) {
                n26 -= cTabItem.closeRect.width + 4;
            }
            if (n26 > 0) {
                Font font = gC.getFont();
                gC.setFont(cTabItem.font == null ? this.parent.getFont() : cTabItem.font);
                if (cTabItem.shortenedText == null || cTabItem.shortenedTextWidth != n26) {
                    cTabItem.shortenedText = this.shortenText(gC, cTabItem.getText(), n26);
                    cTabItem.shortenedTextWidth = n26;
                }
                Point point2 = gC.textExtent(cTabItem.shortenedText, 9);
                int n27 = n8 + (n9 - point2.y) / 2;
                int n28 = this.parent.onBottom ? -1 : 1;
                gC.setForeground(this.parent.selectionForeground);
                gC.drawText(cTabItem.shortenedText, n5, n27 += n28, 9);
                gC.setFont(font);
                if (this.parent.isFocusControl()) {
                    object = this.parent.getDisplay();
                    if (this.parent.simple || this.parent.single) {
                        gC.setBackground(((Display)object).getSystemColor(2));
                        gC.setForeground(((Display)object).getSystemColor(1));
                        gC.drawFocus(n5 - 1, n27 - 1, point2.x + 2, point2.y + 2);
                    } else {
                        gC.setForeground(((Display)object).getSystemColor(17));
                        gC.drawLine(n5, n27 + point2.y + 1, n5 + point2.x + 1, n27 + point2.y + 1);
                    }
                }
            }
            if (this.parent.showClose || cTabItem.showClose) {
                this.drawClose(gC, cTabItem.closeRect, cTabItem.closeImageState);
            }
        }
    }

    void drawTabArea(GC gC, Rectangle rectangle, int n2) {
        int n3;
        int n4;
        int[] nArray;
        int[] nArray2;
        int n5;
        int n6;
        Point point = this.parent.getSize();
        int[] nArray3 = null;
        Color color = this.parent.getDisplay().getSystemColor(18);
        int n7 = this.parent.tabHeight;
        int n8 = this.parent.getStyle();
        int n9 = n6 = this.parent.borderVisible ? 1 : 0;
        int n10 = this.parent.onBottom ? n6 : 0;
        int n11 = this.parent.onBottom ? 0 : n6;
        int n12 = this.parent.selectedIndex;
        int n13 = n5 = (n8 & 0x800000) != 0 ? 1 : 3;
        if (n7 == 0) {
            int n14;
            if ((n8 & 0x800000) != 0 && (n8 & 0x800) == 0) {
                return;
            }
            int n15 = n6 - 1;
            int n16 = point.x - n9;
            int n17 = this.parent.onBottom ? point.y - n11 - n5 - 1 : n10 + n5;
            int n18 = n14 = this.parent.onBottom ? point.y - n11 : n10;
            if (n6 <= 0 || this.parent.onBottom) {
                // empty if block
            }
            nArray3 = new int[]{n15, n17, n15, --n14, n16, n14, n16, n17};
            if (n12 != -1 && this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1 && !this.parent.selectionGradientVertical) {
                this.drawBackground(gC, nArray3, true);
            } else if (n12 == -1 && this.parent.gradientColors != null && this.parent.gradientColors.length > 1 && !this.parent.gradientVertical) {
                this.drawBackground(gC, nArray3, false);
            } else {
                gC.setBackground(n12 == -1 ? this.parent.getBackground() : this.parent.selectionBackground);
                gC.fillPolygon(nArray3);
            }
            if (n6 > 0) {
                gC.setForeground(color);
                gC.drawPolyline(nArray3);
            }
            return;
        }
        int n19 = Math.max(0, n6 - 1);
        int n20 = this.parent.onBottom ? point.y - n11 - n7 : n10;
        int n21 = point.x - n6 - n9 + 1;
        int n22 = n7 - 1;
        boolean bl2 = this.parent.simple;
        if (this.parent.onBottom) {
            if ((n8 & 0x800) != 0) {
                nArray2 = bl2 ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                nArray = bl2 ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            } else {
                nArray2 = bl2 ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
                nArray = bl2 ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
            }
            nArray3 = new int[nArray2.length + nArray.length + 4];
            n4 = 0;
            nArray3[n4++] = n19;
            nArray3[n4++] = n20 - n5;
            for (n3 = 0; n3 < nArray2.length / 2; ++n3) {
                nArray3[n4++] = n19 + nArray2[2 * n3];
                nArray3[n4++] = n20 + n22 + nArray2[2 * n3 + 1];
                if (n6 != 0) continue;
                int n23 = n4 - 1;
                nArray3[n23] = nArray3[n23] + 1;
            }
            for (n3 = 0; n3 < nArray.length / 2; ++n3) {
                nArray3[n4++] = n19 + n21 + nArray[2 * n3];
                nArray3[n4++] = n20 + n22 + nArray[2 * n3 + 1];
                if (n6 != 0) continue;
                int n24 = n4 - 1;
                nArray3[n24] = nArray3[n24] + 1;
            }
            nArray3[n4++] = n19 + n21;
            nArray3[n4++] = n20 - n5;
        } else {
            if ((n8 & 0x800) != 0) {
                nArray2 = bl2 ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                nArray = bl2 ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            } else {
                nArray2 = bl2 ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
                nArray = bl2 ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
            }
            nArray3 = new int[nArray2.length + nArray.length + 4];
            n4 = 0;
            nArray3[n4++] = n19;
            nArray3[n4++] = n20 + n22 + n5 + 1;
            for (n3 = 0; n3 < nArray2.length / 2; ++n3) {
                nArray3[n4++] = n19 + nArray2[2 * n3];
                nArray3[n4++] = n20 + nArray2[2 * n3 + 1];
            }
            for (n3 = 0; n3 < nArray.length / 2; ++n3) {
                nArray3[n4++] = n19 + n21 + nArray[2 * n3];
                nArray3[n4++] = n20 + nArray[2 * n3 + 1];
            }
            nArray3[n4++] = n19 + n21;
            nArray3[n4++] = n20 + n22 + n5 + 1;
        }
        boolean bl3 = this.parent.single;
        boolean bl4 = bl3 && n12 != -1;
        this.drawBackground(gC, nArray3, bl4);
        Region region = new Region();
        region.add(new Rectangle(n19, n20, n21 + 1, n22 + 1));
        region.subtract(nArray3);
        gC.setBackground(this.parent.getParent().getBackground());
        this.fillRegion(gC, region);
        region.dispose();
        if (n12 == -1) {
            n3 = n6;
            int n25 = this.parent.onBottom ? point.y - n11 - n7 - 1 : n10 + n7;
            int n26 = point.x - n9;
            gC.setForeground(color);
            gC.drawLine(n3, n25, n26, n25);
        }
        if (n6 > 0) {
            if (!color.equals(this.lastBorderColor)) {
                this.createAntialiasColors();
            }
            this.antialias(nArray3, null, this.tabAreaColor, gC);
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
        }
    }

    void drawUnselected(int n2, GC gC, Rectangle rectangle, int n3) {
        CTabItem cTabItem = this.parent.items[n2];
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.height;
        int n7 = rectangle.width;
        if (!cTabItem.showing) {
            return;
        }
        Rectangle rectangle2 = gC.getClipping();
        if (!rectangle2.intersects(rectangle)) {
            return;
        }
        if ((n3 & 8) != 0) {
            if (n2 > 0 && n2 < this.parent.selectedIndex) {
                this.drawLeftUnselectedBorder(gC, rectangle, n3);
            }
            if (n2 > this.parent.selectedIndex) {
                this.drawRightUnselectedBorder(gC, rectangle, n3);
            }
        }
        if ((n3 & 0x10) != 0) {
            int n8;
            Rectangle rectangle3 = this.computeTrim(n2, 0, 0, 0, 0, 0);
            int n9 = n4 - rectangle3.x;
            Image image = cTabItem.getImage();
            if (image != null && !image.isDisposed() && this.parent.showUnselectedImage) {
                Rectangle rectangle4 = image.getBounds();
                int n10 = n4 + n7 - n9 - (rectangle3.width + rectangle3.x);
                if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                    n10 -= cTabItem.closeRect.width + 4;
                }
                if (rectangle4.width < n10) {
                    int n11 = n9;
                    n8 = rectangle4.height;
                    int n12 = n5 + (n6 - n8) / 2;
                    int n13 = this.parent.onBottom ? -1 : 1;
                    int n14 = rectangle4.width * n8 / rectangle4.height;
                    gC.drawImage(image, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, n11, n12 += n13, n14, n8);
                    n9 += n14 + 4;
                }
            }
            int n15 = n4 + n7 - n9 - (rectangle3.width + rectangle3.x);
            if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                n15 -= cTabItem.closeRect.width + 4;
            }
            if (n15 > 0) {
                Font font = gC.getFont();
                gC.setFont(cTabItem.font == null ? this.parent.getFont() : cTabItem.font);
                if (cTabItem.shortenedText == null || cTabItem.shortenedTextWidth != n15) {
                    cTabItem.shortenedText = this.shortenText(gC, cTabItem.getText(), n15);
                    cTabItem.shortenedTextWidth = n15;
                }
                Point point = gC.textExtent(cTabItem.shortenedText, 9);
                n8 = n5 + (n6 - point.y) / 2;
                int n16 = this.parent.onBottom ? -1 : 1;
                gC.setForeground(this.parent.getForeground());
                gC.drawText(cTabItem.shortenedText, n9, n8 += n16, 9);
                gC.setFont(font);
            }
            if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                this.drawClose(gC, cTabItem.closeRect, cTabItem.closeImageState);
            }
        }
    }

    void fillRegion(GC gC, Region region) {
        Region region2 = new Region();
        gC.getClipping(region2);
        region.intersect(region2);
        gC.setClipping(region);
        gC.fillRectangle(region.getBounds());
        gC.setClipping(region2);
        region2.dispose();
    }

    Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = new Color((Device)this.parent.getDisplay(), CLOSE_FILL);
        }
        return this.fillColor;
    }

    boolean isSelectionHighlightColorsCacheHit(Color color) {
        if (this.selectionHighlightGradientColorsCache == null) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length < 2) {
            return false;
        }
        Color color2 = this.selectionHighlightGradientColorsCache[0];
        Color color3 = this.selectionHighlightGradientColorsCache[this.selectionHighlightGradientColorsCache.length - 1];
        if (!color2.equals(color)) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length != this.parent.tabHeight) {
            return false;
        }
        return color3.equals(this.parent.selectionBackground);
    }

    void setSelectionHighlightGradientColor(Color color) {
        this.selectionHighlightGradientBegin = null;
        if (color == null) {
            return;
        }
        if (this.parent.getDisplay().getDepth() < 15) {
            return;
        }
        if (this.parent.selectionGradientColors.length < 2) {
            return;
        }
        this.selectionHighlightGradientBegin = color;
        if (!this.isSelectionHighlightColorsCacheHit(color)) {
            this.createSelectionHighlightGradientColors(color);
        }
    }

    String shortenText(GC gC, String string, int n2) {
        return this.useEllipses() ? this.shortenText(gC, string, n2, ELLIPSIS) : this.shortenText(gC, string, n2, "");
    }

    String shortenText(GC gC, String string, int n2, String string2) {
        if (gC.textExtent((String)string, (int)9).x <= n2) {
            return string;
        }
        int n3 = gC.textExtent((String)string2, (int)9).x;
        int n4 = string.length();
        TextLayout textLayout = new TextLayout(this.parent.getDisplay());
        textLayout.setText(string);
        int n5 = textLayout.getPreviousOffset(n4, 2);
        while (n5 > 0) {
            string = string.substring(0, n5);
            int n6 = gC.textExtent((String)string, (int)9).x;
            if (n6 + n3 <= n2) break;
            n5 = textLayout.getPreviousOffset(n5, 2);
        }
        textLayout.dispose();
        return n5 == 0 ? string.substring(0, 1) : string + string2;
    }

    void updateCurves() {
        if (this.getClass().getName().equals("org.eclipse.e4.ui.workbench.renderers.swt.CTabRendering")) {
            return;
        }
        int n2 = this.parent.tabHeight;
        if (n2 == this.lastTabHeight) {
            return;
        }
        if (this.parent.onBottom) {
            int n3 = n2 - 12;
            this.curve = new int[]{0, 13 + n3, 0, 12 + n3, 2, 12 + n3, 3, 11 + n3, 5, 11 + n3, 6, 10 + n3, 7, 10 + n3, 9, 8 + n3, 10, 8 + n3, 11, 7 + n3, 11 + n3, 7, 12 + n3, 6, 13 + n3, 6, 15 + n3, 4, 16 + n3, 4, 17 + n3, 3, 19 + n3, 3, 20 + n3, 2, 22 + n3, 2, 23 + n3, 1};
            this.curveWidth = 26 + n3;
            this.curveIndent = this.curveWidth / 3;
        } else {
            int n4 = n2 - 12;
            this.curve = new int[]{0, 0, 0, 1, 2, 1, 3, 2, 5, 2, 6, 3, 7, 3, 9, 5, 10, 5, 11, 6, 11 + n4, 6 + n4, 12 + n4, 7 + n4, 13 + n4, 7 + n4, 15 + n4, 9 + n4, 16 + n4, 9 + n4, 17 + n4, 10 + n4, 19 + n4, 10 + n4, 20 + n4, 11 + n4, 22 + n4, 11 + n4, 23 + n4, 12 + n4};
            this.curveWidth = 26 + n4;
            this.curveIndent = this.curveWidth / 3;
            this.topCurveHighlightStart = new int[]{0, 2, 1, 2, 2, 2, 3, 3, 4, 3, 5, 3, 6, 4, 7, 4, 8, 5, 9, 6, 10, 6};
            this.topCurveHighlightEnd = new int[]{10 + n4, 6 + n4, 11 + n4, 7 + n4, 12 + n4, 8 + n4, 13 + n4, 8 + n4, 14 + n4, 9 + n4, 15 + n4, 10 + n4, 16 + n4, 10 + n4, 17 + n4, 11 + n4, 18 + n4, 11 + n4, 19 + n4, 11 + n4, 20 + n4, 12 + n4, 21 + n4, 12 + n4, 22 + n4, 12 + n4};
        }
    }

    boolean useEllipses() {
        return this.parent.simple;
    }
}

