/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WebBrowser {
    Browser browser;
    Hashtable<Integer, BrowserFunction> functions = new Hashtable();
    AuthenticationListener[] authenticationListeners = new AuthenticationListener[0];
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    boolean jsEnabledOnNextPage = true;
    boolean jsEnabled = true;
    int nextFunctionIndex = 1;
    Object evaluateResult;
    static final String ERROR_ID = "org.eclipse.swt.browser.error";
    static final String EXECUTE_ID = "SWTExecuteTemporaryFunction";
    static Vector<String[]> NativePendingCookies = new Vector();
    static Vector<String[]> MozillaPendingCookies = new Vector();
    static String CookieName;
    static String CookieValue;
    static String CookieUrl;
    static boolean CookieResult;
    static Runnable MozillaClearSessions;
    static Runnable NativeClearSessions;
    static Runnable MozillaGetCookie;
    static Runnable NativeGetCookie;
    static Runnable MozillaSetCookie;
    static Runnable NativeSetCookie;
    static final int[][] KeyTable;

    WebBrowser() {
    }

    public void addAuthenticationListener(AuthenticationListener authenticationListener) {
        AuthenticationListener[] authenticationListenerArray = new AuthenticationListener[this.authenticationListeners.length + 1];
        System.arraycopy(this.authenticationListeners, 0, authenticationListenerArray, 0, this.authenticationListeners.length);
        this.authenticationListeners = authenticationListenerArray;
        this.authenticationListeners[this.authenticationListeners.length - 1] = authenticationListener;
    }

    public void addCloseWindowListener(CloseWindowListener closeWindowListener) {
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = closeWindowListenerArray;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = closeWindowListener;
    }

    public void addLocationListener(LocationListener locationListener) {
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, this.locationListeners.length);
        this.locationListeners = locationListenerArray;
        this.locationListeners[this.locationListeners.length - 1] = locationListener;
    }

    public void addOpenWindowListener(OpenWindowListener openWindowListener) {
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, this.openWindowListeners.length);
        this.openWindowListeners = openWindowListenerArray;
        this.openWindowListeners[this.openWindowListeners.length - 1] = openWindowListener;
    }

    public void addProgressListener(ProgressListener progressListener) {
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, this.progressListeners.length);
        this.progressListeners = progressListenerArray;
        this.progressListeners[this.progressListeners.length - 1] = progressListener;
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, this.statusTextListeners.length);
        this.statusTextListeners = statusTextListenerArray;
        this.statusTextListeners[this.statusTextListeners.length - 1] = statusTextListener;
    }

    public void addTitleListener(TitleListener titleListener) {
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, this.titleListeners.length);
        this.titleListeners = titleListenerArray;
        this.titleListeners[this.titleListeners.length - 1] = titleListener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = visibilityWindowListener;
    }

    public abstract boolean back();

    public static void clearSessions() {
        if (NativeClearSessions != null) {
            NativeClearSessions.run();
        }
        if (MozillaClearSessions != null) {
            MozillaClearSessions.run();
        }
    }

    public static String GetCookie(String string, String string2) {
        CookieName = string;
        CookieUrl = string2;
        CookieValue = null;
        if (NativeGetCookie != null) {
            NativeGetCookie.run();
        }
        if (CookieValue == null && MozillaGetCookie != null) {
            MozillaGetCookie.run();
        }
        String string3 = CookieValue;
        CookieUrl = null;
        CookieValue = null;
        CookieName = null;
        return string3;
    }

    public static boolean SetCookie(String string, String string2, boolean bl2) {
        CookieValue = string;
        CookieUrl = string2;
        CookieResult = false;
        if (NativeSetCookie != null) {
            NativeSetCookie.run();
        } else if (bl2 && NativePendingCookies != null) {
            NativePendingCookies.add(new String[]{string, string2});
        }
        if (MozillaSetCookie != null) {
            MozillaSetCookie.run();
        } else if (bl2 && MozillaPendingCookies != null) {
            MozillaPendingCookies.add(new String[]{string, string2});
        }
        CookieUrl = null;
        CookieValue = null;
        return CookieResult;
    }

    static void SetPendingCookies(Vector<String[]> vector) {
        for (String[] stringArray : vector) {
            WebBrowser.SetCookie(stringArray[0], stringArray[1], false);
        }
    }

    public abstract void create(Composite var1, int var2);

    static String CreateErrorString(String string) {
        return ERROR_ID + string;
    }

    static String ExtractError(String string) {
        return string.substring(ERROR_ID.length());
    }

    public boolean close() {
        return true;
    }

    public void createFunction(BrowserFunction browserFunction) {
        Object object;
        Comparable<Integer> comparable;
        Enumeration<Integer> enumeration = this.functions.keys();
        while (enumeration.hasMoreElements()) {
            comparable = enumeration.nextElement();
            object = this.functions.get(comparable);
            if (!((BrowserFunction)object).name.equals(browserFunction.name)) continue;
            this.deregisterFunction((BrowserFunction)object);
            break;
        }
        browserFunction.index = this.getNextFunctionIndex();
        this.registerFunction(browserFunction);
        comparable = new StringBuffer(browserFunction.name);
        ((StringBuffer)comparable).append(" = function ");
        ((StringBuffer)comparable).append(browserFunction.name);
        ((StringBuffer)comparable).append("() {var result = callJava(");
        ((StringBuffer)comparable).append(browserFunction.index);
        ((StringBuffer)comparable).append(",'");
        ((StringBuffer)comparable).append(browserFunction.token);
        ((StringBuffer)comparable).append("',Array.prototype.slice.call(arguments)); if (typeof result == 'string' && result.indexOf('");
        ((StringBuffer)comparable).append(ERROR_ID);
        ((StringBuffer)comparable).append("') == 0) {var error = new Error(result.substring(");
        ((StringBuffer)comparable).append(ERROR_ID.length());
        ((StringBuffer)comparable).append(")); throw error;} return result;};");
        object = new StringBuffer("if (!window.callJava) {window.callJava = function callJava(index, token, args) {");
        ((StringBuffer)object).append("return external.callJava(index,token,args);}};");
        if (browserFunction.top) {
            ((StringBuffer)object).append(((StringBuffer)comparable).toString());
        }
        ((StringBuffer)object).append("var frameIds = null;");
        if (browserFunction.frameNames != null) {
            ((StringBuffer)object).append("frameIds = {");
            for (int i2 = 0; i2 < browserFunction.frameNames.length; ++i2) {
                ((StringBuffer)object).append('\'');
                ((StringBuffer)object).append(browserFunction.frameNames[i2]);
                ((StringBuffer)object).append("':1,");
            }
            if (browserFunction.frameNames.length > 0) {
                ((StringBuffer)object).deleteCharAt(((StringBuffer)object).length() - 1);
            }
            ((StringBuffer)object).append("};");
        }
        ((StringBuffer)object).append("for (var i = 0; i < frames.length; i++) {try {if (!frameIds || (frames[i].name && frameIds[frames[i].name])) {");
        ((StringBuffer)object).append("if (!frames[i].callJava) {frames[i].callJava = window.callJava;} frames[i].");
        ((StringBuffer)object).append(((StringBuffer)comparable).toString());
        ((StringBuffer)object).append("}} catch(e) {}};");
        browserFunction.functionString = ((StringBuffer)object).toString();
        this.execute(browserFunction.functionString);
    }

    void deregisterFunction(BrowserFunction browserFunction) {
        this.functions.remove(new Integer(browserFunction.index));
    }

    public void destroyFunction(BrowserFunction browserFunction) {
        String string = this.getDeleteFunctionString(browserFunction.name);
        StringBuffer stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {try {frames[i].eval(\"");
        stringBuffer.append(string);
        stringBuffer.append("\");} catch (e) {}}");
        this.execute(stringBuffer.toString());
        this.execute(string);
        this.deregisterFunction(browserFunction);
    }

    public abstract boolean execute(String var1);

    public Object evaluate(String string, boolean bl2) throws SWTException {
        return this.evaluate(string);
    }

    public Object evaluate(String string) throws SWTException {
        int n2;
        EvaluateFunction evaluateFunction = new EvaluateFunction(this.browser, "");
        evaluateFunction.index = n2 = this.getNextFunctionIndex();
        evaluateFunction.isEvaluate = true;
        this.registerFunction(evaluateFunction);
        String string2 = EXECUTE_ID + n2;
        StringBuffer stringBuffer = new StringBuffer("window.");
        stringBuffer.append(string2);
        stringBuffer.append(" = function ");
        stringBuffer.append(string2);
        stringBuffer.append("() {\n");
        stringBuffer.append(string);
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        stringBuffer = new StringBuffer("if (window.");
        stringBuffer.append(string2);
        stringBuffer.append(" == undefined) {window.external.callJava(");
        stringBuffer.append(n2);
        stringBuffer.append(",'");
        stringBuffer.append(evaluateFunction.token);
        stringBuffer.append("', ['");
        stringBuffer.append(ERROR_ID);
        stringBuffer.append("']);} else {try {var result = ");
        stringBuffer.append(string2);
        stringBuffer.append("(); window.external.callJava(");
        stringBuffer.append(n2);
        stringBuffer.append(",'");
        stringBuffer.append(evaluateFunction.token);
        stringBuffer.append("', [result]);} catch (e) {window.external.callJava(");
        stringBuffer.append(n2);
        stringBuffer.append(",'");
        stringBuffer.append(evaluateFunction.token);
        stringBuffer.append("', ['");
        stringBuffer.append(ERROR_ID);
        stringBuffer.append("' + e.message]);}}");
        this.execute(stringBuffer.toString());
        this.execute(this.getDeleteFunctionString(string2));
        this.deregisterFunction(evaluateFunction);
        Object object = this.evaluateResult;
        this.evaluateResult = null;
        if (object instanceof SWTException) {
            throw (SWTException)object;
        }
        return object;
    }

    public abstract boolean forward();

    public abstract String getBrowserType();

    String getDeleteFunctionString(String string) {
        return "delete window." + string;
    }

    int getNextFunctionIndex() {
        return this.nextFunctionIndex++;
    }

    public abstract String getText();

    public abstract String getUrl();

    public Object getWebBrowser() {
        return null;
    }

    public abstract boolean isBackEnabled();

    public boolean isFocusControl() {
        return false;
    }

    public abstract boolean isForwardEnabled();

    public abstract void refresh();

    void registerFunction(BrowserFunction browserFunction) {
        this.functions.put(new Integer(browserFunction.index), browserFunction);
    }

    public void removeAuthenticationListener(AuthenticationListener authenticationListener) {
        if (this.authenticationListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.authenticationListeners.length; ++i2) {
            if (authenticationListener != this.authenticationListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.authenticationListeners.length == 1) {
            this.authenticationListeners = new AuthenticationListener[0];
            return;
        }
        AuthenticationListener[] authenticationListenerArray = new AuthenticationListener[this.authenticationListeners.length - 1];
        System.arraycopy(this.authenticationListeners, 0, authenticationListenerArray, 0, n2);
        System.arraycopy(this.authenticationListeners, n2 + 1, authenticationListenerArray, n2, this.authenticationListeners.length - n2 - 1);
        this.authenticationListeners = authenticationListenerArray;
    }

    public void removeCloseWindowListener(CloseWindowListener closeWindowListener) {
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.closeWindowListeners.length; ++i2) {
            if (closeWindowListener != this.closeWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, n2);
        System.arraycopy(this.closeWindowListeners, n2 + 1, closeWindowListenerArray, n2, this.closeWindowListeners.length - n2 - 1);
        this.closeWindowListeners = closeWindowListenerArray;
    }

    public void removeLocationListener(LocationListener locationListener) {
        if (this.locationListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.locationListeners.length; ++i2) {
            if (locationListener != this.locationListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, n2);
        System.arraycopy(this.locationListeners, n2 + 1, locationListenerArray, n2, this.locationListeners.length - n2 - 1);
        this.locationListeners = locationListenerArray;
    }

    public void removeOpenWindowListener(OpenWindowListener openWindowListener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.openWindowListeners.length; ++i2) {
            if (openWindowListener != this.openWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, n2);
        System.arraycopy(this.openWindowListeners, n2 + 1, openWindowListenerArray, n2, this.openWindowListeners.length - n2 - 1);
        this.openWindowListeners = openWindowListenerArray;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.progressListeners.length; ++i2) {
            if (progressListener != this.progressListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, n2);
        System.arraycopy(this.progressListeners, n2 + 1, progressListenerArray, n2, this.progressListeners.length - n2 - 1);
        this.progressListeners = progressListenerArray;
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.statusTextListeners.length; ++i2) {
            if (statusTextListener != this.statusTextListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, n2);
        System.arraycopy(this.statusTextListeners, n2 + 1, statusTextListenerArray, n2, this.statusTextListeners.length - n2 - 1);
        this.statusTextListeners = statusTextListenerArray;
    }

    public void removeTitleListener(TitleListener titleListener) {
        if (this.titleListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.titleListeners.length; ++i2) {
            if (titleListener != this.titleListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, n2);
        System.arraycopy(this.titleListeners, n2 + 1, titleListenerArray, n2, this.titleListeners.length - n2 - 1);
        this.titleListeners = titleListenerArray;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.visibilityWindowListeners.length; ++i2) {
            if (visibilityWindowListener != this.visibilityWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, n2);
        System.arraycopy(this.visibilityWindowListeners, n2 + 1, visibilityWindowListenerArray, n2, this.visibilityWindowListeners.length - n2 - 1);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
    }

    boolean sendKeyEvent(Event event) {
        int n2 = 0;
        boolean bl2 = true;
        switch (event.keyCode) {
            case 27: {
                n2 = 2;
                bl2 = true;
                break;
            }
            case 13: {
                n2 = 4;
                bl2 = false;
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                n2 = 64;
                bl2 = false;
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                n2 = 32;
                bl2 = false;
                break;
            }
            case 9: {
                n2 = (event.stateMask & 0x20000) != 0 ? 8 : 16;
                bl2 = (event.stateMask & 0x40000) != 0;
                break;
            }
            case 0x1000006: {
                if ((event.stateMask & 0x40000) == 0) break;
                n2 = 512;
                bl2 = true;
                break;
            }
            case 0x1000005: {
                if ((event.stateMask & 0x40000) == 0) break;
                n2 = 256;
                bl2 = true;
                break;
            }
            default: {
                if (!this.translateMnemonics() || event.character == '\u0000' || (event.stateMask & 0x50000) != 65536) break;
                n2 = 128;
                bl2 = true;
            }
        }
        boolean bl3 = true;
        if (n2 != 0) {
            boolean bl4 = event.doit;
            event.doit = bl2;
            bl3 = !this.browser.traverse(n2, event);
            event.doit = bl4;
        }
        if (bl3) {
            this.browser.notifyListeners(event.type, event);
            bl3 = event.doit;
        }
        return bl3;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public abstract boolean setText(String var1, boolean var2);

    public abstract boolean setUrl(String var1, String var2, String[] var3);

    public abstract void stop();

    int translateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][0] != n2) continue;
            return KeyTable[i2][1];
        }
        return 0;
    }

    boolean translateMnemonics() {
        return true;
    }

    static {
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {224, 0x400000}, {65, 97}, {66, 98}, {67, 99}, {68, 100}, {69, 101}, {70, 102}, {71, 103}, {72, 104}, {73, 105}, {74, 106}, {75, 107}, {76, 108}, {77, 109}, {78, 110}, {79, 111}, {80, 112}, {81, 113}, {82, 114}, {83, 115}, {84, 116}, {85, 117}, {86, 118}, {87, 119}, {88, 120}, {89, 121}, {90, 122}, {48, 48}, {49, 49}, {50, 50}, {51, 51}, {52, 52}, {53, 53}, {54, 54}, {55, 55}, {56, 56}, {57, 57}, {32, 32}, {59, 59}, {61, 61}, {188, 44}, {190, 46}, {191, 47}, {219, 91}, {221, 93}, {222, 39}, {192, 96}, {220, 92}, {108, 124}, {37, 0x1000003}, {39, 0x1000004}, {38, 0x1000001}, {40, 0x1000002}, {45, 0x1000009}, {36, 0x1000007}, {35, 0x1000008}, {46, 127}, {33, 0x1000005}, {34, 0x1000006}, {8, 8}, {13, 13}, {9, 9}, {27, 27}, {12, 127}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {127, 0}, {128, 0}, {129, 0}, {130, 0}, {131, 0}, {132, 0}, {133, 0}, {134, 0}, {135, 0}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {14, 0x1000050}, {107, 16777259}, {109, 16777261}, {106, 16777258}, {111, 16777263}, {110, 16777262}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {44, 16777303}, {6, 0x1000051}, {19, 0x1000055}, {3, 16777302}, {186, 59}, {187, 61}, {189, 45}};
    }

    public class EvaluateFunction
    extends BrowserFunction {
        public EvaluateFunction(Browser browser, String string) {
            super(browser, string, true, new String[0], false);
        }

        public Object function(Object[] objectArray) {
            String string;
            if (objectArray[0] instanceof String && (string = (String)objectArray[0]).startsWith(WebBrowser.ERROR_ID)) {
                String string2 = WebBrowser.ExtractError(string);
                WebBrowser.this.evaluateResult = string2.length() > 0 ? new SWTException(50, string2) : new SWTException(50);
                return null;
            }
            WebBrowser.this.evaluateResult = objectArray[0];
            return null;
        }
    }
}

