/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.inputStream = new XPCOMObject(new int[]{2, 0, 0, 0, 1, 3, 4, 1}){

            public long method0(long[] lArray) {
                return InputStream.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return InputStream.this.AddRef();
            }

            public long method2(long[] lArray) {
                return InputStream.this.Release();
            }

            public long method3(long[] lArray) {
                return InputStream.this.Close();
            }

            public long method4(long[] lArray) {
                return InputStream.this.Available(lArray[0]);
            }

            public long method5(long[] lArray) {
                return InputStream.this.Read(lArray[0], (int)lArray[1], lArray[2]);
            }

            public long method6(long[] lArray) {
                return InputStream.this.ReadSegments(lArray[0], lArray[1], (int)lArray[2], lArray[3]);
            }

            public long method7(long[] lArray) {
                return InputStream.this.IsNonBlocking(lArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    long getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l3, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(IIDStore.GetIID(nsIInputStream.class))) {
            XPCOM.memmove(l3, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(l3, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(long l2) {
        int n2;
        int n3 = n2 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (MozillaVersion.CheckVersion(6)) {
            XPCOM.memmove(l2, new long[]{n2}, 8L);
        } else {
            XPCOM.memmove(l2, new int[]{n2}, 4L);
        }
        return 0;
    }

    int Read(long l2, int n2, long l3) {
        int n3 = Math.min(n2, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n3 > 0) {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buffer, this.index, byArray, 0, n3);
            XPCOM.memmove(l2, byArray, (long)n3);
            this.index += n3;
        }
        XPCOM.memmove(l3, new int[]{n3}, 4L);
        return 0;
    }

    int ReadSegments(long l2, long l3, int n2, long l4) {
        int n3;
        int[] nArray;
        int n4;
        int n5 = n4 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (n2 != -1) {
            n4 = Math.min(n4, n2);
        }
        for (n3 = n4; n3 > 0; n3 -= nArray[0]) {
            nArray = new int[1];
            long l5 = XPCOM.Call(l2, this.getAddress(), l3, this.buffer, this.index, n3, nArray);
            if (l5 != 0L) break;
            this.index += nArray[0];
        }
        XPCOM.memmove(l4, new int[]{n4 - n3}, 4L);
        return 0;
    }

    int IsNonBlocking(long l2) {
        XPCOM.memmove(l2, new boolean[]{false});
        return 0;
    }
}

