/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String cacheParentPath;
    String[] pluginDirs;
    boolean isXULRunner;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String MOZILLA_PLUGIN_PATH = "MOZ_PLUGIN_PATH";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";
    static boolean IsSparc;

    AppFileLocProvider(String string, String string2, String string3, boolean bl2) {
        this.mozillaPath = string + SEPARATOR_OS;
        this.profilePath = string2 + SEPARATOR_OS;
        this.cacheParentPath = string3;
        this.isXULRunner = bl2;
        if (!Compatibility.fileExists(string2, "")) {
            long[] lArray = new long[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, lArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(lArray[0]);
            n2 = nsILocalFile2.Create(1, 448);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            nsILocalFile2.Release();
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }
        };
        this.directoryServiceProvider = new XPCOMObject(new int[]{2, 0, 0, 3}){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }
        };
        this.directoryServiceProvider2 = new XPCOMObject(new int[]{2, 0, 0, 3, 2}){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return AppFileLocProvider.this.getFiles(lArray[0], lArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    long getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int QueryInterface(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l3, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(l3, new long[]{this.directoryServiceProvider.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(l3, new long[]{this.directoryServiceProvider2.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(l3, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(long l2, long l3) {
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3 = XPCOM.strlen(l2);
        byte[] byArray = new byte[n3];
        XPCOM.memmove(byArray, l2, (long)n3);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n4 = 0;
                long l4 = C.getenv(MozillaDelegate.wcsToMbcs(null, MOZILLA_PLUGIN_PATH, true));
                if (l4 != 0L) {
                    n2 = C.strlen(l4);
                    object3 = new byte[n2];
                    C.memmove((byte[])object3, l4, (long)n2);
                    String string2 = new String(MozillaDelegate.mbcsToWcs(null, (byte[])object3));
                    if (string2.length() > 0) {
                        object2 = System.getProperty("path.separator");
                        object = new ArrayList<String>();
                        int n5 = -1;
                        do {
                            int n6;
                            String string3;
                            if ((string3 = (n5 = string2.indexOf((String)object2, n6 = n5 + 1)) == -1 ? string2.substring(n6) : string2.substring(n6, n5)).length() <= 0) continue;
                            object.add(string3);
                        } while (n5 != -1);
                        int n7 = object.size();
                        this.pluginDirs = new String[n7 + (IsSparc ? 1 : 2)];
                        for (n4 = 0; n4 < n7; ++n4) {
                            this.pluginDirs[n4] = (String)object.get(n4);
                        }
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[IsSparc ? 1 : 2];
                }
                if (!IsSparc) {
                    this.pluginDirs[n4++] = this.mozillaPath + PLUGINS_DIR;
                }
                this.pluginDirs[n4++] = System.getProperty("user.home") + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(l3, new long[]{0L}, (long)C.PTR_SIZEOF);
        if (stringArray != null) {
            long[] lArray = new long[1];
            nsISupports[] nsISupportsArray2 = new nsISupports[stringArray.length];
            int n8 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object3 = new nsEmbedString(stringArray[n2]);
                int n9 = XPCOM.NS_NewLocalFile(((nsEmbedString)object3).getAddress(), 1, lArray);
                if (n9 != -2142109695) {
                    if (n9 != 0) {
                        Mozilla.error(n9);
                    }
                    if (lArray[0] == 0L) {
                        Mozilla.error(-2147467261);
                    }
                    object2 = new nsILocalFile(lArray[0]);
                    lArray[0] = 0L;
                    n9 = ((nsISupports)object2).QueryInterface(IIDStore.GetIID(nsIFile.class), lArray);
                    if (n9 != 0) {
                        Mozilla.error(n9);
                    }
                    if (lArray[0] == 0L) {
                        Mozilla.error(-2147467262);
                    }
                    ((nsISupports)object2).Release();
                    object = new nsIFile(lArray[0]);
                    nsISupportsArray2[n8++] = object;
                }
                ((nsEmbedString)object3).dispose();
                lArray[0] = 0L;
            }
            if (n8 < stringArray.length) {
                nsISupports[] nsISupportsArray3 = new nsISupports[n8];
                System.arraycopy(nsISupportsArray2, 0, nsISupportsArray3, 0, n8);
                nsISupportsArray2 = nsISupportsArray3;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray2);
            simpleEnumerator.AddRef();
            XPCOM.memmove(l3, new long[]{simpleEnumerator.getAddress()}, (long)C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(long l2, long l3, long l4) {
        int n2 = XPCOM.strlen(l2);
        byte[] byArray = new byte[n2];
        XPCOM.memmove(byArray, l2, (long)n2);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = this.profilePath + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = this.profilePath + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = this.profilePath + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = this.profilePath + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = this.profilePath + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.cacheParentPath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.mozillaPath + COMPONENTS_DIR : this.profilePath + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.profilePath + COMPONENTS_DIR : this.mozillaPath + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.profilePath : this.mozillaPath;
        } else if (string.equals("PrfDef") && this.isXULRunner) {
            string2 = this.profilePath;
        }
        XPCOM.memmove(l3, new boolean[]{true});
        XPCOM.memmove(l4, new long[]{0L}, (long)C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            long[] lArray = new long[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n3 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, lArray);
            if (n3 != 0) {
                Mozilla.error(n3);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(lArray[0]);
            lArray[0] = 0L;
            n3 = nsILocalFile2.QueryInterface(IIDStore.GetIID(nsIFile.class), lArray);
            if (n3 != 0) {
                Mozilla.error(n3);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467262);
            }
            XPCOM.memmove(l4, new long[]{lArray[0]}, (long)C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }
}

