/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableColumn;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableHeader;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTableRow;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

class TableAccessibleDelegate {
    Map childColumnToIdMap = new HashMap();
    Map childRowToIdMap = new HashMap();
    Accessible tableAccessible;
    AccessibleTableHeader headerAccessible;

    public TableAccessibleDelegate(Accessible accessible) {
        this.tableAccessible = accessible;
        this.tableAccessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = TableAccessibleDelegate.this.childColumnToIdMap.size() + TableAccessibleDelegate.this.childRowToIdMap.size();
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    ++accessibleControlEvent.detail;
                }
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n2 = TableAccessibleDelegate.this.childColumnToIdMap.size() + TableAccessibleDelegate.this.childRowToIdMap.size();
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    ++n2;
                }
                Accessible[] accessibleArray = new Accessible[n2];
                int n3 = 0;
                for (Accessible accessible : TableAccessibleDelegate.this.childRowToIdMap.values()) {
                    accessibleArray[n3++] = accessible;
                }
                for (Accessible accessible : TableAccessibleDelegate.this.childColumnToIdMap.values()) {
                    accessibleArray[n3++] = accessible;
                }
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    accessibleArray[n3] = TableAccessibleDelegate.this.headerAccessible();
                }
                accessibleControlEvent.children = accessibleArray;
            }

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                NSPoint nSPoint = new NSPoint();
                nSPoint.x = accessibleControlEvent.x;
                Monitor monitor = Display.getCurrent().getPrimaryMonitor();
                nSPoint.y = monitor.getBounds().height - accessibleControlEvent.y;
                for (AccessibleTableRow accessibleTableRow : TableAccessibleDelegate.this.childRowToIdMap.values()) {
                    NSValue nSValue = new NSValue(accessibleTableRow.getPositionAttribute((int)-1).id);
                    NSPoint nSPoint2 = nSValue.pointValue();
                    NSValue nSValue2 = new NSValue(accessibleTableRow.getSizeAttribute(-1));
                    NSSize nSSize = nSValue2.sizeValue();
                    if (!(nSPoint2.y < nSPoint.y) || !(nSPoint.y < nSPoint2.y + nSSize.height)) continue;
                    AccessibleControlEvent accessibleControlEvent2 = new AccessibleControlEvent(accessibleControlEvent.getSource());
                    accessibleControlEvent2.x = (int)nSPoint.x;
                    accessibleControlEvent2.y = (int)nSPoint.y;
                    accessibleTableRow.getChildAtPoint(accessibleControlEvent);
                    break;
                }
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                NSNumber nSNumber;
                int n2 = 0x300000;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                for (int i2 = 0; i2 < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size(); ++i2) {
                    AccessibleTableListener accessibleTableListener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i2);
                    accessibleTableListener.getSelectedRows(accessibleTableEvent);
                }
                if (accessibleTableEvent.selected != null) {
                    int[] nArray = accessibleTableEvent.selected;
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        if (nArray[i3] != TableAccessibleDelegate.this.tableAccessible.index) continue;
                        n2 |= 2;
                        break;
                    }
                }
                if ((nSNumber = (NSNumber)TableAccessibleDelegate.this.tableAccessible.getFocusedAttribute(-1)).boolValue()) {
                    n2 |= 4;
                }
                accessibleControlEvent.detail = n2;
            }
        });
        this.tableAccessible.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void getColumnCount(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                for (int i2 = 0; i2 < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size(); ++i2) {
                    AccessibleTableListener accessibleTableListener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i2);
                    if (accessibleTableListener == this) continue;
                    accessibleTableListener.getColumnCount(accessibleTableEvent2);
                }
                accessibleTableEvent.count = accessibleTableEvent2.count;
            }

            public void getColumn(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                this.getColumns(accessibleTableEvent2);
                accessibleTableEvent.accessible = accessibleTableEvent2.accessibles[accessibleTableEvent.column];
            }

            public void getColumns(AccessibleTableEvent accessibleTableEvent) {
                int n2;
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                this.getColumnCount(accessibleTableEvent2);
                if (accessibleTableEvent2.count != TableAccessibleDelegate.this.childColumnToIdMap.size()) {
                    TableAccessibleDelegate.this.childColumnToIdMap.clear();
                }
                Accessible[] accessibleArray = new Accessible[accessibleTableEvent2.count];
                for (n2 = 0; n2 < accessibleTableEvent2.count; ++n2) {
                    accessibleArray[n2] = TableAccessibleDelegate.this.childColumnToOs(n2);
                }
                n2 = TableAccessibleDelegate.this.childColumnToIdMap.size() > 0 ? TableAccessibleDelegate.this.childColumnToIdMap.size() : 1;
                Accessible[] accessibleArray2 = new Accessible[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    accessibleArray2[i2] = (Accessible)TableAccessibleDelegate.this.childColumnToIdMap.get(new Integer(i2));
                }
                accessibleTableEvent.accessibles = accessibleArray2;
            }

            public void getColumnHeader(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.accessible = TableAccessibleDelegate.this.childColumnToIdMap.size() > 1 ? TableAccessibleDelegate.this.headerAccessible() : null;
            }

            public void getRowCount(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                for (int i2 = 0; i2 < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size(); ++i2) {
                    AccessibleTableListener accessibleTableListener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i2);
                    if (accessibleTableListener == this) continue;
                    accessibleTableListener.getRowCount(accessibleTableEvent2);
                }
                accessibleTableEvent.count = accessibleTableEvent2.count;
            }

            public void getRow(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                this.getRows(accessibleTableEvent2);
                accessibleTableEvent.accessible = accessibleTableEvent2.accessibles[accessibleTableEvent.row];
            }

            public void getRows(AccessibleTableEvent accessibleTableEvent) {
                int n2;
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                this.getRowCount(accessibleTableEvent2);
                if (accessibleTableEvent2.count != TableAccessibleDelegate.this.childRowToIdMap.size()) {
                    TableAccessibleDelegate.this.childRowToIdMap.clear();
                }
                Accessible[] accessibleArray = new Accessible[accessibleTableEvent2.count];
                for (n2 = 0; n2 < accessibleTableEvent2.count; ++n2) {
                    accessibleArray[n2] = TableAccessibleDelegate.this.childRowToOs(n2);
                }
                n2 = TableAccessibleDelegate.this.childRowToIdMap.size() > 0 ? TableAccessibleDelegate.this.childRowToIdMap.size() : 1;
                Accessible[] accessibleArray2 = new Accessible[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    accessibleArray2[i2] = (Accessible)TableAccessibleDelegate.this.childRowToIdMap.get(new Integer(i2));
                }
                accessibleTableEvent.accessibles = accessibleArray2;
            }
        });
    }

    Accessible childColumnToOs(int n2) {
        if (n2 == -1) {
            return this.tableAccessible;
        }
        AccessibleTableColumn accessibleTableColumn = (AccessibleTableColumn)this.childColumnToIdMap.get(new Integer(n2));
        if (accessibleTableColumn == null) {
            accessibleTableColumn = new AccessibleTableColumn(this.tableAccessible, n2);
            this.childColumnToIdMap.put(new Integer(n2), accessibleTableColumn);
        }
        return accessibleTableColumn;
    }

    Accessible childRowToOs(int n2) {
        if (n2 == -1) {
            return this.tableAccessible;
        }
        AccessibleTableRow accessibleTableRow = (AccessibleTableRow)this.childRowToIdMap.get(new Integer(n2));
        if (accessibleTableRow == null) {
            accessibleTableRow = new AccessibleTableRow(this.tableAccessible, n2);
            this.childRowToIdMap.put(new Integer(n2), accessibleTableRow);
        }
        return accessibleTableRow;
    }

    AccessibleTableHeader headerAccessible() {
        if (this.headerAccessible == null) {
            this.headerAccessible = new AccessibleTableHeader(this.tableAccessible, -1);
        }
        return this.headerAccessible;
    }

    void release() {
        SWTAccessibleDelegate sWTAccessibleDelegate;
        Iterator iterator;
        Collection collection;
        if (this.childRowToIdMap != null) {
            collection = this.childRowToIdMap.values();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                sWTAccessibleDelegate = ((Accessible)iterator.next()).delegate;
                if (sWTAccessibleDelegate == null) continue;
                sWTAccessibleDelegate.internal_dispose_SWTAccessibleDelegate();
                sWTAccessibleDelegate.release();
            }
            this.childRowToIdMap.clear();
            this.childRowToIdMap = null;
        }
        if (this.childColumnToIdMap != null) {
            collection = this.childColumnToIdMap.values();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                sWTAccessibleDelegate = ((Accessible)iterator.next()).delegate;
                if (sWTAccessibleDelegate == null) continue;
                sWTAccessibleDelegate.internal_dispose_SWTAccessibleDelegate();
                sWTAccessibleDelegate.release();
            }
            this.childColumnToIdMap.clear();
            this.childColumnToIdMap = null;
        }
    }

    void reset() {
        this.release();
        this.childColumnToIdMap = new HashMap();
        this.childRowToIdMap = new HashMap();
    }
}

