/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.id;

class Relation {
    Accessible accessible;
    Accessible[] targets;
    int type;

    Relation(Accessible accessible, int n2) {
        this.accessible = accessible;
        this.type = n2;
        this.targets = new Accessible[0];
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != accessible) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] == accessible) continue;
            accessibleArray[n2++] = this.targets[i2];
        }
        this.targets = accessibleArray;
    }

    id getTitleUIElement() {
        id id2 = null;
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            Accessible accessible = this.targets[i2];
            id2 = accessible.accessibleHandle(accessible);
        }
        return id2;
    }

    id getServesAsTitleForUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            Accessible accessible = this.targets[i2];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
        }
        return nSMutableArray;
    }

    id getLinkedUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            Accessible accessible = this.targets[i2];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
        }
        return nSMutableArray;
    }
}

