/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableRow
extends Accessible {
    public AccessibleTableRow(Accessible accessible, int n2) {
        super(accessible);
        this.index = n2;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n2 = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Object[] objectArray = new Object[n2];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                for (int i2 = 0; i2 < n2; ++i2) {
                    accessibleTableEvent.column = i2;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    for (int i3 = 0; i3 < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i3) {
                        AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i3);
                        accessibleTableListener.getCell(accessibleTableEvent);
                    }
                    if (accessibleTableEvent.accessible != null) {
                        accessibleTableEvent.accessible.parent = AccessibleTableRow.this;
                    }
                    objectArray[i2] = accessibleTableEvent.accessible;
                }
                accessibleControlEvent.children = objectArray;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Object object;
                NSObject nSObject;
                int n2 = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Accessible[] accessibleArray = new Accessible[n2];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                for (int i2 = 0; i2 < n2; ++i2) {
                    accessibleTableEvent.column = i2;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    for (int i3 = 0; i3 < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i3) {
                        AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i3);
                        accessibleTableListener.getCell(accessibleTableEvent);
                    }
                    accessibleArray[i2] = accessibleTableEvent.accessible;
                }
                NSValue nSValue = (NSValue)accessibleArray[0].getPositionAttribute(-1);
                NSPoint nSPoint = nSValue.pointValue();
                int n3 = 0;
                int n4 = 0;
                for (int i4 = 0; i4 < accessibleArray.length; ++i4) {
                    nSObject = (NSValue)accessibleArray[i4].getSizeAttribute(-1);
                    object = ((NSValue)nSObject).sizeValue();
                    if (((NSSize)object).height > (double)n3) {
                        n3 = (int)((NSSize)object).height;
                    }
                    n4 = (int)((double)n4 + ((NSSize)object).width);
                }
                accessibleControlEvent.x = (int)nSPoint.x;
                NSArray nSArray = NSScreen.screens();
                nSObject = new NSScreen(nSArray.objectAtIndex(0L));
                object = ((NSScreen)nSObject).frame();
                accessibleControlEvent.y = (int)(((NSRect)object).height - nSPoint.y - (double)n3);
                accessibleControlEvent.width = n4;
                accessibleControlEvent.height = n3;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n2 = accessibleControlEvent.childID;
                accessibleControlEvent.detail = n2 == -1 ? 28 : 29;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                NSNumber nSNumber;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                accessibleTableEvent.column = 0;
                accessibleTableEvent.row = AccessibleTableRow.this.index;
                for (int i2 = 0; i2 < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i2) {
                    AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i2);
                    accessibleTableListener.getCell(accessibleTableEvent);
                }
                accessibleControlEvent.childID = accessibleTableEvent.accessible != null ? ((nSNumber = (NSNumber)accessibleTableEvent.accessible.getFocusedAttribute(-1)).boolValue() ? -1 : -2) : -2;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void isColumnSelected(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.isSelected = false;
            }

            public void isRowSelected(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                accessibleTableEvent2.row = accessibleTableEvent.row;
                for (int i2 = 0; i2 < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i2) {
                    AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i2);
                    accessibleTableListener.isRowSelected(accessibleTableEvent2);
                }
                accessibleTableEvent.isSelected = accessibleTableEvent2.isSelected;
            }
        });
    }

    void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
        Object object;
        int n2;
        int n3 = Math.max(1, this.parent.getColumnCount());
        Accessible[] accessibleArray = new Accessible[n3];
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n2 = 0; n2 < n3; ++n2) {
            accessibleTableEvent.column = n2;
            accessibleTableEvent.row = this.index;
            for (int i2 = 0; i2 < this.parent.accessibleTableListeners.size(); ++i2) {
                object = this.parent.accessibleTableListeners.get(i2);
                object.getCell(accessibleTableEvent);
            }
            accessibleArray[n2] = accessibleTableEvent.accessible;
        }
        for (n2 = 0; n2 < accessibleArray.length; ++n2) {
            NSValue nSValue = (NSValue)accessibleArray[n2].getPositionAttribute(this.index);
            object = nSValue.pointValue();
            NSValue nSValue2 = (NSValue)accessibleArray[n2].getSizeAttribute(this.index);
            NSSize nSSize = nSValue2.sizeValue();
            if (!(((NSPoint)object).x <= (double)accessibleControlEvent.x) || !((double)accessibleControlEvent.x <= ((NSPoint)object).x + nSSize.width)) continue;
            accessibleArray[n2].parent = this;
            accessibleControlEvent.accessible = accessibleArray[n2];
            break;
        }
    }
}

