/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.accessibility.Relation;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.accessibility.TableAccessibleDelegate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Accessible {
    static boolean DEBUG = false;
    static final int MAX_RELATION_TYPES = 15;
    static NSString[] baseAttributes = new NSString[]{OS.NSAccessibilityRoleAttribute, OS.NSAccessibilitySubroleAttribute, OS.NSAccessibilityRoleDescriptionAttribute, OS.NSAccessibilityHelpAttribute, OS.NSAccessibilityFocusedAttribute, OS.NSAccessibilityParentAttribute, OS.NSAccessibilityChildrenAttribute, OS.NSAccessibilityPositionAttribute, OS.NSAccessibilitySizeAttribute, OS.NSAccessibilityWindowAttribute, OS.NSAccessibilityTopLevelUIElementAttribute};
    NSMutableArray attributeNames = null;
    NSMutableArray parameterizedAttributeNames = null;
    NSMutableArray actionNames = null;
    Vector<AccessibleListener> accessibleListeners;
    Vector<AccessibleControlListener> accessibleControlListeners;
    Vector<AccessibleTextListener> accessibleTextListeners;
    Vector<AccessibleActionListener> accessibleActionListeners;
    Vector<AccessibleEditableTextListener> accessibleEditableTextListeners;
    Vector<AccessibleHyperlinkListener> accessibleHyperlinkListeners;
    Vector<AccessibleTableListener> accessibleTableListeners;
    Vector<AccessibleTableCellListener> accessibleTableCellListeners;
    Vector<AccessibleTextExtendedListener> accessibleTextExtendedListeners;
    Vector<AccessibleValueListener> accessibleValueListeners;
    Vector<AccessibleAttributeListener> accessibleAttributeListeners;
    Relation[] relations = new Relation[15];
    Accessible parent;
    Control control;
    int currentRole = -1;
    Map childToIdMap = new HashMap();
    SWTAccessibleDelegate delegate;
    int index = -1;
    TableAccessibleDelegate tableDelegate;

    public Accessible(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        this.parent = accessible;
        this.control = accessible.control;
        this.delegate = new SWTAccessibleDelegate(this, -1);
    }

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    id accessibleHandle(Accessible accessible) {
        if (accessible.delegate != null) {
            return accessible.delegate;
        }
        if (accessible.control != null) {
            NSView nSView = accessible.control.view;
            long l2 = OS.objc_msgSend(nSView.id, OS.sel_accessibleHandle);
            return new id(l2);
        }
        return null;
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new Vector();
        }
        this.accessibleListeners.add(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new Vector();
        }
        this.accessibleControlListeners.add(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new Vector();
            }
            this.accessibleTextExtendedListeners.add((AccessibleTextExtendedListener)accessibleTextListener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new Vector();
            }
            this.accessibleTextListeners.add(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new Vector();
        }
        this.accessibleActionListeners.add(accessibleActionListener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new Vector();
        }
        this.accessibleEditableTextListeners.add(accessibleEditableTextListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new Vector();
        }
        this.accessibleHyperlinkListeners.add(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new Vector();
        }
        this.accessibleTableListeners.add(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new Vector();
        }
        this.accessibleTableCellListeners.add(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new Vector();
        }
        this.accessibleValueListeners.add(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new Vector();
        }
        this.accessibleAttributeListeners.add(accessibleAttributeListener);
    }

    void addCGColor(double[] dArray, NSMutableAttributedString nSMutableAttributedString, NSString nSString, NSRange nSRange) {
        long l2 = OS.CGColorSpaceCreateDeviceRGB();
        long l3 = OS.CGColorCreate(l2, dArray);
        OS.CGColorSpaceRelease(l2);
        nSMutableAttributedString.addAttribute(nSString, new id(l3), nSRange);
        OS.CGColorRelease(l3);
    }

    public void addRelation(int n2, Accessible accessible) {
        this.checkWidget();
        if (this.relations[n2] == null) {
            this.relations[n2] = new Relation(this, n2);
        }
        this.relations[n2].addTarget(accessible);
    }

    int accessibleListenersSize() {
        return this.accessibleListeners == null ? 0 : this.accessibleListeners.size();
    }

    int accessibleControlListenersSize() {
        return this.accessibleControlListeners == null ? 0 : this.accessibleControlListeners.size();
    }

    int accessibleValueListenersSize() {
        return this.accessibleValueListeners == null ? 0 : this.accessibleValueListeners.size();
    }

    int accessibleTextExtendedListenersSize() {
        return this.accessibleTextExtendedListeners == null ? 0 : this.accessibleTextExtendedListeners.size();
    }

    int accessibleTextListenersSize() {
        return this.accessibleTextListeners == null ? 0 : this.accessibleTextListeners.size();
    }

    int accessibleTableCellListenersSize() {
        return this.accessibleTableCellListeners == null ? 0 : this.accessibleTableCellListeners.size();
    }

    int accessibleTableListenersSize() {
        return this.accessibleTableListeners == null ? 0 : this.accessibleTableListeners.size();
    }

    int accessibleHyperlinkListenersSize() {
        return this.accessibleHyperlinkListeners == null ? 0 : this.accessibleHyperlinkListeners.size();
    }

    int accessibleEditableTextListenersSize() {
        return this.accessibleEditableTextListeners == null ? 0 : this.accessibleEditableTextListeners.size();
    }

    int accessibleAttributeListenersSize() {
        return this.accessibleAttributeListeners == null ? 0 : this.accessibleAttributeListeners.size();
    }

    int accessibleActionListenersSize() {
        return this.accessibleActionListeners == null ? 0 : this.accessibleActionListeners.size();
    }

    void checkRole(int n2) {
        if (n2 != this.currentRole) {
            this.currentRole = n2;
            if (this.attributeNames != null) {
                this.attributeNames.release();
                this.attributeNames = null;
            }
            if (this.parameterizedAttributeNames != null) {
                this.parameterizedAttributeNames.release();
                this.parameterizedAttributeNames = null;
            }
            if (this.actionNames != null) {
                this.actionNames.release();
                this.actionNames = null;
            }
        }
    }

    void createTableDelegate() {
        if (this.tableDelegate == null) {
            this.tableDelegate = new TableAccessibleDelegate(this);
        }
    }

    id getColumnIndexRangeAttribute(int n2) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableCellListenersSize(); ++i2) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i2);
            accessibleTableCellListener.getColumnIndex(accessibleTableCellEvent);
            accessibleTableCellListener.getColumnSpan(accessibleTableCellEvent);
        }
        NSRange nSRange = new NSRange();
        nSRange.location = accessibleTableCellEvent.index;
        nSRange.length = accessibleTableCellEvent.count;
        return NSValue.valueWithRange(nSRange);
    }

    id getRowIndexRangeAttribute(int n2) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableCellListenersSize(); ++i2) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i2);
            accessibleTableCellListener.getRowIndex(accessibleTableCellEvent);
            accessibleTableCellListener.getRowSpan(accessibleTableCellEvent);
        }
        NSRange nSRange = new NSRange();
        nSRange.location = accessibleTableCellEvent.index;
        nSRange.length = accessibleTableCellEvent.count;
        return NSValue.valueWithRange(nSRange);
    }

    id getSelectedAttribute(int n2) {
        if (this.accessibleTableListenersSize() > 0) {
            AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
            accessibleTableEvent.row = this.index;
            for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
                AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i2);
                if (this.currentRole == 28) {
                    accessibleTableListener.isRowSelected(accessibleTableEvent);
                    continue;
                }
                accessibleTableListener.isColumnSelected(accessibleTableEvent);
            }
            return NSNumber.numberWithBool(accessibleTableEvent.isSelected);
        }
        return NSNumber.numberWithBool(false);
    }

    id getIndexAttribute(int n2) {
        return NSNumber.numberWithInt(this.index);
    }

    id getHeaderAttribute(int n2) {
        SWTAccessibleDelegate sWTAccessibleDelegate = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i2);
            accessibleTableListener.getColumnHeader(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessible != null) {
            sWTAccessibleDelegate = accessibleTableEvent.accessible.delegate;
        }
        return sWTAccessibleDelegate;
    }

    id getVisibleColumnsAttribute(int n2) {
        Accessible[] accessibleArray;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray nSMutableArray = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            accessibleArray = this.accessibleTableListeners.get(i2);
            accessibleArray.getVisibleColumns(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessibles != null) {
            NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
            accessibleArray = accessibleTableEvent.accessibles;
            for (int i3 = 0; i3 < accessibleArray.length; ++i3) {
                Accessible accessible = accessibleArray[i3];
                nSMutableArray2.addObject(accessible.delegate);
            }
            nSMutableArray = nSMutableArray2;
        }
        return nSMutableArray == null ? NSArray.array() : nSMutableArray;
    }

    id getVisibleRowsAttribute(int n2) {
        Accessible[] accessibleArray;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray nSMutableArray = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            accessibleArray = this.accessibleTableListeners.get(i2);
            accessibleArray.getVisibleRows(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessibles != null) {
            NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
            accessibleArray = accessibleTableEvent.accessibles;
            for (int i3 = 0; i3 < accessibleArray.length; ++i3) {
                Accessible accessible = accessibleArray[i3];
                nSMutableArray2.addObject(accessible.delegate);
            }
            nSMutableArray = nSMutableArray2;
        }
        return nSMutableArray == null ? NSArray.array() : nSMutableArray;
    }

    id getSelectedRowsAttribute(int n2) {
        Object object;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        Object object2 = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            object = this.accessibleTableListeners.get(i2);
            object.getSelectedRows(accessibleTableEvent);
        }
        if (accessibleTableEvent.selected != null) {
            int[] nArray = accessibleTableEvent.selected;
            object = NSMutableArray.arrayWithCapacity(nArray.length);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                accessibleTableEvent.row = nArray[i3];
                for (int i4 = 0; i4 < this.accessibleTableListenersSize(); ++i4) {
                    AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i4);
                    accessibleTableListener.getRow(accessibleTableEvent);
                }
                if (accessibleTableEvent.accessible == null) continue;
                ((NSMutableArray)object).addObject(accessibleTableEvent.accessible.delegate);
            }
            object2 = object;
        }
        return object2 == null ? NSArray.array() : object2;
    }

    int getRowCount() {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i2);
            accessibleTableListener.getRowCount(accessibleTableEvent);
        }
        return accessibleTableEvent.count;
    }

    id getRowsAttribute(int n2) {
        Object object;
        int n3;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n3 = 0; n3 < this.accessibleTableListenersSize(); ++n3) {
            object = this.accessibleTableListeners.get(n3);
            object.getRowCount(accessibleTableEvent);
            object.getRows(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessibles == null) {
            accessibleTableEvent.accessibles = new Accessible[0];
        }
        if (accessibleTableEvent.count != accessibleTableEvent.accessibles.length) {
            this.createTableDelegate();
            for (n3 = 0; n3 < this.accessibleTableListenersSize(); ++n3) {
                object = this.accessibleTableListeners.get(n3);
                object.getRowCount(accessibleTableEvent);
                object.getRows(accessibleTableEvent);
            }
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
        object = accessibleTableEvent.accessibles;
        int n4 = 0;
        while (n4 < ((Accessible[])object).length) {
            Accessible accessible = (Accessible)object[n4];
            accessible.index = n4++;
            nSMutableArray.addObject(accessible.delegate);
        }
        return nSMutableArray;
    }

    id getSelectedColumnsAttribute(int n2) {
        Object object;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        Object object2 = null;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            object = this.accessibleTableListeners.get(i2);
            object.getSelectedColumns(accessibleTableEvent);
        }
        if (accessibleTableEvent.selected != null) {
            int[] nArray = accessibleTableEvent.selected;
            object = NSMutableArray.arrayWithCapacity(nArray.length);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                accessibleTableEvent.column = nArray[i3];
                for (int i4 = 0; i4 < this.accessibleTableListenersSize(); ++i4) {
                    AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i4);
                    accessibleTableListener.getColumn(accessibleTableEvent);
                }
                if (accessibleTableEvent.accessible == null) continue;
                ((NSMutableArray)object).addObject(accessibleTableEvent.accessible.delegate);
            }
            object2 = object;
        }
        return object2 == null ? NSArray.array() : object2;
    }

    int getColumnCount() {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i2);
            accessibleTableListener.getColumnCount(accessibleTableEvent);
        }
        return accessibleTableEvent.count;
    }

    id getColumnsAttribute(int n2) {
        Object object;
        int n3;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n3 = 0; n3 < this.accessibleTableListenersSize(); ++n3) {
            object = this.accessibleTableListeners.get(n3);
            object.getColumnCount(accessibleTableEvent);
            object.getColumns(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessibles == null) {
            accessibleTableEvent.accessibles = new Accessible[0];
        }
        if (accessibleTableEvent.count != accessibleTableEvent.accessibles.length) {
            this.createTableDelegate();
            for (n3 = 0; n3 < this.accessibleTableListenersSize(); ++n3) {
                object = this.accessibleTableListeners.get(n3);
                object.getColumnCount(accessibleTableEvent);
                object.getColumns(accessibleTableEvent);
            }
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleTableEvent.accessibles.length);
        object = accessibleTableEvent.accessibles;
        int n4 = 0;
        while (n4 < ((Accessible[])object).length) {
            Object object2 = object[n4];
            ((Accessible)object2).index = n4++;
            nSMutableArray.addObject(((Accessible)object2).delegate);
        }
        return nSMutableArray;
    }

    public id internal_accessibilityActionDescription(NSString nSString, int n2) {
        NSString nSString2 = NSString.string();
        String string = nSString.getString();
        if (this.accessibleActionListenersSize() > 0) {
            int n3;
            int n4;
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            for (n4 = 0; n4 < this.accessibleActionListenersSize(); ++n4) {
                AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(n4);
                accessibleActionListener.getActionCount(accessibleActionEvent);
            }
            n4 = -1;
            for (n3 = 0; n3 < accessibleActionEvent.count; ++n3) {
                accessibleActionEvent.index = n3;
                for (int i2 = 0; i2 < this.accessibleActionListenersSize(); ++i2) {
                    AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i2);
                    accessibleActionListener.getName(accessibleActionEvent);
                }
                if (!string.equals(accessibleActionEvent.result)) continue;
                n4 = n3;
                break;
            }
            if (n4 != -1) {
                accessibleActionEvent.index = n4;
                accessibleActionEvent.result = null;
                for (n3 = 0; n3 < this.accessibleActionListenersSize(); ++n3) {
                    AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(n3);
                    accessibleActionListener.getDescription(accessibleActionEvent);
                }
                if (accessibleActionEvent.result != null) {
                    nSString2 = NSString.stringWith(accessibleActionEvent.result);
                }
            }
        }
        return nSString2;
    }

    public NSArray internal_accessibilityActionNames(int n2) {
        if (this.accessibleActionListenersSize() > 0) {
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            for (int i2 = 0; i2 < this.accessibleActionListenersSize(); ++i2) {
                AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i2);
                accessibleActionListener.getActionCount(accessibleActionEvent);
            }
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(accessibleActionEvent.count);
            for (int i3 = 0; i3 < accessibleActionEvent.count; ++i3) {
                accessibleActionEvent.index = i3;
                for (int i4 = 0; i4 < this.accessibleActionListenersSize(); ++i4) {
                    AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i4);
                    accessibleActionListener.getName(accessibleActionEvent);
                }
                nSMutableArray.addObject(NSString.stringWith(accessibleActionEvent.result));
            }
            return nSMutableArray;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i5 = 0; i5 < this.accessibleControlListenersSize(); ++i5) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i5);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (n2 == -1 && this.actionNames != null) {
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(5L);
        switch (accessibleControlEvent.detail) {
            case 30: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 62: 
            case 1027: 
            case 1073: {
                nSMutableArray.addObject(OS.NSAccessibilityPressAction);
                break;
            }
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityConfirmAction);
                break;
            }
        }
        if (n2 == -1) {
            this.actionNames = nSMutableArray;
            this.actionNames.retain();
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        return nSMutableArray;
    }

    public boolean internal_accessibilityIsAttributeSettable(NSString nSString, int n2) {
        if (this.accessibleTextExtendedListenersSize() > 0) {
            if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
                return true;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
                return true;
            }
        }
        if (this.accessibleEditableTextListenersSize() > 0 && nSString.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return true;
        }
        return this.accessibleValueListenersSize() > 0 && nSString.isEqualToString(OS.NSAccessibilityValueAttribute);
    }

    public NSArray internal_accessibilityAttributeNames(int n2) {
        String string;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (this.attributeNames != null) {
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(baseAttributes.length);
        for (int i3 = 0; i3 < baseAttributes.length; ++i3) {
            nSMutableArray.addObject(baseAttributes[i3]);
        }
        switch (accessibleControlEvent.detail) {
            case 10: {
                break;
            }
            case 9: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 2: {
                nSMutableArray.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 11: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 12: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 21: {
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 13: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 3: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 18: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 41: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 43: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 44: 
            case 45: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 62: {
                break;
            }
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityExpandedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 42: 
            case 1044: 
            case 1054: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityInsertionPointLineNumberAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedTextRangesAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 22: {
                break;
            }
            case 33: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 34: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 24: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 29: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 35: {
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                break;
            }
            case 36: {
                nSMutableArray.addObject(OS.NSAccessibilityColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
            }
            case 60: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityContentsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTabsAttribute);
                break;
            }
            case 37: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 48: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 51: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 30: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 8: {
                break;
            }
            case 54: {
                break;
            }
            case 1025: {
                break;
            }
            case 27: {
                nSMutableArray.removeObject(OS.NSAccessibilityChildrenAttribute);
                nSMutableArray.removeObject(OS.NSAccessibilityFocusedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityIndexAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 15: {
                break;
            }
            case 40: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityDescriptionAttribute);
                break;
            }
            case 20: {
                break;
            }
            case 28: {
                nSMutableArray.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityIndexAttribute);
                nSMutableArray.addObject(OS.NSAccessibilitySelectedAttribute);
                break;
            }
            case 52: {
                break;
            }
            case 23: {
                break;
            }
            case 1027: {
                break;
            }
            case 1073: {
                break;
            }
            case 61: {
                break;
            }
            case 1029: {
                break;
            }
            case 47: {
                break;
            }
            case 1038: {
                break;
            }
            case 1043: {
                break;
            }
            case 1040: {
                break;
            }
            case 1053: {
                break;
            }
        }
        if (accessibleControlEvent.detail != -1 && (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58) == -1) {
            nSMutableArray.removeObject(OS.NSAccessibilitySubroleAttribute);
        }
        if (n2 != -1) {
            nSMutableArray.removeObject(OS.NSAccessibilityChildrenAttribute);
        }
        if (n2 == -1) {
            this.attributeNames = nSMutableArray;
            this.attributeNames.retain();
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        return nSMutableArray;
    }

    public id internal_accessibilityAttributeValue(NSString nSString, int n2) {
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
            return this.getRoleAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySubroleAttribute)) {
            return this.getSubroleAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            return this.getRoleDescriptionAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityExpandedAttribute)) {
            return this.getExpandedAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
            return this.getHelpAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
            return this.getTitleAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            return this.getValueAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            return this.getMaxValueAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return this.getMinValueAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return this.getEnabledAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            return this.getFocusedAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityParentAttribute)) {
            return this.getParentAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            return this.getChildrenAttribute(n2, false);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleChildrenAttribute)) {
            return this.getChildrenAttribute(n2, true);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityContentsAttribute)) {
            return this.getChildrenAttribute(n2, false);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTabsAttribute)) {
            return this.getTabsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityWindowAttribute)) {
            return this.getWindowAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTopLevelUIElementAttribute)) {
            return this.getTopLevelUIElementAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityPositionAttribute)) {
            return this.getPositionAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySizeAttribute)) {
            return this.getSizeAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return this.getDescriptionAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityNumberOfCharactersAttribute)) {
            return this.getNumberOfCharactersAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return this.getSelectedTextAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            return this.getSelectedTextRangeAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityInsertionPointLineNumberAttribute)) {
            return this.getInsertionPointLineNumberAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangesAttribute)) {
            return this.getSelectedTextRangesAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            return this.getVisibleCharacterRangeAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
            return this.getServesAsTitleForUIElementsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTitleUIElementAttribute)) {
            return this.getTitleUIElementAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute)) {
            return this.getColumnsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedColumnsAttribute)) {
            return this.getSelectedColumnsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRowsAttribute)) {
            return this.getRowsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedRowsAttribute)) {
            return this.getSelectedRowsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleRowsAttribute)) {
            return this.getVisibleRowsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) {
            return this.getVisibleColumnsAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHeaderAttribute)) {
            return this.getHeaderAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityIndexAttribute)) {
            return this.getIndexAttribute(n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedAttribute)) {
            return this.getSelectedAttribute(n2);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityRowIndexRangeAttribute)) {
            return this.getRowIndexRangeAttribute(n2);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityColumnIndexRangeAttribute)) {
            return this.getColumnIndexRangeAttribute(n2);
        }
        return null;
    }

    public id internal_accessibilityAttributeValue_forParameter(NSString nSString, id id2, int n2) {
        if (nSString.isEqualToString(OS.NSAccessibilityStringForRangeParameterizedAttribute)) {
            return this.getStringForRangeParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForLineParameterizedAttribute)) {
            return this.getRangeForLineParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForIndexParameterizedAttribute)) {
            return this.getRangeForIndexParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityLineForIndexParameterizedAttribute)) {
            return this.getLineForIndexParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityBoundsForRangeParameterizedAttribute)) {
            return this.getBoundsForRangeParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForPositionParameterizedAttribute)) {
            return this.getRangeForPositionParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute)) {
            return this.getAttributedStringForRangeParameterizedAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute)) {
            return this.getStyleRangeForIndexAttribute(id2, n2);
        }
        if (OS.VERSION >= 4192 && nSString.isEqualToString(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute)) {
            return this.getCellForColumnAndRowParameter(id2, n2);
        }
        return null;
    }

    public id internal_accessibilityFocusedUIElement(int n2) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        accessibleControlEvent.accessible = null;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getFocus(accessibleControlEvent);
        }
        if (accessibleControlEvent.childID == -3) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.control.view.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public id internal_accessibilityHitTest(NSPoint nSPoint, int n2) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.x = (int)nSPoint.x;
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        accessibleControlEvent.y = (int)((double)monitor.getBounds().height - nSPoint.y);
        accessibleControlEvent.childID = -3;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
        }
        if (accessibleControlEvent.childID == -3 && accessibleControlEvent.accessible == null) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.delegate.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public boolean internal_accessibilityIsIgnored(int n2) {
        int n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (n3 = 0; n3 < this.accessibleControlListenersSize(); n3 += 1) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n3);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        int n4 = n3 = accessibleControlEvent.detail == -1 ? 1 : 0;
        if (n3) {
            n3 = this.getTitleAttribute(n2) == null && this.getHelpAttribute(n2) == null && this.getDescriptionAttribute(n2) == null ? 1 : 0;
        }
        return n3 != 0;
    }

    public NSArray internal_accessibilityParameterizedAttributeNames(int n2) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        this.checkRole(accessibleControlEvent.detail);
        if (n2 == -1 && this.parameterizedAttributeNames != null) {
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(4L);
        switch (accessibleControlEvent.detail) {
            case 42: 
            case 1044: 
            case 1054: {
                nSMutableArray.addObject(OS.NSAccessibilityStringForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForLineParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForIndexParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityLineForIndexParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityBoundsForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityRangeForPositionParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute);
                nSMutableArray.addObject(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute);
                break;
            }
            case 24: {
                if (OS.VERSION < 4192) break;
                nSMutableArray.addObject(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
            }
        }
        if (n2 == -1) {
            this.parameterizedAttributeNames = nSMutableArray;
            this.parameterizedAttributeNames.retain();
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        return nSMutableArray;
    }

    public boolean internal_accessibilityPerformAction(NSString nSString, int n2) {
        String string = nSString.getString();
        if (this.accessibleActionListenersSize() > 0) {
            int n3;
            int n4;
            AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
            for (n4 = 0; n4 < this.accessibleActionListenersSize(); ++n4) {
                AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(n4);
                accessibleActionListener.getActionCount(accessibleActionEvent);
            }
            n4 = -1;
            for (n3 = 0; n3 < accessibleActionEvent.count; ++n3) {
                accessibleActionEvent.index = n3;
                for (int i2 = 0; i2 < this.accessibleActionListenersSize(); ++i2) {
                    AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i2);
                    accessibleActionListener.getName(accessibleActionEvent);
                }
                if (!string.equals(accessibleActionEvent.result)) continue;
                n4 = n3;
                break;
            }
            if (n4 != -1) {
                accessibleActionEvent.index = n4;
                accessibleActionEvent.result = null;
                for (n3 = 0; n3 < this.accessibleActionListenersSize(); ++n3) {
                    AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(n3);
                    accessibleActionListener.doAction(accessibleActionEvent);
                }
                return "OK".equals(accessibleActionEvent.result);
            }
        }
        return false;
    }

    public void internal_accessibilitySetValue_forAttribute(id id2, NSString nSString, int n2) {
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            this.setSelectedTextRangeAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            this.setSelectedTextAttribute(id2, n2);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            this.setVisibleCharacterRangeAttribute(id2, n2);
        }
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            NSNumber nSNumber = new NSNumber(id2);
            accessibleValueEvent.value = new Double(nSNumber.doubleValue());
            for (int i2 = 0; i2 < this.accessibleValueListenersSize(); ++i2) {
                AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i2);
                accessibleValueListener.setCurrentValue(accessibleValueEvent);
            }
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release(true);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        this.release(true);
    }

    id getAttributedStringForRangeParameterizedAttribute(id id2, int n2) {
        Object object;
        if (this.accessibleAttributeListenersSize() == 0) {
            return null;
        }
        id id3 = this.getStringForRangeParameterizedAttribute(id2, n2);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.initWithString(new NSString(id3), null);
        nSMutableAttributedString.autorelease();
        NSValue nSValue = new NSValue(id2.id);
        NSRange nSRange = nSValue.rangeValue();
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = (int)nSRange.location;
        accessibleTextAttributeEvent.end = -1;
        accessibleTextAttributeEvent.start = -1;
        NSRange nSRange2 = new NSRange();
        while ((long)accessibleTextAttributeEvent.offset < nSRange.location + nSRange.length) {
            NSObject nSObject;
            Object object2;
            for (int i2 = 0; i2 < this.accessibleAttributeListenersSize(); ++i2) {
                object2 = this.accessibleAttributeListeners.get(i2);
                object2.getTextAttributes(accessibleTextAttributeEvent);
            }
            if (accessibleTextAttributeEvent.start == -1 && accessibleTextAttributeEvent.end == -1) {
                return id3;
            }
            nSRange2.location = (long)accessibleTextAttributeEvent.start - nSRange.location;
            nSRange2.length = accessibleTextAttributeEvent.end - accessibleTextAttributeEvent.start;
            if (nSRange2.location < 0L) {
                nSRange2.length -= -nSRange2.location;
                nSRange2.location = 0L;
            }
            if (nSRange2.location + nSRange2.length > nSRange.length) {
                nSRange2.length = nSRange.length - nSRange2.location;
            }
            accessibleTextAttributeEvent.offset = accessibleTextAttributeEvent.end;
            if (accessibleTextAttributeEvent.textStyle == null) continue;
            TextStyle textStyle = accessibleTextAttributeEvent.textStyle;
            if (textStyle.font != null) {
                object2 = NSMutableDictionary.dictionaryWithCapacity(4L);
                object = textStyle.font.handle;
                nSObject = ((NSFont)object).fontName();
                ((NSMutableDictionary)object2).setValue(nSObject, OS.NSAccessibilityFontNameKey);
                NSString nSString = ((NSFont)object).familyName();
                ((NSMutableDictionary)object2).setValue(nSString, OS.NSAccessibilityFontFamilyKey);
                NSString nSString2 = ((NSFont)object).displayName();
                ((NSMutableDictionary)object2).setValue(nSString2, OS.NSAccessibilityVisibleNameKey);
                double d2 = ((NSFont)object).pointSize();
                ((NSMutableDictionary)object2).setValue(NSNumber.numberWithDouble(d2), OS.NSAccessibilityFontSizeKey);
                nSMutableAttributedString.addAttribute(OS.NSAccessibilityFontTextAttribute, (id)object2, nSRange2);
            }
            if (textStyle.foreground != null) {
                this.addCGColor(textStyle.foreground.handle, nSMutableAttributedString, OS.NSAccessibilityForegroundColorTextAttribute, nSRange2);
            }
            if (textStyle.background != null) {
                this.addCGColor(textStyle.background.handle, nSMutableAttributedString, OS.NSAccessibilityBackgroundColorTextAttribute, nSRange2);
            }
            if (textStyle.underline) {
                int n3 = textStyle.underlineStyle;
                object = OS.NSAccessibilityUnderlineTextAttribute;
                nSObject = null;
                switch (n3) {
                    case 0: {
                        nSObject = NSNumber.numberWithInt(1);
                        break;
                    }
                    case 1: {
                        nSObject = NSNumber.numberWithInt(9);
                        break;
                    }
                    case 3: {
                        object = OS.NSAccessibilityMisspelledTextAttribute;
                        nSObject = NSNumber.numberWithBool(true);
                        break;
                    }
                    default: {
                        nSObject = NSNumber.numberWithInt(0);
                    }
                }
                nSMutableAttributedString.addAttribute((NSString)object, nSObject, nSRange2);
            }
            if (textStyle.underlineColor != null) {
                this.addCGColor(textStyle.underlineColor.handle, nSMutableAttributedString, OS.NSAccessibilityUnderlineColorTextAttribute, nSRange2);
            }
            if (textStyle.strikeout) {
                nSMutableAttributedString.addAttribute(OS.NSAccessibilityStrikethroughTextAttribute, NSNumber.numberWithBool(true), nSRange2);
                if (textStyle.strikeoutColor != null) {
                    this.addCGColor(textStyle.strikeoutColor.handle, nSMutableAttributedString, OS.NSAccessibilityStrikethroughColorTextAttribute, nSRange2);
                }
            }
            if (textStyle.data == null || !(textStyle.data instanceof URL)) continue;
            URL uRL = (URL)textStyle.data;
            object = NSURL.URLWithString(NSString.stringWith(uRL.toExternalForm()));
            nSMutableAttributedString.addAttribute(OS.NSAccessibilityLinkTextAttribute, (id)object, nSRange2);
        }
        AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(this);
        accessibleAttributeEvent.indent = Integer.MAX_VALUE;
        for (int i3 = 0; i3 < this.accessibleAttributeListenersSize(); ++i3) {
            object = this.accessibleAttributeListeners.get(i3);
            object.getAttributes(accessibleAttributeEvent);
        }
        if (accessibleAttributeEvent.indent != Integer.MAX_VALUE) {
            NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(3L);
            int n4 = 0;
            switch (accessibleAttributeEvent.alignment) {
                case 0x1000000: {
                    n4 = 2;
                    break;
                }
                case 131072: {
                    n4 = 1;
                    break;
                }
                default: {
                    n4 = 0;
                }
            }
            nSMutableDictionary.setValue(NSNumber.numberWithInt(n4), NSString.stringWith("AXTextAlignment"));
            nSRange.location = 0L;
            nSMutableAttributedString.addAttribute(NSString.stringWith("AXParagraphStyle"), nSMutableDictionary, nSRange);
        }
        return nSMutableAttributedString;
    }

    id getBoundsForRangeParameterizedAttribute(id id2, int n2) {
        if (this.accessibleTextExtendedListenersSize() == 0) {
            return null;
        }
        NSValue nSValue = null;
        NSValue nSValue2 = new NSValue(id2.id);
        NSRange nSRange = nSValue2.rangeValue();
        NSRect nSRect = new NSRect();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            Object object;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.start = (int)nSRange.location;
            accessibleTextEvent.end = (int)(nSRange.location + nSRange.length);
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                object = this.accessibleTextExtendedListeners.get(i2);
                object.getTextBounds(accessibleTextEvent);
            }
            nSRect.x = accessibleTextEvent.x;
            NSArray nSArray = NSScreen.screens();
            object = new NSScreen(nSArray.objectAtIndex(0L));
            NSRect nSRect2 = ((NSScreen)object).frame();
            nSRect.y = nSRect2.height - (double)accessibleTextEvent.y - (double)accessibleTextEvent.height;
            nSRect.width = accessibleTextEvent.width;
            nSRect.height = accessibleTextEvent.height;
            nSValue = NSValue.valueWithRect(nSRect);
        }
        return nSValue;
    }

    id getExpandedAttribute(int n2) {
        return NSNumber.numberWithBool(false);
    }

    id getHelpAttribute(int n2) {
        NSString nSString = null;
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n2;
        for (int i2 = 0; i2 < this.accessibleListenersSize(); ++i2) {
            AccessibleListener accessibleListener = this.accessibleListeners.get(i2);
            accessibleListener.getHelp(accessibleEvent);
        }
        if (accessibleEvent.result != null) {
            nSString = NSString.stringWith(accessibleEvent.result);
        }
        return nSString;
    }

    id getRangeForPositionParameterizedAttribute(id id2, int n2) {
        NSValue nSValue = null;
        NSValue nSValue2 = new NSValue(id2.id);
        NSPoint nSPoint = nSValue2.pointValue();
        NSRange nSRange = new NSRange();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            NSArray nSArray = NSScreen.screens();
            NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0L));
            NSRect nSRect = nSScreen.frame();
            nSPoint.y = nSRect.height - nSPoint.y;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.x = (int)nSPoint.x;
            accessibleTextEvent.y = (int)nSPoint.y;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
            }
            nSRange.location = accessibleTextEvent.offset;
            nSRange.length = 1L;
        }
        nSValue = NSValue.valueWithRange(nSRange);
        return nSValue;
    }

    NSString getRoleAttribute(int n2) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail != -1) {
            String string = this.roleToOs(accessibleControlEvent.detail);
            int n3 = string.indexOf(58);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getSubroleAttribute(int n2) {
        String string;
        int n3;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail != -1 && (n3 = (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58)) != -1) {
            string = string.substring(n3 + 1);
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getRoleDescriptionAttribute(int n2) {
        Object object;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            object = this.accessibleControlListeners.get(i2);
            object.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail != -1) {
            if (accessibleControlEvent.detail == 37) {
                nSString = new NSString(OS.NSAccessibilityRoleDescription(NSString.stringWith((String)"AXTab").id, 0L));
            } else {
                String string = this.roleToOs(accessibleControlEvent.detail);
                object = null;
                int n3 = string.indexOf(58);
                if (n3 != -1) {
                    object = string.substring(n3 + 1);
                    string = string.substring(0, n3);
                }
                NSString nSString2 = NSString.stringWith(string);
                NSString nSString3 = null;
                if (object != null) {
                    nSString3 = NSString.stringWith((String)object);
                }
                nSString = new NSString(OS.NSAccessibilityRoleDescription(nSString2 != null ? nSString2.id : 0L, nSString3 != null ? nSString3.id : 0L));
            }
        }
        return nSString;
    }

    id getTitleAttribute(int n2) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.detail = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        if (accessibleControlEvent.detail != 41) {
            AccessibleEvent accessibleEvent = new AccessibleEvent(this);
            accessibleEvent.childID = n2;
            accessibleEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleListenersSize(); ++i3) {
                AccessibleListener accessibleListener = this.accessibleListeners.get(i3);
                accessibleListener.getName(accessibleEvent);
            }
            if (accessibleEvent.result != null) {
                nSString = NSString.stringWith(accessibleEvent.result);
            }
        }
        return nSString;
    }

    id getTitleUIElementAttribute(int n2) {
        id id2 = null;
        Relation relation = this.relations[9];
        if (relation != null) {
            id2 = relation.getTitleUIElement();
        }
        return id2;
    }

    id getValueAttribute(int n2) {
        id id2 = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            for (int i2 = 0; i2 < this.accessibleValueListenersSize(); ++i2) {
                AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i2);
                accessibleValueListener.getCurrentValue(accessibleValueEvent);
            }
            id2 = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        } else {
            Object object;
            int n3;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.detail = -1;
            accessibleControlEvent.result = null;
            for (n3 = 0; n3 < this.accessibleControlListenersSize(); ++n3) {
                object = this.accessibleControlListeners.get(n3);
                object.getRole(accessibleControlEvent);
                object.getValue(accessibleControlEvent);
            }
            n3 = accessibleControlEvent.detail;
            object = accessibleControlEvent.result;
            switch (n3) {
                case 3: 
                case 44: 
                case 45: 
                case 48: 
                case 51: {
                    if (object != null) {
                        try {
                            int n4 = Integer.parseInt((String)object);
                            id2 = NSNumber.numberWithBool(n4 != 0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (((String)object).equalsIgnoreCase("true")) {
                                id2 = NSNumber.numberWithBool(true);
                                break;
                            }
                            if (!((String)object).equalsIgnoreCase("false")) break;
                            id2 = NSNumber.numberWithBool(false);
                        }
                        break;
                    }
                    id2 = NSNumber.numberWithBool(false);
                    break;
                }
                case 37: 
                case 60: {
                    AccessibleControlEvent accessibleControlEvent2 = new AccessibleControlEvent(this);
                    accessibleControlEvent2.childID = -4;
                    for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                        AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                        accessibleControlListener.getSelection(accessibleControlEvent2);
                    }
                    if (accessibleControlEvent2.childID >= -1) {
                        if (n3 == 37) {
                            id2 = NSNumber.numberWithBool(accessibleControlEvent2.childID == n2);
                            break;
                        }
                        id2 = new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent2.childID).id));
                        break;
                    }
                    id2 = NSNumber.numberWithBool(false);
                    break;
                }
                case 42: 
                case 46: 
                case 1044: 
                case 1054: {
                    if (object == null) break;
                    id2 = NSString.stringWith((String)object);
                    break;
                }
                case 29: 
                case 41: {
                    AccessibleEvent accessibleEvent = new AccessibleEvent(this);
                    accessibleEvent.childID = n2;
                    accessibleEvent.result = null;
                    for (int i4 = 0; i4 < this.accessibleListenersSize(); ++i4) {
                        AccessibleListener accessibleListener = this.accessibleListeners.get(i4);
                        accessibleListener.getName(accessibleEvent);
                    }
                    if (accessibleEvent.result != null) {
                        id2 = NSString.stringWith(accessibleEvent.result);
                    } else if (object != null) {
                        id2 = NSString.stringWith((String)object);
                    }
                    id2 = id2 == null ? NSString.string() : id2;
                }
            }
        }
        return id2;
    }

    id getEnabledAttribute(int n2) {
        int n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.detail = 0;
        accessibleControlEvent.childID = n2;
        for (n3 = 0; n3 < this.accessibleControlListenersSize(); n3 += 1) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n3);
            accessibleControlListener.getState(accessibleControlEvent);
        }
        int n4 = n3 = (accessibleControlEvent.detail & 1) == 0 ? 1 : 0;
        if (!n3 && this.delegate == null) {
            n3 = this.control.isEnabled();
        }
        return NSNumber.numberWithBool(n3 != 0);
    }

    id getFocusedAttribute(int n2) {
        int n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        for (n3 = 0; n3 < this.accessibleControlListenersSize(); n3 += 1) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n3);
            accessibleControlListener.getFocus(accessibleControlEvent);
        }
        if (accessibleControlEvent.accessible != null) {
            n3 = accessibleControlEvent.accessible.index == n2 && accessibleControlEvent.accessible.control == this.control ? 1 : 0;
            return NSNumber.numberWithBool(n3 != 0);
        }
        if (accessibleControlEvent.childID == -1) {
            return NSNumber.numberWithBool(true);
        }
        if (accessibleControlEvent.childID == -2) {
            return NSNumber.numberWithBool(false);
        }
        if (accessibleControlEvent.childID != -3) {
            return NSNumber.numberWithBool(accessibleControlEvent.childID == n2);
        }
        return null;
    }

    id getParentAttribute(int n2) {
        id id2 = null;
        id2 = n2 == -1 ? (this.parent != null ? (this.parent.delegate != null ? this.parent.delegate : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this.parent).id))) : null) : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this).id));
        return id2;
    }

    id getChildrenAttribute(int n2, boolean bl2) {
        id id2 = null;
        if (n2 == -1) {
            int n3;
            if (this.currentRole == 24) {
                this.getRowsAttribute(n2);
                this.getColumnsAttribute(n2);
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.detail = -1;
            for (n3 = 0; n3 < this.accessibleControlListenersSize(); ++n3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n3);
                accessibleControlListener.getChildCount(accessibleControlEvent);
            }
            n3 = accessibleControlEvent.detail;
            int n4 = accessibleControlEvent.detail = bl2 ? 1 : 0;
            if (n3 >= 0) {
                Object object;
                for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
                    object = this.accessibleControlListeners.get(i2);
                    object.getChildren(accessibleControlEvent);
                }
                Object[] objectArray = accessibleControlEvent.children;
                n3 = objectArray != null ? objectArray.length : 0;
                object = NSMutableArray.arrayWithCapacity(n3);
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object2;
                    Object object3 = objectArray[i3];
                    if (object3 instanceof Accessible) {
                        object2 = (Accessible)object3;
                        if (((Accessible)object2).delegate != null) {
                            ((NSMutableArray)object).addObject(((Accessible)object2).delegate);
                            continue;
                        }
                        ((NSMutableArray)object).addObject(this.accessibleHandle((Accessible)object2));
                        continue;
                    }
                    if (!(object3 instanceof Integer)) continue;
                    object2 = this.childIDToOs((Integer)object3);
                    ((NSMutableArray)object).addObject((id)object2);
                }
                id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getTabsAttribute(int n2) {
        id id2 = null;
        if (n2 == -1) {
            Object object;
            int n3;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.detail = -1;
            for (n3 = 0; n3 < this.accessibleControlListenersSize(); ++n3) {
                object = this.accessibleControlListeners.get(n3);
                object.getChildCount(accessibleControlEvent);
            }
            if (accessibleControlEvent.detail > 0) {
                for (n3 = 0; n3 < this.accessibleControlListenersSize(); ++n3) {
                    object = this.accessibleControlListeners.get(n3);
                    object.getChildren(accessibleControlEvent);
                }
                Object[] objectArray = accessibleControlEvent.children;
                if (objectArray != null && objectArray.length > 0) {
                    object = NSMutableArray.arrayWithCapacity(objectArray.length);
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        Object object2 = objectArray[i2];
                        if (object2 instanceof Integer) {
                            int n4;
                            accessibleControlEvent.childID = n4 = ((Integer)object2).intValue();
                            accessibleControlEvent.detail = -1;
                            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                                accessibleControlListener.getRole(accessibleControlEvent);
                            }
                            if (accessibleControlEvent.detail != 37) continue;
                            id id3 = this.childIDToOs((Integer)object2);
                            ((NSMutableArray)object).addObject(id3);
                            continue;
                        }
                        ((NSMutableArray)object).addObject(((Accessible)object2).control.view);
                    }
                    id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
                }
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getWindowAttribute(int n2) {
        return this.control.view.window();
    }

    id getTopLevelUIElementAttribute(int n2) {
        return this.control.view.window();
    }

    id getPositionAttribute(int n2) {
        Object object;
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.width = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            object = this.accessibleControlListeners.get(i2);
            object.getLocation(accessibleControlEvent);
        }
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        object = new NSPoint();
        if (accessibleControlEvent.width != -1) {
            ((NSPoint)object).x = accessibleControlEvent.x;
            ((NSPoint)object).y = monitor.getBounds().height - accessibleControlEvent.y - accessibleControlEvent.height;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        } else if (n2 != -1) {
            Point point = null;
            Rectangle rectangle = this.control.getBounds();
            point = this.control.getParent() != null ? this.control.getParent().toDisplay(rectangle.x, rectangle.y) : ((Shell)this.control).toDisplay(rectangle.x, rectangle.y);
            ((NSPoint)object).x = point.x;
            ((NSPoint)object).y = point.y;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        }
        return nSValue;
    }

    id getSizeAttribute(int n2) {
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        accessibleControlEvent.width = -1;
        for (int i2 = 0; i2 < this.accessibleControlListenersSize(); ++i2) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i2);
            accessibleControlListener.getLocation(accessibleControlEvent);
        }
        NSSize nSSize = new NSSize();
        if (accessibleControlEvent.width != -1) {
            nSSize.width = accessibleControlEvent.width;
            nSSize.height = accessibleControlEvent.height;
            nSValue = NSValue.valueWithSize(nSSize);
        } else if (n2 != -1) {
            nSSize.height = 0.0;
            nSSize.width = 0.0;
            nSValue = NSValue.valueWithSize(nSSize);
        }
        return nSValue;
    }

    id getCellForColumnAndRowParameter(id id2, int n2) {
        SWTAccessibleDelegate sWTAccessibleDelegate = null;
        NSArray nSArray = new NSArray(id2.id);
        if (nSArray.count() == 2L) {
            AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
            accessibleTableEvent.column = new NSNumber(nSArray.objectAtIndex(0L)).intValue();
            accessibleTableEvent.row = new NSNumber(nSArray.objectAtIndex(1L)).intValue();
            for (int i2 = 0; i2 < this.accessibleTableListenersSize(); ++i2) {
                AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i2);
                accessibleTableListener.getCell(accessibleTableEvent);
                sWTAccessibleDelegate = accessibleTableEvent.accessible.delegate;
            }
        }
        return sWTAccessibleDelegate;
    }

    id getDescriptionAttribute(int n2) {
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n2;
        accessibleEvent.result = null;
        NSString nSString = null;
        for (int i2 = 0; i2 < this.accessibleListenersSize(); ++i2) {
            AccessibleListener accessibleListener = this.accessibleListeners.get(i2);
            accessibleListener.getDescription(accessibleEvent);
        }
        NSString nSString2 = nSString = accessibleEvent.result != null ? NSString.stringWith(accessibleEvent.result) : null;
        if (nSString == null && this.control instanceof Composite) {
            nSString = NSString.string();
        }
        return nSString;
    }

    id getInsertionPointLineNumberAttribute(int n2) {
        NSNumber nSNumber = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            int n3;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
                accessibleTextExtendedListener.getCaretOffset(accessibleTextEvent);
            }
            accessibleTextEvent.start = n3 = accessibleTextEvent.offset;
            accessibleTextEvent.end = n3;
            accessibleTextEvent.count = Integer.MIN_VALUE;
            accessibleTextEvent.type = 4;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
            }
            nSNumber = NSNumber.numberWithInt(Math.max(0, -accessibleTextEvent.count));
        } else {
            int n4;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.offset = -1;
            for (n4 = 0; n4 < this.accessibleTextListenersSize(); ++n4) {
                AccessibleTextListener accessibleTextListener = this.accessibleTextListeners.get(n4);
                accessibleTextListener.getCaretOffset(accessibleTextEvent);
            }
            if (accessibleControlEvent.result != null && accessibleTextEvent.offset != -1) {
                n4 = this.lineNumberForOffset(accessibleControlEvent.result, accessibleTextEvent.offset);
                nSNumber = NSNumber.numberWithInt(n4);
            }
        }
        return nSNumber;
    }

    id getLineForIndexParameterizedAttribute(id id2, int n2) {
        NSNumber nSNumber = null;
        NSNumber nSNumber2 = new NSNumber(id2.id);
        int n3 = nSNumber2.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.start = n3;
            accessibleTextEvent.end = n3;
            accessibleTextEvent.count = Integer.MIN_VALUE;
            accessibleTextEvent.type = 4;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
            }
            nSNumber = NSNumber.numberWithInt(Math.max(0, -accessibleTextEvent.count));
        } else {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSNumber = NSNumber.numberWithInt(this.lineNumberForOffset(string, n3));
            }
        }
        return nSNumber;
    }

    id getMaxValueAttribute(int n2) {
        NSNumber nSNumber = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            for (int i2 = 0; i2 < this.accessibleValueListenersSize(); ++i2) {
                AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i2);
                accessibleValueListener.getMaximumValue(accessibleValueEvent);
            }
            nSNumber = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        }
        return nSNumber;
    }

    id getMinValueAttribute(int n2) {
        NSNumber nSNumber = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
            for (int i2 = 0; i2 < this.accessibleValueListenersSize(); ++i2) {
                AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i2);
                accessibleValueListener.getMinimumValue(accessibleValueEvent);
            }
            nSNumber = NSNumber.numberWithDouble(accessibleValueEvent.value.doubleValue());
        }
        return nSNumber;
    }

    id getNumberOfCharactersAttribute(int n2) {
        NSNumber nSNumber = null;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.count = -1;
        for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
            accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
        }
        if (accessibleTextEvent.count != -1) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -1;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getRole(accessibleControlEvent);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            accessibleTextEvent.count = accessibleControlEvent.detail == 42 && accessibleControlEvent.result != null ? accessibleControlEvent.result.length() : 0;
            nSNumber = NSNumber.numberWithInt(accessibleTextEvent.count);
        }
        return nSNumber;
    }

    id getRangeForLineParameterizedAttribute(id id2, int n2) {
        NSValue nSValue = null;
        NSNumber nSNumber = new NSNumber(id2.id);
        int n3 = nSNumber.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.end = 0;
            accessibleTextEvent.start = 0;
            accessibleTextEvent.count = n3;
            accessibleTextEvent.type = 4;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            if (accessibleControlEvent.result != null) {
                NSRange nSRange = this.rangeForLineNumber(n3, accessibleControlEvent.result);
                if (nSRange.location != -1L) {
                    nSValue = NSValue.valueWithRange(nSRange);
                }
            }
        }
        return nSValue;
    }

    id getRangeForIndexParameterizedAttribute(id id2, int n2) {
        NSValue nSValue = null;
        NSNumber nSNumber = new NSNumber(id2.id);
        int n3 = nSNumber.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.end = 0;
            accessibleTextEvent.start = 0;
            accessibleTextEvent.count = n3;
            accessibleTextEvent.type = 0;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else if (this.accessibleControlListenersSize() > 0) {
            // empty if block
        }
        return nSValue;
    }

    id getSelectedTextAttribute(int n2) {
        NSString nSString = NSString.string();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            String string;
            int n3;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.index = 0;
            for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
                accessibleTextExtendedListener.getSelection(accessibleTextEvent);
            }
            n3 = accessibleTextEvent.start;
            int n4 = accessibleTextEvent.end;
            if (n3 != n4) {
                accessibleTextEvent.type = 5;
                for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
            }
            if ((string = accessibleTextEvent.result) != null) {
                nSString = NSString.stringWith(string);
            }
        } else if (this.accessibleTextListenersSize() > 0) {
            int n5;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = -1;
            for (n5 = 0; n5 < this.accessibleTextListenersSize(); ++n5) {
                AccessibleTextListener accessibleTextListener = this.accessibleTextListeners.get(n5);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
            }
            n5 = accessibleTextEvent.offset;
            int n6 = accessibleTextEvent.length;
            if (n5 != -1 && n6 != -1 && n6 != 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
                accessibleControlEvent.childID = accessibleTextEvent.childID;
                accessibleControlEvent.result = null;
                for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                    AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                    accessibleControlListener.getValue(accessibleControlEvent);
                }
                String string = accessibleControlEvent.result;
                if (string != null) {
                    nSString = NSString.stringWith(string.substring(n5, n5 + n6));
                }
            }
        }
        return nSString;
    }

    id getSelectedTextRangeAttribute(int n2) {
        NSValue nSValue = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.index = 0;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getSelection(accessibleTextEvent);
            }
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
            nSValue = NSValue.valueWithRange(nSRange);
        } else if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            for (int i3 = 0; i3 < this.accessibleTextListenersSize(); ++i3) {
                AccessibleTextListener accessibleTextListener = this.accessibleTextListeners.get(i3);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
            }
            if (accessibleTextEvent.offset != -1) {
                NSRange nSRange = new NSRange();
                nSRange.location = accessibleTextEvent.offset;
                nSRange.length = accessibleTextEvent.length;
                nSValue = NSValue.valueWithRange(nSRange);
            }
        }
        return nSValue;
    }

    id getServesAsTitleForUIElementsAttribute(int n2) {
        id id2 = null;
        Relation relation = this.relations[8];
        if (relation != null) {
            id2 = relation.getServesAsTitleForUIElements();
        }
        return id2;
    }

    id getStringForRangeParameterizedAttribute(id id2, int n2) {
        NSString nSString = null;
        NSValue nSValue = new NSValue(id2.id);
        NSRange nSRange = nSValue.rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.start = (int)nSRange.location;
            accessibleTextEvent.end = (int)(nSRange.location + nSRange.length);
            accessibleTextEvent.type = 5;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getText(accessibleTextEvent);
            }
            if (accessibleTextEvent.result != null) {
                nSString = NSString.stringWith(accessibleTextEvent.result);
            }
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSString = NSString.stringWith(string.substring((int)nSRange.location, (int)(nSRange.location + nSRange.length)));
            }
        }
        return nSString;
    }

    id getSelectedTextRangesAttribute(int n2) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(3L);
        if (this.accessibleTextExtendedListenersSize() > 0) {
            Object object;
            int n3;
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
                object = this.accessibleTextExtendedListeners.get(n3);
                object.getSelectionCount(accessibleTextEvent);
            }
            if (accessibleTextEvent.count > 0) {
                for (n3 = 0; n3 < accessibleTextEvent.count; ++n3) {
                    accessibleTextEvent.index = n3;
                    for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                        AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                        accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                    }
                    object = new NSRange();
                    ((NSRange)object).location = accessibleTextEvent.start;
                    ((NSRange)object).length = accessibleTextEvent.end - accessibleTextEvent.start;
                    nSMutableArray.addObject(NSValue.valueWithRange((NSRange)object));
                }
            }
        } else if (this.accessibleTextListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            for (int i3 = 0; i3 < this.accessibleTextListenersSize(); ++i3) {
                AccessibleTextListener accessibleTextListener = this.accessibleTextListeners.get(i3);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
            }
            if (accessibleTextEvent.offset != -1) {
                NSRange nSRange = new NSRange();
                nSRange.location = accessibleTextEvent.offset;
                nSRange.length = accessibleTextEvent.length;
                nSMutableArray.addObject(NSValue.valueWithRange(nSRange));
            }
        }
        if (nSMutableArray.count() == 0L) {
            nSMutableArray.addObject(NSValue.valueWithRange(new NSRange()));
        }
        return nSMutableArray;
    }

    id getStyleRangeForIndexAttribute(id id2, int n2) {
        if (this.accessibleAttributeListenersSize() == 0) {
            return null;
        }
        NSNumber nSNumber = new NSNumber(id2.id);
        int n3 = nSNumber.intValue();
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = n3;
        accessibleTextAttributeEvent.end = -1;
        accessibleTextAttributeEvent.start = -1;
        for (int i2 = 0; i2 < this.accessibleAttributeListenersSize(); ++i2) {
            AccessibleAttributeListener accessibleAttributeListener = this.accessibleAttributeListeners.get(i2);
            accessibleAttributeListener.getTextAttributes(accessibleTextAttributeEvent);
        }
        NSRange nSRange = new NSRange();
        if (accessibleTextAttributeEvent.start == -1 && accessibleTextAttributeEvent.end == -1) {
            nSRange.location = n3;
            nSRange.length = 0L;
        } else {
            nSRange.location = accessibleTextAttributeEvent.start;
            nSRange.length = accessibleTextAttributeEvent.end - accessibleTextAttributeEvent.start;
        }
        return NSValue.valueWithRange(nSRange);
    }

    id getVisibleCharacterRangeAttribute(int n2) {
        NSRange nSRange = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.childID = n2;
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.getVisibleRanges(accessibleTextEvent);
            }
            nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.start;
            nSRange.length = accessibleTextEvent.end - accessibleTextEvent.start;
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n2;
            accessibleControlEvent.result = null;
            for (int i3 = 0; i3 < this.accessibleControlListenersSize(); ++i3) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i3);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            if (accessibleControlEvent.result != null) {
                nSRange = new NSRange();
                nSRange.location = 0L;
                nSRange.length = accessibleControlEvent.result.length();
            }
        }
        return nSRange != null ? NSValue.valueWithRange(nSRange) : null;
    }

    int lineNumberForOffset(String string, int n2) {
        int n3 = 1;
        int n4 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            switch (string.charAt(i2)) {
                case '\r': {
                    if (i2 + 1 < n4 && string.charAt(i2 + 1) == '\n') {
                        ++i2;
                    }
                }
                case '\n': {
                    ++n3;
                }
            }
        }
        return n3;
    }

    NSRange rangeForLineNumber(int n2, String string) {
        NSRange nSRange = new NSRange();
        nSRange.location = -1L;
        int n3 = 1;
        int n4 = 0;
        int n5 = string.length();
        for (int i2 = 0; i2 < n5; ++i2) {
            if (n3 == n2) {
                if (n4 == 0) {
                    nSRange.location = i2;
                }
                ++n4;
            }
            if (n3 > n2) break;
            switch (string.charAt(i2)) {
                case '\r': {
                    if (i2 + 1 < n5 && string.charAt(i2 + 1) == '\n') {
                        ++i2;
                    }
                }
                case '\n': {
                    ++n3;
                }
            }
        }
        nSRange.length = n4;
        return nSRange;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.remove(accessibleListener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.remove(accessibleControlListener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.remove(accessibleTextListener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.remove(accessibleTextListener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.remove(accessibleActionListener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.remove(accessibleEditableTextListener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.remove(accessibleHyperlinkListener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.remove(accessibleTableListener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.remove(accessibleTableCellListener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.remove(accessibleValueListener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.remove(accessibleAttributeListener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int n2, Accessible accessible) {
        this.checkWidget();
        if (this.relations[n2] != null) {
            this.relations[n2].removeTarget(accessible);
        }
    }

    void release(boolean bl2) {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        if (this.delegate != null) {
            this.delegate.internal_dispose_SWTAccessibleDelegate();
            this.delegate.release();
        }
        this.delegate = null;
        this.relations = null;
        if (this.childToIdMap != null) {
            Collection collection = this.childToIdMap.values();
            for (SWTAccessibleDelegate sWTAccessibleDelegate : collection) {
                sWTAccessibleDelegate.internal_dispose_SWTAccessibleDelegate();
                sWTAccessibleDelegate.release();
            }
            this.childToIdMap.clear();
            this.childToIdMap = null;
        }
        if (this.tableDelegate != null) {
            this.tableDelegate.release();
        }
    }

    static NSArray retainedAutoreleased(NSArray nSArray) {
        id id2 = nSArray.retain();
        NSObject nSObject = new NSObject(id2.id).autorelease();
        return new NSArray(nSObject.id);
    }

    public void sendEvent(int n2, Object object) {
        this.checkWidget();
        id id2 = this.accessibleHandle(this);
        if (DEBUG) {
            System.out.println("sendEvent: 0x" + Integer.toHexString(n2) + ", data = " + object + ", source = " + id2);
        }
        switch (n2) {
            case 256: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 285: 
            case 512: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 524: 
            case 32778: 
            case 32782: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityValueChangedNotification.id);
                break;
            }
            case 32777: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
                break;
            }
            case 32788: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 32779: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityMovedNotification.id);
                break;
            }
            case 32780: 
            case 32781: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityTitleChangedNotification.id);
                break;
            }
            case 283: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 518: {
                int[] nArray;
                if (this.tableDelegate != null) {
                    this.tableDelegate.reset();
                    this.getRowsAttribute(-1);
                    this.getColumnsAttribute(-1);
                }
                if (object == null || (nArray = (int[])object)[2] == 0) break;
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityRowCountChangedNotification.id);
                break;
            }
        }
    }

    public void sendEvent(int n2, Object object, int n3) {
        this.checkWidget();
        id id2 = this.childIDToOs(n3);
        if (DEBUG) {
            System.out.println("sendEvent: 0x" + Integer.toHexString(n2) + ", data = " + object + ", source = " + id2);
        }
        switch (n2) {
            case 32777: 
            case 32778: 
            case 32782: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
                break;
            }
            case 32788: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 32779: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityMovedNotification.id);
                break;
            }
            case 32780: 
            case 32781: {
                OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityTitleChangedNotification.id);
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        id id2 = this.accessibleHandle(this);
        if (DEBUG) {
            System.out.println("selectionChanged on " + id2);
        }
        if (this.currentRole == 24) {
            OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedRowsChangedNotification.id);
        } else {
            OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
        }
    }

    public void setFocus(int n2) {
        this.checkWidget();
        id id2 = this.childIDToOs(n2);
        if (DEBUG) {
            System.out.println("setFocus on " + id2);
        }
        OS.NSAccessibilityPostNotification(id2.id, OS.NSAccessibilityFocusedUIElementChangedNotification.id);
    }

    void setSelectedTextAttribute(id id2, int n2) {
        Object object;
        NSString nSString = new NSString(id2.id);
        int n3 = 0;
        id id3 = this.getNumberOfCharactersAttribute(n2);
        int n4 = new NSNumber(id3).intValue();
        id id4 = this.getSelectedTextRangeAttribute(n2);
        if (id4 != null) {
            object = new NSValue(id4).rangeValue();
            n3 = (int)((NSRange)object).location;
            n4 = (int)(((NSRange)object).location + ((NSRange)object).length);
        }
        if (this.accessibleEditableTextListenersSize() > 0) {
            object = new AccessibleEditableTextEvent(this);
            ((AccessibleEditableTextEvent)object).start = n3;
            ((AccessibleEditableTextEvent)object).end = n4;
            ((AccessibleEditableTextEvent)object).string = nSString.getString();
            for (int i2 = 0; i2 < this.accessibleEditableTextListenersSize(); ++i2) {
                AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i2);
                accessibleEditableTextListener.replaceText((AccessibleEditableTextEvent)object);
            }
        }
    }

    void setSelectedTextRangeAttribute(id id2, int n2) {
        NSRange nSRange = new NSValue(id2.id).rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.index = 0;
            accessibleTextEvent.start = (int)nSRange.location;
            accessibleTextEvent.end = (int)(nSRange.location + nSRange.length);
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
                accessibleTextExtendedListener.addSelection(accessibleTextEvent);
            }
        }
    }

    void setVisibleCharacterRangeAttribute(id id2, int n2) {
        NSRange nSRange = new NSValue(id2.id).rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
            accessibleTextEvent.type = 0;
            accessibleTextEvent.start = (int)nSRange.location;
            accessibleTextEvent.end = (int)(nSRange.location + nSRange.length);
            for (int i2 = 0; i2 < this.accessibleTextExtendedListenersSize(); ++i2) {
                AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i2);
                accessibleTextExtendedListener.scrollText(accessibleTextEvent);
            }
        }
    }

    public void textCaretMoved(int n2) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    public void textChanged(int n2, int n3, int n4) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityValueChangedNotification.id);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    id childIDToOs(int n2) {
        if (n2 == -1) {
            return this.control.view;
        }
        SWTAccessibleDelegate sWTAccessibleDelegate = (SWTAccessibleDelegate)this.childToIdMap.get(new Integer(n2));
        if (sWTAccessibleDelegate == null) {
            sWTAccessibleDelegate = new SWTAccessibleDelegate(this, n2);
            this.childToIdMap.put(new Integer(n2), sWTAccessibleDelegate);
        }
        return sWTAccessibleDelegate;
    }

    NSString concatStringsAsRole(NSString nSString, NSString nSString2) {
        NSString nSString3 = nSString;
        nSString3 = nSString3.stringByAppendingString(NSString.stringWith(":"));
        nSString3 = nSString3.stringByAppendingString(nSString2);
        return nSString3;
    }

    String roleToOs(int n2) {
        NSString nSString = null;
        switch (n2) {
            case 10: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 9: {
                nSString = OS.NSAccessibilityWindowRole;
                break;
            }
            case 2: {
                nSString = OS.NSAccessibilityMenuBarRole;
                break;
            }
            case 11: {
                nSString = OS.NSAccessibilityMenuRole;
                break;
            }
            case 12: {
                nSString = OS.NSAccessibilityMenuItemRole;
                break;
            }
            case 21: {
                nSString = OS.NSAccessibilitySplitterRole;
                break;
            }
            case 13: {
                nSString = OS.NSAccessibilityHelpTagRole;
                break;
            }
            case 3: {
                nSString = OS.NSAccessibilityScrollBarRole;
                break;
            }
            case 18: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole);
                break;
            }
            case 41: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 43: {
                nSString = OS.NSAccessibilityButtonRole;
                break;
            }
            case 44: {
                nSString = OS.NSAccessibilityCheckBoxRole;
                break;
            }
            case 45: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 62: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 46: {
                nSString = OS.NSAccessibilityComboBoxRole;
                break;
            }
            case 42: {
                int n3 = this.control.getStyle();
                if ((n3 & 2) != 0) {
                    nSString = OS.NSAccessibilityTextAreaRole;
                    break;
                }
                nSString = OS.NSAccessibilityTextFieldRole;
                break;
            }
            case 22: {
                nSString = OS.NSAccessibilityToolbarRole;
                break;
            }
            case 33: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 34: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 27: {
                nSString = OS.NSAccessibilityColumnRole;
                break;
            }
            case 28: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 24: {
                nSString = OS.NSAccessibilityTableRole;
                break;
            }
            case 29: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 25: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 26: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 35: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 36: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole);
                break;
            }
            case 60: {
                nSString = OS.NSAccessibilityTabGroupRole;
                break;
            }
            case 37: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 48: {
                nSString = OS.NSAccessibilityProgressIndicatorRole;
                break;
            }
            case 51: {
                nSString = OS.NSAccessibilitySliderRole;
                break;
            }
            case 30: {
                nSString = OS.NSAccessibilityLinkRole;
                break;
            }
            case 1025: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 40: {
                nSString = OS.NSAccessibilityImageRole;
                break;
            }
            case 20: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1027: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1073: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1038: 
            case 1040: 
            case 1043: 
            case 1053: 
            case 1060: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1044: 
            case 1054: {
                nSString = OS.NSAccessibilityTextAreaRole;
                break;
            }
            case 8: 
            case 15: 
            case 23: 
            case 47: 
            case 52: 
            case 54: 
            case 61: 
            case 1029: {
                nSString = OS.NSAccessibilityUnknownRole;
            }
        }
        return nSString.getString();
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    public long internal_addRelationAttributes(long l2) {
        NSArray nSArray = new NSArray(l2);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count());
        nSMutableArray.addObjectsFromArray(nSArray);
        if (this.getTitleAttribute(-1) != null && !nSMutableArray.containsObject(OS.NSAccessibilityTitleAttribute)) {
            nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
        }
        if (this.getDescriptionAttribute(-1) != null && !nSMutableArray.containsObject(OS.NSAccessibilityDescriptionAttribute)) {
            nSMutableArray.addObject(OS.NSAccessibilityDescriptionAttribute);
        }
        if (this.relations[8] != null) {
            if (!nSMutableArray.containsObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
            }
            if (!nSMutableArray.containsObject(OS.NSAccessibilityTitleAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
            }
        } else {
            nSMutableArray.removeObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
        if (this.relations[9] != null) {
            if (!nSMutableArray.containsObject(OS.NSAccessibilityTitleUIElementAttribute)) {
                nSMutableArray.addObject(OS.NSAccessibilityTitleUIElementAttribute);
            }
        } else {
            nSMutableArray.removeObject(OS.NSAccessibilityTitleUIElementAttribute);
        }
        return nSMutableArray.id;
    }
}

