/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.digest;

import java.security.MessageDigest;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Xof;

public class BCMessageDigest
extends MessageDigest {
    protected Digest digest;
    protected int digestSize;

    protected BCMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    protected BCMessageDigest(Xof xof, int n2) {
        super(xof.getAlgorithmName());
        this.digest = xof;
        this.digestSize = n2 / 8;
    }

    public void engineReset() {
        this.digest.reset();
    }

    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public int engineGetDigestLength() {
        return this.digestSize;
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[this.digestSize];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }
}

