/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.gcm.BasicGCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private BlockCipher cipher;
    private GCMMultiplier multiplier;
    private GCMExponentiator exp;
    private boolean forEncryption;
    private boolean initialised;
    private int macSize;
    private byte[] lastKey;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private byte[] H;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] S_at;
    private byte[] S_atPre;
    private byte[] counter;
    private int blocksRemaining;
    private int bufOff;
    private long totalLength;
    private byte[] atBlock;
    private int atBlockPos;
    private long atLength;
    private long atLengthPre;

    public GCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, null);
    }

    public GCMBlockCipher(BlockCipher blockCipher, GCMMultiplier gCMMultiplier) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (gCMMultiplier == null) {
            gCMMultiplier = new Tables4kGCMMultiplier();
        }
        this.cipher = blockCipher;
        this.multiplier = gCMMultiplier;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        CipherParameters cipherParameters2;
        this.forEncryption = bl2;
        this.macBlock = null;
        this.initialised = true;
        byte[] byArray = null;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)cipherParameters2).getNonce();
            this.initialAssociatedText = ((AEADParameters)cipherParameters2).getAssociatedText();
            int n2 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.macSize = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            this.initialAssociatedText = null;
            this.macSize = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = bl2 ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[n3];
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (bl2 && this.nonce != null && Arrays.areEqual(this.nonce, byArray)) {
            if (keyParameter == null) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
            if (this.lastKey != null && Arrays.areEqual(this.lastKey, keyParameter.getKey())) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
        }
        this.nonce = byArray;
        if (keyParameter != null) {
            this.lastKey = keyParameter.getKey();
        }
        if (keyParameter != null) {
            this.cipher.init(true, keyParameter);
            this.H = new byte[16];
            this.cipher.processBlock(this.H, 0, this.H, 0);
            this.multiplier.init(this.H);
            this.exp = null;
        } else if (this.H == null) {
            throw new IllegalArgumentException("Key must be specified in initial init");
        }
        this.J0 = new byte[16];
        if (this.nonce.length == 12) {
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            this.gHASH(this.J0, this.nonce, this.nonce.length);
            byte[] byArray2 = new byte[16];
            Pack.longToBigEndian((long)this.nonce.length * 8L, byArray2, 8);
            this.gHASHBlock(this.J0, byArray2);
        }
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = Arrays.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public byte[] getMac() {
        if (this.macBlock == null) {
            return new byte[this.macSize];
        }
        return Arrays.clone(this.macBlock);
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % 16;
    }

    public void processAADByte(byte by) {
        this.checkStatus();
        this.atBlock[this.atBlockPos] = by;
        if (++this.atBlockPos == 16) {
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.checkStatus();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.atBlock[this.atBlockPos] = byArray[n2 + i2];
            if (++this.atBlockPos != 16) continue;
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    private void initCipher() {
        if (this.atLength > 0L) {
            System.arraycopy(this.S_at, 0, this.S_atPre, 0, 16);
            this.atLengthPre = this.atLength;
        }
        if (this.atBlockPos > 0) {
            this.gHASHPartial(this.S_atPre, this.atBlock, 0, this.atBlockPos);
            this.atLengthPre += (long)this.atBlockPos;
        }
        if (this.atLengthPre > 0L) {
            System.arraycopy(this.S_atPre, 0, this.S, 0, 16);
        }
    }

    public int processByte(byte by, byte[] byArray, int n2) throws DataLengthException {
        this.checkStatus();
        this.bufBlock[this.bufOff] = by;
        if (++this.bufOff == this.bufBlock.length) {
            this.processBlock(this.bufBlock, 0, byArray, n2);
            if (this.forEncryption) {
                this.bufOff = 0;
            } else {
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
            }
            return 16;
        }
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        this.checkStatus();
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("Input buffer too short");
        }
        int n5 = 0;
        if (this.forEncryption) {
            if (this.bufOff != 0) {
                while (n3 > 0) {
                    --n3;
                    this.bufBlock[this.bufOff] = byArray[n2++];
                    if (++this.bufOff != 16) continue;
                    this.processBlock(this.bufBlock, 0, byArray2, n4);
                    this.bufOff = 0;
                    n5 += 16;
                    break;
                }
            }
            while (n3 >= 16) {
                this.processBlock(byArray, n2, byArray2, n4 + n5);
                n2 += 16;
                n3 -= 16;
                n5 += 16;
            }
            if (n3 > 0) {
                System.arraycopy(byArray, n2, this.bufBlock, 0, n3);
                this.bufOff = n3;
            }
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.bufBlock[this.bufOff] = byArray[n2 + i2];
                if (++this.bufOff != this.bufBlock.length) continue;
                this.processBlock(this.bufBlock, 0, byArray2, n4 + n5);
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
                n5 += 16;
            }
        }
        return n5;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        this.checkStatus();
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        int n3 = this.bufOff;
        if (this.forEncryption) {
            if (byArray.length - n2 < n3 + this.macSize) {
                throw new OutputLengthException("Output buffer too short");
            }
        } else {
            if (n3 < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            if (byArray.length - n2 < (n3 -= this.macSize)) {
                throw new OutputLengthException("Output buffer too short");
            }
        }
        if (n3 > 0) {
            this.processPartial(this.bufBlock, 0, n3, byArray, n2);
        }
        this.atLength += (long)this.atBlockPos;
        if (this.atLength > this.atLengthPre) {
            if (this.atBlockPos > 0) {
                this.gHASHPartial(this.S_at, this.atBlock, 0, this.atBlockPos);
            }
            if (this.atLengthPre > 0L) {
                GCMUtil.xor(this.S_at, this.S_atPre);
            }
            long l2 = this.totalLength * 8L + 127L >>> 7;
            byte[] byArray2 = new byte[16];
            if (this.exp == null) {
                this.exp = new BasicGCMExponentiator();
                this.exp.init(this.H);
            }
            this.exp.exponentiateX(l2, byArray2);
            GCMUtil.multiply(this.S_at, byArray2);
            GCMUtil.xor(this.S, this.S_at);
        }
        byte[] byArray3 = new byte[16];
        Pack.longToBigEndian(this.atLength * 8L, byArray3, 0);
        Pack.longToBigEndian(this.totalLength * 8L, byArray3, 8);
        this.gHASHBlock(this.S, byArray3);
        byte[] byArray4 = new byte[16];
        this.cipher.processBlock(this.J0, 0, byArray4, 0);
        GCMUtil.xor(byArray4, this.S);
        int n4 = n3;
        this.macBlock = new byte[this.macSize];
        System.arraycopy(byArray4, 0, this.macBlock, 0, this.macSize);
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, byArray, n2 + this.bufOff, this.macSize);
            n4 += this.macSize;
        } else {
            byte[] byArray5 = new byte[this.macSize];
            System.arraycopy(this.bufBlock, n3, byArray5, 0, this.macSize);
            if (!Arrays.constantTimeAreEqual(this.macBlock, byArray5)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.reset(false);
        return n4;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.cipher.reset();
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = Arrays.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            Arrays.fill(this.bufBlock, (byte)0);
        }
        if (bl2) {
            this.macBlock = null;
        }
        if (this.forEncryption) {
            this.initialised = false;
        } else if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private void processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray2.length - n3 < 16) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        byte[] byArray3 = new byte[16];
        this.getNextCTRBlock(byArray3);
        if (this.forEncryption) {
            GCMUtil.xor(byArray3, byArray, n2);
            this.gHASHBlock(this.S, byArray3);
            System.arraycopy(byArray3, 0, byArray2, n3, 16);
        } else {
            this.gHASHBlock(this.S, byArray, n2);
            GCMUtil.xor(byArray3, 0, byArray, n2, byArray2, n3);
        }
        this.totalLength += 16L;
    }

    private void processPartial(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[16];
        this.getNextCTRBlock(byArray3);
        if (this.forEncryption) {
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
            this.gHASHPartial(this.S, byArray, n2, n3);
        } else {
            this.gHASHPartial(this.S, byArray, n2, n3);
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        this.totalLength += (long)n3;
    }

    private void gHASH(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.gHASHPartial(byArray, byArray2, i2, n3);
        }
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2) {
        GCMUtil.xor(byArray, byArray2);
        this.multiplier.multiplyH(byArray);
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2, int n2) {
        GCMUtil.xor(byArray, byArray2, n2);
        this.multiplier.multiplyH(byArray);
    }

    private void gHASHPartial(byte[] byArray, byte[] byArray2, int n2, int n3) {
        GCMUtil.xor(byArray, byArray2, n2, n3);
        this.multiplier.multiplyH(byArray);
    }

    private void getNextCTRBlock(byte[] byArray) {
        if (this.blocksRemaining == 0) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        --this.blocksRemaining;
        int n2 = 1;
        this.counter[15] = (byte)(n2 += this.counter[15] & 0xFF);
        n2 >>>= 8;
        this.counter[14] = (byte)(n2 += this.counter[14] & 0xFF);
        n2 >>>= 8;
        this.counter[13] = (byte)(n2 += this.counter[13] & 0xFF);
        n2 >>>= 8;
        this.counter[12] = (byte)(n2 += this.counter[12] & 0xFF);
        this.cipher.processBlock(this.counter, 0, byArray, 0);
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }
}

