/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.dvcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class ServiceType
extends ASN1Object {
    public static final ServiceType CPD = new ServiceType(1);
    public static final ServiceType VSD = new ServiceType(2);
    public static final ServiceType VPKC = new ServiceType(3);
    public static final ServiceType CCPD = new ServiceType(4);
    private ASN1Enumerated value;

    public ServiceType(int n2) {
        this.value = new ASN1Enumerated(n2);
    }

    private ServiceType(ASN1Enumerated aSN1Enumerated) {
        this.value = aSN1Enumerated;
    }

    public static ServiceType getInstance(Object object) {
        if (object instanceof ServiceType) {
            return (ServiceType)object;
        }
        if (object != null) {
            return new ServiceType(ASN1Enumerated.getInstance(object));
        }
        return null;
    }

    public static ServiceType getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return ServiceType.getInstance(ASN1Enumerated.getInstance(aSN1TaggedObject, bl2));
    }

    public BigInteger getValue() {
        return this.value.getValue();
    }

    public ASN1Primitive toASN1Primitive() {
        return this.value;
    }

    public String toString() {
        int n2 = this.value.intValueExact();
        return "" + n2 + (n2 == ServiceType.CPD.value.intValueExact() ? "(CPD)" : (n2 == ServiceType.VSD.value.intValueExact() ? "(VSD)" : (n2 == ServiceType.VPKC.value.intValueExact() ? "(VPKC)" : (n2 == ServiceType.CCPD.value.intValueExact() ? "(CCPD)" : "?"))));
    }
}

