/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.StreamUtil;

public class DERSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public static DERSequence convert(ASN1Sequence aSN1Sequence) {
        return (DERSequence)aSN1Sequence.toDERObject();
    }

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DERSequence(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector);
    }

    public DERSequence(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray);
    }

    DERSequence(ASN1Encodable[] aSN1EncodableArray, boolean bl2) {
        super(aSN1EncodableArray, bl2);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int n2 = this.elements.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                ASN1Primitive aSN1Primitive = this.elements[i2].toASN1Primitive().toDERObject();
                n3 += aSN1Primitive.encodedLength();
            }
            this.bodyLength = n3;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int n2 = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        if (bl2) {
            aSN1OutputStream.write(48);
        }
        DEROutputStream dEROutputStream = aSN1OutputStream.getDERSubStream();
        int n2 = this.elements.length;
        if (this.bodyLength >= 0 || n2 > 16) {
            aSN1OutputStream.writeLength(this.getBodyLength());
            for (int i2 = 0; i2 < n2; ++i2) {
                ASN1Primitive aSN1Primitive = this.elements[i2].toASN1Primitive().toDERObject();
                aSN1Primitive.encode(dEROutputStream, true);
            }
        } else {
            int n3;
            int n4 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[n3] = aSN1Primitive = this.elements[n3].toASN1Primitive().toDERObject();
                n4 += aSN1Primitive.encodedLength();
            }
            this.bodyLength = n4;
            aSN1OutputStream.writeLength(n4);
            for (n3 = 0; n3 < n2; ++n3) {
                aSN1PrimitiveArray[n3].encode(dEROutputStream, true);
            }
        }
    }

    ASN1Primitive toDERObject() {
        return this;
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

