/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private final char[] string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERBMPString) {
            return DERBMPString.getInstance(aSN1Primitive);
        }
        return new DERBMPString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERBMPString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        int n2 = byArray.length;
        if (0 != (n2 & 1)) {
            throw new IllegalArgumentException("malformed BMPString encoding encountered");
        }
        int n3 = n2 / 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 != n3; ++i2) {
            cArray[i2] = (char)(byArray[2 * i2] << 8 | byArray[2 * i2 + 1] & 0xFF);
        }
        this.string = cArray;
    }

    DERBMPString(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = cArray;
    }

    public DERBMPString(String string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = string.toCharArray();
    }

    public String getString() {
        return new String(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    protected boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)aSN1Primitive;
        return Arrays.areEqual(this.string, dERBMPString.string);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length * 2) + this.string.length * 2;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        char c2;
        int n2;
        int n3;
        int n4 = this.string.length;
        if (bl2) {
            aSN1OutputStream.write(30);
        }
        aSN1OutputStream.writeLength(n4 * 2);
        byte[] byArray = new byte[8];
        int n5 = n4 & 0xFFFFFFFC;
        for (n3 = 0; n3 < n5; n3 += 4) {
            n2 = this.string[n3];
            c2 = this.string[n3 + 1];
            char c3 = this.string[n3 + 2];
            char c4 = this.string[n3 + 3];
            byArray[0] = (byte)(n2 >> 8);
            byArray[1] = (byte)n2;
            byArray[2] = (byte)(c2 >> 8);
            byArray[3] = (byte)c2;
            byArray[4] = (byte)(c3 >> 8);
            byArray[5] = (byte)c3;
            byArray[6] = (byte)(c4 >> 8);
            byArray[7] = (byte)c4;
            aSN1OutputStream.write(byArray, 0, 8);
        }
        if (n3 < n4) {
            n2 = 0;
            do {
                c2 = this.string[n3];
                byArray[n2++] = (byte)(c2 >> 8);
                byArray[n2++] = (byte)c2;
            } while (++n3 < n4);
            aSN1OutputStream.write(byArray, 0, n2);
        }
    }
}

