/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serializer.SerializerTrace;
import org.apache.xml.serializer.WriterChain;

final class SerializerTraceWriter
extends Writer
implements WriterChain {
    private final Writer m_writer;
    private final SerializerTrace m_tracer;
    private int buf_length;
    private byte[] buf;
    private int count;

    private void setBufferSize(int size) {
        this.buf = new byte[size + 3];
        this.buf_length = size;
        this.count = 0;
    }

    public SerializerTraceWriter(Writer out, SerializerTrace tracer) {
        this.m_writer = out;
        this.m_tracer = tracer;
        this.setBufferSize(1024);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            char[] chars = new char[this.count];
            for (int i2 = 0; i2 < this.count; ++i2) {
                chars[i2] = (char)this.buf[i2];
            }
            if (this.m_tracer != null) {
                this.m_tracer.fireGenerateEvent(12, chars, 0, chars.length);
            }
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
        this.flushBuffer();
    }

    public void write(int c2) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(c2);
        }
        if (this.count >= this.buf_length) {
            this.flushBuffer();
        }
        if (c2 < 128) {
            this.buf[this.count++] = (byte)c2;
        } else if (c2 < 2048) {
            this.buf[this.count++] = (byte)(192 + (c2 >> 6));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (c2 >> 12));
            this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(chars, start, length);
        }
        if ((lengthx3 = (length << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n2 = length + start;
        for (int i2 = start; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
                continue;
            }
            this.buf[this.count++] = (byte)(224 + (c2 >> 12));
            this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        }
    }

    public void write(String s2) throws IOException {
        int length;
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(s2);
        }
        if ((lengthx3 = ((length = s2.length()) << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
                continue;
            }
            this.buf[this.count++] = (byte)(224 + (c2 >> 12));
            this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        }
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public OutputStream getOutputStream() {
        OutputStream retval = null;
        if (this.m_writer instanceof WriterChain) {
            retval = ((WriterChain)((Object)this.m_writer)).getOutputStream();
        }
        return retval;
    }
}

