/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import java.text.CharacterIterator;
import java.util.Locale;
import java.util.Stack;
import org.apache.xerces.impl.xpath.regex.BMPattern;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.Op;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.ParserForXMLSchema;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegexParser;
import org.apache.xerces.impl.xpath.regex.Token;
import org.apache.xerces.util.IntStack;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 6242499334195006401L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op, boolean bl2) {
        Op op2;
        switch (token.type) {
            case 11: {
                op2 = Op.createDot();
                op2.next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token.getChar());
                op2.next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token.getChar());
                op2.next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token);
                op2.next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl2) {
                    int n2 = token.size() - 1;
                    while (n2 >= 0) {
                        op2 = this.compile(token.getChild(n2), op2, false);
                        --n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < token.size()) {
                        op2 = this.compile(token.getChild(n3), op2, true);
                        ++n3;
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token.size());
                int n4 = 0;
                while (n4 < token.size()) {
                    unionOp.addElement(this.compile(token.getChild(n4), op, bl2));
                    ++n4;
                }
                op2 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n5 = token.getMin();
                int n6 = token.getMax();
                if (n5 >= 0 && n5 == n6) {
                    op2 = op;
                    int n7 = 0;
                    while (n7 < n5) {
                        op2 = this.compile(token2, op2, bl2);
                        ++n7;
                    }
                } else {
                    if (n5 > 0 && n6 > 0) {
                        n6 -= n5;
                    }
                    if (n6 > 0) {
                        op2 = op;
                        int n8 = 0;
                        while (n8 < n6) {
                            Op.ChildOp childOp = Op.createQuestion(token.type == 9);
                            childOp.next = op;
                            childOp.setChild(this.compile(token2, op2, bl2));
                            op2 = childOp;
                            ++n8;
                        }
                    } else {
                        Op.ChildOp childOp = token.type == 9 ? Op.createNonGreedyClosure() : Op.createClosure(this.numberOfClosures++);
                        childOp.next = op;
                        childOp.setChild(this.compile(token2, childOp, bl2));
                        op2 = childOp;
                    }
                    if (n5 <= 0) break;
                    int n9 = 0;
                    while (n9 < n5) {
                        op2 = this.compile(token2, op2, bl2);
                        ++n9;
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token.getString());
                op2.next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token.getReferenceNumber());
                op2.next = op;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op2 = this.compile(token.getChild(0), op, bl2);
                    break;
                }
                if (bl2) {
                    op = Op.createCapture(token.getParenNumber(), op);
                    op = this.compile(token.getChild(0), op, bl2);
                    op2 = Op.createCapture(-token.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token.getParenNumber(), op);
                op = this.compile(token.getChild(0), op, bl2);
                op2 = Op.createCapture(token.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token.getChild(0), null, bl2));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token.getChild(0), null, bl2), ((Token.ModifierToken)token).getOptions(), ((Token.ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token;
                int n10 = conditionToken.refNumber;
                Op op3 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl2);
                Op op4 = this.compile(conditionToken.yes, op, bl2);
                Op op5 = conditionToken.no == null ? null : this.compile(conditionToken.no, op, bl2);
                op2 = Op.createCondition(op, n10, op3, op4, op5);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n2, int n3) {
        return this.matches(cArray, n2, n3, (Match)null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    public boolean matches(char[] cArray, int n2, int n3, Match match) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(cArray, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(cArray);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(cArray, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.setInUse(false);
                return true;
            }
            context.setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(cArray, context.start, context.limit)) < 0) {
            context.setInUse(false);
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.match(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c2 = cArray[n4];
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.match(context, this.operations, n4, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            n4 = context.start;
            while (n4 <= n5) {
                int n9 = cArray[n4];
                if (REUtil.isHighSurrogate(n9) && n4 + 1 < context.limit) {
                    n9 = REUtil.composeFromSurrogates(n9, cArray[n4 + 1]);
                }
                if (!rangeToken.match(n9) || 0 > (n8 = this.match(context, this.operations, n4, 1, this.options))) {
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.match(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.setInUse(false);
            return true;
        }
        context.setInUse(false);
        return false;
    }

    public boolean matches(String string) {
        return this.matches(string, 0, string.length(), (Match)null);
    }

    public boolean matches(String string, int n2, int n3) {
        return this.matches(string, n2, n3, (Match)null);
    }

    public boolean matches(String string, Match match) {
        return this.matches(string, 0, string.length(), match);
    }

    public boolean matches(String string, int n2, int n3, Match match) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(string, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(string);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(string, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.setInUse(false);
                return true;
            }
            context.setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(string, context.start, context.limit)) < 0) {
            context.setInUse(false);
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.match(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c2 = string.charAt(n4);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.match(context, this.operations, n4, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            n4 = context.start;
            while (n4 <= n5) {
                int n9 = string.charAt(n4);
                if (REUtil.isHighSurrogate(n9) && n4 + 1 < context.limit) {
                    n9 = REUtil.composeFromSurrogates(n9, string.charAt(n4 + 1));
                }
                if (!rangeToken.match(n9) || 0 > (n8 = this.match(context, this.operations, n4, 1, this.options))) {
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.match(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.setInUse(false);
            return true;
        }
        context.setInUse(false);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int match(Context var1_1, Op var2_2, int var3_3, int var4_4, int var5_5) {
        var6_6 = var1_1.target;
        var7_7 = new Stack<Op>();
        var8_8 = new IntStack();
        var9_9 = RegularExpression.isSet(var5_5, 2);
        var10_10 = -1;
        var11_11 = false;
        while (true) {
            block59: {
                if (var2_2 != null && var3_3 <= var1_1.limit && var3_3 >= var1_1.start) break block59;
                var10_10 = var2_2 == null ? (RegularExpression.isSet(var5_5, 512) != false && var3_3 != var1_1.limit ? -1 : var3_3) : -1;
                var11_11 = true;
                ** GOTO lbl243
            }
            var10_10 = -1;
            switch (var2_2.type) {
                case 1: {
                    v0 = var12_12 = var4_4 > 0 ? var3_3 : var3_3 - 1;
                    if (var12_12 >= var1_1.limit || var12_12 < 0 || !this.matchChar(var2_2.getData(), var6_6.charAt(var12_12), var9_9)) {
                        var11_11 = true;
                    } else {
                        var3_3 += var4_4;
                        var2_2 = var2_2.next;
                    }
                    ** GOTO lbl243
                }
                case 0: {
                    v1 = var12_13 = var4_4 > 0 ? var3_3 : var3_3 - 1;
                    if (var12_13 < var1_1.limit && var12_13 >= 0) ** GOTO lbl28
                    var11_11 = true;
                    ** GOTO lbl243
lbl28:
                    // 1 sources

                    if (!RegularExpression.isSet(var5_5, 4)) ** GOTO lbl32
                    if (REUtil.isHighSurrogate(var6_6.charAt(var12_13)) && var12_13 + var4_4 >= 0 && var12_13 + var4_4 < var1_1.limit) {
                        var12_13 += var4_4;
                    }
                    ** GOTO lbl-1000
lbl32:
                    // 1 sources

                    var13_23 = var6_6.charAt(var12_13);
                    if (REUtil.isHighSurrogate(var13_23) && var12_13 + var4_4 >= 0 && var12_13 + var4_4 < var1_1.limit) {
                        var13_23 = REUtil.composeFromSurrogates(var13_23, var6_6.charAt(var12_13 += var4_4));
                    }
                    if (RegularExpression.isEOLChar(var13_23)) {
                        var11_11 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var3_3 = var4_4 > 0 ? var12_13 + 1 : var12_13;
                        var2_2 = var2_2.next;
                    }
                    ** GOTO lbl243
                }
                case 3: 
                case 4: {
                    v2 = var12_14 = var4_4 > 0 ? var3_3 : var3_3 - 1;
                    if (var12_14 >= var1_1.limit || var12_14 < 0) {
                        var11_11 = true;
                    } else {
                        var13_23 = var6_6.charAt(var3_3);
                        if (REUtil.isHighSurrogate(var13_23) && var12_14 + var4_4 < var1_1.limit && var12_14 + var4_4 >= 0) {
                            var13_23 = REUtil.composeFromSurrogates(var13_23, var6_6.charAt(var12_14 += var4_4));
                        }
                        if (!(var14_24 = var2_2.getToken()).match(var13_23)) {
                            var11_11 = true;
                        } else {
                            var3_3 = var4_4 > 0 ? var12_14 + 1 : var12_14;
                            var2_2 = var2_2.next;
                        }
                    }
                    ** GOTO lbl243
                }
                case 5: {
                    if (!this.matchAnchor(var6_6, var2_2, var1_1, var3_3, var5_5)) {
                        var11_11 = true;
                    } else {
                        var2_2 = var2_2.next;
                    }
                    ** GOTO lbl243
                }
                case 16: {
                    var12_15 = var2_2.getData();
                    if (var12_15 <= 0 || var12_15 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + var12_15);
                    }
                    if (var1_1.match.getBeginning(var12_15) >= 0 && var1_1.match.getEnd(var12_15) >= 0) ** GOTO lbl68
                    var11_11 = true;
                    ** GOTO lbl243
lbl68:
                    // 1 sources

                    var13_23 = var1_1.match.getBeginning(var12_15);
                    var14_25 = var1_1.match.getEnd(var12_15) - var13_23;
                    if (var4_4 <= 0) ** GOTO lbl76
                    if (var6_6.regionMatches(var9_9, var3_3, var1_1.limit, var13_23, var14_25)) ** GOTO lbl74
                    var11_11 = true;
                    ** GOTO lbl243
lbl74:
                    // 1 sources

                    var3_3 += var14_25;
                    ** GOTO lbl80
lbl76:
                    // 1 sources

                    if (!var6_6.regionMatches(var9_9, var3_3 - var14_25, var1_1.limit, var13_23, var14_25)) {
                        var11_11 = true;
                    } else {
                        var3_3 -= var14_25;
lbl80:
                        // 2 sources

                        var2_2 = var2_2.next;
                    }
                    ** GOTO lbl243
                }
                case 6: {
                    var12_16 = var2_2.getString();
                    var13_23 = var12_16.length();
                    if (var4_4 <= 0) ** GOTO lbl91
                    if (var6_6.regionMatches(var9_9, var3_3, var1_1.limit, var12_16, var13_23)) ** GOTO lbl89
                    var11_11 = true;
                    ** GOTO lbl243
lbl89:
                    // 1 sources

                    var3_3 += var13_23;
                    ** GOTO lbl95
lbl91:
                    // 1 sources

                    if (!var6_6.regionMatches(var9_9, var3_3 - var13_23, var1_1.limit, var12_16, var13_23)) {
                        var11_11 = true;
                    } else {
                        var3_3 -= var13_23;
lbl95:
                        // 2 sources

                        var2_2 = var2_2.next;
                    }
                    ** GOTO lbl243
                }
                case 7: {
                    var12_17 = var2_2.getData();
                    if (!var1_1.closureContexts[var12_17].contains(var3_3)) ** GOTO lbl102
                    var11_11 = true;
                    ** GOTO lbl243
lbl102:
                    // 1 sources

                    var1_1.closureContexts[var12_17].addOffset(var3_3);
                }
                case 9: {
                    var7_7.push(var2_2);
                    var8_8.push(var3_3);
                    var2_2 = var2_2.getChild();
                    ** GOTO lbl243
                }
                case 8: 
                case 10: {
                    var7_7.push(var2_2);
                    var8_8.push(var3_3);
                    var2_2 = var2_2.next;
                    ** GOTO lbl243
                }
                case 11: {
                    if (var2_2.size() == 0) {
                        var11_11 = true;
                    } else {
                        var7_7.push(var2_2);
                        var8_8.push(0);
                        var8_8.push(var3_3);
                        var2_2 = var2_2.elementAt(0);
                    }
                    ** GOTO lbl243
                }
                case 15: {
                    var12_18 = var2_2.getData();
                    if (var1_1.match != null) {
                        if (var12_18 > 0) {
                            var8_8.push(var1_1.match.getBeginning(var12_18));
                            var1_1.match.setBeginning(var12_18, var3_3);
                        } else {
                            var13_23 = -var12_18;
                            var8_8.push(var1_1.match.getEnd(var13_23));
                            var1_1.match.setEnd(var13_23, var3_3);
                        }
                        var7_7.push(var2_2);
                        var8_8.push(var3_3);
                    }
                    var2_2 = var2_2.next;
                    ** GOTO lbl243
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    var7_7.push(var2_2);
                    var8_8.push(var4_4);
                    var8_8.push(var3_3);
                    var4_4 = var2_2.type == 20 || var2_2.type == 21 ? 1 : -1;
                    var2_2 = var2_2.getChild();
                    ** GOTO lbl243
                }
                case 24: {
                    var7_7.push(var2_2);
                    var8_8.push(var3_3);
                    var2_2 = var2_2.getChild();
                    ** GOTO lbl243
                }
                case 25: {
                    var12_19 = var5_5;
                    var12_19 |= var2_2.getData();
                    var7_7.push(var2_2);
                    var8_8.push(var5_5);
                    var8_8.push(var3_3);
                    var5_5 = var12_19 &= ~var2_2.getData2();
                    var2_2 = var2_2.getChild();
                    ** GOTO lbl243
                }
                case 26: {
                    var12_20 = (Op.ConditionOp)var2_2;
                    if (var12_20.refNumber <= 0) ** GOTO lbl171
                    if (var12_20.refNumber >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + var12_20.refNumber);
                    }
                    var2_2 = var1_1.match.getBeginning(var12_20.refNumber) >= 0 && var1_1.match.getEnd(var12_20.refNumber) >= 0 ? var12_20.yes : (var12_20.no != null ? var12_20.no : var12_20.next);
                    ** GOTO lbl243
lbl171:
                    // 1 sources

                    var7_7.push(var2_2);
                    var8_8.push(var3_3);
                    var2_2 = var12_20.condition;
                    if (true) ** GOTO lbl243
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + var2_2.type);
                }
            }
            do {
                if (var7_7.isEmpty()) {
                    return var10_10;
                }
                var2_2 = (Op)var7_7.pop();
                var3_3 = var8_8.pop();
                switch (var2_2.type) {
                    case 7: 
                    case 9: {
                        if (var10_10 >= 0) break;
                        var2_2 = var2_2.next;
                        var11_11 = false;
                        break;
                    }
                    case 8: 
                    case 10: {
                        if (var10_10 >= 0) break;
                        var2_2 = var2_2.getChild();
                        var11_11 = false;
                        break;
                    }
                    case 11: {
                        var12_21 = var8_8.pop();
                        if (var10_10 >= 0) break;
                        if (++var12_21 < var2_2.size()) {
                            var7_7.push(var2_2);
                            var8_8.push(var12_21);
                            var8_8.push(var3_3);
                            var2_2 = var2_2.elementAt(var12_21);
                            var11_11 = false;
                            break;
                        }
                        var10_10 = -1;
                        break;
                    }
                    case 15: {
                        var12_22 = var2_2.getData();
                        var13_23 = var8_8.pop();
                        if (var10_10 >= 0) break;
                        if (var12_22 > 0) {
                            var1_1.match.setBeginning(var12_22, var13_23);
                            break;
                        }
                        var1_1.match.setEnd(-var12_22, var13_23);
                        break;
                    }
                    case 20: 
                    case 22: {
                        var4_4 = var8_8.pop();
                        if (0 <= var10_10) {
                            var2_2 = var2_2.next;
                            var11_11 = false;
                        }
                        var10_10 = -1;
                        break;
                    }
                    case 21: 
                    case 23: {
                        var4_4 = var8_8.pop();
                        if (0 > var10_10) {
                            var2_2 = var2_2.next;
                            var11_11 = false;
                        }
                        var10_10 = -1;
                        break;
                    }
                    case 25: {
                        var5_5 = var8_8.pop();
                    }
                    case 24: {
                        if (var10_10 < 0) break;
                        var3_3 = var10_10;
                        var2_2 = var2_2.next;
                        var11_11 = false;
                        break;
                    }
                    case 26: {
                        var14_24 = (Op.ConditionOp)var2_2;
                        var2_2 = 0 <= var10_10 ? var14_24.yes : (var14_24.no != null ? var14_24.no : var14_24.next);
                        var11_11 = false;
                        break;
                    }
                }
lbl243:
                // 45 sources

            } while (var11_11);
        }
    }

    private boolean matchChar(int n2, int n3, boolean bl2) {
        return bl2 ? RegularExpression.matchIgnoreCase(n2, n3) : n2 == n3;
    }

    boolean matchAnchor(ExpressionTarget expressionTarget, Op op, Context context, int n2, int n3) {
        boolean bl2 = false;
        switch (op.getData()) {
            case 94: {
                if (!(RegularExpression.isSet(n3, 8) ? n2 != context.start && (n2 <= context.start || n2 >= context.limit || !RegularExpression.isEOLChar(expressionTarget.charAt(n2 - 1))) : n2 != context.start)) break;
                return false;
            }
            case 64: {
                if (n2 == context.start || n2 > context.start && RegularExpression.isEOLChar(expressionTarget.charAt(n2 - 1))) break;
                return false;
            }
            case 36: {
                if (!(RegularExpression.isSet(n3, 8) ? n2 != context.limit && (n2 >= context.limit || !RegularExpression.isEOLChar(expressionTarget.charAt(n2))) : !(n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(expressionTarget.charAt(n2)) || n2 + 2 == context.limit && expressionTarget.charAt(n2) == '\r' && expressionTarget.charAt(n2 + 1) == '\n'))) break;
                return false;
            }
            case 65: {
                if (n2 == context.start) break;
                return false;
            }
            case 90: {
                if (n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(expressionTarget.charAt(n2)) || n2 + 2 == context.limit && expressionTarget.charAt(n2) == '\r' && expressionTarget.charAt(n2 + 1) == '\n') break;
                return false;
            }
            case 122: {
                if (n2 == context.limit) break;
                return false;
            }
            case 98: {
                if (context.length == 0) {
                    return false;
                }
                int n4 = RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3);
                if (n4 == 0) {
                    return false;
                }
                int n5 = RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3);
                if (n4 != n5) break;
                return false;
            }
            case 66: {
                if (context.length == 0) {
                    bl2 = true;
                } else {
                    int n6 = RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3);
                    boolean bl3 = bl2 = n6 == 0 || n6 == RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3);
                }
                if (bl2) break;
                return false;
            }
            case 60: {
                if (context.length == 0 || n2 == context.limit) {
                    return false;
                }
                if (RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3) == 1 && RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3) == 2) break;
                return false;
            }
            case 62: {
                if (context.length == 0 || n2 == context.start) {
                    return false;
                }
                if (RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3) == 2 && RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3) == 1) break;
                return false;
            }
        }
        return true;
    }

    private static final int getPreviousWordType(ExpressionTarget expressionTarget, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(expressionTarget, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(expressionTarget, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(ExpressionTarget expressionTarget, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(expressionTarget.charAt(n4), n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n2;
        int n3;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        context.match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.setInUse(false);
                return true;
            }
            context.setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n3 = this.fixedStringTable.matches(characterIterator, context.start, context.limit)) < 0) {
            context.setInUse(false);
            return false;
        }
        n3 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = context.start;
                n8 = this.match(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl2 = true;
                n2 = context.start;
                while (n2 <= n3) {
                    char c2 = characterIterator.setIndex(n2);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl2 = true;
                    } else {
                        if (bl2 && 0 <= (n8 = this.match(context, this.operations, n2, 1, this.options))) break;
                        bl2 = false;
                    }
                    ++n2;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            n2 = context.start;
            while (n2 <= n3) {
                int n9 = characterIterator.setIndex(n2);
                if (REUtil.isHighSurrogate(n9) && n2 + 1 < context.limit) {
                    n9 = REUtil.composeFromSurrogates(n9, characterIterator.setIndex(n2 + 1));
                }
                if (!rangeToken.match(n9) || 0 > (n8 = this.match(context, this.operations, n2, 1, this.options))) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            n2 = context.start;
            while (n2 <= n3) {
                n8 = this.match(context, this.operations, n2, 1, this.options);
                if (0 > n8) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n2);
                context.match.setEnd(0, n8);
            }
            context.setInUse(false);
            return true;
        }
        context.setInUse(false);
        return false;
    }

    void prepare() {
        Object object;
        int n2;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n2 = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object = new char[1];
                object[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object, this.options);
            this.fixedString = ((Token.FixedStringContainer)object).token == null ? null : ((Token.FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n2, int n3) {
        return (n2 & n3) == n3;
    }

    public RegularExpression(String string) throws ParseException {
        this(string, null);
    }

    public RegularExpression(String string, String string2) throws ParseException {
        this.setPattern(string, string2);
    }

    public RegularExpression(String string, String string2, Locale locale) throws ParseException {
        this.setPattern(string, string2, locale);
    }

    RegularExpression(String string, Token token, int n2, boolean bl2, int n3) {
        this.regex = string;
        this.tokentree = token;
        this.nofparen = n2;
        this.options = n3;
        this.hasBackReferences = bl2;
    }

    public void setPattern(String string) throws ParseException {
        this.setPattern(string, Locale.getDefault());
    }

    public void setPattern(String string, Locale locale) throws ParseException {
        this.setPattern(string, this.options, locale);
    }

    private void setPattern(String string, int n2, Locale locale) throws ParseException {
        this.regex = string;
        this.options = n2;
        RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema(locale) : new RegexParser(locale);
        this.tokentree = regexParser.parse(this.regex, this.options);
        this.nofparen = regexParser.parennumber;
        this.hasBackReferences = regexParser.hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string, String string2) throws ParseException {
        this.setPattern(string, string2, Locale.getDefault());
    }

    public void setPattern(String string, String string2, Locale locale) throws ParseException {
        this.setPattern(string, REUtil.parseOptions(string2), locale);
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string, int n2) {
        return this.regex.equals(string) && this.options == n2;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c2, int n2) {
        if (!RegularExpression.isSet(n2, 64)) {
            if (RegularExpression.isSet(n2, 32)) {
                return Token.getRange("IsWord", true).match(c2) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c2) ? 1 : 2;
        }
        switch (Character.getType(c2)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n2) {
        return n2 == 10 || n2 == 13 || n2 == 8232 || n2 == 8233;
    }

    private static final boolean isWordChar(int n2) {
        if (n2 == 95) {
            return true;
        }
        if (n2 < 48) {
            return false;
        }
        if (n2 > 122) {
            return false;
        }
        if (n2 <= 57) {
            return true;
        }
        if (n2 < 65) {
            return false;
        }
        if (n2 <= 90) {
            return true;
        }
        return n2 >= 97;
    }

    private static final boolean matchIgnoreCase(int n2, int n3) {
        char c2;
        if (n2 == n3) {
            return true;
        }
        if (n2 > 65535 || n3 > 65535) {
            return false;
        }
        char c3 = Character.toUpperCase((char)n2);
        if (c3 == (c2 = Character.toUpperCase((char)n3))) {
            return true;
        }
        return Character.toLowerCase(c3) == Character.toLowerCase(c2);
    }

    static final class Context {
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        ClosureContext[] closureContexts;
        private StringTarget stringTarget;
        private CharArrayTarget charArrayTarget;
        private CharacterIteratorTarget characterIteratorTarget;
        ExpressionTarget target;

        Context() {
        }

        private void resetCommon(int n2) {
            this.length = this.limit - this.start;
            this.setInUse(true);
            this.match = null;
            if (this.closureContexts == null || this.closureContexts.length != n2) {
                this.closureContexts = new ClosureContext[n2];
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.closureContexts[n3] == null) {
                    this.closureContexts[n3] = new ClosureContext();
                } else {
                    this.closureContexts[n3].reset();
                }
                ++n3;
            }
        }

        void reset(CharacterIterator characterIterator, int n2, int n3, int n4) {
            if (this.characterIteratorTarget == null) {
                this.characterIteratorTarget = new CharacterIteratorTarget(characterIterator);
            } else {
                this.characterIteratorTarget.resetTarget(characterIterator);
            }
            this.target = this.characterIteratorTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(String string, int n2, int n3, int n4) {
            if (this.stringTarget == null) {
                this.stringTarget = new StringTarget(string);
            } else {
                this.stringTarget.resetTarget(string);
            }
            this.target = this.stringTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(char[] cArray, int n2, int n3, int n4) {
            if (this.charArrayTarget == null) {
                this.charArrayTarget = new CharArrayTarget(cArray);
            } else {
                this.charArrayTarget.resetTarget(cArray);
            }
            this.target = this.charArrayTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        synchronized void setInUse(boolean bl2) {
            this.inuse = bl2;
        }
    }

    static final class ClosureContext {
        int[] offsets = new int[4];
        int currentIndex = 0;

        ClosureContext() {
        }

        boolean contains(int n2) {
            int n3 = 0;
            while (n3 < this.currentIndex) {
                if (this.offsets[n3] == n2) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        void reset() {
            this.currentIndex = 0;
        }

        void addOffset(int n2) {
            if (this.currentIndex == this.offsets.length) {
                this.offsets = this.expandOffsets();
            }
            this.offsets[this.currentIndex++] = n2;
        }

        private int[] expandOffsets() {
            int n2 = this.offsets.length;
            int n3 = n2 << 1;
            int[] nArray = new int[n3];
            System.arraycopy(this.offsets, 0, nArray, 0, this.currentIndex);
            return nArray;
        }
    }

    static final class CharacterIteratorTarget
    extends ExpressionTarget {
        CharacterIterator target;

        CharacterIteratorTarget(CharacterIterator characterIterator) {
            this.target = characterIterator;
        }

        final void resetTarget(CharacterIterator characterIterator) {
            this.target = characterIterator;
        }

        final char charAt(int n2) {
            return this.target.setIndex(n2);
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, String string, int n4) {
            if (n2 < 0 || n3 - n2 < n4) {
                return false;
            }
            return bl2 ? this.regionMatchesIgnoreCase(n2, n3, string, n4) : this.regionMatches(n2, n3, string, n4);
        }

        private final boolean regionMatches(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                if (this.target.setIndex(n2++) == string.charAt(n5++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target.setIndex(n2++)) == (c4 = string.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, int n4, int n5) {
            if (n2 < 0 || n3 - n2 < n5) {
                return false;
            }
            return bl2 ? this.regionMatchesIgnoreCase(n2, n3, n4, n5) : this.regionMatches(n2, n3, n4, n5);
        }

        private final boolean regionMatches(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                if (this.target.setIndex(n2++) == this.target.setIndex(n6++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target.setIndex(n2++)) == (c4 = this.target.setIndex(n6++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
    }

    static final class CharArrayTarget
    extends ExpressionTarget {
        char[] target;

        CharArrayTarget(char[] cArray) {
            this.target = cArray;
        }

        final void resetTarget(char[] cArray) {
            this.target = cArray;
        }

        char charAt(int n2) {
            return this.target[n2];
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, String string, int n4) {
            if (n2 < 0 || n3 - n2 < n4) {
                return false;
            }
            return bl2 ? this.regionMatchesIgnoreCase(n2, n3, string, n4) : this.regionMatches(n2, n3, string, n4);
        }

        private final boolean regionMatches(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                if (this.target[n2++] == string.charAt(n5++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target[n2++]) == (c4 = string.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, int n4, int n5) {
            if (n2 < 0 || n3 - n2 < n5) {
                return false;
            }
            return bl2 ? this.regionMatchesIgnoreCase(n2, n3, n4, n5) : this.regionMatches(n2, n3, n4, n5);
        }

        private final boolean regionMatches(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                if (this.target[n2++] == this.target[n6++]) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target[n2++]) == (c4 = this.target[n6++]) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
    }

    static final class StringTarget
    extends ExpressionTarget {
        private String target;

        StringTarget(String string) {
            this.target = string;
        }

        final void resetTarget(String string) {
            this.target = string;
        }

        final char charAt(int n2) {
            return this.target.charAt(n2);
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, String string, int n4) {
            if (n3 - n2 < n4) {
                return false;
            }
            return bl2 ? this.target.regionMatches(true, n2, string, 0, n4) : this.target.regionMatches(n2, string, 0, n4);
        }

        final boolean regionMatches(boolean bl2, int n2, int n3, int n4, int n5) {
            if (n3 - n2 < n5) {
                return false;
            }
            return bl2 ? this.target.regionMatches(true, n2, this.target, n4, n5) : this.target.regionMatches(n2, this.target, n4, n5);
        }
    }

    static abstract class ExpressionTarget {
        ExpressionTarget() {
        }

        abstract char charAt(int var1);

        abstract boolean regionMatches(boolean var1, int var2, int var3, String var4, int var5);

        abstract boolean regionMatches(boolean var1, int var2, int var3, int var4, int var5);
    }
}

