/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.util.ShortListImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSValue;

public class ValidatedInfo
implements XSValue {
    public String normalizedValue;
    public Object actualValue;
    public short actualValueType;
    public XSSimpleType actualType;
    public XSSimpleType memberType;
    public XSSimpleType[] memberTypes;
    public ShortList itemValueTypes;

    public void reset() {
        this.normalizedValue = null;
        this.actualValue = null;
        this.actualValueType = (short)45;
        this.actualType = null;
        this.memberType = null;
        this.memberTypes = null;
        this.itemValueTypes = null;
    }

    public String stringValue() {
        if (this.actualValue == null) {
            return this.normalizedValue;
        }
        return this.actualValue.toString();
    }

    public static boolean isComparable(ValidatedInfo validatedInfo, ValidatedInfo validatedInfo2) {
        short s2;
        short s3 = ValidatedInfo.convertToPrimitiveKind(validatedInfo.actualValueType);
        if (s3 != (s2 = ValidatedInfo.convertToPrimitiveKind(validatedInfo2.actualValueType))) {
            return s3 == 1 && s2 == 2 || s3 == 2 && s2 == 1;
        }
        if (s3 == 44 || s3 == 43) {
            int n2;
            ShortList shortList = validatedInfo.itemValueTypes;
            ShortList shortList2 = validatedInfo2.itemValueTypes;
            int n3 = shortList != null ? shortList.getLength() : 0;
            int n4 = n2 = shortList2 != null ? shortList2.getLength() : 0;
            if (n3 != n2) {
                return false;
            }
            int n5 = 0;
            while (n5 < n3) {
                short s4;
                short s5 = ValidatedInfo.convertToPrimitiveKind(shortList.item(n5));
                if (!(s5 == (s4 = ValidatedInfo.convertToPrimitiveKind(shortList2.item(n5))) || s5 == 1 && s4 == 2 || s5 == 2 && s4 == 1)) {
                    return false;
                }
                ++n5;
            }
        }
        return true;
    }

    private static short convertToPrimitiveKind(short s2) {
        if (s2 <= 20) {
            return s2;
        }
        if (s2 <= 29) {
            return 2;
        }
        if (s2 <= 42) {
            return 4;
        }
        return s2;
    }

    public Object getActualValue() {
        return this.actualValue;
    }

    public short getActualValueType() {
        return this.actualValueType;
    }

    public ShortList getListValueTypes() {
        return this.itemValueTypes == null ? ShortListImpl.EMPTY_LIST : this.itemValueTypes;
    }

    public XSObjectList getMemberTypeDefinitions() {
        if (this.memberTypes == null) {
            return XSObjectListImpl.EMPTY_LIST;
        }
        return new XSObjectListImpl(this.memberTypes, this.memberTypes.length);
    }

    public String getNormalizedValue() {
        return this.normalizedValue;
    }

    public XSSimpleTypeDefinition getTypeDefinition() {
        return this.actualType;
    }

    public XSSimpleTypeDefinition getMemberTypeDefinition() {
        return this.memberType;
    }

    public void copyFrom(XSValue xSValue) {
        if (xSValue == null) {
            this.reset();
        } else if (xSValue instanceof ValidatedInfo) {
            ValidatedInfo validatedInfo = (ValidatedInfo)xSValue;
            this.normalizedValue = validatedInfo.normalizedValue;
            this.actualValue = validatedInfo.actualValue;
            this.actualValueType = validatedInfo.actualValueType;
            this.actualType = validatedInfo.actualType;
            this.memberType = validatedInfo.memberType;
            this.memberTypes = validatedInfo.memberTypes;
            this.itemValueTypes = validatedInfo.itemValueTypes;
        } else {
            XSSimpleType xSSimpleType;
            this.normalizedValue = xSValue.getNormalizedValue();
            this.actualValue = xSValue.getActualValue();
            this.actualValueType = xSValue.getActualValueType();
            this.actualType = (XSSimpleType)xSValue.getTypeDefinition();
            this.memberType = (XSSimpleType)xSValue.getMemberTypeDefinition();
            XSSimpleType xSSimpleType2 = xSSimpleType = this.memberType == null ? this.actualType : this.memberType;
            if (xSSimpleType != null && xSSimpleType.getBuiltInKind() == 43) {
                XSObjectList xSObjectList = xSValue.getMemberTypeDefinitions();
                this.memberTypes = new XSSimpleType[xSObjectList.getLength()];
                int n2 = 0;
                while (n2 < xSObjectList.getLength()) {
                    this.memberTypes[n2] = (XSSimpleType)xSObjectList.get(n2);
                    ++n2;
                }
            } else {
                this.memberTypes = null;
            }
            this.itemValueTypes = xSValue.getListValueTypes();
        }
    }
}

