/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A b2, A c2) {
        return a10 -> ComparableUtils.is(a10).between(b2, c2);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A b2, A c2) {
        return a10 -> ComparableUtils.is(a10).betweenExclusive(b2, c2);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A b2) {
        return a10 -> ComparableUtils.is(a10).greaterThanOrEqualTo(b2);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A b2) {
        return a10 -> ComparableUtils.is(a10).greaterThan(b2);
    }

    public static <A extends Comparable<A>> ComparableCheckBuilder<A> is(A a10) {
        return new ComparableCheckBuilder(a10, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A b2) {
        return a10 -> ComparableUtils.is(a10).lessThanOrEqualTo(b2);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A b2) {
        return a10 -> ComparableUtils.is(a10).lessThan(b2);
    }

    public static <A extends Comparable<A>> A max(A comparable1, A comparable2) {
        return ObjectUtils.compare(comparable1, comparable2, false) > 0 ? comparable1 : comparable2;
    }

    public static <A extends Comparable<A>> A min(A comparable1, A comparable2) {
        return ObjectUtils.compare(comparable1, comparable2, true) < 0 ? comparable1 : comparable2;
    }

    private ComparableUtils() {
    }

    public static class ComparableCheckBuilder<A extends Comparable<A>> {
        private final A a;

        private ComparableCheckBuilder(A a10) {
            this.a = a10;
        }

        public boolean between(A b2, A c2) {
            return this.betweenOrdered(b2, c2) || this.betweenOrdered(c2, b2);
        }

        public boolean betweenExclusive(A b2, A c2) {
            return this.betweenOrderedExclusive(b2, c2) || this.betweenOrderedExclusive(c2, b2);
        }

        private boolean betweenOrdered(A b2, A c2) {
            return this.greaterThanOrEqualTo(b2) && this.lessThanOrEqualTo(c2);
        }

        private boolean betweenOrderedExclusive(A b2, A c2) {
            return this.greaterThan(b2) && this.lessThan(c2);
        }

        public boolean equalTo(A b2) {
            return this.a.compareTo(b2) == 0;
        }

        public boolean greaterThan(A b2) {
            return this.a.compareTo(b2) > 0;
        }

        public boolean greaterThanOrEqualTo(A b2) {
            return this.a.compareTo(b2) >= 0;
        }

        public boolean lessThan(A b2) {
            return this.a.compareTo(b2) < 0;
        }

        public boolean lessThanOrEqualTo(A b2) {
            return this.a.compareTo(b2) <= 0;
        }

        /* synthetic */ ComparableCheckBuilder(Comparable x0, 1 x1) {
            this(x0);
        }
    }
}

