/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.jdk;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;

class JDK11Hooks
extends JDKHooks {
    private static final ClassLoader systemClassLoader = new PsuedoSystemClassLoader();

    JDK11Hooks() {
    }

    public ClassLoader getThreadContextClassLoader() {
        return null;
    }

    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public Enumeration getResources(ClassLoader loader, String resourceName) throws IOException {
        final URL first = loader.getResource(resourceName);
        final Enumeration<URL> rest = loader.getResources(resourceName);
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = first == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL o2 = this.next;
                this.next = this.getNext();
                return o2;
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL n2;
                if (!this.firstDone) {
                    this.firstDone = true;
                    n2 = first;
                } else {
                    n2 = null;
                    while (rest.hasMoreElements() && n2 == null) {
                        n2 = (URL)rest.nextElement();
                        if (first == null || n2 == null || !n2.equals(first)) continue;
                        n2 = null;
                    }
                }
                return n2;
            }
        };
    }
}

