/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.UnitValue;

public final class AC
implements Externalizable {
    private final ArrayList<DimConstraint> cList = new ArrayList(1);
    private transient int curIx = 0;

    public AC() {
        this.cList.add(new DimConstraint());
    }

    public final DimConstraint[] getConstaints() {
        return this.cList.toArray(new DimConstraint[this.cList.size()]);
    }

    public final void setConstaints(DimConstraint[] constr) {
        if (constr == null || constr.length < 1) {
            constr = new DimConstraint[]{new DimConstraint()};
        }
        this.cList.clear();
        this.cList.ensureCapacity(constr.length);
        for (DimConstraint c2 : constr) {
            this.cList.add(c2);
        }
    }

    public int getCount() {
        return this.cList.size();
    }

    public final AC count(int size) {
        this.makeSize(size);
        return this;
    }

    public final AC noGrid() {
        return this.noGrid(this.curIx);
    }

    public final AC noGrid(int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setNoGrid(true);
        }
        return this;
    }

    public final AC index(int i2) {
        this.makeSize(i2);
        this.curIx = i2;
        return this;
    }

    public final AC fill() {
        return this.fill(this.curIx);
    }

    public final AC fill(int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setFill(true);
        }
        return this;
    }

    public final AC sizeGroup() {
        return this.sizeGroup("", this.curIx);
    }

    public final AC sizeGroup(String s2) {
        return this.sizeGroup(s2, this.curIx);
    }

    public final AC sizeGroup(String s2, int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setSizeGroup(s2);
        }
        return this;
    }

    public final AC size(String s2) {
        return this.size(s2, this.curIx);
    }

    public final AC size(String size, int ... indexes) {
        BoundSize bs2 = ConstraintParser.parseBoundSize(size, false, true);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setSize(bs2);
        }
        return this;
    }

    public final AC gap() {
        ++this.curIx;
        this.makeSize(this.curIx);
        return this;
    }

    public final AC gap(String size) {
        return this.gap(size, this.curIx++);
    }

    public final AC gap(String size, int ... indexes) {
        BoundSize bsa = size != null ? ConstraintParser.parseBoundSize(size, true, true) : null;
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix + 1);
            if (bsa == null) continue;
            this.cList.get(ix).setGapAfter(bsa);
        }
        return this;
    }

    public final AC align(String side) {
        return this.align(side, this.curIx);
    }

    public final AC align(String side, int ... indexes) {
        UnitValue al2 = ConstraintParser.parseAlignKeywords(side, true);
        if (al2 == null) {
            al2 = ConstraintParser.parseAlignKeywords(side, false);
        }
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setAlign(al2);
        }
        return this;
    }

    public final AC growPrio(int p2) {
        return this.growPrio(p2, this.curIx);
    }

    public final AC growPrio(int p2, int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setGrowPriority(p2);
        }
        return this;
    }

    public final AC grow() {
        return this.grow(100.0f, this.curIx);
    }

    public final AC grow(float w2) {
        return this.grow(w2, this.curIx);
    }

    public final AC grow(float w2, int ... indexes) {
        Float gw = new Float(w2);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setGrow(gw);
        }
        return this;
    }

    public final AC shrinkPrio(int p2) {
        return this.shrinkPrio(p2, this.curIx);
    }

    public final AC shrinkPrio(int p2, int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setShrinkPriority(p2);
        }
        return this;
    }

    public final AC shrink() {
        return this.shrink(100.0f, this.curIx);
    }

    public final AC shrink(float w2) {
        return this.shrink(w2, this.curIx);
    }

    public final AC shrink(float w2, int ... indexes) {
        Float sw = new Float(w2);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setShrink(sw);
        }
        return this;
    }

    public final AC shrinkWeight(float w2) {
        return this.shrink(w2);
    }

    public final AC shrinkWeight(float w2, int ... indexes) {
        return this.shrink(w2, indexes);
    }

    private void makeSize(int sz) {
        if (this.cList.size() <= sz) {
            this.cList.ensureCapacity(sz);
            for (int i2 = this.cList.size(); i2 <= sz; ++i2) {
                this.cList.add(new DimConstraint());
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return LayoutUtil.getSerializedObject(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        LayoutUtil.setSerializedObject(this, LayoutUtil.readAsXML(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getClass() == AC.class) {
            LayoutUtil.writeAsXML(out, this);
        }
    }
}

