/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_SALSA20_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Salsa20Parameters
implements Parameters {
    protected byte[] pBlockCounter;
    protected byte[] pNonce;

    public Salsa20Parameters(byte[] pBlockCounter, byte[] pNonce) {
        this.pBlockCounter = pBlockCounter;
        this.pNonce = pNonce;
    }

    public Object clone() {
        return new Salsa20Parameters(this.pBlockCounter, this.pNonce);
    }

    public Object getPKCS11ParamsObject() {
        CK_SALSA20_PARAMS params = new CK_SALSA20_PARAMS();
        params.pBlockCounter = this.pBlockCounter;
        params.pNonce = this.pNonce;
        return params;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pNonce: ");
        buffer.append(Functions.toHexString(this.pNonce));
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Salsa20Parameters) {
            Salsa20Parameters other = (Salsa20Parameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pNonce, other.pNonce) && Functions.equals(this.pBlockCounter, other.pBlockCounter);
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pNonce) ^ Functions.hashCode(this.pBlockCounter);
    }
}

