/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.MessageParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_GCM_MESSAGE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class GcmMessageParameters
implements Parameters,
MessageParameters {
    protected byte[] pIv;
    protected long ulIvFixedBits;
    protected long ivGenerator;
    protected byte[] pTag;

    public GcmMessageParameters(byte[] pIv, long ulIvFixedBits, long ivGenerator, byte[] pTag) {
        if (pIv == null) {
            throw new NullPointerException("Argument \"pIv\" must not be null.");
        }
        this.pIv = pIv;
        this.ulIvFixedBits = ulIvFixedBits;
        this.pTag = pTag;
    }

    public Object clone() {
        return new GcmMessageParameters((byte[])this.pIv.clone(), this.ulIvFixedBits, this.ivGenerator, (byte[])this.pTag.clone());
    }

    public Object getPKCS11ParamsObject() {
        CK_GCM_MESSAGE_PARAMS params = new CK_GCM_MESSAGE_PARAMS();
        params.pIv = this.pIv;
        params.ulIvFixedBits = this.ulIvFixedBits;
        params.ivGenerator = this.ivGenerator;
        params.pTag = this.pTag;
        return params;
    }

    public void setValuesFromPKCS11Object(Object obj) {
        if (obj instanceof CK_GCM_MESSAGE_PARAMS) {
            this.pIv = ((CK_GCM_MESSAGE_PARAMS)obj).pIv;
            this.ulIvFixedBits = ((CK_GCM_MESSAGE_PARAMS)obj).ulIvFixedBits;
            this.ivGenerator = ((CK_GCM_MESSAGE_PARAMS)obj).ivGenerator;
            this.pTag = ((CK_GCM_MESSAGE_PARAMS)obj).pTag;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pIV: ");
        buffer.append(Functions.toHexString(this.pIv));
        buffer.append(Constants.NEWLINE);
        buffer.append("pTag: ");
        buffer.append(Functions.toHexString(this.pTag));
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof GcmMessageParameters) {
            GcmMessageParameters other = (GcmMessageParameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pIv, other.pIv) && Functions.equals(this.pTag, other.pTag) && this.ulIvFixedBits == other.ulIvFixedBits && this.ivGenerator == other.ivGenerator;
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pIv) ^ Functions.hashCode(this.pTag) ^ new Long(this.ivGenerator).hashCode() ^ new Long(this.ulIvFixedBits).hashCode();
    }
}

