/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_ECDSA_ECIES_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class EcdsaEciesParams
implements Parameters {
    public long hashAlg;
    public long cryptAlg;
    public long cryptOpt;
    public long macAlg;
    public long macOpt;
    public byte[] sharedSecret1;
    public byte[] sharedSecret2;

    public EcdsaEciesParams(long hashAlg, long cryptAlg, long cryptOpt, long macAlg, long macOpt) {
        this(hashAlg, cryptAlg, cryptOpt, macAlg, macOpt, null, null);
    }

    public EcdsaEciesParams(long hashAlg, long cryptAlg, long cryptOpt, long macAlg, long macOpt, byte[] sharedSecret1, byte[] sharedSecret2) {
        this.hashAlg = hashAlg;
        this.cryptAlg = cryptAlg;
        this.cryptOpt = cryptOpt;
        this.macAlg = macAlg;
        this.macOpt = macOpt;
        this.sharedSecret1 = sharedSecret1 == null ? null : (byte[])sharedSecret1.clone();
        this.sharedSecret2 = sharedSecret2 == null ? null : (byte[])sharedSecret2.clone();
    }

    public Object getPKCS11ParamsObject() {
        CK_ECDSA_ECIES_PARAMS pkcs11Params = new CK_ECDSA_ECIES_PARAMS();
        pkcs11Params.hashAlg = this.hashAlg;
        pkcs11Params.cryptAlg = this.cryptAlg;
        pkcs11Params.cryptOpt = this.cryptOpt;
        pkcs11Params.macAlg = this.macAlg;
        pkcs11Params.macOpt = this.macOpt;
        pkcs11Params.pSharedSecret1 = this.sharedSecret1 == null ? null : (byte[])this.sharedSecret1.clone();
        pkcs11Params.pSharedSecret2 = this.sharedSecret2 == null ? null : (byte[])this.sharedSecret2.clone();
        return pkcs11Params;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("  ");
        buffer.append(super.toString());
        buffer.append(": ");
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("hash algorithm:         ");
        buffer.append(Functions.mechanismCodeToString(this.hashAlg));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("crypto algorithm:       ");
        buffer.append(Functions.mechanismCodeToString(this.cryptAlg));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("crypto options:         ");
        buffer.append(this.cryptOpt);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("mac algorithm:          ");
        buffer.append(Functions.mechanismCodeToString(this.macAlg));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("mac    options:         ");
        buffer.append(this.macOpt);
        if (this.sharedSecret1 != null) {
            buffer.append(Constants.NEWLINE);
            buffer.append("  ");
            buffer.append("  ");
            buffer.append("shared secret1 (len):   ");
            buffer.append(this.sharedSecret1.length);
        }
        if (this.sharedSecret2 != null) {
            buffer.append(Constants.NEWLINE);
            buffer.append("  ");
            buffer.append("  ");
            buffer.append("shared secret2 (len):   ");
            buffer.append(this.sharedSecret2.length);
        }
        buffer.append(Constants.NEWLINE);
        return buffer.toString();
    }
}

