/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X942DHPrivateKey
extends DHPrivateKey {
    protected ByteArrayAttribute subprime_;

    public X942DHPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected X942DHPrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X942DHPrivateKey(session, objectHandle);
    }

    protected static void putAttributesInTable(X942DHPrivateKey object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.PRIME, object.prime_);
        object.attributeTable_.put(Attribute.BASE, object.base_);
        object.attributeTable_.put(Attribute.SUBPRIME, object.subprime_);
        object.attributeTable_.put(Attribute.VALUE, object.value_);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X942DHPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X942DHPrivateKey clone = (X942DHPrivateKey)super.clone();
        clone.prime_ = (ByteArrayAttribute)this.prime_.clone();
        clone.base_ = (ByteArrayAttribute)this.base_.clone();
        clone.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        clone.value_ = (ByteArrayAttribute)this.value_.clone();
        X942DHPrivateKey.putAttributesInTable(clone);
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof X942DHPrivateKey) {
            X942DHPrivateKey other = (X942DHPrivateKey)otherObject;
            equal = this == other || super.equals(other) && this.prime_.equals(other.prime_) && this.base_.equals(other.base_) && this.subprime_.equals(other.subprime_) && this.value_.equals(other.value_);
        }
        return equal;
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Prime (hex): ");
        buffer.append(this.prime_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Base (hex): ");
        buffer.append(this.base_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Subprime (hex): ");
        buffer.append(this.subprime_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Value (hex): ");
        buffer.append(this.value_.toString());
        return buffer.toString();
    }
}

