/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CDMFSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public CDMFSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CDMF);
    }

    protected CDMFSecretKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType_.setLongValue(Key.KeyType.CDMF);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        return new CDMFSecretKey(session, objectHandle);
    }

    protected static void putAttributesInTable(CDMFSecretKey object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.VALUE, object.value_);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        CDMFSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CDMFSecretKey clone = (CDMFSecretKey)super.clone();
        clone.value_ = (ByteArrayAttribute)this.value_.clone();
        CDMFSecretKey.putAttributesInTable(clone);
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof CDMFSecretKey) {
            CDMFSecretKey other = (CDMFSecretKey)otherObject;
            equal = this == other || super.equals(other) && this.value_.equals(other.value_);
        }
        return equal;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Value (hex): ");
        buffer.append(this.value_.toString());
        return buffer.toString();
    }
}

