/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.parser.Matrix;

public class Vector {
    private static final int I1 = 0;
    private static final int I2 = 1;
    private static final int I3 = 2;
    private final float[] values = new float[]{0.0f, 0.0f, 0.0f};

    public Vector(float x2, float y2, float z2) {
        this.values[0] = x2;
        this.values[1] = y2;
        this.values[2] = z2;
    }

    public float get(int index) {
        return this.values[index];
    }

    public Vector cross(Matrix by) {
        float x2 = this.values[0] * by.get(0) + this.values[1] * by.get(3) + this.values[2] * by.get(6);
        float y2 = this.values[0] * by.get(1) + this.values[1] * by.get(4) + this.values[2] * by.get(7);
        float z2 = this.values[0] * by.get(2) + this.values[1] * by.get(5) + this.values[2] * by.get(8);
        return new Vector(x2, y2, z2);
    }

    public Vector subtract(Vector v2) {
        float x2 = this.values[0] - v2.values[0];
        float y2 = this.values[1] - v2.values[1];
        float z2 = this.values[2] - v2.values[2];
        return new Vector(x2, y2, z2);
    }

    public Vector add(Vector v2) {
        float x2 = this.values[0] + v2.values[0];
        float y2 = this.values[1] + v2.values[1];
        float z2 = this.values[2] + v2.values[2];
        return new Vector(x2, y2, z2);
    }

    public Vector cross(Vector with) {
        float x2 = this.values[1] * with.values[2] - this.values[2] * with.values[1];
        float y2 = this.values[2] * with.values[0] - this.values[0] * with.values[2];
        float z2 = this.values[0] * with.values[1] - this.values[1] * with.values[0];
        return new Vector(x2, y2, z2);
    }

    public float dot(Vector with) {
        return this.values[0] * with.values[0] + this.values[1] * with.values[1] + this.values[2] * with.values[2];
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.values[0] * this.values[0] + this.values[1] * this.values[1] + this.values[2] * this.values[2];
    }

    public String toString() {
        return this.values[0] + "," + this.values[1] + "," + this.values[2];
    }
}

