/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import java.util.Arrays;

public class Matrix {
    public static final int I11 = 0;
    public static final int I12 = 1;
    public static final int I13 = 2;
    public static final int I21 = 3;
    public static final int I22 = 4;
    public static final int I23 = 5;
    public static final int I31 = 6;
    public static final int I32 = 7;
    public static final int I33 = 8;
    private final float[] vals = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    Matrix() {
    }

    Matrix(float tx, float ty) {
        this.vals[6] = tx;
        this.vals[7] = ty;
    }

    Matrix(float a10, float b2, float c2, float d2, float e2, float f2) {
        this.vals[0] = a10;
        this.vals[1] = b2;
        this.vals[2] = 0.0f;
        this.vals[3] = c2;
        this.vals[4] = d2;
        this.vals[5] = 0.0f;
        this.vals[6] = e2;
        this.vals[7] = f2;
        this.vals[8] = 1.0f;
    }

    public float get(int index) {
        return this.vals[index];
    }

    public Matrix multiply(Matrix by) {
        Matrix result = new Matrix();
        float[] a10 = this.vals;
        float[] b2 = by.vals;
        float[] c2 = result.vals;
        c2[0] = a10[0] * b2[0] + a10[1] * b2[3] + a10[2] * b2[6];
        c2[1] = a10[0] * b2[1] + a10[1] * b2[4] + a10[2] * b2[7];
        c2[2] = a10[0] * b2[2] + a10[1] * b2[5] + a10[2] * b2[8];
        c2[3] = a10[3] * b2[0] + a10[4] * b2[3] + a10[5] * b2[6];
        c2[4] = a10[3] * b2[1] + a10[4] * b2[4] + a10[5] * b2[7];
        c2[5] = a10[3] * b2[2] + a10[4] * b2[5] + a10[5] * b2[8];
        c2[6] = a10[6] * b2[0] + a10[7] * b2[3] + a10[8] * b2[6];
        c2[7] = a10[6] * b2[1] + a10[7] * b2[4] + a10[8] * b2[7];
        c2[8] = a10[6] * b2[2] + a10[7] * b2[5] + a10[8] * b2[8];
        return result;
    }

    public Matrix subtract(Matrix arg) {
        Matrix result = new Matrix();
        float[] a10 = this.vals;
        float[] b2 = arg.vals;
        float[] c2 = result.vals;
        c2[0] = a10[0] - b2[0];
        c2[1] = a10[1] - b2[1];
        c2[2] = a10[2] - b2[2];
        c2[3] = a10[3] - b2[3];
        c2[4] = a10[4] - b2[4];
        c2[5] = a10[5] - b2[5];
        c2[6] = a10[6] - b2[6];
        c2[7] = a10[7] - b2[7];
        c2[8] = a10[8] - b2[8];
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Arrays.equals(this.vals, ((Matrix)obj).vals);
    }

    public int hashCode() {
        int result = 1;
        for (float val : this.vals) {
            result = 31 * result + Float.floatToIntBits(val);
        }
        return result;
    }

    public String toString() {
        return this.vals[0] + "\t" + this.vals[1] + "\t" + this.vals[2] + "\n" + this.vals[3] + "\t" + this.vals[4] + "\t" + this.vals[2] + "\n" + this.vals[6] + "\t" + this.vals[7] + "\t" + this.vals[8];
    }
}

