/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.hyphenation.Hyphen;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SimplePatternParser
implements SimpleXMLDocHandler,
PatternConsumer {
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;
    int currElement;
    PatternConsumer consumer;
    StringBuffer token = new StringBuffer();
    List<Object> exception;
    char hyphenChar = (char)45;
    SimpleXMLParser parser;

    protected static String getPattern(String word) {
        StringBuilder pat = new StringBuilder();
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isDigit(word.charAt(i2))) continue;
            pat.append(word.charAt(i2));
        }
        return pat.toString();
    }

    protected static String getInterletterValues(String pat) {
        StringBuilder il = new StringBuilder();
        String word = pat + "a";
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = word.charAt(i2);
            if (Character.isDigit(c2)) {
                il.append(c2);
                ++i2;
                continue;
            }
            il.append('0');
        }
        return il.toString();
    }

    public static void main(String[] args) {
        try (FileInputStream fis = new FileInputStream(args[0]);){
            if (args.length > 0) {
                SimplePatternParser pp = new SimplePatternParser();
                pp.parse(fis, pp);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void parse(InputStream stream, PatternConsumer consumer) {
        this.consumer = consumer;
        try {
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, stream);
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    protected List<Object> normalizeException(List<Object> ex) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object item : ex) {
            if (item instanceof String) {
                String str = (String)item;
                StringBuilder buf = new StringBuilder();
                for (int j2 = 0; j2 < str.length(); ++j2) {
                    char c2 = str.charAt(j2);
                    if (c2 != this.hyphenChar) {
                        buf.append(c2);
                        continue;
                    }
                    res.add(buf.toString());
                    buf.setLength(0);
                    char[] h2 = new char[]{this.hyphenChar};
                    res.add(new Hyphen(new String(h2), null, null));
                }
                if (buf.length() <= 0) continue;
                res.add(buf.toString());
                continue;
            }
            res.add(item);
        }
        return res;
    }

    protected String getExceptionWord(List<Object> ex) {
        StringBuilder res = new StringBuilder();
        for (Object item : ex) {
            if (item instanceof String) {
                res.append((String)item);
                continue;
            }
            if (((Hyphen)item).noBreak == null) continue;
            res.append(((Hyphen)item).noBreak);
        }
        return res.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String tag) {
        if (this.token.length() > 0) {
            String word = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)((ArrayList)this.exception).clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    @Override
    public void startDocument() {
    }

    @Override
    @Deprecated
    public void startElement(String tag, HashMap h2) {
        this.startElement(tag, (Map<String, String>)h2);
    }

    @Override
    public void startElement(String tag, Map<String, String> h2) {
        switch (tag) {
            case "hyphen-char": {
                String hh = h2.get("value");
                if (hh == null || hh.length() != 1) break;
                this.hyphenChar = hh.charAt(0);
                break;
            }
            case "classes": {
                this.currElement = 1;
                break;
            }
            case "patterns": {
                this.currElement = 3;
                break;
            }
            case "exceptions": {
                this.currElement = 2;
                this.exception = new ArrayList<Object>();
                break;
            }
            case "hyphen": {
                if (this.token.length() > 0) {
                    this.exception.add(this.token.toString());
                }
                this.exception.add(new Hyphen(h2.get("pre"), h2.get("no"), h2.get("post")));
                this.currElement = 4;
            }
        }
        this.token.setLength(0);
    }

    @Override
    public void text(String str) {
        StringTokenizer tk = new StringTokenizer(str);
        while (tk.hasMoreTokens()) {
            String word = tk.nextToken();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)((ArrayList)this.exception).clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                }
            }
        }
    }

    @Override
    public void addClass(String c2) {
        System.out.println("class: " + c2);
    }

    @Override
    public void addException(String w2, ArrayList e2) {
        System.out.println("exception: " + w2 + " : " + e2.toString());
    }

    @Override
    public void addPattern(String p2, String v2) {
        System.out.println("pattern: " + p2 + " : " + v2);
    }
}

