/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.ByteVector;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import com.lowagie.text.pdf.hyphenation.SimplePatternParser;
import com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    private static final long serialVersionUID = -7763254239309429432L;
    protected ByteVector vspace;
    protected Map<String, List> stoplist = new HashMap<String, List>(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String values) {
        int n2 = values.length();
        int m2 = (n2 & 1) == 1 ? (n2 >> 1) + 2 : (n2 >> 1) + 1;
        int offset = this.vspace.alloc(m2);
        byte[] va = this.vspace.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            int j2 = i2 >> 1;
            byte v2 = (byte)(values.charAt(i2) - 48 + 1 & 0xF);
            va[j2 + offset] = (i2 & 1) == 1 ? (byte)(va[j2 + offset] | v2) : (byte)(v2 << 4);
        }
        va[m2 - 1 + offset] = 0;
        return offset;
    }

    protected String unpackValues(int k2) {
        StringBuilder buf = new StringBuilder();
        byte v2 = this.vspace.get(k2++);
        while (v2 != 0) {
            char c2 = (char)((v2 >>> 4) - 1 + 48);
            buf.append(c2);
            c2 = (char)(v2 & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001' + 48);
            buf.append(c2);
            v2 = this.vspace.get(k2++);
        }
        return buf.toString();
    }

    public void loadSimplePatterns(InputStream stream) {
        SimplePatternParser pp = new SimplePatternParser();
        this.ivalues = new TernaryTree();
        pp.parse(stream, this);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k2 = super.find(pat);
        if (k2 >= 0) {
            return this.unpackValues(k2);
        }
        return "";
    }

    protected int hstrcmp(char[] s2, int si, char[] t2, int ti) {
        while (s2[si] == t2[ti]) {
            if (s2[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t2[ti] == '\u0000') {
            return 0;
        }
        return s2[si] - t2[ti];
    }

    protected byte[] getValues(int k2) {
        StringBuilder buf = new StringBuilder();
        byte v2 = this.vspace.get(k2++);
        while (v2 != 0) {
            char c2 = (char)((v2 >>> 4) - 1);
            buf.append(c2);
            c2 = (char)(v2 & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001');
            buf.append(c2);
            v2 = this.vspace.get(k2++);
        }
        byte[] res = new byte[buf.length()];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = (byte)buf.charAt(i2);
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index, byte[] il) {
        int i2 = index;
        char sp = word[i2];
        char p2 = this.root;
        block0: while (p2 > '\u0000' && p2 < this.sc.length) {
            byte[] values;
            if (this.sc[p2] == '\uffff') {
                if (this.hstrcmp(word, i2, this.kv.getArray(), this.lo[p2]) == 0) {
                    values = this.getValues(this.eq[p2]);
                    int j2 = index;
                    for (byte value : values) {
                        if (j2 < il.length && value > il[j2]) {
                            il[j2] = value;
                        }
                        ++j2;
                    }
                }
                return;
            }
            int d2 = sp - this.sc[p2];
            if (d2 == 0) {
                if (sp == '\u0000') break;
                sp = word[++i2];
                char q2 = p2 = this.eq[p2];
                while (q2 > '\u0000' && q2 < this.sc.length && this.sc[q2] != '\uffff') {
                    if (this.sc[q2] == '\u0000') {
                        values = this.getValues(this.eq[q2]);
                        int j3 = index;
                        for (byte value : values) {
                            if (j3 < il.length && value > il[j3]) {
                                il[j3] = value;
                            }
                            ++j3;
                        }
                        continue block0;
                    }
                    q2 = this.lo[q2];
                }
                continue;
            }
            p2 = d2 < 0 ? this.lo[p2] : this.hi[p2];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w2 = word.toCharArray();
        return this.hyphenate(w2, 0, w2.length, remainCharCount, pushCharCount);
    }

    public Hyphenation hyphenate(char[] w2, int offset, int len, int remainCharCount, int pushCharCount) {
        int i2;
        char[] word = new char[len + 3];
        char[] c2 = new char[2];
        int iIgnoreAtBeginning = 0;
        int iLength = len;
        boolean bEndOfLetters = false;
        for (i2 = 1; i2 <= len; ++i2) {
            c2[0] = w2[offset + i2 - 1];
            int nc = this.classmap.find(c2, 0);
            if (nc < 0) {
                if (i2 == 1 + iIgnoreAtBeginning) {
                    ++iIgnoreAtBeginning;
                } else {
                    bEndOfLetters = true;
                }
                --iLength;
                continue;
            }
            if (!bEndOfLetters) {
                word[i2 - iIgnoreAtBeginning] = (char)nc;
                continue;
            }
            return null;
        }
        len = iLength;
        if (len < remainCharCount + pushCharCount) {
            return null;
        }
        int[] result = new int[len + 1];
        int k2 = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            List hw = this.stoplist.get(sw);
            int j2 = 0;
            for (i2 = 0; i2 < hw.size(); ++i2) {
                Object o2 = hw.get(i2);
                if (!(o2 instanceof String) || (j2 += ((String)o2).length()) < remainCharCount || j2 >= len - pushCharCount) continue;
                result[k2++] = j2 + iIgnoreAtBeginning;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            for (i2 = 0; i2 < len + 1; ++i2) {
                this.searchPatterns(word, i2, il);
            }
            for (i2 = 0; i2 < len; ++i2) {
                if ((il[i2 + 1] & 1) != 1 || i2 < remainCharCount || i2 > len - pushCharCount) continue;
                result[k2++] = i2 + iIgnoreAtBeginning;
            }
        }
        if (k2 > 0) {
            int[] res = new int[k2];
            System.arraycopy(result, 0, res, 0, k2);
            return new Hyphenation(new String(w2, offset, len), res);
        }
        return null;
    }

    @Override
    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key = new char[2];
            key[1] = '\u0000';
            for (int i2 = 0; i2 < chargroup.length(); ++i2) {
                key[0] = chargroup.charAt(i2);
                this.classmap.insert(key, 0, equivChar);
            }
        }
    }

    @Override
    public void addException(String word, ArrayList hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    @Override
    public void addPattern(String pattern, String ivalue) {
        int k2 = this.ivalues.find(ivalue);
        if (k2 <= 0) {
            k2 = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k2);
        }
        this.insert(pattern, (char)k2);
    }

    @Override
    public void printStats() {
        System.out.println("Value space size = " + this.vspace.length());
        super.printStats();
    }
}

