/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.XMLUtil;
import com.lowagie.text.xml.simpleparser.IanaEncodings;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class SimpleNamedDestination
implements SimpleXMLDocHandler {
    private HashMap<String, String> xmlNames;
    private Map<String, String> xmlLast;

    private SimpleNamedDestination() {
    }

    public static HashMap<Object, Object> getNamedDestination(PdfReader reader, boolean fromNames) {
        IntHashtable pages = new IntHashtable();
        int numPages = reader.getNumberOfPages();
        for (int k2 = 1; k2 <= numPages; ++k2) {
            pages.put(reader.getPageOrigRef(k2).getNumber(), k2);
        }
        HashMap names = fromNames ? reader.getNamedDestinationFromNames() : reader.getNamedDestinationFromStrings();
        Iterator it = names.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PdfArray arr = (PdfArray)entry.getValue();
            StringBuilder s2 = new StringBuilder();
            try {
                s2.append(pages.get(arr.getAsIndirectObject(0).getNumber()));
                s2.append(' ').append(arr.getPdfObject(1).toString().substring(1));
                for (int k3 = 2; k3 < arr.size(); ++k3) {
                    s2.append(' ').append(arr.getPdfObject(k3).toString());
                }
                entry.setValue(s2.toString());
            }
            catch (Exception e2) {
                it.remove();
            }
        }
        return names;
    }

    public static void exportToXML(HashMap names, OutputStream out, String encoding, boolean onlyASCII) throws IOException {
        String jenc = IanaEncodings.getJavaEncoding(encoding);
        BufferedWriter wrt = new BufferedWriter(new OutputStreamWriter(out, jenc));
        SimpleNamedDestination.exportToXML(names, wrt, encoding, onlyASCII);
    }

    public static void exportToXML(HashMap names, Writer wrt, String encoding, boolean onlyASCII) throws IOException {
        wrt.write("<?xml version=\"1.0\" encoding=\"");
        wrt.write(XMLUtil.escapeXML(encoding, onlyASCII));
        wrt.write("\"?>\n<Destination>\n");
        Iterator iterator = names.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o2;
            Map.Entry entry = o2 = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            wrt.write("  <Name Page=\"");
            wrt.write(XMLUtil.escapeXML(value, onlyASCII));
            wrt.write("\">");
            wrt.write(XMLUtil.escapeXML(SimpleNamedDestination.escapeBinaryString(key), onlyASCII));
            wrt.write("</Name>\n");
        }
        wrt.write("</Destination>\n");
        wrt.flush();
    }

    public static HashMap<String, String> importFromXML(InputStream in) throws IOException {
        SimpleNamedDestination names = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)names, in);
        return names.xmlNames;
    }

    public static HashMap<String, String> importFromXML(Reader in) throws IOException {
        SimpleNamedDestination names = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)names, in);
        return names.xmlNames;
    }

    static PdfArray createDestinationArray(String value, PdfWriter writer) {
        PdfArray ar2 = new PdfArray();
        StringTokenizer tk = new StringTokenizer(value);
        int n2 = Integer.parseInt(tk.nextToken());
        ar2.add(writer.getPageReference(n2));
        if (!tk.hasMoreTokens()) {
            ar2.add(PdfName.XYZ);
            ar2.add(new float[]{0.0f, 10000.0f, 0.0f});
        } else {
            String fn = tk.nextToken();
            if (fn.startsWith("/")) {
                fn = fn.substring(1);
            }
            ar2.add(new PdfName(fn));
            for (int k2 = 0; k2 < 4 && tk.hasMoreTokens(); ++k2) {
                fn = tk.nextToken();
                if (fn.equals("null")) {
                    ar2.add(PdfNull.PDFNULL);
                    continue;
                }
                ar2.add(new PdfNumber(fn));
            }
        }
        return ar2;
    }

    public static PdfDictionary outputNamedDestinationAsNames(HashMap names, PdfWriter writer) {
        PdfDictionary dic = new PdfDictionary();
        Iterator iterator = names.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o2;
            Map.Entry entry = o2 = iterator.next();
            try {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                PdfArray ar2 = SimpleNamedDestination.createDestinationArray(value, writer);
                PdfName kn = new PdfName(key);
                dic.put(kn, ar2);
            }
            catch (Exception exception) {}
        }
        return dic;
    }

    public static PdfDictionary outputNamedDestinationAsStrings(Map<String, String> names, PdfWriter writer) throws IOException {
        HashMap<String, PdfIndirectReference> n2 = new HashMap<String, PdfIndirectReference>();
        Iterator<Map.Entry<String, String>> it = names.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            try {
                String value = entry.getValue();
                PdfArray ar2 = SimpleNamedDestination.createDestinationArray(value, writer);
                n2.put(entry.getKey(), writer.addToBody(ar2).getIndirectReference());
            }
            catch (Exception e2) {
                it.remove();
            }
        }
        return PdfNameTree.writeTree(n2, writer);
    }

    public static String escapeBinaryString(String s2) {
        char[] cc;
        StringBuilder buf = new StringBuilder();
        for (char c2 : cc = s2.toCharArray()) {
            if (c2 < ' ') {
                buf.append('\\');
                String octal = "00" + Integer.toOctalString(c2);
                buf.append(octal.substring(octal.length() - 3));
                continue;
            }
            if (c2 == '\\') {
                buf.append("\\\\");
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public static String unEscapeBinaryString(String s2) {
        StringBuilder buf = new StringBuilder();
        char[] cc = s2.toCharArray();
        int len = cc.length;
        for (int k2 = 0; k2 < len; ++k2) {
            char c2 = cc[k2];
            if (c2 == '\\') {
                if (++k2 >= len) {
                    buf.append('\\');
                    break;
                }
                c2 = cc[k2];
                if (c2 >= '0' && c2 <= '7') {
                    int n2 = c2 - 48;
                    ++k2;
                    for (int j2 = 0; j2 < 2 && k2 < len && (c2 = cc[k2]) >= '0' && c2 <= '7'; ++k2, ++j2) {
                        n2 = n2 * 8 + c2 - 48;
                    }
                    --k2;
                    buf.append((char)n2);
                    continue;
                }
                buf.append(c2);
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("Destination")) {
            if (this.xmlLast == null && this.xmlNames != null) {
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("destination.end.tag.out.of.place"));
        }
        if (!tag.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.end.tag.1", tag));
        }
        if (this.xmlLast == null || this.xmlNames == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("name.end.tag.out.of.place"));
        }
        if (!this.xmlLast.containsKey("Page")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("page.attribute.missing"));
        }
        this.xmlNames.put(SimpleNamedDestination.unEscapeBinaryString(this.xmlLast.get("Name")), this.xmlLast.get("Page"));
        this.xmlLast = null;
    }

    @Override
    public void startDocument() {
    }

    @Override
    @Deprecated
    public void startElement(String tag, HashMap h2) {
        this.startElement(tag, (Map<String, String>)h2);
    }

    @Override
    public void startElement(String tag, Map<String, String> h2) {
        if (this.xmlNames == null) {
            if (tag.equals("Destination")) {
                this.xmlNames = new HashMap();
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.destination"));
        }
        if (!tag.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("tag.1.not.allowed", tag));
        }
        if (this.xmlLast != null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("nested.tags.are.not.allowed"));
        }
        this.xmlLast = new HashMap<String, String>(h2);
        this.xmlLast.put("Name", "");
    }

    @Override
    public void text(String str) {
        if (this.xmlLast == null) {
            return;
        }
        String name = this.xmlLast.get("Name");
        name = name + str;
        this.xmlLast.put("Name", name);
    }
}

