/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;

public class RadioCheckField
extends BaseField {
    public static final int TYPE_CHECK = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_CROSS = 3;
    public static final int TYPE_DIAMOND = 4;
    public static final int TYPE_SQUARE = 5;
    public static final int TYPE_STAR = 6;
    private static String[] typeChars = new String[]{"4", "l", "8", "u", "n", "H"};
    private int checkType;
    private String onValue;
    private boolean checked;

    public RadioCheckField(PdfWriter writer, Rectangle box, String fieldName, String onValue) {
        super(writer, box, fieldName);
        this.setOnValue(onValue);
        this.setCheckType(1);
    }

    public RadioCheckField(PdfWriter writer, String fieldName, String onValue) {
        super(writer, null, fieldName);
        this.setOnValue(onValue);
        this.setCheckType(3);
    }

    public static PdfAppearance getAppearance(boolean on, PdfWriter writer, int checkType, int rotation, int borderStyle, Rectangle box, float borderWidth, float fontSize, String text, Color textColor, Color backgroundColor, Color borderColor, BaseFont ufont) {
        if (checkType == 2) {
            return RadioCheckField.getAppearanceRadioCircle(on, writer, box, rotation, backgroundColor, borderWidth, borderColor, textColor);
        }
        if (checkType == 3) {
            return RadioCheckField.getAppearanceRadioCross(on, writer, box, rotation, backgroundColor, borderWidth, borderColor, textColor);
        }
        PdfAppearance app = RadioCheckField.getBorderAppearance(writer, box, rotation, backgroundColor, borderStyle, borderWidth, borderColor, 0, 0);
        if (!on) {
            return app;
        }
        boolean borderExtra = borderStyle == 2 || borderStyle == 3;
        float h2 = box.getHeight() - borderWidth * 2.0f;
        float bw2 = borderWidth;
        if (borderExtra) {
            h2 -= borderWidth * 2.0f;
            bw2 *= 2.0f;
        }
        float offsetX = borderExtra ? 2.0f * borderWidth : borderWidth;
        offsetX = Math.max(offsetX, 1.0f);
        float offX = Math.min(bw2, offsetX);
        float wt = box.getWidth() - 2.0f * offX;
        float ht = box.getHeight() - 2.0f * offX;
        float fsize = fontSize;
        if (fsize == 0.0f) {
            float bw = ufont.getWidthPoint(text, 1.0f);
            fsize = bw == 0.0f ? 12.0f : wt / bw;
            float nfsize = h2 / ufont.getFontDescriptor(1, 1.0f);
            fsize = Math.min(fsize, nfsize);
        }
        app.saveState();
        app.rectangle(offX, offX, wt, ht);
        app.clip();
        app.newPath();
        if (textColor == null) {
            app.resetGrayFill();
        } else {
            app.setColorFill(textColor);
        }
        app.beginText();
        app.setFontAndSize(ufont, fsize);
        app.setTextMatrix((box.getWidth() - ufont.getWidthPoint(text, fsize)) / 2.0f, (box.getHeight() - ufont.getAscentPoint(text, fsize)) / 2.0f);
        app.showText(text);
        app.endText();
        app.restoreState();
        return app;
    }

    public static PdfAppearance getAppearanceRadioCircle(boolean on, PdfWriter writer, Rectangle box, int rotation, Color backgroundColor, float borderWidth, Color borderColor, Color textColor) {
        PdfAppearance app = PdfAppearance.createAppearance(writer, box.getWidth(), box.getHeight());
        switch (rotation) {
            case 90: {
                app.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, box.getHeight(), 0.0f);
                break;
            }
            case 180: {
                app.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, box.getWidth(), box.getHeight());
                break;
            }
            case 270: {
                app.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, box.getWidth());
                break;
            }
        }
        Rectangle boundingBox = new Rectangle(app.getBoundingBox());
        float cx = boundingBox.getWidth() / 2.0f;
        float cy = boundingBox.getHeight() / 2.0f;
        float r2 = (Math.min(boundingBox.getWidth(), boundingBox.getHeight()) - borderWidth) / 2.0f;
        if (r2 <= 0.0f) {
            return app;
        }
        if (backgroundColor != null) {
            app.setColorFill(backgroundColor);
            app.circle(cx, cy, r2 + borderWidth / 2.0f);
            app.fill();
        }
        if (borderWidth > 0.0f && borderColor != null) {
            app.setLineWidth(borderWidth);
            app.setColorStroke(borderColor);
            app.circle(cx, cy, r2);
            app.stroke();
        }
        if (on) {
            if (textColor == null) {
                app.resetGrayFill();
            } else {
                app.setColorFill(textColor);
            }
            app.circle(cx, cy, r2 / 2.0f);
            app.fill();
        }
        return app;
    }

    public static PdfAppearance getAppearanceRadioCross(boolean on, PdfWriter writer, Rectangle box, int rotation, Color backgroundColor, float borderWidth, Color borderColor, Color textColor) {
        PdfAppearance app = PdfAppearance.createAppearance(writer, box.getWidth(), box.getHeight());
        switch (rotation) {
            case 90: {
                app.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, box.getHeight(), 0.0f);
                break;
            }
            case 180: {
                app.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, box.getWidth(), box.getHeight());
                break;
            }
            case 270: {
                app.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, box.getWidth());
            }
        }
        app.saveState();
        if (backgroundColor != null) {
            app.setColorFill(backgroundColor);
        } else {
            app.setRGBColorFillF(0.0f, 0.0f, 0.0f);
        }
        if (borderWidth > 0.0f && borderColor != null) {
            app.setLineWidth(borderWidth);
            app.setColorStroke(borderColor);
            app.rectangle(1.0f, 1.0f, box.getWidth() - 2.0f, box.getHeight() - 2.0f);
            app.clip();
        }
        if (on) {
            app.newPath();
            app.moveTo(2.0f, box.getHeight() - 2.0f);
            if (textColor != null) {
                app.setColorFill(textColor);
            }
            app.lineTo(box.getWidth() - 2.0f, 2.0f);
            app.moveTo(box.getWidth() - 2.0f, box.getHeight() - 2.0f);
            app.lineTo(2.0f, 2.0f);
            app.closePathStroke();
        }
        app.restoreState();
        return app;
    }

    public int getCheckType() {
        return this.checkType;
    }

    public void setCheckType(int checkType) {
        if (checkType < 1 || checkType > 6) {
            checkType = 1;
        }
        this.checkType = checkType;
        this.setText(typeChars[checkType - 1]);
        try {
            this.setFont(BaseFont.createFont("ZapfDingbats", "Cp1252", false));
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public String getOnValue() {
        return this.onValue;
    }

    public void setOnValue(String onValue) {
        this.onValue = onValue;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public PdfFormField getRadioGroup(boolean noToggleToOff, boolean radiosInUnison) {
        PdfFormField field = PdfFormField.createRadioButton(this.writer, noToggleToOff);
        if (radiosInUnison) {
            field.setFieldFlags(0x2000000);
        }
        field.setFieldName(this.fieldName);
        field.setUserName(this.alternateFieldName);
        field.setMappingName(this.mappingName);
        if ((this.options & 1) != 0) {
            field.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            field.setFieldFlags(2);
        }
        field.setValueAsName(this.checked ? this.onValue : "Off");
        return field;
    }

    @Deprecated
    public PdfFormField getRadioField() throws IOException, DocumentException {
        return this.getField(true);
    }

    @Deprecated
    public PdfFormField getCheckField() throws IOException, DocumentException {
        return this.getField(false);
    }

    public PdfFormField getCheckboxParent() {
        PdfFormField field = PdfFormField.createCheckBox(this.writer);
        field.setFieldName(this.fieldName);
        field.setUserName(this.alternateFieldName);
        field.setMappingName(this.mappingName);
        if ((this.options & 1) != 0) {
            field.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            field.setFieldFlags(2);
        }
        field.setValueAsName(this.checked ? this.onValue : "Off");
        return field;
    }

    public PdfFormField getKidField() throws IOException, DocumentException {
        return this.getField(true);
    }

    public PdfFormField getFullField() throws IOException, DocumentException {
        return this.getField(false);
    }

    protected PdfFormField getField(boolean isKid) throws IOException, DocumentException {
        PdfFormField field = null;
        field = isKid ? PdfFormField.createEmpty(this.writer) : PdfFormField.createCheckBox(this.writer);
        field.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (!isKid) {
            field.setFieldName(this.fieldName);
            field.setUserName(this.alternateFieldName);
            field.setMappingName(this.mappingName);
            if ((this.options & 1) != 0) {
                field.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                field.setFieldFlags(2);
            }
            field.setValueAsName(this.checked ? this.onValue : "Off");
            this.setCheckType(this.checkType);
        }
        if (this.text != null) {
            field.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            field.setMKRotation(this.rotation);
        }
        field.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance tpon = RadioCheckField.getAppearance(true, this.writer, this.checkType, this.rotation, this.borderStyle, this.box, this.borderWidth, this.fontSize, this.text, this.textColor, this.backgroundColor, this.borderColor, super.getRealFont());
        PdfAppearance tpoff = RadioCheckField.getAppearance(false, this.writer, this.checkType, this.rotation, this.borderStyle, this.box, this.borderWidth, this.fontSize, this.text, this.textColor, this.backgroundColor, this.borderColor, super.getRealFont());
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.onValue, tpon);
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", tpoff);
        field.setAppearanceState(this.checked ? this.onValue : "Off");
        PdfAppearance da = (PdfAppearance)tpon.getDuplicate();
        da.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            da.setGrayFill(0.0f);
        } else {
            da.setColorFill(this.textColor);
        }
        field.setDefaultAppearanceString(da);
        if (this.borderColor != null) {
            field.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            field.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                field.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                field.setFlags(36);
                break;
            }
            default: {
                field.setFlags(4);
            }
        }
        if ((this.visibility & 1) != 0) {
            field.addFlags(1);
        }
        if ((this.visibility & 4) != 0) {
            field.addFlags(4);
        }
        if ((this.visibility & 0x20) != 0) {
            field.addFlags(32);
        }
        if ((this.visibility & 0x80) != 0) {
            field.addFlags(128);
        }
        return field;
    }
}

