/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PdfStructureTreeRoot
extends PdfDictionary {
    private final Map<Integer, PdfArray> parentTree = new HashMap<Integer, PdfArray>();
    private final PdfIndirectReference reference;
    private final PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter writer) {
        super(PdfName.STRUCTTREEROOT);
        this.writer = writer;
        this.reference = writer.getPdfIndirectReference();
    }

    public void mapRole(PdfName used, PdfName standard) {
        PdfDictionary rm = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (rm == null) {
            rm = new PdfDictionary();
            this.put(PdfName.ROLEMAP, rm);
        }
        rm.put(used, standard);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    void setPageMark(int page, PdfIndirectReference reference) {
        Integer i2 = page;
        PdfArray ar2 = this.parentTree.get(i2);
        if (ar2 == null) {
            ar2 = new PdfArray();
            this.parentTree.put(i2, ar2);
        }
        ar2.add(reference);
    }

    private void nodeProcess(PdfDictionary dictionary, PdfIndirectReference reference) throws IOException {
        PdfObject obj = dictionary.get(PdfName.K);
        if (obj != null && obj.isArray() && !((PdfArray)obj).getElements().isEmpty() && !((PdfArray)obj).getElements().get(0).isNumber()) {
            PdfArray ar2 = (PdfArray)obj;
            for (int k2 = 0; k2 < ar2.size(); ++k2) {
                PdfStructureElement e2 = (PdfStructureElement)ar2.getDirectObject(k2);
                ar2.set(k2, e2.getReference());
                this.nodeProcess(e2, e2.getReference());
            }
        }
        if (reference != null) {
            this.writer.addToBody((PdfObject)dictionary, reference);
        }
    }

    void buildTree() throws IOException {
        HashMap<Integer, PdfIndirectReference> numTree = new HashMap<Integer, PdfIndirectReference>();
        for (Integer i2 : this.parentTree.keySet()) {
            PdfArray ar2 = this.parentTree.get(i2);
            numTree.put(i2, this.writer.addToBody(ar2).getIndirectReference());
        }
        PdfDictionary dicTree = PdfNumberTree.writeTree(numTree, this.writer);
        if (dicTree != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody(dicTree).getIndirectReference());
        }
        this.nodeProcess(this, this.reference);
    }
}

