/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PdfSmartCopy
extends PdfCopy {
    private Map<ByteStore, PdfIndirectReference> streamMap = new HashMap<ByteStore, PdfIndirectReference>();

    public PdfSmartCopy(Document document, OutputStream os) throws DocumentException {
        super(document, os);
    }

    @Override
    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfIndirectReference theRef;
        PdfCopy.RefKey key;
        PdfCopy.IndirectReferences iRef;
        PdfObject srcObj = PdfReader.getPdfObjectRelease(in);
        ByteStore streamKey = null;
        boolean validStream = false;
        if (srcObj == null) {
            return null;
        }
        if (srcObj.isStream()) {
            try {
                streamKey = new ByteStore((PRStream)srcObj);
                validStream = true;
                PdfIndirectReference streamRef = this.streamMap.get(streamKey);
                if (streamRef != null) {
                    return streamRef;
                }
            }
            catch (IOException streamRef) {
                // empty catch block
            }
        }
        if ((iRef = (PdfCopy.IndirectReferences)this.indirects.get(key = new PdfCopy.RefKey(in))) != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new PdfCopy.IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if (srcObj.isDictionary() && PdfName.PAGE.equals(type = PdfReader.getPdfObjectRelease(((PdfDictionary)srcObj).get(PdfName.TYPE)))) {
            return theRef;
        }
        iRef.setCopied();
        if (validStream) {
            this.streamMap.put(streamKey, theRef);
        }
        PdfObject obj = this.copyObject(srcObj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    static class ByteStore {
        private final int MAX_LEVELS = 100;
        private byte[] b;
        private int hash;
        private MessageDigest md5;

        ByteStore(PRStream str) throws IOException {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
            ByteBuffer bb2 = new ByteBuffer();
            int level = 100;
            this.serObject(str, level, bb2);
            this.b = bb2.toByteArray();
            this.md5 = null;
        }

        private void serObject(PdfObject obj, int level, ByteBuffer bb2) throws IOException {
            if (level <= 0) {
                throw new IOException("Max level reached");
            }
            if (obj == null) {
                bb2.append("$Lnull");
                return;
            }
            if ((obj = PdfReader.getPdfObject(obj)).isStream()) {
                bb2.append("$B");
                this.serDic((PdfDictionary)obj, level - 1, bb2);
                this.md5.reset();
                bb2.append(this.md5.digest(PdfReader.getStreamBytesRaw((PRStream)obj)));
            } else if (obj.isDictionary()) {
                this.serDic((PdfDictionary)obj, level - 1, bb2);
            } else if (obj.isArray()) {
                this.serArray((PdfArray)obj, level - 1, bb2);
            } else if (obj.isString()) {
                bb2.append("$S").append(obj.toString());
            } else if (obj.isName()) {
                bb2.append("$N").append(obj.toString());
            } else {
                bb2.append("$L").append(obj.toString());
            }
        }

        private void serDic(PdfDictionary dic, int level, ByteBuffer bb2) throws IOException {
            bb2.append("$D");
            if (level <= 0) {
                throw new IOException("Max level reached");
            }
            Object[] keys = dic.getKeys().toArray();
            Arrays.sort(keys);
            for (Object key : keys) {
                this.serObject((PdfObject)key, level, bb2);
                this.serObject(dic.get((PdfName)key), level, bb2);
            }
        }

        private void serArray(PdfArray array, int level, ByteBuffer bb2) throws IOException {
            bb2.append("$A");
            if (level <= 0) {
                throw new IOException("Max level reached");
            }
            for (int k2 = 0; k2 < array.size(); ++k2) {
                this.serObject(array.getPdfObject(k2), level, bb2);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteStore)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return Arrays.equals(this.b, ((ByteStore)obj).b);
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b1 : this.b) {
                    this.hash = this.hash * 31 + (b1 & 0xFF);
                }
            }
            return this.hash;
        }
    }
}

