/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfObject;
import java.util.Objects;

public class PdfNumber
extends PdfObject
implements Comparable<PdfNumber> {
    private double value;

    public PdfNumber(String content) {
        super(2);
        try {
            this.value = Double.parseDouble(content.trim());
            this.setContent(content);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("1.is.not.a.valid.number.2", content, nfe.toString()));
        }
    }

    public PdfNumber(int value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    public PdfNumber(long value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    public PdfNumber(double value) {
        super(2);
        this.value = value;
        this.setContent(ByteBuffer.formatDouble(value));
    }

    public PdfNumber(float value) {
        this((double)value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PdfNumber)) {
            return false;
        }
        PdfNumber pdfNumber = (PdfNumber)o2;
        return Double.compare(pdfNumber.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int compareTo(PdfNumber o2) {
        Objects.requireNonNull(o2, "PdfNumber is null, can't be compared to current instance.");
        if (this == o2) {
            return 0;
        }
        return Double.compare(o2.value, this.value);
    }
}

