/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.crypto.AESCipher;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import com.lowagie.text.pdf.crypto.IVGenerator;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamEncryption
extends OutputStream {
    private static final int AES_128 = 4;
    private static final int AES_256_V3 = 6;
    protected OutputStream out;
    protected ARCFOUREncryption arcfour;
    protected AESCipher cipher;
    private byte[] sb = new byte[1];
    private boolean aes;
    private boolean finished;

    public OutputStreamEncryption(OutputStream out, byte[] key, int off, int len, int revision) {
        try {
            this.out = out;
            boolean bl2 = this.aes = revision == 4 || revision == 6;
            if (this.aes) {
                byte[] iv = IVGenerator.getIV();
                byte[] nkey = new byte[len];
                System.arraycopy(key, off, nkey, 0, len);
                this.cipher = new AESCipher(true, nkey, iv);
                this.write(iv);
            } else {
                this.arcfour = new ARCFOUREncryption();
                this.arcfour.prepareARCFOURKey(key, off, len);
            }
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    public OutputStreamEncryption(OutputStream out, byte[] key, int revision) {
        this(out, key, 0, key.length, revision);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.sb[0] = (byte)b2;
        this.write(this.sb, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.aes) {
            byte[] b22 = this.cipher.update(b2, off, len);
            if (b22 == null || b22.length == 0) {
                return;
            }
            this.out.write(b22, 0, b22.length);
        } else {
            byte[] b23 = new byte[Math.min(len, 4192)];
            while (len > 0) {
                int sz = Math.min(len, b23.length);
                this.arcfour.encryptARCFOUR(b2, off, sz, b23, 0);
                this.out.write(b23, 0, sz);
                len -= sz;
                off += sz;
            }
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            if (this.aes) {
                byte[] b2;
                try {
                    b2 = this.cipher.doFinal();
                }
                catch (Exception ex) {
                    throw new ExceptionConverter(ex);
                }
                this.out.write(b2, 0, b2.length);
            }
        }
    }
}

