/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.TTFCache;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.nio.IntBuffer;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.truetype.TTFFile;

public class FopGlyphProcessor {
    private static boolean isFopSupported;

    public static boolean isFopSupported() {
        return isFopSupported;
    }

    public static byte[] convertToBytesWithGlyphs(BaseFont font, String text, String fileName, Map<Integer, int[]> longTag, String language) throws UnsupportedEncodingException {
        TrueTypeFontUnicode ttu = (TrueTypeFontUnicode)font;
        IntBuffer charBuffer = IntBuffer.allocate(text.length());
        IntBuffer glyphBuffer = IntBuffer.allocate(text.length());
        int textLength = text.length();
        for (char c2 : text.toCharArray()) {
            int[] metrics = ttu.getMetricsTT(c2);
            if (metrics == null) {
                --textLength;
                continue;
            }
            charBuffer.put(c2);
            glyphBuffer.put(metrics[0]);
        }
        charBuffer.limit(textLength);
        glyphBuffer.limit(textLength);
        GlyphSequence glyphSequence = new GlyphSequence(charBuffer, glyphBuffer, null);
        TTFFile ttf = TTFCache.getTTFFile(fileName, ttu);
        GlyphSubstitutionTable gsubTable = ttf.getGSUB();
        if (gsubTable != null) {
            String script = CharScript.scriptTagFromCode((int)CharScript.dominantScript((CharSequence)text));
            if ("zyyy".equals(script) || "auto".equals(script)) {
                script = "*";
            }
            glyphSequence = gsubTable.substitute(glyphSequence, script, language);
        }
        int limit = glyphSequence.getGlyphs().limit();
        int[] processedChars = glyphSequence.getGlyphs().array();
        char[] charEncodedGlyphCodes = new char[limit];
        for (int i2 = 0; i2 < limit; ++i2) {
            charEncodedGlyphCodes[i2] = (char)processedChars[i2];
            Integer glyphCode = processedChars[i2];
            if (longTag.containsKey(glyphCode)) continue;
            longTag.put(glyphCode, new int[]{processedChars[i2], ttu.getGlyphWidth(processedChars[i2]), charBuffer.get(i2)});
        }
        return new String(charEncodedGlyphCodes).getBytes("UnicodeBigUnmarked");
    }

    static {
        try {
            Class.forName("org.apache.fop.complexscripts.util.GlyphSequence");
            isFopSupported = true;
        }
        catch (ClassNotFoundException e2) {
            isFopSupported = false;
        }
    }
}

