/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList<Font> fonts = new ArrayList();

    public FontSelector() {
        FontFactory.register("font-fallback/LiberationSans-Regular.ttf", "sans");
        Font font = FontFactory.getFont("sans", "Identity-H");
        this.fonts.add(font);
    }

    public void setDefaultColor(Color color) {
        this.fonts.get(this.fonts.size() - 1).setColor(color);
    }

    public void setDefaultSize(float size) {
        this.fonts.get(this.fonts.size() - 1).setSize(size);
    }

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(this.fonts.size() - 1, font);
            return;
        }
        BaseFont bf2 = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf2, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(this.fonts.size() - 1, f2);
    }

    public Phrase process(String text) {
        int fsize = this.fonts.size();
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuilder sb = new StringBuilder();
        Font font = null;
        int lastidx = -1;
        Phrase ret = new Phrase();
        block0: for (int k2 = 0; k2 < len; ++k2) {
            char c2 = cc[k2];
            if (c2 == '\n' || c2 == '\r') {
                sb.append(c2);
                continue;
            }
            if (Utilities.isSurrogatePair(cc, k2)) {
                int u2 = Utilities.convertToUtf32(cc, k2);
                for (int f2 = 0; f2 < fsize; ++f2) {
                    font = this.fonts.get(f2);
                    if (!font.getBaseFont().charExists(u2)) continue;
                    if (lastidx != f2) {
                        if (sb.length() > 0 && lastidx != -1) {
                            Chunk ck = new Chunk(sb.toString(), this.fonts.get(lastidx));
                            ret.add(ck);
                            sb.setLength(0);
                        }
                        lastidx = f2;
                    }
                    sb.append(c2);
                    if (cc.length <= k2 + 1) continue block0;
                    sb.append(cc[++k2]);
                    continue block0;
                }
                continue;
            }
            for (int f3 = 0; f3 < fsize; ++f3) {
                font = this.fonts.get(f3);
                if (!font.getBaseFont().charExists(c2)) continue;
                if (lastidx != f3) {
                    if (sb.length() > 0 && lastidx != -1) {
                        Chunk ck = new Chunk(sb.toString(), this.fonts.get(lastidx));
                        ret.add(ck);
                        sb.setLength(0);
                    }
                    lastidx = f3;
                }
                sb.append(c2);
                continue block0;
            }
        }
        if (sb.length() > 0) {
            Chunk ck = lastidx == -1 ? new Chunk(sb.toString()) : new Chunk(sb.toString(), this.fonts.get(lastidx));
            ret.add(ck);
        }
        return ret;
    }
}

