/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.TextRenderingOptions;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.FopGlyphProcessor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.awt.font.GlyphVector;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    protected boolean subset = true;
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap<Integer, int[]> longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;

    FontDetails(PdfName fontName, PdfIndirectReference indirectReference, BaseFont baseFont) {
        this.fontName = fontName;
        this.indirectReference = indirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] convertToBytes(String text, TextRenderingOptions options) {
        byte[] b2 = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(text);
            }
            case 0: 
            case 1: {
                b2 = this.baseFont.convertToBytes(text);
                int len = b2.length;
                byte[] byArray = b2;
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte b1 = byArray[n3];
                    this.shortTag[b1 & 0xFF] = 1;
                    ++n3;
                }
                return b2;
            }
            case 2: {
                int len = text.length();
                int k2 = 0;
                while (k2 < len) {
                    this.cjkTag.put(this.cjkFont.getCidCode(text.charAt(k2)), 0);
                    ++k2;
                }
                return this.baseFont.convertToBytes(text);
            }
            case 4: {
                return this.baseFont.convertToBytes(text);
            }
            case 3: {
                try {
                    int len = text.length();
                    int[] metrics = null;
                    char[] glyph = new char[len];
                    int i2 = 0;
                    if (this.symbolic) {
                        b2 = PdfEncodings.convertToBytes(text, "symboltt");
                        len = b2.length;
                        for (int k3 = 0; k3 < len; ++k3) {
                            metrics = this.ttu.getMetricsTT(b2[k3] & 0xFF);
                            if (metrics == null) continue;
                            this.longTag.put(metrics[0], new int[]{metrics[0], metrics[1], this.ttu.getUnicodeDifferences(b2[k3] & 0xFF)});
                            glyph[i2++] = (char)metrics[0];
                        }
                        String s2 = new String(glyph, 0, i2);
                        return s2.getBytes("UnicodeBigUnmarked");
                    }
                    String fileName = ((TrueTypeFontUnicode)this.getBaseFont()).fileName;
                    if (!options.isGlyphSubstitutionEnabled()) return this.convertToBytesWithGlyphs(text);
                    if (!FopGlyphProcessor.isFopSupported()) return this.convertToBytesWithGlyphs(text);
                    if (fileName == null) return this.convertToBytesWithGlyphs(text);
                    if (fileName.length() <= 0) return this.convertToBytesWithGlyphs(text);
                    if (fileName.contains(".ttf")) return FopGlyphProcessor.convertToBytesWithGlyphs(this.ttu, text, fileName, this.longTag, options.getDocumentLanguage());
                    if (!fileName.contains(".TTF")) return this.convertToBytesWithGlyphs(text);
                    return FopGlyphProcessor.convertToBytesWithGlyphs(this.ttu, text, fileName, this.longTag, options.getDocumentLanguage());
                }
                catch (UnsupportedEncodingException e2) {
                    throw new ExceptionConverter(e2);
                }
            }
        }
        return b2;
    }

    private byte[] convertToBytesWithGlyphs(String text) throws UnsupportedEncodingException {
        int len = text.length();
        int[] metrics = null;
        int[] glyph = new int[len];
        int i2 = 0;
        for (int k2 = 0; k2 < len; ++k2) {
            int val;
            if (Utilities.isSurrogatePair(text, k2)) {
                val = Utilities.convertToUtf32(text, k2);
                ++k2;
            } else {
                val = text.charAt(k2);
            }
            metrics = this.ttu.getMetricsTT(val);
            if (metrics == null) continue;
            int m0 = metrics[0];
            Integer gl = m0;
            if (!this.longTag.containsKey(gl)) {
                this.longTag.put(gl, new int[]{m0, metrics[1], val});
            }
            glyph[i2++] = m0;
        }
        return this.getCJKEncodingBytes(glyph, i2);
    }

    private byte[] getCJKEncodingBytes(int[] glyph, int size) {
        byte[] result = new byte[size * 2];
        for (int i2 = 0; i2 < size; ++i2) {
            int g2 = glyph[i2];
            result[i2 * 2] = (byte)(g2 >> 8);
            result[i2 * 2 + 1] = (byte)(g2 & 0xFF);
        }
        return result;
    }

    byte[] convertToBytes(GlyphVector glyphVector) {
        return this.convertToBytes(glyphVector, 0, glyphVector.getNumGlyphs());
    }

    byte[] convertToBytes(GlyphVector glyphVector, int beginIndex, int endIndex) {
        if (this.fontType != 3 || this.symbolic) {
            throw new UnsupportedOperationException("Only supported for True Type Unicode fonts");
        }
        char[] glyphs = new char[endIndex - beginIndex];
        int glyphCount = 0;
        for (int i2 = beginIndex; i2 < endIndex; ++i2) {
            int[] nArray;
            int code = glyphVector.getGlyphCode(i2);
            if (code == 65534 || code == 65535) continue;
            glyphs[glyphCount++] = (char)code;
            Integer codeKey = code;
            if (this.longTag.containsKey(codeKey)) continue;
            int glyphWidth = this.ttu.getGlyphWidth(code);
            Integer charCode = this.ttu.getCharacterCode(code);
            if (charCode != null) {
                int[] nArray2 = new int[3];
                nArray2[0] = code;
                nArray2[1] = glyphWidth;
                nArray = nArray2;
                nArray2[2] = charCode;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = code;
                nArray = nArray3;
                nArray3[1] = glyphWidth;
            }
            int[] metrics = nArray;
            this.longTag.put(codeKey, metrics);
        }
        String s2 = new String(glyphs, 0, glyphCount);
        try {
            byte[] b2 = s2.getBytes("UnicodeBigUnmarked");
            return b2;
        }
        catch (UnsupportedEncodingException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    void writeFont(PdfWriter writer) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(writer, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int lastChar;
                    int firstChar;
                    for (firstChar = 0; firstChar < 256 && this.shortTag[firstChar] == 0; ++firstChar) {
                    }
                    for (lastChar = 255; lastChar >= firstChar && this.shortTag[lastChar] == 0; --lastChar) {
                    }
                    if (firstChar > 255) {
                        firstChar = 255;
                        lastChar = 255;
                    }
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{firstChar, lastChar, this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.longTag, this.subset});
                }
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }
}

