/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFont;
import java.io.IOException;
import java.util.HashMap;

class EnumerateTTC
extends TrueTypeFont {
    private static final int TRUE_TYPE_SFNT_VERSION = 65536;
    private static final int CFF_DATA_SFNT_VERSION = 0x4F54544F;
    protected String[] names;

    EnumerateTTC(String ttcFile) throws DocumentException, IOException {
        this.fileName = ttcFile;
        this.rf = new RandomAccessFileOrArray(ttcFile);
        this.findNames();
    }

    EnumerateTTC(byte[] ttcArray) throws DocumentException, IOException {
        this.fileName = "Byte array TTC";
        this.rf = new RandomAccessFileOrArray(ttcArray);
        this.findNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findNames() throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            String mainTag = this.readStandardString(4);
            if (!mainTag.equals("ttcf")) {
                throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttc.file", this.fileName));
            }
            short majorVersion = this.rf.readShort();
            this.rf.skipBytes(2);
            int dirCount = this.rf.readInt();
            this.names = new String[dirCount];
            int dirPos = this.rf.getFilePointer();
            for (int dirIdx = 0; dirIdx < dirCount; ++dirIdx) {
                boolean cffDataFont;
                this.tables.clear();
                this.rf.seek(dirPos);
                this.rf.skipBytes(dirIdx * 4);
                this.directoryOffset = this.rf.readInt();
                this.rf.seek(this.directoryOffset);
                int sfntVersion = this.rf.readInt();
                boolean trueTypeFont = sfntVersion == 65536;
                boolean bl2 = cffDataFont = sfntVersion == 0x4F54544F && (majorVersion == 1 || majorVersion == 2);
                if (!trueTypeFont && !cffDataFont) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttf.file", this.fileName));
                }
                int num_tables = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                for (int k2 = 0; k2 < num_tables; ++k2) {
                    String tag = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] table_location = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(tag, table_location);
                }
                this.names[dirIdx] = this.getBaseFont();
            }
        }
        finally {
            if (this.rf != null) {
                this.rf.close();
            }
        }
    }

    String[] getNames() {
        return this.names;
    }
}

