/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.util.HashMap;

public class DocumentFont
extends BaseFont {
    private static final int[] stdEnc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 36, 37, 38, 8217, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 8216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 162, 163, 8260, 165, 402, 167, 164, 39, 8220, 171, 8249, 8250, 64257, 64258, 0, 8211, 8224, 8225, 183, 0, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 0, 191, 0, 96, 180, 710, 732, 175, 728, 729, 168, 0, 730, 184, 0, 733, 731, 711, 8212, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 170, 0, 0, 0, 0, 321, 216, 338, 186, 0, 0, 0, 0, 0, 230, 0, 0, 0, 305, 0, 0, 322, 248, 339, 223, 0, 0, 0, 0};
    private static String[] cjkNames = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    private static String[] cjkNames2 = new String[]{"MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs2 = new String[]{"UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H", "UniCNS-UTF16-H", "UniGB-UTF16-H", "UniKS-UTF16-H", "UniJIS-UTF16-H"};
    private HashMap<Integer, int[]> metrics = new HashMap();
    private String fontName;
    private PRIndirectReference refFont;
    private PdfDictionary font;
    private IntHashtable uni2byte = new IntHashtable();
    private IntHashtable diffmap;
    private float Ascender = 800.0f;
    private float CapHeight = 700.0f;
    private float Descender = -200.0f;
    private float ItalicAngle = 0.0f;
    private float llx = -50.0f;
    private float lly = -200.0f;
    private float urx = 100.0f;
    private float ury = 900.0f;
    private boolean isType0 = false;
    private BaseFont cjkMirror;

    DocumentFont(PRIndirectReference refFont) {
        this.encoding = "";
        this.fontSpecific = false;
        this.refFont = refFont;
        this.fontType = 4;
        this.font = (PdfDictionary)PdfReader.getPdfObject(refFont);
        PdfName asName = this.font.getAsName(PdfName.BASEFONT);
        this.fontName = asName != null ? PdfName.decodeName(asName.toString()) : "badFontName";
        PdfName subType = this.font.getAsName(PdfName.SUBTYPE);
        if (PdfName.TYPE1.equals(subType) || PdfName.TRUETYPE.equals(subType)) {
            this.doType1TT();
        } else {
            for (int k2 = 0; k2 < cjkNames.length; ++k2) {
                if (!this.fontName.startsWith(cjkNames[k2])) continue;
                this.fontName = cjkNames[k2];
                try {
                    this.cjkMirror = BaseFont.createFont(this.fontName, cjkEncs[k2], false);
                }
                catch (Exception e2) {
                    throw new ExceptionConverter(e2);
                }
                return;
            }
            PdfName encName = this.font.getAsName(PdfName.ENCODING);
            if (encName != null) {
                String enc = PdfName.decodeName(encName.toString());
                for (int k3 = 0; k3 < cjkEncs2.length; ++k3) {
                    if (!enc.startsWith(cjkEncs2[k3])) continue;
                    try {
                        if (k3 > 3) {
                            k3 -= 4;
                        }
                        this.cjkMirror = BaseFont.createFont(cjkNames2[k3], cjkEncs2[k3], false);
                    }
                    catch (Exception e3) {
                        throw new ExceptionConverter(e3);
                    }
                    return;
                }
                this.encoding = enc;
                if (PdfName.TYPE0.equals(subType) && enc.equals("Identity-H")) {
                    this.processType0(this.font);
                    this.isType0 = true;
                }
            }
        }
    }

    private void processType0(PdfDictionary font) {
        try {
            PdfObject toUniObject = PdfReader.getPdfObjectRelease(font.get(PdfName.TOUNICODE));
            PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(font.get(PdfName.DESCENDANTFONTS));
            PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
            PdfNumber dwo = (PdfNumber)PdfReader.getPdfObjectRelease(cidft.get(PdfName.DW));
            int dw = 1000;
            if (dwo != null) {
                dw = dwo.intValue();
            }
            IntHashtable widths = this.readWidths((PdfArray)PdfReader.getPdfObjectRelease(cidft.get(PdfName.W)));
            PdfDictionary fontDesc = (PdfDictionary)PdfReader.getPdfObjectRelease(cidft.get(PdfName.FONTDESCRIPTOR));
            this.fillFontDesc(fontDesc);
            if (toUniObject != null) {
                this.fillMetrics(PdfReader.getStreamBytes((PRStream)toUniObject), widths, dw);
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private IntHashtable readWidths(PdfArray ws) {
        IntHashtable hh = new IntHashtable();
        if (ws == null) {
            return hh;
        }
        for (int k2 = 0; k2 < ws.size(); ++k2) {
            PdfObject obj;
            int c1 = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(k2))).intValue();
            if ((obj = PdfReader.getPdfObjectRelease(ws.getPdfObject(++k2))).isArray()) {
                PdfArray a22 = (PdfArray)obj;
                for (int j2 = 0; j2 < a22.size(); ++j2) {
                    int c2 = ((PdfNumber)PdfReader.getPdfObjectRelease(a22.getPdfObject(j2))).intValue();
                    hh.put(c1++, c2);
                }
                continue;
            }
            int c2 = ((PdfNumber)obj).intValue();
            int w2 = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(++k2))).intValue();
            while (c1 <= c2) {
                hh.put(c1, w2);
                ++c1;
            }
        }
        return hh;
    }

    private String decodeString(PdfString ps) {
        if (ps.isHexWriting()) {
            return PdfEncodings.convertToString(ps.getBytes(), "UnicodeBigUnmarked");
        }
        return ps.toUnicodeString();
    }

    private void fillMetrics(byte[] touni, IntHashtable widths, int dw) {
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(touni));
            PdfObject ob = null;
            PdfObject last = null;
            while ((ob = ps.readPRObject()) != null) {
                if (ob.type() == 200) {
                    int k2;
                    int n2;
                    if (ob.toString().equals("beginbfchar")) {
                        n2 = ((PdfNumber)last).intValue();
                        for (k2 = 0; k2 < n2; ++k2) {
                            String cid = this.decodeString((PdfString)ps.readPRObject());
                            String uni = this.decodeString((PdfString)ps.readPRObject());
                            if (uni.length() != 1) continue;
                            char cidc = cid.charAt(0);
                            char unic = uni.charAt(uni.length() - 1);
                            int w2 = dw;
                            if (widths.containsKey(cidc)) {
                                w2 = widths.get(cidc);
                            }
                            this.metrics.put(Integer.valueOf(unic), new int[]{cidc, w2});
                        }
                        continue;
                    }
                    if (!ob.toString().equals("beginbfrange")) continue;
                    n2 = ((PdfNumber)last).intValue();
                    for (k2 = 0; k2 < n2; ++k2) {
                        String cid1 = this.decodeString((PdfString)ps.readPRObject());
                        String cid2 = this.decodeString((PdfString)ps.readPRObject());
                        int cid1c = cid1.charAt(0);
                        char cid2c = cid2.charAt(0);
                        PdfObject ob2 = ps.readPRObject();
                        if (ob2.isString()) {
                            String uni = this.decodeString((PdfString)ob2);
                            if (uni.length() != 1) continue;
                            int unic = uni.charAt(uni.length() - 1);
                            while (cid1c <= cid2c) {
                                int w3 = dw;
                                if (widths.containsKey(cid1c)) {
                                    w3 = widths.get(cid1c);
                                }
                                this.metrics.put(unic, new int[]{cid1c++, w3});
                                ++unic;
                            }
                            continue;
                        }
                        PdfArray a10 = (PdfArray)ob2;
                        int j2 = 0;
                        while (j2 < a10.size()) {
                            String uni = this.decodeString(a10.getAsString(j2));
                            if (uni.length() == 1) {
                                char unic = uni.charAt(uni.length() - 1);
                                int w4 = dw;
                                if (widths.containsKey(cid1c)) {
                                    w4 = widths.get(cid1c);
                                }
                                this.metrics.put(Integer.valueOf(unic), new int[]{cid1c, w4});
                            }
                            ++j2;
                            ++cid1c;
                        }
                    }
                    continue;
                }
                last = ob;
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private void doType1TT() {
        PdfObject enc = PdfReader.getPdfObject(this.font.get(PdfName.ENCODING));
        if (enc == null) {
            PdfName baseFont = this.font.getAsName(PdfName.BASEFONT);
            if (PdfName.SYMBOL.equals(baseFont) || PdfName.ZAPFDINGBATS.equals(baseFont)) {
                this.fillEncoding(baseFont);
            } else {
                this.fillEncoding(null);
            }
        } else if (enc.isName()) {
            this.fillEncoding((PdfName)enc);
        } else {
            PdfDictionary encDic = (PdfDictionary)enc;
            if ((enc = PdfReader.getPdfObject(encDic.get(PdfName.BASEENCODING))) == null) {
                this.fillEncoding(null);
            } else {
                this.fillEncoding((PdfName)enc);
            }
            PdfArray diffs = encDic.getAsArray(PdfName.DIFFERENCES);
            if (diffs != null) {
                this.diffmap = new IntHashtable();
                int currentNumber = 0;
                for (int k2 = 0; k2 < diffs.size(); ++k2) {
                    PdfObject obj = diffs.getPdfObject(k2);
                    if (obj.isNumber()) {
                        currentNumber = ((PdfNumber)obj).intValue();
                        continue;
                    }
                    int[] c2 = GlyphList.nameToUnicode(PdfName.decodeName(obj.toString()));
                    if (c2 != null && c2.length > 0) {
                        this.uni2byte.put(c2[0], currentNumber);
                        this.diffmap.put(c2[0], currentNumber);
                    }
                    ++currentNumber;
                }
            }
        }
        PdfArray newWidths = this.font.getAsArray(PdfName.WIDTHS);
        PdfNumber first = this.font.getAsNumber(PdfName.FIRSTCHAR);
        PdfNumber last = this.font.getAsNumber(PdfName.LASTCHAR);
        if (BuiltinFonts14.containsKey(this.fontName)) {
            int n2;
            BaseFont bf2;
            try {
                bf2 = BaseFont.createFont(this.fontName, "Cp1252", false);
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
            for (int i2 : e = this.uni2byte.toOrderedKeys()) {
                n2 = this.uni2byte.get(i2);
                this.widths[n2] = bf2.getRawWidth(n2, GlyphList.unicodeToName(i2));
            }
            if (this.diffmap != null) {
                for (int i2 : e = this.diffmap.toOrderedKeys()) {
                    n2 = this.diffmap.get(i2);
                    this.widths[n2] = bf2.getRawWidth(n2, GlyphList.unicodeToName(i2));
                }
                this.diffmap = null;
            }
            this.Ascender = bf2.getFontDescriptor(1, 1000.0f);
            this.CapHeight = bf2.getFontDescriptor(2, 1000.0f);
            this.Descender = bf2.getFontDescriptor(3, 1000.0f);
            this.ItalicAngle = bf2.getFontDescriptor(4, 1000.0f);
            this.llx = bf2.getFontDescriptor(5, 1000.0f);
            this.lly = bf2.getFontDescriptor(6, 1000.0f);
            this.urx = bf2.getFontDescriptor(7, 1000.0f);
            this.ury = bf2.getFontDescriptor(8, 1000.0f);
        }
        if (first != null && last != null && newWidths != null) {
            int f2 = first.intValue();
            for (int k3 = 0; k3 < newWidths.size(); ++k3) {
                this.widths[f2 + k3] = newWidths.getAsNumber(k3).intValue();
            }
        }
        this.fillFontDesc(this.font.getAsDict(PdfName.FONTDESCRIPTOR));
    }

    private void fillFontDesc(PdfDictionary fontDesc) {
        PdfArray bbox;
        if (fontDesc == null) {
            return;
        }
        PdfNumber v2 = fontDesc.getAsNumber(PdfName.ASCENT);
        if (v2 != null) {
            this.Ascender = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.CAPHEIGHT)) != null) {
            this.CapHeight = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.DESCENT)) != null) {
            this.Descender = v2.floatValue();
        }
        if ((v2 = fontDesc.getAsNumber(PdfName.ITALICANGLE)) != null) {
            this.ItalicAngle = v2.floatValue();
        }
        if ((bbox = fontDesc.getAsArray(PdfName.FONTBBOX)) != null) {
            float t2;
            this.llx = bbox.getAsNumber(0).floatValue();
            this.lly = bbox.getAsNumber(1).floatValue();
            this.urx = bbox.getAsNumber(2).floatValue();
            this.ury = bbox.getAsNumber(3).floatValue();
            if (this.llx > this.urx) {
                t2 = this.llx;
                this.llx = this.urx;
                this.urx = t2;
            }
            if (this.lly > this.ury) {
                t2 = this.lly;
                this.lly = this.ury;
                this.ury = t2;
            }
        }
    }

    private void fillEncoding(PdfName encoding) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(encoding) || PdfName.WIN_ANSI_ENCODING.equals(encoding) || PdfName.SYMBOL.equals(encoding) || PdfName.ZAPFDINGBATS.equals(encoding)) {
            byte[] b2 = new byte[256];
            for (int k2 = 0; k2 < 256; ++k2) {
                b2[k2] = (byte)k2;
            }
            String enc = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(encoding)) {
                enc = "MacRoman";
            } else if (PdfName.SYMBOL.equals(encoding)) {
                enc = "Symbol";
            } else if (PdfName.ZAPFDINGBATS.equals(encoding)) {
                enc = "ZapfDingbats";
            }
            String cv = PdfEncodings.convertToString(b2, enc);
            char[] arr = cv.toCharArray();
            for (int k3 = 0; k3 < 256; ++k3) {
                this.uni2byte.put(arr[k3], k3);
            }
        } else {
            for (int k4 = 0; k4 < 256; ++k4) {
                this.uni2byte.put(stdEnc[k4], k4);
            }
        }
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(key, fontSize);
        }
        switch (key) {
            case 1: 
            case 9: {
                return this.Ascender * fontSize / 1000.0f;
            }
            case 2: {
                return this.CapHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.Descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.fontName}};
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    public void setPostscriptFontName(String name) {
    }

    @Override
    int getRawWidth(int c2, String name) {
        return 0;
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException {
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    @Override
    public int getWidth(int char1) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(char1);
        }
        if (this.isType0) {
            int[] ws = this.metrics.get(char1);
            if (ws != null) {
                return ws[1];
            }
            return 0;
        }
        return super.getWidth(char1);
    }

    @Override
    public int getWidth(String text) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(text);
        }
        if (this.isType0) {
            char[] chars = text.toCharArray();
            int total = 0;
            for (char aChar : chars) {
                int[] ws = this.metrics.get(Character.getNumericValue(aChar));
                if (ws == null) continue;
                total += ws[1];
            }
            return total;
        }
        return super.getWidth(text);
    }

    @Override
    byte[] convertToBytes(String text) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes(text, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            char[] chars = text.toCharArray();
            int len = chars.length;
            byte[] b2 = new byte[len * 2];
            int bptr = 0;
            for (char aChar : chars) {
                int[] ws = this.metrics.get(Character.getNumericValue(aChar));
                if (ws == null) continue;
                int g2 = ws[0];
                b2[bptr++] = (byte)(g2 / 256);
                b2[bptr++] = (byte)g2;
            }
            if (bptr == b2.length) {
                return b2;
            }
            byte[] nb = new byte[bptr];
            System.arraycopy(b2, 0, nb, 0, bptr);
            return nb;
        }
        char[] cc = text.toCharArray();
        byte[] b3 = new byte[cc.length];
        int ptr = 0;
        for (char c2 : cc) {
            if (!this.uni2byte.containsKey(c2)) continue;
            b3[ptr++] = (byte)this.uni2byte.get(c2);
        }
        if (ptr == b3.length) {
            return b3;
        }
        byte[] b2 = new byte[ptr];
        System.arraycopy(b3, 0, b2, 0, ptr);
        return b2;
    }

    @Override
    byte[] convertToBytes(int char1) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes((char)char1, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            int[] ws = this.metrics.get(char1);
            if (ws != null) {
                int g2 = ws[0];
                return new byte[]{(byte)(g2 / 256), (byte)g2};
            }
            return new byte[0];
        }
        if (this.uni2byte.containsKey(char1)) {
            return new byte[]{(byte)this.uni2byte.get(char1)};
        }
        return new byte[0];
    }

    PdfIndirectReference getIndirectReference() {
        return this.refFont;
    }

    @Override
    public boolean charExists(int c2) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.charExists(c2);
        }
        if (this.isType0) {
            return this.metrics.containsKey(c2);
        }
        return super.charExists(c2);
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public int[] getCharBBox(int c2) {
        return null;
    }

    @Override
    protected int[] getRawCharBBox(int c2, String name) {
        return null;
    }

    IntHashtable getUni2Byte() {
        return this.uni2byte;
    }

    public PdfDictionary getFontDescriptor() {
        return this.font.getAsDict(PdfName.FONTDESCRIPTOR);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DocumentFont [");
        if (this.metrics != null) {
            builder.append("metrics=");
            builder.append(this.metrics);
            builder.append(", ");
        }
        if (this.fontName != null) {
            builder.append("fontName=");
            builder.append(this.fontName);
            builder.append(", ");
        }
        if (this.refFont != null) {
            builder.append("refFont=");
            builder.append(this.refFont);
            builder.append(", ");
        }
        if (this.font != null) {
            builder.append("font=");
            builder.append(this.font);
            builder.append(", ");
        }
        if (this.uni2byte != null) {
            builder.append("uni2byte size=");
            builder.append(this.uni2byte.size());
            builder.append(", ");
        }
        if (this.diffmap != null) {
            builder.append("diffmap=");
            builder.append(this.diffmap);
            builder.append(", ");
        }
        builder.append("Ascender=");
        builder.append(this.Ascender);
        builder.append(", CapHeight=");
        builder.append(this.CapHeight);
        builder.append(", Descender=");
        builder.append(this.Descender);
        builder.append(", ItalicAngle=");
        builder.append(this.ItalicAngle);
        builder.append(", llx=");
        builder.append(this.llx);
        builder.append(", lly=");
        builder.append(this.lly);
        builder.append(", urx=");
        builder.append(this.urx);
        builder.append(", ury=");
        builder.append(this.ury);
        builder.append(", isType0=");
        builder.append(this.isType0);
        builder.append(", ");
        if (this.cjkMirror != null) {
            builder.append("cjkMirror=");
            builder.append(this.cjkMirror);
        }
        builder.append("]");
        return builder.toString();
    }
}

