/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

class CJKFont
extends BaseFont {
    static final String CJK_ENCODING = "UnicodeBigUnmarked";
    private static final int FIRST = 0;
    private static final int BRACKET = 1;
    private static final int SERIAL = 2;
    private static final int V1Y = 880;
    static Properties cjkFonts = new Properties();
    static Properties cjkEncodings = new Properties();
    static ConcurrentHashMap<String, HashMap<Object, Object>> allFonts = new ConcurrentHashMap(500, 0.85f, 64);
    private static boolean propertiesLoaded = false;
    private static Object initLock = new Object();
    Hashtable<String, char[]> allCMaps = new Hashtable();
    private String fontName;
    private String style = "";
    private String CMap;
    private boolean cidDirect = false;
    private char[] translationMap;
    private IntHashtable vMetrics;
    private IntHashtable hMetrics;
    private HashMap<Object, Object> fontDesc;
    private boolean vertical = false;

    CJKFont(String fontName, String enc, boolean emb) throws DocumentException {
        CJKFont.loadProperties();
        this.fontType = 2;
        String nameBase = CJKFont.getBaseName(fontName);
        if (!CJKFont.isCJKFont(nameBase, enc)) {
            throw new DocumentException(MessageLocalization.getComposedMessage("font.1.with.2.encoding.is.not.a.cjk.font", fontName, enc));
        }
        if (nameBase.length() < fontName.length()) {
            this.style = fontName.substring(nameBase.length());
            fontName = nameBase;
        }
        this.fontName = fontName;
        this.encoding = CJK_ENCODING;
        this.vertical = enc.endsWith("V");
        this.CMap = enc;
        if (enc.startsWith("Identity-")) {
            this.cidDirect = true;
            String s2 = cjkFonts.getProperty(fontName);
            char[] c2 = this.allCMaps.get(s2 = s2.substring(0, s2.indexOf(95)));
            if (c2 == null) {
                c2 = CJKFont.readCMap(s2);
                if (c2 == null) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("the.cmap.1.does.not.exist.as.a.resource", s2));
                }
                c2[Short.MAX_VALUE] = 10;
                this.allCMaps.put(s2, c2);
            }
            this.translationMap = c2;
        } else {
            char[] c3 = this.allCMaps.get(enc);
            if (c3 == null) {
                String s3 = cjkEncodings.getProperty(enc);
                if (s3 == null) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("the.resource.cjkencodings.properties.does.not.contain.the.encoding.1", enc));
                }
                StringTokenizer tk = new StringTokenizer(s3);
                String nt = tk.nextToken();
                c3 = this.allCMaps.get(nt);
                if (c3 == null) {
                    c3 = CJKFont.readCMap(nt);
                    this.allCMaps.put(nt, c3);
                }
                if (tk.hasMoreTokens()) {
                    String nt2 = tk.nextToken();
                    char[] m2 = CJKFont.readCMap(nt2);
                    for (int k2 = 0; k2 < 65536; ++k2) {
                        if (m2[k2] != '\u0000') continue;
                        m2[k2] = c3[k2];
                    }
                    this.allCMaps.put(enc, m2);
                    c3 = m2;
                }
            }
            this.translationMap = c3;
        }
        this.fontDesc = allFonts.get(fontName);
        if (this.fontDesc == null) {
            this.fontDesc = CJKFont.readFontProperties(fontName);
            allFonts.putIfAbsent(fontName, this.fontDesc);
            this.fontDesc = allFonts.get(fontName);
        }
        this.hMetrics = (IntHashtable)this.fontDesc.get("W");
        this.vMetrics = (IntHashtable)this.fontDesc.get("W2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        if (propertiesLoaded) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (propertiesLoaded) {
                return;
            }
            try {
                InputStream is = CJKFont.getResourceStream("com/lowagie/text/pdf/fonts/cjkfonts.properties");
                cjkFonts.load(is);
                is.close();
                is = CJKFont.getResourceStream("com/lowagie/text/pdf/fonts/cjkencodings.properties");
                cjkEncodings.load(is);
                is.close();
            }
            catch (Exception e2) {
                cjkFonts = new Properties();
                cjkEncodings = new Properties();
            }
            propertiesLoaded = true;
        }
    }

    public static boolean isCJKFont(String fontName, String enc) {
        CJKFont.loadProperties();
        String encodings = cjkFonts.getProperty(fontName);
        return encodings != null && (enc.equals("Identity-H") || enc.equals("Identity-V") || encodings.contains("_" + enc + "_"));
    }

    static char[] readCMap(String name) {
        try {
            name = name + ".cmap";
            InputStream is = CJKFont.getResourceStream("com/lowagie/text/pdf/fonts/" + name);
            char[] c2 = new char[65536];
            for (int k2 = 0; k2 < 65536; ++k2) {
                c2[k2] = (char)((is.read() << 8) + is.read());
            }
            is.close();
            return c2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static IntHashtable createMetric(String s2) {
        IntHashtable h2 = new IntHashtable();
        StringTokenizer tk = new StringTokenizer(s2);
        while (tk.hasMoreTokens()) {
            int n1 = Integer.parseInt(tk.nextToken());
            h2.put(n1, Integer.parseInt(tk.nextToken()));
        }
        return h2;
    }

    static String convertToHCIDMetrics(int[] keys, IntHashtable h2) {
        if (keys.length == 0) {
            return null;
        }
        int lastCid = 0;
        int lastValue = 0;
        for (int start = 0; start < keys.length; ++start) {
            lastCid = keys[start];
            lastValue = h2.get(lastCid);
            if (lastValue == 0) continue;
            ++start;
            break;
        }
        if (lastValue == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(lastCid);
        int state = 0;
        for (int k2 = start; k2 < keys.length; ++k2) {
            int cid = keys[k2];
            int value = h2.get(cid);
            if (value == 0) continue;
            switch (state) {
                case 0: {
                    if (cid == lastCid + 1 && value == lastValue) {
                        state = 2;
                        break;
                    }
                    if (cid == lastCid + 1) {
                        state = 1;
                        buf.append('[').append(lastValue);
                        break;
                    }
                    buf.append('[').append(lastValue).append(']').append(cid);
                    break;
                }
                case 1: {
                    if (cid == lastCid + 1 && value == lastValue) {
                        state = 2;
                        buf.append(']').append(lastCid);
                        break;
                    }
                    if (cid == lastCid + 1) {
                        buf.append(' ').append(lastValue);
                        break;
                    }
                    state = 0;
                    buf.append(' ').append(lastValue).append(']').append(cid);
                    break;
                }
                case 2: {
                    if (cid == lastCid + 1 && value == lastValue) break;
                    buf.append(' ').append(lastCid).append(' ').append(lastValue).append(' ').append(cid);
                    state = 0;
                }
            }
            lastValue = value;
            lastCid = cid;
        }
        switch (state) {
            case 0: {
                buf.append('[').append(lastValue).append("]]");
                break;
            }
            case 1: {
                buf.append(' ').append(lastValue).append("]]");
                break;
            }
            case 2: {
                buf.append(' ').append(lastCid).append(' ').append(lastValue).append(']');
            }
        }
        return buf.toString();
    }

    static String convertToVCIDMetrics(int[] keys, IntHashtable v2, IntHashtable h2) {
        if (keys.length == 0) {
            return null;
        }
        int lastCid = 0;
        int lastValue = 0;
        int lastHValue = 0;
        for (int start = 0; start < keys.length; ++start) {
            lastCid = keys[start];
            lastValue = v2.get(lastCid);
            if (lastValue != 0) {
                ++start;
                break;
            }
            lastHValue = h2.get(lastCid);
        }
        if (lastValue == 0) {
            return null;
        }
        if (lastHValue == 0) {
            lastHValue = 1000;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(lastCid);
        int state = 0;
        for (int k2 = start; k2 < keys.length; ++k2) {
            int cid = keys[k2];
            int value = v2.get(cid);
            if (value == 0) continue;
            int hValue = h2.get(lastCid);
            if (hValue == 0) {
                hValue = 1000;
            }
            switch (state) {
                case 0: {
                    if (cid == lastCid + 1 && value == lastValue && hValue == lastHValue) {
                        state = 2;
                        break;
                    }
                    buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(' ').append(cid);
                    break;
                }
                case 2: {
                    if (cid == lastCid + 1 && value == lastValue && hValue == lastHValue) break;
                    buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(' ').append(cid);
                    state = 0;
                }
            }
            lastValue = value;
            lastCid = cid;
            lastHValue = hValue;
        }
        buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(" ]");
        return buf.toString();
    }

    static HashMap<Object, Object> readFontProperties(String name) {
        try {
            name = name + ".properties";
            InputStream is = CJKFont.getResourceStream("com/lowagie/text/pdf/fonts/" + name);
            Properties p2 = new Properties();
            p2.load(is);
            is.close();
            IntHashtable W2 = CJKFont.createMetric(p2.getProperty("W"));
            p2.remove("W");
            IntHashtable W22 = CJKFont.createMetric(p2.getProperty("W2"));
            p2.remove("W2");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Enumeration<Object> e2 = p2.keys();
            while (e2.hasMoreElements()) {
                Object obj = e2.nextElement();
                map.put(obj, p2.getProperty((String)obj));
            }
            map.put("W", W2);
            map.put("W2", W22);
            return map;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getWidth(int char1) {
        int v2;
        int c2 = char1;
        if (!this.cidDirect) {
            c2 = this.translationMap[c2];
        }
        if ((v2 = this.vertical ? this.vMetrics.get(c2) : this.hMetrics.get(c2)) > 0) {
            return v2;
        }
        return 1000;
    }

    @Override
    public int getWidth(String text) {
        int total = 0;
        for (int k2 = 0; k2 < text.length(); ++k2) {
            int v2;
            char c2 = text.charAt(k2);
            if (!this.cidDirect) {
                c2 = this.translationMap[c2];
            }
            if ((v2 = this.vertical ? this.vMetrics.get(c2) : this.hMetrics.get(c2)) > 0) {
                total += v2;
                continue;
            }
            total += 1000;
        }
        return total;
    }

    @Override
    int getRawWidth(int c2, String name) {
        return 0;
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    private PdfDictionary getFontDescriptor() {
        PdfDictionary dic = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        dic.put(PdfName.ASCENT, new PdfLiteral((String)this.fontDesc.get("Ascent")));
        dic.put(PdfName.CAPHEIGHT, new PdfLiteral((String)this.fontDesc.get("CapHeight")));
        dic.put(PdfName.DESCENT, new PdfLiteral((String)this.fontDesc.get("Descent")));
        dic.put(PdfName.FLAGS, new PdfLiteral((String)this.fontDesc.get("Flags")));
        dic.put(PdfName.FONTBBOX, new PdfLiteral((String)this.fontDesc.get("FontBBox")));
        dic.put(PdfName.FONTNAME, new PdfName(this.fontName + this.style));
        dic.put(PdfName.ITALICANGLE, new PdfLiteral((String)this.fontDesc.get("ItalicAngle")));
        dic.put(PdfName.STEMV, new PdfLiteral((String)this.fontDesc.get("StemV")));
        PdfDictionary pdic = new PdfDictionary();
        pdic.put(PdfName.PANOSE, new PdfString((String)this.fontDesc.get("Panose"), null));
        dic.put(PdfName.STYLE, pdic);
        return dic;
    }

    private PdfDictionary getCIDFont(PdfIndirectReference fontDescriptor, IntHashtable cjkTag) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE0);
        dic.put(PdfName.BASEFONT, new PdfName(this.fontName + this.style));
        dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        int[] keys = cjkTag.toOrderedKeys();
        String w2 = CJKFont.convertToHCIDMetrics(keys, this.hMetrics);
        if (w2 != null) {
            dic.put(PdfName.W, new PdfLiteral(w2));
        }
        if (this.vertical) {
            w2 = CJKFont.convertToVCIDMetrics(keys, this.vMetrics, this.hMetrics);
            if (w2 != null) {
                dic.put(PdfName.W2, new PdfLiteral(w2));
            }
        } else {
            dic.put(PdfName.DW, new PdfNumber(1000));
        }
        PdfDictionary cdic = new PdfDictionary();
        cdic.put(PdfName.REGISTRY, new PdfString((String)this.fontDesc.get("Registry"), null));
        cdic.put(PdfName.ORDERING, new PdfString((String)this.fontDesc.get("Ordering"), null));
        cdic.put(PdfName.SUPPLEMENT, new PdfLiteral((String)this.fontDesc.get("Supplement")));
        dic.put(PdfName.CIDSYSTEMINFO, cdic);
        return dic;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference CIDFont) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE0);
        String name = this.fontName;
        if (this.style.length() > 0) {
            name = name + "-" + this.style.substring(1);
        }
        name = name + "-" + this.CMap;
        dic.put(PdfName.BASEFONT, new PdfName(name));
        dic.put(PdfName.ENCODING, new PdfName(this.CMap));
        dic.put(PdfName.DESCENDANTFONTS, new PdfArray(CIDFont));
        return dic;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        IntHashtable cjkTag = (IntHashtable)params[0];
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        pobj = this.getFontDescriptor();
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        if ((pobj = this.getCIDFont(ind_font, cjkTag)) != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font);
        writer.addToBody((PdfObject)pobj, ref);
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    private float getDescNumber(String name) {
        return Integer.parseInt((String)this.fontDesc.get(name));
    }

    private float getBBox(int idx) {
        String s2 = (String)this.fontDesc.get("FontBBox");
        StringTokenizer tk = new StringTokenizer(s2, " []\r\n\t\f");
        String ret = tk.nextToken();
        for (int k2 = 0; k2 < idx; ++k2) {
            ret = tk.nextToken();
        }
        return Integer.parseInt(ret);
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        switch (key) {
            case 1: 
            case 9: {
                return this.getDescNumber("Ascent") * fontSize / 1000.0f;
            }
            case 2: {
                return this.getDescNumber("CapHeight") * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.getDescNumber("Descent") * fontSize / 1000.0f;
            }
            case 4: {
                return this.getDescNumber("ItalicAngle");
            }
            case 5: {
                return fontSize * this.getBBox(0) / 1000.0f;
            }
            case 6: {
                return fontSize * this.getBBox(1) / 1000.0f;
            }
            case 7: {
                return fontSize * this.getBBox(2) / 1000.0f;
            }
            case 8: {
                return fontSize * this.getBBox(3) / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return fontSize * (this.getBBox(2) - this.getBBox(0)) / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    public void setPostscriptFontName(String name) {
        this.fontName = name;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.fontName}};
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    @Override
    public int getUnicodeEquivalent(int c2) {
        if (this.cidDirect) {
            return this.translationMap[c2];
        }
        return c2;
    }

    @Override
    public int getCidCode(int c2) {
        if (this.cidDirect) {
            return c2;
        }
        return this.translationMap[c2];
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    public boolean charExists(int c2) {
        if (c2 >= this.translationMap.length) {
            return false;
        }
        return this.translationMap[c2] != '\u0000';
    }

    @Override
    public boolean setCharAdvance(int c2, int advance) {
        return false;
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public int[] getCharBBox(int c2) {
        return null;
    }

    @Override
    protected int[] getRawCharBBox(int c2, String name) {
        return null;
    }
}

